/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.db;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.trace.Trace;

public class CheckInstanceCommand
extends Command {
    private String m_groupName = null;
    private String m_instanceName = null;
    private ClusterUtil m_clusterUtil = null;
    private boolean m_isActive = false;
    private boolean m_bskgxn = false;

    public CheckInstanceCommand(String groupName, String instanceName, ClusterUtil clusterUtil) {
        this(groupName, instanceName, clusterUtil, false);
    }

    public CheckInstanceCommand(String groupName, String instanceName, ClusterUtil clusterUtil, boolean bskgxn) {
        this.m_groupName = groupName;
        this.m_instanceName = instanceName;
        this.m_clusterUtil = clusterUtil;
        this.m_bskgxn = bskgxn;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of CheckInstanceCommand");
        Object ret = null;
        try {
            this.m_isActive = this.m_clusterUtil.checkInstance(this.m_groupName, this.m_instanceName, this.m_bskgxn);
            Trace.out("m_isActive = " + this.m_isActive);
            this.setStatus(this.m_isActive);
            return true;
        }
        catch (ClusterUtilException e) {
            this.getStatusLogger().log((Command)this, (Exception)((Object)e));
            Trace.out("CheckInstanceCommand.execute:Exception calling ClusterUtil");
            this.setException((Exception)((Object)e));
            return false;
        }
    }

    public boolean isRunning() {
        return this.m_isActive;
    }
}

