/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.daemon;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.trace.Trace;

public class GetGSDInfoCommand
extends Command {
    private String m_groupName = null;
    private String m_nodeName = null;
    private ClusterUtil m_clusterUtil = null;
    private int m_portNum = 0;

    public GetGSDInfoCommand(String groupName, String nodeName, ClusterUtil clusterUtil) {
        this.m_groupName = groupName;
        this.m_nodeName = nodeName;
        this.m_clusterUtil = clusterUtil;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of GetCoordinatorCommand");
        Object ret = null;
        try {
            Trace.out(" groupname = " + this.m_groupName + " nodename-" + this.m_nodeName);
            this.m_portNum = this.m_clusterUtil.getGSDPortNum(this.m_groupName, this.m_nodeName);
            this.setStatus(true);
            return true;
        }
        catch (ClusterUtilException e) {
            Trace.out("GetGSDInfoCommand:Exception  calling native system " + (Object)((Object)e));
            this.setException((Exception)((Object)e));
            return false;
        }
    }

    public int getPortNum() {
        return this.m_portNum;
    }
}

