/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.daemon;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class CheckCSSStatusCommand
extends Command {
    private String m_nodeName;
    private String m_oracleHome;
    private Version m_version;
    private boolean m_cssStatus;

    public CheckCSSStatusCommand(String nodeName, String oracleHome, Version version) {
        this.m_nodeName = nodeName;
        this.m_oracleHome = oracleHome;
        this.m_version = version;
        this.commandResult = new CommandResult();
        this.commandResult.setNodeName(nodeName);
    }

    @Override
    public boolean execute() {
        Trace.out("CheckCSSStatusCommand on node:" + this.m_nodeName);
        this.m_cssStatus = this.nativeSystem.checkCSSStatus(this.m_nodeName, this.m_oracleHome, this.m_version, this.commandResult);
        return this.commandResult.getStatus();
    }

    public boolean getCSSStatus() {
        return this.m_cssStatus;
    }
}

