/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command;

import java.io.File;
import java.rmi.RemoteException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.GetEnvironmentCommand;
import oracle.ops.mgmt.daemon.OPSMDaemonI;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class RemoteCommand
extends Command {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private String s_location;
    private OPSMDaemonI s_opsmDaemon;
    private OperationResult m_operationResult;
    private Operation m_operation;
    private GetActiveNodes m_activeNodes;
    private boolean m_retry;
    private String m_nodeName;
    private String m_scriptLocation;
    private NativeSystem m_nativeSystem;
    private Exception m_exception;
    private String m_localNode;
    private String m_startNodeName;
    private static int m_numRetry = 0;

    public RemoteCommand(String nodeName, Operation op) throws ClusterException {
        this.s_location = null;
        this.s_opsmDaemon = null;
        this.m_operationResult = null;
        this.m_operation = null;
        this.m_activeNodes = null;
        this.m_retry = false;
        this.m_nodeName = null;
        this.m_scriptLocation = "";
        this.m_nativeSystem = new SystemFactory().CreateSystem();
        this.m_exception = null;
        this.m_localNode = null;
        this.m_startNodeName = null;
        this.m_nodeName = nodeName;
        this.m_activeNodes = GetActiveNodes.create();
        this.m_operation = op;
        this.createDaemon(this.m_nodeName, false);
    }

    public RemoteCommand(String nodeName, Operation op, boolean retry) throws ClusterException {
        block5: {
            this.s_location = null;
            this.s_opsmDaemon = null;
            this.m_operationResult = null;
            this.m_operation = null;
            this.m_activeNodes = null;
            this.m_retry = false;
            this.m_nodeName = null;
            this.m_scriptLocation = "";
            this.m_nativeSystem = new SystemFactory().CreateSystem();
            this.m_exception = null;
            this.m_localNode = null;
            this.m_startNodeName = null;
            this.m_activeNodes = GetActiveNodes.create();
            this.m_localNode = this.m_activeNodes.getNodeName();
            this.m_nodeName = nodeName;
            this.m_startNodeName = nodeName.equals(this.m_localNode) ? "localnode" : nodeName;
            this.m_operation = op;
            this.setScriptLocation();
            this.m_retry = retry;
            try {
                this.createDaemon(this.m_nodeName, false);
            }
            catch (ClusterException e) {
                Trace.out("Could not create Daemon");
                if (this.m_retry) break block5;
                throw e;
            }
        }
        if (this.s_opsmDaemon == null && this.m_retry) {
            if (this.m_activeNodes.isDaemonRunning(this.m_nodeName)) {
                Trace.out("daemon found running upon retry");
                return;
            }
            Trace.out("RemoteCommand.execute:Retrying the operation");
            if (!this.m_activeNodes.startDaemon(this.m_startNodeName, this.m_scriptLocation)) {
                Trace.out("Could not start Daemon");
                throw new ClusterException(s_msgBundle.getMessage("1017", true));
            }
            ++m_numRetry;
            this.createDaemon(this.m_nodeName, this.m_retry);
        }
    }

    public RemoteCommand(Operation op) throws ClusterException {
        this.s_location = null;
        this.s_opsmDaemon = null;
        this.m_operationResult = null;
        this.m_operation = null;
        this.m_activeNodes = null;
        this.m_retry = false;
        this.m_nodeName = null;
        this.m_scriptLocation = "";
        this.m_nativeSystem = new SystemFactory().CreateSystem();
        this.m_exception = null;
        this.m_localNode = null;
        this.m_startNodeName = null;
        this.m_activeNodes = GetActiveNodes.create();
        this.m_nodeName = this.m_activeNodes.getNodeName();
        this.m_operation = op;
        this.createDaemon(this.m_nodeName, false);
        String coordinatorNode = null;
        try {
            if (this.s_opsmDaemon != null) {
                coordinatorNode = this.m_activeNodes.getCoordinatorName();
                Trace.out("RemoteCommand.constructor3: Coordinator Node is " + coordinatorNode);
            }
        }
        catch (Exception e) {
            Trace.out("RemoteCommand.constructor3: Exception in RemoteCommand");
            throw new ClusterException(s_msgBundle.getMessage("1018", true), e);
        }
        if (coordinatorNode != null && !coordinatorNode.equals(this.m_nodeName)) {
            Trace.out("RemoteCommand.constructor3: Creating new handle  to coordinator daemon, Local Node= " + this.m_nodeName + " coordinator node = " + coordinatorNode);
            this.createDaemon(coordinatorNode, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public RemoteCommand(Operation op, boolean retry) throws ClusterException {
        block12: {
            super();
            this.s_location = null;
            this.s_opsmDaemon = null;
            this.m_operationResult = null;
            this.m_operation = null;
            this.m_activeNodes = null;
            this.m_retry = false;
            this.m_nodeName = null;
            this.m_scriptLocation = "";
            this.m_nativeSystem = new SystemFactory().CreateSystem();
            this.m_exception = null;
            this.m_localNode = null;
            this.m_startNodeName = null;
            this.m_activeNodes = GetActiveNodes.create();
            this.m_retry = retry;
            this.m_nodeName = this.m_activeNodes.getNodeName();
            this.m_operation = op;
            this.setScriptLocation();
            try {
                this.createDaemon(this.m_nodeName, false);
            }
            catch (ClusterException e) {
                Trace.out("Exception in RemoteCommand: " + e);
                if (this.m_retry) break block12;
                throw e;
            }
        }
        coordinatorNode = null;
        if (this.s_opsmDaemon != null) {
            try {
                coordinatorNode = this.m_activeNodes.getCoordinatorName();
                Trace.out("RemoteCommand.constructor4: Coordinator Node is " + coordinatorNode);
            }
            catch (Exception e) {
                if (this.m_retry) ** GOTO lbl49
                throw new ClusterException(RemoteCommand.s_msgBundle.getMessage("1018", true), e);
            }
        } else if (this.m_retry) {
            Trace.out("Need to restart daemon" + this.m_nodeName);
            if (!this.m_activeNodes.isDaemonRunning(this.m_nodeName)) {
                Trace.out("RemoteCommand: Local Node Dead..trying to restart");
                if (this.m_activeNodes.startDaemon("localnode", this.m_scriptLocation)) {
                    this.createDaemon(this.m_nodeName, this.m_retry);
                    try {
                        coordinatorNode = this.m_activeNodes.getCoordinatorName();
                        Trace.out("RemoteCommand: Coordinator Node is " + coordinatorNode);
                        ++RemoteCommand.m_numRetry;
                    }
                    catch (Exception e) {
                        throw new ClusterException(RemoteCommand.s_msgBundle.getMessage("1018", true), e);
                    }
                }
            }
        }
lbl49:
        // 9 sources

        if (coordinatorNode != null && !coordinatorNode.equals(this.m_nodeName)) {
            Trace.out("RemoteCommand:Creating new daemon, Local Node " + this.m_nodeName);
            this.createDaemon(coordinatorNode, false);
        }
    }

    private void setScriptLocation() throws ClusterException {
        GetEnvironmentCommand getEnvironment = new GetEnvironmentCommand("ORACLE_HOME");
        if (!getEnvironment.execute()) {
            throw new ClusterException(s_msgBundle.getMessage("1016", true));
        }
        CommandResult commandResult = getEnvironment.getCommandResult();
        String env = commandResult.getEnvironment();
        String fullPath = env + File.separator + "bin" + File.separator + "gsd.sh";
        this.m_scriptLocation = new String(System.getProperty("srvm.daemon.startscript", fullPath));
        Trace.out("RemoteCommand: script location " + this.m_scriptLocation);
    }

    private void createDaemon(String nodeName, boolean force) throws ClusterException {
        Trace.out("my SecurityManager = " + System.getSecurityManager());
        if (force) {
            this.m_activeNodes.removeReference(nodeName);
        }
        this.s_opsmDaemon = this.m_activeNodes.getReference(nodeName);
        Trace.out("my SecurityManager (now) = " + System.getSecurityManager());
    }

    @Override
    public boolean execute() {
        if (this.s_opsmDaemon == null) {
            Trace.out("RemoteCommand.execute: No Handle to Daemon");
            return false;
        }
        try {
            if (this.s_opsmDaemon == null) {
                return false;
            }
            Trace.out("RemoteCommand.execute: s_opsmDaemon is not null " + this.m_retry);
            String opName = this.m_operation.getClass().getName();
            Trace.out("Submitting " + opName + " to gsd");
            this.m_operationResult = this.s_opsmDaemon.execute(this.m_operation);
        }
        catch (InterruptedException ie) {
            this.m_exception = ie;
            Trace.out("RemoteCommand.execute:Interrupted Exception");
            Trace.out(ie);
            return false;
        }
        catch (RemoteException re) {
            this.m_exception = re;
            Trace.out("RemoteCommand.execute:Exception caught retry=" + this.m_retry);
            Trace.out(re);
            if (this.m_retry && !this.m_operation.isSynchronized() && m_numRetry != 0) {
                try {
                    if (this.m_activeNodes.isDaemonRunning(this.m_nodeName)) {
                        Trace.out(re);
                        Trace.out("RemoteCommand: retry option set..but  no point retrying..daemon is already running");
                        return false;
                    }
                }
                catch (ClusterException ce) {
                    Trace.out("RemoteCommand:Problem in Clusterware");
                    return false;
                }
                Trace.out("RemoteCommand.execute:Retrying the operation");
                try {
                    if (!this.m_activeNodes.startDaemon(this.m_nodeName, this.m_scriptLocation)) {
                        return false;
                    }
                    this.createDaemon(this.m_nodeName, this.m_retry);
                }
                catch (Exception e) {
                    this.m_exception = e;
                    this.m_operationResult = new OperationResult(2);
                    this.m_operationResult.setException(e);
                    this.m_exception = e;
                    Trace.out("RemoteCommand.execute: Problem restarting the daemon");
                    return false;
                }
                try {
                    if (this.s_opsmDaemon == null) {
                        this.m_operationResult = new OperationResult(2);
                        this.m_operationResult.setException(re);
                        return false;
                    }
                    Trace.out("RemoteCommand.execute:Calling execute  again in retry mode");
                    this.m_operationResult = this.s_opsmDaemon.execute(this.m_operation);
                }
                catch (Exception e) {
                    this.m_exception = e;
                    this.m_operationResult = new OperationResult(2);
                    this.m_operationResult.setException(e);
                    Trace.out("RemoteCommand:Could not execute  command even after retry");
                    this.m_exception = e;
                    return false;
                }
            }
            this.m_operationResult = new OperationResult(2);
            this.m_operationResult.setException(re);
            Trace.out("RemoteCommand: Exception caught..No  retry option set...just exiting");
            Trace.out(re);
            return false;
        }
        catch (Exception e) {
            this.m_exception = e;
            this.m_operationResult = new OperationResult(2);
            this.m_operationResult.setException(e);
            Trace.out("RemoteCommand.execute: Exception in RemoteCommand");
            Trace.out(e);
            return false;
        }
        if (this.m_operationResult == null) {
            Trace.out("RemoteCommand.execute: Returning false");
            return false;
        }
        Trace.out("RemoteCommand.execute: Returning true");
        return true;
    }

    public Operation getOperation() {
        return this.m_operation;
    }

    @Override
    public String getNode() {
        return this.m_nodeName;
    }

    public OperationResult getOperationResult() throws ClusterException {
        if (this.m_operationResult == null || this.m_operationResult.getStatus() == 2) {
            Object[] args = new Object[]{this.m_nodeName};
            if (this.m_exception != null) {
                throw new ClusterException(s_msgBundle.getMessage("1020", true, args), this.m_exception);
            }
            throw new ClusterException(s_msgBundle.getMessage("1020", true, args));
        }
        return this.m_operationResult;
    }
}

