/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ops.mgmt.command.CommandEvent;
import oracle.ops.mgmt.command.CommandListener;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.StatusLogger;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

public abstract class Command {
    protected static final String LOCALNODE = "localnode";
    protected boolean m_success = false;
    protected String m_node;
    protected NativeSystem nativeSystem;
    private StatusLogger m_statusLogger;
    protected CommandResult commandResult;
    private int m_phase = 0;
    private Thread m_ownerThread = Thread.currentThread();
    private Exception m_exception = null;
    protected List m_cmdListeners;

    public Command() {
        this.m_statusLogger = new StatusLogger();
        this.nativeSystem = new SystemFactory().CreateSystem();
        this.m_cmdListeners = new ArrayList();
    }

    public abstract boolean execute();

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    protected boolean abort() {
        return false;
    }

    protected boolean prepare() {
        return false;
    }

    protected boolean commit() {
        return false;
    }

    public Command getCommand() {
        return this;
    }

    public String getNode() {
        return this.m_node;
    }

    public void setStatus(boolean resultStatus) {
        this.m_success = resultStatus;
    }

    public boolean getStatus() {
        return this.m_success;
    }

    public Thread getOwnerThread() {
        return this.m_ownerThread;
    }

    public void setPhase(int newPhase) {
        this.m_phase = newPhase;
    }

    public int getPhase() {
        return this.m_phase;
    }

    public StatusLogger getStatusLogger() {
        return this.m_statusLogger;
    }

    public void setException(Exception e) {
        this.m_exception = e;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public synchronized void addListener(Object cmdListener) {
        if (cmdListener != null) {
            this.m_cmdListeners.add(cmdListener);
        }
    }

    public synchronized void removeListener(Object cmdListener) {
        if (cmdListener != null) {
            this.m_cmdListeners.remove(cmdListener);
        }
    }

    protected synchronized void postEvent() {
        CommandEvent event = new CommandEvent(this, this.commandResult);
        this.postEvent(event);
    }

    protected synchronized void postEvent(CommandEvent event) {
        Trace.out("inside Command.postEvent, listener size=" + this.m_cmdListeners.size());
        Iterator listeners = this.m_cmdListeners.iterator();
        while (listeners.hasNext()) {
            ((CommandListener)listeners.next()).updateStatus(event);
            Trace.out("Posted event: node=" + event.getNode() + " status=" + event.getStatus());
        }
    }
}

