/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.util.HashMap;
import oracle.ops.mgmt.trace.Trace;

public class VoteDiskInfo {
    private int m_number = 0;
    private long m_size = 0L;
    private int m_status = 0;
    private String m_VDIN = null;
    private String m_path = null;
    private String m_group = null;
    private int m_isASMPath = -1;
    private static HashMap<String, Integer> statusMap = new HashMap(4);

    VoteDiskInfo(String path, long size, int number) {
        this(number, size, 0, null, path, null);
    }

    public VoteDiskInfo(int number, long size, int status, String VDIN, String path, String group) {
        this.m_number = number;
        this.m_size = size;
        this.m_status = status;
        this.m_VDIN = VDIN;
        this.m_path = path;
        this.m_group = group;
        if (group != null) {
            this.m_isASMPath = group.contentEquals("[]") ? 0 : 1;
        }
    }

    public String getPath() {
        return this.m_path;
    }

    public long getSize() {
        return this.m_size;
    }

    public int getNumber() {
        return this.m_number;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getVDIN() {
        return this.m_VDIN;
    }

    public String getGroup() {
        return this.m_group;
    }

    public int isASMPath() {
        return this.m_isASMPath;
    }

    public static int mapStatusToInt(String strStatus) {
        if (statusMap.containsKey(strStatus)) {
            return statusMap.get(strStatus);
        }
        Trace.out("Invalid VDisk status string " + strStatus);
        return -1;
    }

    public String toString() {
        return "|Number|Size|Status|VDIN|Path|Group|isASMPath|\n|" + Integer.toString(this.m_number) + "|" + Long.toString(this.m_size) + "|" + Integer.toString(this.m_status) + "|" + this.m_VDIN + "|" + this.m_path + "|" + this.m_group + "|" + Integer.toString(this.m_isASMPath) + "|";
    }

    static {
        statusMap.put("UNKNOWN", new Integer(0));
        statusMap.put("PENDOFFL", new Integer(1));
        statusMap.put("ONLINE", new Integer(2));
        statusMap.put("OFFLINE", new Integer(3));
    }
}

