/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.InvalidVersionException;
import oracle.ops.mgmt.cluster.Version101;
import oracle.ops.mgmt.cluster.Version102;
import oracle.ops.mgmt.cluster.Version10205;
import oracle.ops.mgmt.cluster.Version111;
import oracle.ops.mgmt.cluster.Version11107;
import oracle.ops.mgmt.cluster.Version11201;
import oracle.ops.mgmt.cluster.Version11202;
import oracle.ops.mgmt.cluster.Version11203;
import oracle.ops.mgmt.cluster.Version11204;
import oracle.ops.mgmt.cluster.Version12100;
import oracle.ops.mgmt.cluster.Version12102;
import oracle.ops.mgmt.cluster.Version92;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class Version
implements Serializable {
    static final long serialVersionUID = 6472177181665279479L;
    protected String majorVersion = "12";
    protected String minorVersion = "2";
    protected String releaseVersion = "0";
    protected String patchSetVersion = "1";
    protected String osVersion = "0";
    private static ArrayList s_prevVersion = new ArrayList();

    public Version() {
    }

    protected Version(String majorVer, String minorVer, String releaseVer, String patchSetVer, String osVer) {
        this.majorVersion = majorVer;
        this.minorVersion = minorVer;
        this.releaseVersion = releaseVer;
        this.patchSetVersion = patchSetVer;
        this.osVersion = osVer;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.releaseVersion + "." + this.patchSetVersion + "." + this.osVersion;
    }

    public String toString4() {
        return this.majorVersion + "." + this.minorVersion + "." + this.releaseVersion + "." + this.patchSetVersion;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getPatchSetVersionVersion() {
        return this.patchSetVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public static Version get92Version() {
        return new Version92();
    }

    public static Version get101Version() {
        return new Version101();
    }

    public static Version get102Version() {
        return new Version102();
    }

    public static Version get10205Version() {
        return new Version10205();
    }

    public static Version get11107Version() {
        return new Version11107();
    }

    public static Version get111Version() {
        return new Version111();
    }

    public static Version get11201Version() {
        return new Version11201();
    }

    public static Version get11202Version() {
        return new Version11202();
    }

    public static Version get11203Version() {
        return new Version11203();
    }

    public static Version get11204Version() {
        return new Version11204();
    }

    public static Version get12100Version() {
        return new Version12100();
    }

    public static Version get12101Version() {
        return new Version("12", "1", "0", "1", "0");
    }

    public static Version get12102Version() {
        return new Version12102();
    }

    public static Version get122Version() {
        return new Version("12", "2", "0", "0", "0");
    }

    public static Version getCurrentVersion() {
        return new Version("12", "2", "0", "1", "0");
    }

    private boolean equals4(Version v) {
        return this.toString4().compareTo(v.toString4()) == 0;
    }

    public boolean equals(Version v) {
        return this.equals4(v);
    }

    public static boolean isPre10i(Version v) {
        return Version.isPre(v, 10);
    }

    public static boolean isPre11i(Version v) {
        return Version.isPre(v, 11);
    }

    public static boolean isPre112(Version v) {
        return Version.isPre(v, 11, 2);
    }

    public static boolean isPre11202(Version v) {
        return Version.isPre(v, 11, 2, 2);
    }

    public static boolean isPre11203(Version v) {
        return Version.isPre(v, 11, 2, 3);
    }

    public static boolean isPre11204(Version v) {
        return Version.isPre(v, 11, 2, 4);
    }

    public static boolean isPre12c(Version v) {
        return Version.isPre(v, 12);
    }

    public static boolean isPre12101(Version v) {
        return Version.isPre(v, 12, 1, 1);
    }

    public static boolean isPre12102(Version v) {
        return Version.isPre(v, 12, 1, 2);
    }

    public static boolean isPre122(Version v) {
        return Version.isPre(v, 12, 2);
    }

    public static boolean isPreCurrentVersion(Version v) {
        return Version.isPre(v, Integer.valueOf("12"), Integer.valueOf("2"), Integer.valueOf("1"));
    }

    public static boolean isPre10205(Version v) {
        return Version.isPre(v, 10, 2, 5);
    }

    public static boolean isPre11107(Version v) {
        return Version.isPre(v, 11, 1, 7);
    }

    private static boolean isPre(Version v, int targetMajorVersion) {
        String majorVer;
        Trace.out("version to be checked " + v.toString() + " major version to check against " + targetMajorVersion);
        String string = majorVer = v != null ? v.getMajorVersion() : null;
        if (majorVer == null || Integer.valueOf(majorVer) < targetMajorVersion) {
            Trace.out("isPre.java: Returning TRUE");
            return true;
        }
        Trace.out("isPre.java: Returning FALSE");
        return false;
    }

    private static boolean isPre(Version v, int targetMajorVersion, int targetMinorVersion) {
        boolean majorvercheck = Version.isPre(v, targetMajorVersion);
        if (!majorvercheck) {
            String minorVer;
            String majorVer;
            Trace.out("version to be checked " + v.toString() + " major version to check against " + targetMajorVersion + " minor version to check against " + targetMinorVersion);
            String string = majorVer = v != null ? v.getMajorVersion() : null;
            if (majorVer != null && Integer.valueOf(majorVer) > targetMajorVersion) {
                Trace.out("isPre: Returning FALSE for major version check");
                return false;
            }
            String string2 = minorVer = v != null ? v.getMinorVersion() : null;
            if (minorVer != null && Integer.valueOf(minorVer) < targetMinorVersion) {
                Trace.out("isPre: Returning TRUE for minor version check");
                return true;
            }
            Trace.out("isPre: Returning FALSE");
            return false;
        }
        return majorvercheck;
    }

    public static boolean isPre(Version ver1, Version ver2) {
        return Version.isPre(ver1, Integer.valueOf(ver2.getMajorVersion()), Integer.valueOf(ver2.getMinorVersion()), Integer.valueOf(ver2.getPatchSetVersionVersion()));
    }

    private static boolean isPre(Version v, int targetMajorVersion, int targetMinorVersion, int targetPatchsetVersion) {
        boolean majorvercheck = Version.isPre(v, targetMajorVersion);
        if (!majorvercheck) {
            String minorVer;
            String majorVer;
            Trace.out("version to be checked " + v.toString() + " major version to check against " + targetMajorVersion + " minor version to check against " + targetMinorVersion + " patchset version to check against " + targetPatchsetVersion);
            String string = majorVer = v != null ? v.getMajorVersion() : null;
            if (majorVer != null && Integer.valueOf(majorVer) > targetMajorVersion) {
                Trace.out("isPre: Returning FALSE for major version check");
                return false;
            }
            String string2 = minorVer = v != null ? v.getMinorVersion() : null;
            if (minorVer != null) {
                if (Integer.valueOf(minorVer) < targetMinorVersion) {
                    Trace.out("isPre: Returning TRUE for minor version check");
                    return true;
                }
                if (Integer.valueOf(minorVer) > targetMinorVersion) {
                    Trace.out("isPre: Returning FALSE for minor version check");
                    return false;
                }
            }
            String patchSetVer = v != null ? v.getPatchSetVersionVersion() : null;
            Trace.out("Patchset version in isPre is" + patchSetVer);
            if (patchSetVer == null || Integer.valueOf(patchSetVer) < targetPatchsetVersion) {
                Trace.out("isPre: Returning TRUE for patchset version check");
                return true;
            }
            Trace.out("isPre: Returning FALSE for patchset version check");
            return false;
        }
        return majorvercheck;
    }

    public static Collection getPrevVersions() {
        return Collections.unmodifiableCollection(s_prevVersion);
    }

    public static Version getVersion(String versionString) throws ConfigurationException {
        if (versionString == null) {
            throw new ConfigurationException(MessageBundle.getMessageBundle("Prkc").getMessage("1130", true));
        }
        return VersionEnum.getEnumMember(versionString).toVersion();
    }

    public static boolean isHigher(String targetVersion) throws InvalidVersionException, ConfigurationException {
        Version swversion = new Version();
        boolean invalid = false;
        int targetMajorVersion = 0;
        int targetMinorVersion = 0;
        int targetPatchSetVersion = 0;
        String[] verstr = targetVersion.split(Pattern.quote(String.valueOf('.')));
        if (targetVersion.endsWith(String.valueOf('.')) || verstr.length > 5) {
            invalid = true;
        }
        if (!invalid) {
            try {
                for (int i = 0; i < verstr.length; ++i) {
                    if (i == 0) {
                        targetMajorVersion = Integer.parseInt(verstr[i]);
                    }
                    if (i == 1) {
                        targetMinorVersion = Integer.parseInt(verstr[i]);
                    }
                    if (i == 2) {
                        Integer.parseInt(verstr[i]);
                    }
                    if (i == 3) {
                        targetPatchSetVersion = Integer.parseInt(verstr[i]);
                    }
                    if (i != 4 || verstr[i].matches("(\\d+)(.*)")) continue;
                    invalid = true;
                }
            }
            catch (NumberFormatException e) {
                Trace.out("Format incorrect : " + e.getMessage());
                invalid = true;
            }
        }
        if (invalid) {
            throw new InvalidVersionException("1177", new Object[]{targetVersion});
        }
        Trace.out("Calling isPre to compare software version " + swversion.toString() + "against major ver " + targetMajorVersion + " minor ver " + targetMinorVersion + " and patch set ver " + targetPatchSetVersion);
        boolean result = Version.isPre(swversion, targetMajorVersion, targetMinorVersion, targetPatchSetVersion);
        return result;
    }

    static {
        s_prevVersion.add(Version.get12101Version());
        s_prevVersion.add(Version.get12100Version());
        s_prevVersion.add(Version.get11204Version());
        s_prevVersion.add(Version.get11203Version());
        s_prevVersion.add(Version.get11202Version());
        s_prevVersion.add(Version.get11201Version());
        s_prevVersion.add(Version.get111Version());
        s_prevVersion.add(Version.get102Version());
        s_prevVersion.add(Version.get101Version());
        s_prevVersion.add(Version.get92Version());
    }

    public static enum VersionEnum {
        V92000(Version.get92Version()),
        V10100(Version.get101Version()),
        V10200(Version.get102Version()),
        V10205(Version.get10205Version()),
        V11100(Version.get111Version()),
        V11107(Version.get11107Version()),
        V11201(Version.get11201Version()),
        V11202(Version.get11202Version()),
        V11203(Version.get11203Version()),
        V11204(Version.get11204Version()),
        V12100(Version.get12100Version()),
        V12101(Version.get12101Version()),
        V12102(Version.get12102Version()),
        V12200(Version.get122Version()),
        VCURR(Version.getCurrentVersion());

        private Version m_ver;

        public static VersionEnum getEnumMember(String versionString) throws ConfigurationException {
            int dot1 = -1;
            int dot2 = -1;
            int dot3 = -1;
            int dot4 = -1;
            String majorVer = "0";
            String minorVer = "0";
            String releaseVer = "0";
            String patchSetVer = "0";
            String osVer = "0";
            int verlen = versionString.length();
            dot1 = versionString.indexOf(".");
            if (dot1 == -1) {
                majorVer = versionString;
            } else {
                majorVer = versionString.substring(0, dot1);
                dot2 = versionString.indexOf(".", dot1 + 1);
                if (dot2 == -1) {
                    minorVer = versionString.substring(dot1 + 1);
                } else {
                    minorVer = versionString.substring(dot1 + 1, dot2);
                    dot3 = versionString.indexOf(".", dot2 + 1);
                    if (dot3 == -1) {
                        releaseVer = versionString.substring(dot2 + 1);
                    } else {
                        releaseVer = versionString.substring(dot2 + 1, dot3);
                        dot4 = versionString.indexOf(".", dot3 + 1);
                        if (dot4 == -1) {
                            patchSetVer = versionString.substring(dot3 + 1);
                        } else {
                            patchSetVer = versionString.substring(dot3 + 1, dot4);
                            osVer = versionString.substring(dot4 + 1);
                        }
                    }
                }
            }
            Version version = new Version(majorVer, minorVer, releaseVer, patchSetVer, osVer);
            Trace.out("majorVer=" + majorVer + "\n" + "minorVer=" + minorVer + "\n" + "releaseVer=" + releaseVer + "\n" + "patchsetVer=" + patchSetVer + "\n" + "osVer=" + osVer + "\n");
            int matchedLevel = 0;
            VersionEnum retval = null;
            for (VersionEnum g : VersionEnum.values()) {
                if (!g.m_ver.getMajorVersion().equals(version.getMajorVersion())) continue;
                matchedLevel = 0;
                if (matchedLevel < 1) {
                    matchedLevel = 1;
                    retval = g;
                }
                if (!g.m_ver.getMinorVersion().equals(version.getMinorVersion())) continue;
                if (matchedLevel < 2) {
                    matchedLevel = 2;
                    retval = g;
                }
                if (!g.m_ver.getReleaseVersion().equals(version.getReleaseVersion())) continue;
                if (matchedLevel < 3) {
                    matchedLevel = 3;
                    retval = g;
                }
                if (!g.m_ver.getPatchSetVersionVersion().equals(version.getPatchSetVersionVersion()) || matchedLevel >= 4) continue;
                matchedLevel = 4;
                retval = g;
                break;
            }
            if (matchedLevel == 4) {
                Trace.out("Version Match Successful: returning version object " + retval.m_ver.toString4());
                return retval;
            }
            throw new ConfigurationException(MessageBundle.getMessageBundle("Prkc").getMessage("1137", true, new Object[]{versionString}));
        }

        private VersionEnum(Version ver) {
            this.m_ver = ver;
        }

        public String toString() {
            return this.m_ver.toString();
        }

        public Version toVersion() {
            return this.m_ver;
        }
    }
}

