/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;

public class OCRInfo {
    private HashMap m_ocrDiskMap;
    private Version m_version;
    public static final String FORWARD_SLASH = "/";

    OCRInfo(HashMap diskMap) {
        this.m_ocrDiskMap = diskMap;
        this.m_version = new Version();
    }

    OCRInfo(HashMap diskMap, Version version) {
        this.m_ocrDiskMap = diskMap;
        this.m_version = version;
    }

    public String getDisk() {
        return this.getDisk(false);
    }

    public String getMirrorDisk() {
        return this.getDisk(true);
    }

    private String getDisk(boolean diskType) {
        String ocrDisk = null;
        for (Map.Entry entry : this.m_ocrDiskMap.entrySet()) {
            String loc = (String)entry.getKey();
            String typ = (String)entry.getValue();
            if (Trace.isLevelEnabled(5)) {
                Trace.out("OCR location = " + loc + "; Type = " + typ);
            }
            if ((diskType || !typ.equals("OCR_PRIMARY")) && (!diskType || !typ.equals("OCR_MIRROR"))) continue;
            ocrDisk = this.extractDG(loc, false);
        }
        return ocrDisk;
    }

    private String extractDG(String loc, boolean onlyDG) {
        String dg = null;
        if (loc.trim().startsWith("+")) {
            loc = loc.replaceAll("\\\\", FORWARD_SLASH);
            int idx = loc.indexOf(FORWARD_SLASH);
            Trace.out("loc=" + loc + ",idx=" + idx);
            if (idx != -1) {
                dg = loc.substring(0, idx);
                Trace.out("loc=" + loc + ",idx=" + idx + ",dg=" + dg);
            } else {
                dg = loc;
            }
        } else if (!onlyDG) {
            dg = loc;
        }
        return dg;
    }

    public String[] getPaths() {
        return this.m_ocrDiskMap.keySet().toArray(new String[this.m_ocrDiskMap.size()]);
    }

    public String[] getOCRDiskGroups() {
        ArrayList<String> ocrDGs = new ArrayList<String>();
        Iterator it = this.m_ocrDiskMap.entrySet().iterator();
        boolean i = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String loc = (String)entry.getKey();
            Trace.out("Location = " + loc);
            String dg = this.extractDG(loc, true);
            if (dg == null) continue;
            ocrDGs.add(dg);
        }
        return ocrDGs.toArray(new String[ocrDGs.size()]);
    }
}

