/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.daemon.GetCoordinatorCommand;
import oracle.ops.mgmt.command.daemon.GetGSDInfoCommand;
import oracle.ops.mgmt.command.daemon.GetLiveDaemonCommand;
import oracle.ops.mgmt.command.daemon.StartOPSMDaemonCommand;
import oracle.ops.mgmt.command.db.CheckInstanceCommand;
import oracle.ops.mgmt.command.db.CheckOPSCommand;
import oracle.ops.mgmt.daemon.OPSMDaemonI;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.synchronize.BinarySemaphore;
import oracle.ops.mgmt.synchronize.SyncBuffer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GetActiveNodes
implements Constants {
    private static GetActiveNodes s_instance = null;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private String[] m_nodeList = null;
    private String[] m_internalNodeList = null;
    private String m_resultString = null;
    private String m_nodeName = null;
    private boolean m_isCluster = true;
    private Thread m_clusterWareThread = null;
    private SyncBuffer m_commandBuffer = null;
    private BinarySemaphore m_blockingSemaphore = null;
    private Hashtable m_remoteReferenceTable = null;
    private String m_gsdGroupName = null;
    private ClusterUtil m_clusterUtil = null;

    private GetActiveNodes() throws ClusterException {
        String clustProperty = System.getProperty("srvm.cluster", "true");
        if (clustProperty.compareTo("true") != 0) {
            throw new ClusterException(s_msgBundle.getMessage("1021", true));
        }
        this.m_gsdGroupName = new String(System.getProperty("srvm.daemon.groupname", "opsm"));
        try {
            this.m_clusterUtil = new ClusterUtil();
            this.m_nodeName = this.m_clusterUtil.getLocalNodeName();
            this.m_nodeList = this.m_clusterUtil.getNodeNames();
        }
        catch (ClusterUtilException cue) {
            this.m_isCluster = false;
            throw new ClusterException(cue.getMessage());
        }
        this.m_internalNodeList = new String[this.m_nodeList.length];
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            this.m_internalNodeList[i] = this.m_nodeList[i].equals(this.m_nodeName) ? "localnode" : new String(this.m_nodeList[i]);
        }
        Trace.out("Inside GetActiveNodes :" + this.m_nodeName);
        this.m_commandBuffer = new SyncBuffer(1);
        this.m_blockingSemaphore = new BinarySemaphore(0);
        this.m_remoteReferenceTable = new Hashtable();
        this.m_clusterWareThread = new Thread((Runnable)new ClusterWareThread(), "GetActiveNodesThread");
        this.m_clusterWareThread.setDaemon(true);
        this.m_clusterWareThread.start();
        Trace.out("Started clusterware daemon thread");
    }

    public static synchronized GetActiveNodes create() throws ClusterException {
        if (s_instance == null) {
            Trace.out("Going into GetActiveNodes constructor...");
            s_instance = new GetActiveNodes();
            Trace.out("Out of GetActiveNodes constructor.");
        } else {
            Trace.out("Returning an existing instance of GetActiveNodes");
        }
        return s_instance;
    }

    public synchronized OPSMDaemonI getReference(String nodeName) throws ClusterException {
        if (nodeName == null) {
            Trace.out("GetActiveNodes:  Error from calling  function...nodeName passed in getReference is null");
            throw new ClusterException();
        }
        OPSMDaemonI opsmDaemon = (OPSMDaemonI)this.m_remoteReferenceTable.get(nodeName);
        if (opsmDaemon == null) {
            opsmDaemon = this.createDaemon(nodeName);
            this.m_remoteReferenceTable.put(nodeName, opsmDaemon);
        }
        return opsmDaemon;
    }

    public synchronized void removeReference(String nodeName) {
        this.m_remoteReferenceTable.put(nodeName, null);
        this.m_remoteReferenceTable.remove(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OPSMDaemonI createDaemon(String node) throws ClusterException {
        String nodeName = node;
        String location = null;
        OPSMDaemonI opsmDaemon = null;
        Object[] args = new Object[]{nodeName};
        int portNum = 0;
        Trace.out(" Trying to get port number for node " + nodeName);
        GetGSDInfoCommand getGSDInfoCommand = new GetGSDInfoCommand(this.m_gsdGroupName, nodeName, this.m_clusterUtil);
        boolean status = this.submitAndWait(getGSDInfoCommand);
        if (!status) {
            Trace.out("Could not get the port number");
            throw new ClusterException(getGSDInfoCommand.getException().getMessage());
        }
        portNum = getGSDInfoCommand.getPortNum();
        try {
            if (Utils.isDevelopmentEnv()) {
                nodeName = Utils.getLocalHost();
            }
        }
        catch (UnknownHostException e) {
            Trace.out(e);
        }
        location = "//" + nodeName + ":" + portNum + "/OPSMDaemon";
        GetActiveNodes getActiveNodes = this;
        synchronized (getActiveNodes) {
            try {
                Trace.out("Trying to lookup OPSMDaemon at location " + location);
                opsmDaemon = (OPSMDaemonI)Naming.lookup(location);
                Trace.out("Naming.lookup(" + location + ") returns " + opsmDaemon);
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Trace.out("RemoteCommand:Caught Interrupted Exception while  sleeping");
                    e.printStackTrace();
                    throw new ClusterException(s_msgBundle.getMessage("1019", true, args), e);
                }
            }
            catch (ConnectException ce) {
                throw new ClusterException(s_msgBundle.getMessage("1019", true, args), ce);
            }
            catch (NotBoundException nbe) {
                Trace.out("RemoteCommand:Could not lookup the name");
                nbe.printStackTrace();
                throw new ClusterException(s_msgBundle.getMessage("1019", true, args), nbe);
            }
            catch (MalformedURLException me) {
                Trace.out("RemoteCommand: MalformedURL Exception");
                me.printStackTrace();
                throw new ClusterException(s_msgBundle.getMessage("1019", true, args), me);
            }
            catch (RemoteException re) {
                Trace.out("RemoteCommand: RemoteException While Creating  Handle to Daemon");
                re.printStackTrace();
                throw new ClusterException(s_msgBundle.getMessage("1019", true, args), re);
            }
            catch (Exception e) {
                throw new ClusterException(s_msgBundle.getMessage("1019", true, args), e);
            }
        }
        return opsmDaemon;
    }

    private void initializeCluster() throws ClusterException {
        Trace.out("Inside GetActiveNodes.initializeCluster");
        try {
            this.m_clusterUtil = new ClusterUtil();
            this.m_nodeName = this.m_clusterUtil.getLocalNodeName();
        }
        catch (ClusterUtilException cue) {
            throw new ClusterException(cue.getMessage());
        }
        Trace.out("Local node name is " + this.m_nodeName);
    }

    public boolean isCluster() {
        return this.m_isCluster;
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    protected String[] getInternalNodeList() {
        return this.m_internalNodeList;
    }

    public int getNodeNumber() {
        if (this.m_nodeList == null) {
            return 0;
        }
        return this.m_nodeList.length;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    static String getHostName() throws ClusterException {
        try {
            return new Util().getLocalHostName();
        }
        catch (UtilException cue) {
            Trace.out((Exception)((Object)cue));
            throw new ClusterException(s_msgBundle.getMessage("1148", true), (Exception)((Object)cue));
        }
    }

    static String getHostName(String nodeName) throws ClusterException {
        String hostName = null;
        try {
            ClusterUtil clusterUtil = new ClusterUtil();
            hostName = clusterUtil.getHostName(nodeName);
        }
        catch (ClusterUtilException cue) {
            throw new ClusterException(s_msgBundle.getMessage("1056", true, new String[]{nodeName}) + System.getProperty("line.separator") + cue.getMessage());
        }
        Trace.out("hostname = " + hostName);
        return hostName;
    }

    private synchronized boolean submitAndWait(Command command) throws ClusterException {
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1001", true));
        }
        try {
            this.m_blockingSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        return command.getStatus();
    }

    public synchronized boolean checkInstance(String groupName, String instanceName) throws ClusterException {
        Trace.out("instance name passed to checkInstance is " + instanceName);
        return this.checkInstance(groupName, instanceName, false);
    }

    public synchronized boolean checkInstance(String groupName, String instanceName, boolean bskgxn) throws ClusterException {
        Trace.out("instance name passed to checkInstance is " + instanceName);
        if (instanceName == null) {
            throw new ClusterException();
        }
        CheckInstanceCommand checkInstanceCommand = new CheckInstanceCommand(groupName, instanceName, this.m_clusterUtil, bskgxn);
        boolean status = this.submitAndWait(checkInstanceCommand);
        if (checkInstanceCommand.isRunning()) {
            Trace.out("The cluster database instance: " + instanceName + " in group " + groupName + " is still running");
            return true;
        }
        Exception exception = checkInstanceCommand.getException();
        if (exception != null) {
            Trace.out("Exception occurred in calling ClusterUtil");
            throw new ClusterException(exception.getMessage());
        }
        Trace.out("Instance: " + instanceName + " of " + groupName + " is Not running");
        return false;
    }

    public synchronized boolean checkOPS(String groupName) throws ClusterException {
        return this.checkOPS(groupName, false);
    }

    public synchronized boolean checkOPS(String groupName, boolean bskgxn) throws ClusterException {
        CheckOPSCommand checkOPSCommand = new CheckOPSCommand(groupName, this.m_clusterUtil, bskgxn);
        boolean ret = this.submitAndWait(checkOPSCommand);
        if (checkOPSCommand.isRunning()) {
            Trace.out("The cluster database in group " + groupName + " is still running");
            return true;
        }
        Exception exception = checkOPSCommand.getException();
        if (exception != null) {
            Trace.out("Exception occurred in calling ClusterUtil");
            throw new ClusterException(exception.getMessage());
        }
        Trace.out("No instance of " + groupName + " is running");
        return false;
    }

    public synchronized String getCoordinatorName() throws ClusterException {
        GetCoordinatorCommand getCoordinatorCommand = new GetCoordinatorCommand(this.m_gsdGroupName);
        boolean status = this.submitAndWait(getCoordinatorCommand);
        if (!status) {
            Trace.out("Could not get the coordinator name");
            throw new ClusterException();
        }
        Trace.out(" Coordinator node is " + getCoordinatorCommand.getCoordinatorName());
        return getCoordinatorCommand.getCoordinatorName();
    }

    public synchronized String[] getAllDeadDaemons() throws ClusterException {
        GetLiveDaemonCommand getLiveDaemonCommand = new GetLiveDaemonCommand(this.m_gsdGroupName, this.m_clusterUtil);
        if (this.submitAndWait(getLiveDaemonCommand)) {
            String[] liveDaemons = getLiveDaemonCommand.getLiveDaemons();
            if (liveDaemons == null || liveDaemons.length == 0) {
                Trace.out("None of the Daemons are Alive");
                return this.m_nodeList;
            }
            if (liveDaemons.length == this.m_nodeList.length) {
                Trace.out("All the daemons are alive");
                return null;
            }
            String[] deadDaemons = new String[this.m_nodeList.length - liveDaemons.length];
            Trace.out("Number of dead daemons " + deadDaemons.length);
            int k = 0;
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                boolean occurs = false;
                for (int j = 0; j < liveDaemons.length; ++j) {
                    Trace.out("\n The live daemon " + j + " is " + liveDaemons[j]);
                    if (!liveDaemons[j].equals(this.m_nodeList[i])) continue;
                    occurs = true;
                }
                if (occurs) continue;
                deadDaemons[k++] = this.m_nodeList[i];
            }
            return deadDaemons;
        }
        Trace.out("GetActiveNodes:skgxn problem in getting name  of live daemons");
        throw new ClusterException(getLiveDaemonCommand.getException().getMessage());
    }

    public boolean isDaemonRunning(String nodeName) throws ClusterException {
        String[] deadDaemons = null;
        try {
            deadDaemons = this.getAllDeadDaemons();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (deadDaemons == null) {
            return true;
        }
        for (int i = 0; i < deadDaemons.length; ++i) {
            if (!deadDaemons[i].equals(nodeName)) continue;
            return false;
        }
        return true;
    }

    public boolean startDaemon(String nodeName, String scriptLocation) throws ClusterException {
        Trace.out("Trying to start daemon");
        StartOPSMDaemonCommand startOPSMDaemonCommand = new StartOPSMDaemonCommand(nodeName, scriptLocation);
        return startOPSMDaemonCommand.execute();
    }

    private class ClusterWareThread
    implements Runnable {
        ClusterWareThread() throws ClusterException {
        }

        @Override
        public void run() {
            Command commandObj = null;
            while (true) {
                try {
                    commandObj = (Command)GetActiveNodes.this.m_commandBuffer.get();
                    if (commandObj == null) {
                        return;
                    }
                    commandObj.setStatus(commandObj.execute());
                    continue;
                }
                catch (InterruptedException e) {
                    Trace.out(16, "Thread got interrupted");
                    continue;
                }
                catch (Exception e) {
                    Trace.out(e);
                    Trace.out(16, "Exception caught while trying to execute in thread");
                    continue;
                }
                finally {
                    if (commandObj == null) {
                        return;
                    }
                    if (GetActiveNodes.this.m_blockingSemaphore == null) {
                        Trace.out(16, "Blocking semaphore null");
                        continue;
                    }
                    GetActiveNodes.this.m_blockingSemaphore.release();
                    continue;
                }
                break;
            }
        }
    }
}

