/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.util.HashMap;
import java.util.Map;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.Transactional;
import oracle.ops.mgmt.command.service.CreateServiceDepCommand;
import oracle.ops.mgmt.command.service.QueryServiceDepCommand;
import oracle.ops.mgmt.command.service.RemoveServiceDepCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

class ClusterServiceOption
implements Transactional {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkn");
    private int m_executionMode = 4;
    private ClusterConfig m_clusterConfig = ClusterConfig.init();
    private GetActiveNodes m_activeNodes = null;

    ClusterServiceOption() throws ClusterException {
    }

    protected synchronized void createServiceDepCluster(String serviceName, String[] dependencyList, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.createServiceDepOnNodes(serviceName, dependencyList, nodeList, isBlocking);
    }

    protected synchronized void createServiceDepOnNodes(String serviceName, String[] dependencyList, String[] nodeNames, boolean isBlocking) throws ClusterException {
        Command[] createServiceDepCommands = new CreateServiceDepCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            createServiceDepCommands[i] = (CreateServiceDepCommand)new CommandFactory().CreateCommand(new CreateServiceDepCommand(serviceName, dependencyList, nodeNames[i]), 0);
        }
        this.m_clusterConfig.submit(createServiceDepCommands, isBlocking);
    }

    protected synchronized Map<String, String[]> queryServiceDepCluster(String serviceName, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.queryServiceDepOnNodes(serviceName, nodeList, isBlocking);
    }

    protected synchronized Map<String, String[]> queryServiceDepOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        Command[] queryServiceDepCommands = new QueryServiceDepCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            queryServiceDepCommands[i] = (QueryServiceDepCommand)new CommandFactory().CreateCommand(new QueryServiceDepCommand(serviceName, nodeNames[i]), 0);
        }
        this.m_clusterConfig.submit(queryServiceDepCommands, isBlocking);
        HashMap<String, String[]> depMap = new HashMap<String, String[]>();
        for (Command command : queryServiceDepCommands) {
            CommandResult result = command.getCommandResult();
            String[] depList = null;
            if (!result.getStatus()) {
                Object[] args = new String[]{serviceName, command.getNode(), result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1022", true, args));
            }
            String existingDep = result.getResultString()[0];
            Trace.out("existingDep = " + existingDep);
            depList = Utils.getStringArray(existingDep, ",");
            depMap.put(command.getNode(), depList);
        }
        return depMap;
    }

    protected synchronized void removeServiceDepCluster(String serviceName, String[] dependencyList, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.removeServiceDepOnNodes(serviceName, dependencyList, nodeList, isBlocking);
    }

    protected synchronized void removeServiceDepOnNodes(String serviceName, String[] dependencyList, String[] nodeNames, boolean isBlocking) throws ClusterException {
        Command[] removeServiceDepCommands = new RemoveServiceDepCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            removeServiceDepCommands[i] = (RemoveServiceDepCommand)new CommandFactory().CreateCommand(new RemoveServiceDepCommand(serviceName, dependencyList, nodeNames[i]), 0);
        }
        this.m_clusterConfig.submit(removeServiceDepCommands, isBlocking);
    }

    protected void destroy() {
        this.m_clusterConfig.destroy();
    }
}

