/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.Transactional;
import oracle.ops.mgmt.command.registry.CreateRegKeyCommand;
import oracle.ops.mgmt.command.registry.DeleteRegKeyCommand;
import oracle.ops.mgmt.command.registry.DeleteRegValueCommand;
import oracle.ops.mgmt.command.registry.ExistsRegKeyCommand;
import oracle.ops.mgmt.command.registry.GetRegDataCommand;
import oracle.ops.mgmt.command.registry.GetRegSubKeyCommand;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.registry.RegistryNativeResult;
import oracle.ops.mgmt.command.registry.SetRegValueCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

class ClusterRegistry
implements Transactional {
    private int m_executionMode = 4;
    private ClusterConfig m_clusterConfig = ClusterConfig.init();
    private GetActiveNodes m_activeNodes = null;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private static final String SERVICES_KEY = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services";

    ClusterRegistry() throws ClusterException {
    }

    protected synchronized void createRegKeyCluster(String key, String subKey, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.createRegKeyOnNodes(key, subKey, nodeList, isBlocking);
    }

    protected synchronized void createRegKeyOnNodes(String key, String subKey, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Command[] createRegKeyCommands = new CreateRegKeyCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            createRegKeyCommands[i] = (CreateRegKeyCommand)new CommandFactory().CreateCommand(new CreateRegKeyCommand(nodeNames[i], key, subKey), 0);
        }
        try {
            this.m_clusterConfig.submit(createRegKeyCommands, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        for (int i = 0; i < nodeNames.length; ++i) {
            RegistryNativeResult resultObj = ((CreateRegKeyCommand)createRegKeyCommands[i]).getResultObject();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = nodeNames[i];
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " created successfully");
    }

    protected synchronized void deleteRegKeyCluster(String key, String subKey, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.deleteRegKeyOnNodes(key, subKey, nodeList, isBlocking);
    }

    protected synchronized void deleteRegKeyOnNodes(String key, String subKey, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        RegistryNativeResult regResult = new RegistryNativeResult();
        Command[] deleteRegKeyCommands = new DeleteRegKeyCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            deleteRegKeyCommands[i] = (DeleteRegKeyCommand)new CommandFactory().CreateCommand(new DeleteRegKeyCommand(nodeNames[i], key, subKey), 0);
        }
        try {
            this.m_clusterConfig.submit(deleteRegKeyCommands, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        for (int i = 0; i < nodeNames.length; ++i) {
            RegistryNativeResult resultObj = ((DeleteRegKeyCommand)deleteRegKeyCommands[i]).getResultObject();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = nodeNames[i];
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " deleted successfully");
    }

    protected synchronized void setRegValueCluster(String key, String value, Object[] data, int dataType, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.setRegValueOnNodes(key, value, data, dataType, nodeList, isBlocking);
    }

    protected synchronized void setRegValueOnNodes(String key, String value, Object[] data, int dataType, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Trace.out("Setting registry key value/data on Nodes");
        if (data == null) {
            Object[] args = new String[]{key};
            throw new ClusterException(s_msgBundle.getMessage("1051", true, args));
        }
        if (data.length == 0) {
            Object[] args = new String[]{key};
            throw new ClusterException(s_msgBundle.getMessage("1051", true, args));
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null) continue;
            Object[] args = new String[]{key};
            throw new ClusterException(s_msgBundle.getMessage("1051", true, args));
        }
        switch (dataType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                Trace.out("Registry key data type is invalid");
                if (data[0] != null) break;
                Object[] args = new String[]{key};
                throw new ClusterException(s_msgBundle.getMessage("1052", true, args));
            }
        }
        Command[] setRegValueCommands = new SetRegValueCommand[nodeNames.length];
        RegistryKeyData keyData = null;
        block12: for (int i = 0; i < nodeNames.length; ++i) {
            setRegValueCommands[i] = (SetRegValueCommand)new CommandFactory().CreateCommand(new SetRegValueCommand(nodeNames[i], key, value), 0);
            keyData = ((SetRegValueCommand)setRegValueCommands[i]).getDataObject();
            keyData.setDataType(dataType);
            switch (dataType) {
                case 12: {
                    keyData.setData((Integer)data[0]);
                    continue block12;
                }
                case 10: 
                case 14: {
                    keyData.setData((String)data[0]);
                    continue block12;
                }
                case 13: {
                    keyData.setData((Byte)data[0]);
                    continue block12;
                }
                case 11: {
                    keyData.setData((String[])data);
                }
            }
        }
        try {
            this.m_clusterConfig.submit(setRegValueCommands, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        for (int i = 0; i < nodeNames.length; ++i) {
            RegistryNativeResult resultObj = ((SetRegValueCommand)setRegValueCommands[i]).getResultObject();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = nodeNames[i];
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " value/data set successfully");
    }

    protected synchronized void deleteRegValueCluster(String key, String value, boolean isBlocking) throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.deleteRegValueOnNodes(key, value, nodeList, isBlocking);
    }

    protected synchronized void deleteRegValueOnNodes(String key, String value, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Command[] deleteRegValueCommands = new DeleteRegValueCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            deleteRegValueCommands[i] = (DeleteRegValueCommand)new CommandFactory().CreateCommand(new DeleteRegValueCommand(nodeNames[i], key, value), 0);
        }
        try {
            this.m_clusterConfig.submit(deleteRegValueCommands, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        for (int i = 0; i < nodeNames.length; ++i) {
            RegistryNativeResult resultObj = ((DeleteRegValueCommand)deleteRegValueCommands[i]).getResultObject();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = nodeNames[i];
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " delete value successfully");
    }

    protected synchronized Object[] getRegDataOnNode(String key, String value, int dataType, String nodeName, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Trace.out("Inside getRegDataOnNode in ClusterRegistry");
        Command[] getRegDataCommand = new GetRegDataCommand[]{(GetRegDataCommand)new CommandFactory().CreateCommand(new GetRegDataCommand(nodeName, key, value, dataType), 0)};
        try {
            this.m_clusterConfig.submit(getRegDataCommand, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        RegistryNativeResult resultObj = ((GetRegDataCommand)getRegDataCommand[0]).getResultObject();
        bStatus = resultObj.getStatus();
        if (!resultObj.getStatus()) {
            Trace.out("Exception occured while executing native code");
            args[0] = nodeName;
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " get data successfully");
        Object[] result = null;
        RegistryKeyData regKeyData = ((GetRegDataCommand)getRegDataCommand[0]).getDataObject();
        Trace.out("Registry key data obtained successfully");
        switch (dataType) {
            case 10: 
            case 14: {
                result = new Object[]{regKeyData.getStringData()};
                break;
            }
            case 12: {
                result = new Object[]{regKeyData.getIntegerData()};
                break;
            }
            case 13: {
                result = new Object[]{regKeyData.getBinaryData()};
                break;
            }
            case 11: {
                result = new Object[1];
                result = regKeyData.getStringArrayData();
                break;
            }
            default: {
                Trace.out("Invalid data type");
            }
        }
        return result;
    }

    protected synchronized boolean existsRegKeyOnNodes(String key, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Command[] existsRegKeyCommands = new ExistsRegKeyCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            existsRegKeyCommands[i] = (ExistsRegKeyCommand)new CommandFactory().CreateCommand(new ExistsRegKeyCommand(nodeNames[i], key), 0);
        }
        try {
            this.m_clusterConfig.submit(existsRegKeyCommands, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bExists = true;
        boolean bNewLine = false;
        Object[] args = new String[2];
        for (int i = 0; i < nodeNames.length; ++i) {
            RegistryNativeResult resultObj = ((ExistsRegKeyCommand)existsRegKeyCommands[i]).getResultObject();
            bExists &= ((ExistsRegKeyCommand)existsRegKeyCommands[i]).getKeyExists();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = nodeNames[i];
            args[1] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1053", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(key + " exists = " + bExists);
        return bExists;
    }

    protected synchronized String[] getRegSubKey(String key, String nodeName, boolean isBlocking) throws ClusterException {
        HashMap<String, List<String>> rsltMap;
        String[] nodeArr = new String[]{nodeName};
        try {
            rsltMap = this.getRegSubKey(key, nodeArr, isBlocking);
        }
        catch (ClusterOperationException coe) {
            Object[] args = new String[3];
            args[0] = key;
            args[1] = nodeName;
            try {
                args[2] = coe.getErrorMessage(nodeName);
            }
            catch (NoSuchNodeException nsne) {
                args[2] = nsne.getMessage();
            }
            String msg = s_msgBundle.getMessage("1070", true, args);
            throw new ClusterException(msg);
        }
        List<String> svcs = rsltMap.get(nodeName);
        return svcs.toArray(new String[0]);
    }

    protected synchronized HashMap<String, List<String>> getRegSubKey(String key, String[] nodeNames, boolean isBlocking) throws ClusterException, ClusterOperationException {
        return this.doGetRegSubKey(key, nodeNames, isBlocking, false);
    }

    protected synchronized HashMap<String, List<String>> getServices4ImagePath(String[] nodeNames, String imagePath, boolean isBlocking) throws ClusterException, ClusterOperationException {
        HashMap<String, List<String>> rsltMap = this.doGetRegSubKey(SERVICES_KEY, nodeNames, isBlocking, true);
        HashMap<String, List<String>> outMap = new HashMap<String, List<String>>();
        Iterator<String> rsltIter = rsltMap.keySet().iterator();
        while (rsltIter.hasNext()) {
            String node = rsltIter.next().toString();
            Trace.out("Processing services result for node: " + node);
            List<String> srvcList = rsltMap.get(node);
            ArrayList<String> newsrvcList = new ArrayList<String>();
            Trace.out("No of services found on node " + node + " = " + srvcList.size());
            for (String svc : srvcList) {
                int index;
                Trace.out("Service found = " + svc);
                if (!svc.contains("|") || (index = svc.indexOf("|")) == -1) continue;
                String img = svc.substring(index + 1);
                Trace.out("Image path parsed = " + img);
                if (!img.toLowerCase().contains(imagePath.toLowerCase())) continue;
                Trace.out("Adding service " + svc);
                newsrvcList.add(svc.substring(0, index));
            }
            Trace.out("Adding service list of size " + newsrvcList.size() + " for node " + node + " to output map object");
            outMap.put(node, newsrvcList);
        }
        return outMap;
    }

    private HashMap<String, List<String>> doGetRegSubKey(String key, String[] nodeNames, boolean isBlocking, boolean getImagePath) throws ClusterException, ClusterOperationException {
        ClusterException ce = null;
        HashMap<String, List<String>> rsltMap = new HashMap<String, List<String>>();
        Command[] cmd = new GetRegSubKeyCommand[nodeNames.length];
        NativeResult[] results = new RegistryNativeResult[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            cmd[i] = (GetRegSubKeyCommand)new CommandFactory().CreateCommand(new GetRegSubKeyCommand(nodeNames[i], key, getImagePath), 0);
        }
        try {
            this.m_clusterConfig.submit(cmd, isBlocking);
        }
        catch (ClusterException e) {
            ce = e;
            Trace.out("ClusterException: " + ce.getMessage());
        }
        boolean anyFailures = false;
        for (int j = 0; j < nodeNames.length; ++j) {
            results[j] = ((GetRegSubKeyCommand)cmd[j]).getResultObject();
            if (!results[j].getStatus()) {
                Trace.out("Exception occured while executing native code:" + results[j].getOSString());
                anyFailures = true;
                continue;
            }
            RegistryKeyData regKeyData = ((GetRegSubKeyCommand)cmd[j]).getDataObject();
            String[] result = regKeyData.getStringArrayData();
            if (result == null) {
                result = new String[]{};
            }
            Trace.out("Adding node " + nodeNames[j] + " to result Map");
            rsltMap.put(nodeNames[j], Arrays.asList(result));
        }
        if (anyFailures) {
            Trace.out("Throwing CluserOperationException.");
            throw new ClusterOperationException("1069", results);
        }
        return rsltMap;
    }

    protected void waitToCleanUp(int count) throws InterruptedException {
        this.m_clusterConfig.waitToCleanUp(count);
    }

    protected void destroy() {
        this.m_clusterConfig.destroy();
    }
}

