/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.cluster.logger.TraceLogger;
import oracle.cluster.logger.TraceLoggerFactory;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.util.NestedException;

public class ClusterOperationException
extends NestedException {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int EXCEPTION = 2;
    protected Map<String, NativeResult> m_resultMap;

    public ClusterOperationException(String key, NativeResult result) {
        this("Prkc", key, new NativeResult[]{result});
    }

    public ClusterOperationException(String key, NativeResult[] result) {
        this("Prkc", key, result);
    }

    public ClusterOperationException(String key, Object[] args, NativeResult[] result) {
        this("Prkc", key, args, result);
    }

    public ClusterOperationException(String facility, String key, NativeResult[] result) {
        this(facility, key, null, result);
    }

    public ClusterOperationException(String key, Exception e) {
        super("Prkc", key, null, e);
        this.logDiagMessages();
    }

    public ClusterOperationException(String key, Object[] args, Exception e) {
        super("Prkc", key, args, e);
        this.logDiagMessages();
    }

    public ClusterOperationException(String facility, String key, Object[] args, NativeResult[] result) {
        super(facility, key, args);
        this.setResultMap(result);
        this.logDiagMessages();
    }

    protected void setResultMap(NativeResult[] result) {
        this.m_resultMap = new HashMap<String, NativeResult>(result.length);
        for (int i = 0; i < result.length; ++i) {
            this.m_resultMap.put(result[i].getNodeName(), result[i]);
        }
    }

    public int getStatus(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        if (result.getException() != null) {
            return 2;
        }
        if (result.getOSString() != null || !result.getStatus()) {
            return 1;
        }
        return 0;
    }

    public String getErrorMessage(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getOSString();
    }

    public String[] getErrorMessages(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getOSStrings();
    }

    public Exception getException(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getException();
    }

    protected void assertNode(String node) throws NoSuchNodeException {
        if (!this.m_resultMap.containsKey(node)) {
            throw new NoSuchNodeException("1072", new Object[]{node});
        }
    }

    public NativeResult getNativeResult(String node) throws NoSuchNodeException {
        this.assertNode(node);
        return this.m_resultMap.get(node);
    }

    public int getErrorCode(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getOSErrCode();
    }

    public String[] getResultString(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getResultString();
    }

    public String[] getOutputString(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getOutputString();
    }

    public String getNativeResultString(String node) throws NoSuchNodeException {
        this.assertNode(node);
        NativeResult result = this.m_resultMap.get(node);
        return result.getNativeResultString();
    }

    public String[] getResultNodes() {
        String[] nodeNames = new String[this.m_resultMap.size()];
        int i = 0;
        Iterator<String> iterator = this.m_resultMap.keySet().iterator();
        while (iterator.hasNext()) {
            String nodeName;
            nodeNames[i] = nodeName = iterator.next();
            ++i;
        }
        return nodeNames;
    }

    private void logDiagMessages() {
        TraceLoggerFactory tf = TraceLoggerFactory.getInstance();
        TraceLogger s_tlogger = tf.getTraceLogger();
        s_tlogger.logDiagnosticMessages();
    }
}

