/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ops.mgmt.cluster.CSSConfigInfo;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.HostnameException;
import oracle.ops.mgmt.cluster.LocalCSSException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.RemoteCopyException;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.daemon.CheckCSSStatusCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class ClusterInfo {
    private static final String OLSNODES = "olsnodes";
    private static final String LSNODES = "lsnodes";
    private static final String CRSCTL = "crsctl";
    private static String LOCAL_NODE_OPTION = "-l";
    private static String NODE_NUMBER_OPTION = "-n";
    private static String PRIVATE_NODE_NAME_OPTION = "-p";
    private static String NODE_VIP_OPTION = "-i";
    private static String CRSCTL_FORCE_OPTION = "-force";
    private static String CRSCTL_QUERY_OPTION = "query";
    private static String CRSCTL_CSS = "css";
    private static String CRSCTL_CRS = "crs";
    private static String CRSCTL_HAS = "has";
    private static String CRSCTL_VOTEDISK = "votedisk";
    private static String CRSCTL_SOFTWARE_VERSION = "softwareversion";
    private static String CRSCTL_ACTIVE_VERSION = "activeversion";
    private static String CRSCTL_RELEASE_VERSION = "releaseversion";
    private static NativeSystem m_nativeSystem;
    private RuntimeExec m_runtimeExec;
    private String m_olsnodesPath = null;
    private String m_crsctlPath = null;
    private Version m_version;
    private static final String CRSCTL_PRE102_CRSACTIVEVERSION_QUERY_OUTPUT = "Unexpected parameter: crs";

    public ClusterInfo(String CRSHome) throws ClusterInfoException, NoSuchCRSHomeException, NoSuchExecutableException {
        this(CRSHome, new Version());
    }

    public ClusterInfo(String CRSHome, Version ver) throws ClusterInfoException, NoSuchCRSHomeException, NoSuchExecutableException {
        this(CRSHome, Version.isPre10i(ver));
        this.m_version = ver;
    }

    private ClusterInfo(String CRSHome, boolean isPre10iVer) throws ClusterInfoException, NoSuchCRSHomeException, NoSuchExecutableException {
        ClusterInfo.assertHome(CRSHome, true);
        ClusterInfo.initNativeSystem();
        this.m_olsnodesPath = isPre10iVer ? CRSHome + File.separator + "bin" + File.separator + m_nativeSystem.getExeName(LSNODES) : CRSHome + File.separator + "bin" + File.separator + m_nativeSystem.getExeName(OLSNODES);
        File exe = new File(this.m_olsnodesPath);
        if (!exe.exists()) {
            String path = isPre10iVer ? CRSHome + File.separator + m_nativeSystem.getExeName(LSNODES) : CRSHome + File.separator + m_nativeSystem.getExeName(OLSNODES);
            exe = new File(path);
            if (!exe.exists()) {
                Object[] args = new Object[]{this.m_olsnodesPath};
                throw new NoSuchExecutableException(args);
            }
            this.m_olsnodesPath = path;
        }
        Trace.out("m_olsnodesPath=" + this.m_olsnodesPath);
        this.m_crsctlPath = CRSHome + File.separator + "bin" + File.separator + m_nativeSystem.getExeName(CRSCTL);
    }

    public String getLocalNodeName() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_olsnodesPath, LOCAL_NODE_OPTION};
        Trace.out(" cmd=" + cmd[0] + " " + cmd[1]);
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        Trace.out("exit value " + this.m_runtimeExec.getExitValue());
        if (this.m_runtimeExec.getExitValue() == 0) {
            String[] output = this.m_runtimeExec.getOutput();
            Trace.out("output.length=" + output.length);
            for (int i = 0; i < output.length; ++i) {
                Trace.out("output[" + i + "]=" + output[i]);
            }
            if (output.length > 0) {
                return output[0];
            }
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ue) {
                throw new ClusterInfoException("1034", null, (Exception)ue);
            }
            Trace.out("CSS could not return a node name for local hostname=" + hostName);
            Object[] args = new Object[]{hostName};
            throw new ClusterInfoException("1034", args);
        }
        String[] error = this.m_runtimeExec.getError();
        Trace.out("error.length=" + error.length);
        for (int i = 0; i < error.length; ++i) {
            Trace.out("error[" + i + "]=" + error[i]);
        }
        throw new ClusterInfoException(error);
    }

    public String[] getNodeNames() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_olsnodesPath};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0) {
            throw new ClusterInfoException("1035");
        }
        Trace.out("Number of nodes=" + output.length);
        return output;
    }

    public String getHostName(String nodeName) throws ClusterInfoException {
        return ClusterInfo.getHostName(nodeName, this.m_version);
    }

    public static String getHostName(String nodeName, Version version) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        String hostname = null;
        try {
            hostname = m_nativeSystem.getHostName(nodeName);
        }
        catch (HostnameException he) {
            Trace.out("Hostname exception caught: " + he.getMessage());
            throw new ClusterInfoException(he.getMessage());
        }
        if (hostname == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1056", args);
        }
        int dot = hostname.indexOf(46);
        if (dot != -1) {
            hostname = hostname.substring(0, dot);
        }
        Trace.out("Hostname = " + hostname);
        return hostname;
    }

    public static String getPrivateNodeName(String nodeName) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        ClusterInfo.initNativeSystem();
        String privNodeName = null;
        try {
            privNodeName = m_nativeSystem.getPrivateNodeName(nodeName);
        }
        catch (HostnameException he) {
            Trace.out("Hostname exception caught: " + he.getMessage());
            throw new ClusterInfoException(he.getMessage(), he);
        }
        Trace.out("nodeName=" + nodeName + "==> privNodeName=" + privNodeName);
        return privNodeName;
    }

    public String getOraclePrivateName(String nodeName) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        String localNode = this.getLocalNodeName();
        if (!nodeName.equals(localNode)) {
            Trace.out("getOraclePrivateName can only get private name for local node. Specified node name '" + nodeName + "' is not local node '" + localNode + "'");
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1085", args);
        }
        String[] cmd = new String[]{this.m_olsnodesPath, PRIVATE_NODE_NAME_OPTION, LOCAL_NODE_OPTION};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0 || output[0] == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1085", args);
        }
        Trace.out("output[0]=" + output[0]);
        StringTokenizer st = new StringTokenizer(output[0]);
        st.nextToken();
        String nodePrivName = st.hasMoreTokens() ? st.nextToken() : null;
        Trace.out("nodeName=" + nodeName + " Oracle private node name=" + nodePrivName);
        if (nodePrivName == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1085", args);
        }
        return nodePrivName;
    }

    public HashMap getPrivateNodeMap() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_olsnodesPath, PRIVATE_NODE_NAME_OPTION, LOCAL_NODE_OPTION};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0) {
            throw new ClusterInfoException("1035");
        }
        Trace.out("Number of nodes=" + output.length);
        HashMap<String, String> map = new HashMap<String, String>(output.length);
        for (int i = 0; i < output.length; ++i) {
            StringTokenizer st = new StringTokenizer(output[i]);
            String nodeName = st.hasMoreTokens() ? st.nextToken() : null;
            String nodePrivName = st.hasMoreTokens() ? st.nextToken() : null;
            Trace.out("i=" + i + " nodeName=" + nodeName + " nodePrivName=" + nodePrivName);
            map.put(nodeName, nodePrivName);
        }
        return map;
    }

    public String getNodeVIP(String nodeName) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        String[] cmd = new String[]{this.m_olsnodesPath, NODE_VIP_OPTION, nodeName};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0 || output[0] == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1087", args);
        }
        Trace.out("output[0]=" + output[0]);
        StringTokenizer st = new StringTokenizer(output[0]);
        st.nextToken();
        String nodeVIP = st.hasMoreTokens() ? st.nextToken() : null;
        Trace.out("nodeName = " + nodeName + " node VIP = " + nodeVIP);
        if (nodeVIP == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1087", args);
        }
        if (nodeVIP.charAt(0) == '<') {
            Trace.out("nodeVIP returned by olsnodes = " + nodeVIP);
            nodeVIP = null;
        }
        return nodeVIP;
    }

    public HashMap getNodeVIPMap() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_olsnodesPath, NODE_VIP_OPTION};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0) {
            throw new ClusterInfoException("1035");
        }
        Trace.out("Number of nodes = " + output.length);
        HashMap<String, String> map = new HashMap<String, String>(output.length);
        for (int i = 0; i < output.length; ++i) {
            StringTokenizer st = new StringTokenizer(output[i]);
            String nodeName = st.hasMoreTokens() ? st.nextToken() : null;
            String nodeVIP = st.hasMoreTokens() ? st.nextToken() : null;
            Trace.out("i=" + i + " nodeName = " + nodeName + " nodeVIP = " + nodeVIP);
            if (nodeVIP != null && nodeVIP.charAt(0) == '<') {
                Trace.out("VIP returned by olsnodes = " + nodeVIP);
                nodeVIP = null;
            }
            map.put(nodeName, nodeVIP);
        }
        return map;
    }

    public String getRemoteShell() throws RemoteShellException {
        ClusterInfo.initNativeSystem();
        return m_nativeSystem.getRemoteShellCmd();
    }

    public String getRemoteCopy() throws RemoteCopyException {
        ClusterInfo.initNativeSystem();
        return m_nativeSystem.getRemoteCopyCmd();
    }

    public boolean isLocalOnly() throws ClusterInfoException {
        return ClusterInfo.isLocalOnly(this.getLocalNodeName(), this.m_version);
    }

    public static boolean isLocalOnly(Version version) throws ClusterInfoException {
        return ClusterInfo.isLocalOnly("localnode", version);
    }

    public static boolean isLocalOnly(String node) throws ClusterInfoException {
        return ClusterInfo.isLocalOnly(node, new Version());
    }

    public static boolean isLocalOnly(String nodeName, Version version) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        try {
            return m_nativeSystem.isLocalOnly(nodeName, version);
        }
        catch (NativeException e) {
            Trace.out(e);
            throw new ClusterInfoException(e.getMessage(), e);
        }
    }

    public static CSSConfigInfo getCSSConfig(Version version) throws ClusterInfoException {
        return ClusterInfo.getCSSConfig("localnode", version);
    }

    public static CSSConfigInfo getCSSConfig(String node, Version version) throws ClusterInfoException {
        ClusterInfo.assertNode(node);
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        try {
            return new CSSConfigInfo(m_nativeSystem.getCSSConfigType(node, version));
        }
        catch (NativeException e) {
            Trace.out(e);
            throw new ClusterInfoException(e.getMessage(), e);
        }
    }

    public String getNodeNumber(String nodeName) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        String[] cmd = new String[]{this.m_olsnodesPath, NODE_NUMBER_OPTION, nodeName};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0 || output[0] == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1066", args);
        }
        Trace.out("output[0]=" + output[0]);
        StringTokenizer st = new StringTokenizer(output[0]);
        st.nextToken();
        String nodeNum = st.hasMoreTokens() ? st.nextToken() : null;
        Trace.out("nodeName=" + nodeName + " node number=" + nodeNum);
        if (nodeNum == null) {
            Object[] args = new Object[]{nodeName};
            throw new ClusterInfoException("1066", args);
        }
        return nodeNum;
    }

    public Hashtable getClusterNodeMap() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_olsnodesPath, NODE_NUMBER_OPTION};
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0) {
            throw new ClusterInfoException("1035");
        }
        Trace.out("Number of nodes=" + output.length);
        Hashtable<String, String> map = new Hashtable<String, String>(output.length);
        for (int i = 0; i < output.length; ++i) {
            StringTokenizer st = new StringTokenizer(output[i]);
            String nodeName = st.nextToken();
            String nodeNum = st.nextToken();
            Trace.out("i=" + i + " nodeName=" + nodeName + " nodeNum=" + nodeNum);
            map.put(nodeName.trim(), nodeNum.trim());
        }
        return map;
    }

    public String getVoteDiskLocation() throws ClusterInfoException {
        VoteDiskInfo[] votediskInfo = this.getVoteDiskLocations();
        if (votediskInfo != null && votediskInfo.length > 0) {
            return votediskInfo[0].getPath();
        }
        return null;
    }

    public VoteDiskInfo[] getVoteDiskLocations() throws ClusterInfoException {
        return this.getVoteDiskLocations(this.m_version);
    }

    public VoteDiskInfo[] getVoteDiskLocations(Version crsVer) throws ClusterInfoException {
        String[] cmd = null;
        if (Trace.isLevelEnabled(2)) {
            Trace.out("ENTRY");
        }
        if (Version.isPre112(crsVer)) {
            cmd = new String[5];
            cmd[4] = CRSCTL_FORCE_OPTION;
        } else {
            cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_CSS, CRSCTL_VOTEDISK};
        }
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            Trace.out("Exit value != 0\n" + error);
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0 || output[0] == null) {
            Object[] args = new String[]{this.m_runtimeExec.getErrorString()};
            Trace.out("NO OUTPUT\n" + args[0]);
            throw new ClusterInfoException("1092", args);
        }
        ArrayList<VoteDiskInfo> votediskArray = new ArrayList<VoteDiskInfo>(output.length - 1);
        int vdisk_num = 0;
        int vdisk_status = 0;
        long vdisk_size = 0L;
        String vdisk_VDIN = null;
        String vdisk_path = null;
        String vdisk_group = null;
        String disk_no_string = null;
        String path_string = null;
        String grp_string = null;
        for (int i = 0; i < output.length - 1; ++i) {
            StringTokenizer st;
            block14: {
                st = new StringTokenizer(output[i]);
                Trace.out("Number of tokens: " + st.countTokens() + "\noutput[" + i + "]=" + output[i]);
                if (st.countTokens() <= 0 || st.countTokens() != 3 && st.countTokens() != 5) continue;
                try {
                    disk_no_string = st.nextToken();
                    if (disk_no_string.endsWith(".")) {
                        disk_no_string = disk_no_string.substring(0, disk_no_string.length() - 1);
                    }
                    vdisk_num = Integer.parseInt(disk_no_string);
                    if (!st.hasMoreTokens()) break block14;
                    if (Version.isPre112(crsVer)) {
                        vdisk_size = Integer.parseInt(st.nextToken());
                    } else {
                        vdisk_status = this.getVDiskStatusFromMapping(st.nextToken());
                    }
                }
                catch (NumberFormatException nfe) {
                    Trace.out("Number Format Exception:\n" + nfe);
                    continue;
                }
            }
            if (!Version.isPre112(crsVer)) {
                vdisk_VDIN = st.hasMoreTokens() ? st.nextToken() : null;
            }
            path_string = st.hasMoreTokens() ? st.nextToken() : null;
            vdisk_path = path_string != null && path_string.charAt(0) == '(' ? path_string.substring(1, path_string.length() - 1) : path_string;
            if (!Version.isPre112(crsVer)) {
                grp_string = st.hasMoreTokens() ? st.nextToken() : null;
                vdisk_group = grp_string != null && grp_string.equals("[]") ? null : grp_string.substring(1, grp_string.length() - 1);
            }
            if ((!Version.isPre112(crsVer) || vdisk_path == null) && (Version.isPre112(crsVer) || vdisk_path == null || vdisk_VDIN == null || vdisk_status == 0)) continue;
            VoteDiskInfo votedisk = new VoteDiskInfo(vdisk_num, vdisk_size, vdisk_status, vdisk_VDIN, vdisk_path, vdisk_group);
            Trace.out(votedisk.toString());
            votediskArray.add(votedisk);
        }
        VoteDiskInfo[] votedisks = new VoteDiskInfo[votediskArray.size()];
        for (int i = 0; i < votediskArray.size(); ++i) {
            votedisks[i] = (VoteDiskInfo)votediskArray.get(i);
        }
        return votedisks;
    }

    private int getVDiskStatusFromMapping(String strStatus) {
        return VoteDiskInfo.mapStatusToInt(strStatus);
    }

    public static String getOCRLocation(Version version) throws ClusterInfoException {
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        String ocrLocation = null;
        try {
            OCRInfo ocrInfo = new OCRInfo(m_nativeSystem.getOCRLocations(version));
            ocrLocation = ocrInfo.getDisk();
        }
        catch (NativeException e) {
            Trace.out(e);
            throw new ClusterInfoException(e.getMessage(), e);
        }
        return ocrLocation;
    }

    public static OCRInfo getOCRLocations(Version version) throws ClusterInfoException {
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        OCRInfo ocrInfo = null;
        try {
            ocrInfo = new OCRInfo(m_nativeSystem.getOCRLocations(version), version);
        }
        catch (NativeException e) {
            Trace.out(e);
            throw new ClusterInfoException(e.getMessage(), e);
        }
        return ocrInfo;
    }

    public static int checkOCRStorageType(String path) throws ClusterInfoException {
        ClusterInfo.initNativeSystem();
        int retval = 0;
        try {
            retval = m_nativeSystem.checkOCRStorageType(path);
            Trace.out("checkOCRStorageType: retVal " + retval);
        }
        catch (NativeException e) {
            Trace.out(e);
            String msg = e.getMessage();
            throw new ClusterInfoException("1163", new String[]{msg});
        }
        return retval;
    }

    public String getCRSSoftwareVersionString(String nodeName) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_CRS, CRSCTL_SOFTWARE_VERSION, nodeName};
        return this.getSoftwareVersionString(cmd, nodeName, "1093");
    }

    public String getCRSSoftwareVersionString() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_CRS, CRSCTL_SOFTWARE_VERSION};
        return this.getSoftwareVersionString(cmd, null, "1093");
    }

    public String getSIHASoftwareVersionString() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_HAS, CRSCTL_SOFTWARE_VERSION};
        return this.getSoftwareVersionString(cmd, null, "1154");
    }

    public String getCRSReleaseVersionString() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_CRS, CRSCTL_RELEASE_VERSION};
        return this.getReleaseVersionString(cmd);
    }

    public String getSIHAReleaseVersionString() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_HAS, CRSCTL_RELEASE_VERSION};
        return this.getReleaseVersionString(cmd);
    }

    public String getCRSActiveVersionString() throws ClusterInfoException {
        String[] cmd = new String[]{this.m_crsctlPath, CRSCTL_QUERY_OPTION, CRSCTL_CRS, CRSCTL_ACTIVE_VERSION};
        boolean isVersionPre1020 = false;
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        String[] output = this.m_runtimeExec.getOutput();
        if (this.m_runtimeExec.getExitValue() != 0 && output.length != 0 && output[0] != null && output[0].trim().equals(CRSCTL_PRE102_CRSACTIVEVERSION_QUERY_OUTPUT)) {
            String verStrPre1020 = Version.get101Version().toString();
            output[0] = "Oracle Clusterware active version on the cluster is [" + verStrPre1020 + "]";
            isVersionPre1020 = true;
        }
        if (!isVersionPre1020 && this.m_runtimeExec.getExitValue() != 0) {
            Trace.out("Exit value for crsctl query crs activeversion is " + this.m_runtimeExec.getExitValue());
            if (error.length != 0 && error[0] != null) {
                throw new ClusterInfoException(error);
            }
            if (output.length != 0 && output[0] != null) {
                throw new ClusterInfoException(output);
            }
            throw new ClusterInfoException("1094");
        }
        if (output.length == 0 || output[0] == null) {
            String[] args = new String[]{this.m_runtimeExec.getErrorString()};
            throw new ClusterInfoException("1094");
        }
        String versionString = null;
        String tempVerString = null;
        for (int i = 0; i < output.length; ++i) {
            Trace.out("output[" + i + "]=" + output[i]);
            int startIndex = output[i].indexOf(91);
            int endIndex = output[i].indexOf(93);
            if (startIndex != -1 && endIndex != -1) {
                tempVerString = output[i].substring(startIndex + 1, endIndex).trim();
            }
            if (tempVerString == null || !tempVerString.contains(".")) continue;
            versionString = tempVerString;
            break;
        }
        Trace.out("Active version = " + versionString);
        if (versionString != null && !versionString.isEmpty()) {
            return versionString;
        }
        Object[] args = new String[]{this.m_runtimeExec.getErrorString()};
        throw new ClusterInfoException("1094", args);
    }

    private boolean isSupportedVersion(String versionStr) {
        try {
            return Version.getVersion(versionStr) != null;
        }
        catch (ConfigurationException ce) {
            Trace.out("Failed to get version with exception: " + ce.getMessage());
            return false;
        }
    }

    public static String getLocalCSSHome(Version version) throws ClusterInfoException, LocalCSSException {
        return ClusterInfo.getLocalCSSHome("localnode", version);
    }

    public static String getLocalCSSHome(String nodeName, Version version) throws ClusterInfoException, LocalCSSException {
        ClusterInfo.assertNode(nodeName);
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        try {
            if (m_nativeSystem.isLocalOnly(nodeName, version)) {
                return m_nativeSystem.getLocalCSSHome(nodeName, version);
            }
            Object[] args = new String[]{nodeName};
            throw new LocalCSSException("1102", args);
        }
        catch (NativeException e) {
            Trace.out(e);
            throw new ClusterInfoException(e.getMessage(), e);
        }
    }

    public static boolean checkCSSStatus(String oracleHome, Version version) throws ClusterInfoException {
        return ClusterInfo.checkCSSStatus("localnode", oracleHome, version);
    }

    public static boolean checkCSSStatus(String nodeName, String oracleHome, Version version) throws ClusterInfoException {
        ClusterInfo.assertNode(nodeName);
        String[] nodeNames = new String[]{nodeName};
        boolean[] retVal = ClusterInfo.checkCSSStatus(nodeNames, oracleHome, version);
        return retVal[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] checkCSSStatus(String[] nodeNames, String oracleHome, Version version) throws ClusterInfoException {
        ClusterInfo.assertNodes(nodeNames);
        ClusterInfo.assertVersion(version);
        ClusterInfo.initNativeSystem();
        ClusterInfo.assertHome(oracleHome, false);
        Command[] checkCSSStatusCommands = new CheckCSSStatusCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            checkCSSStatusCommands[i] = (CheckCSSStatusCommand)factory.CreateCommand(new CheckCSSStatusCommand(nodeNames[i], oracleHome, version), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = null;
            try {
                clusterConfig = ClusterConfig.init(nodeNames.length);
                clusterConfig.submit(checkCSSStatusCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                if (clusterConfig != null) {
                    clusterConfig.destroy();
                }
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            checkCSSStatusCommands[0].execute();
        }
        NativeResult[] results = new NativeResult[nodeNames.length];
        StringBuffer nodeBuf = new StringBuffer();
        boolean bThrowClusterInfoException = false;
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        boolean[] bCssStatus = new boolean[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = checkCSSStatusCommands[i].getCommandResult();
            bCssStatus[i] = ((CheckCSSStatusCommand)checkCSSStatusCommands[i]).getCSSStatus();
            boolean bException = results[i].getException() != null;
            String errors = results[i].getOSString();
            boolean bErrors = errors != null && errors.length() > 0;
            Trace.out("bException = " + bException);
            Trace.out("bErrors = " + bErrors);
            bThrowClusterInfoException |= bException | bErrors;
            if (!bException) continue;
            Trace.out("error encountered on " + nodeNames[i]);
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(MessageBundle.getMessageBundle("Prkc").getMessage("1074", false, args));
        }
        if (bThrowClusterInfoException) {
            Object[] args = new Object[]{nodeBuf.toString(), errBuf.toString()};
            throw new ClusterInfoException("1103", args);
        }
        return bCssStatus;
    }

    static final void assertNode(String nodeName) throws ClusterInfoException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new ClusterInfoException("1045");
        }
    }

    static final void assertNodes(String[] nodeNames) throws ClusterInfoException {
        if (nodeNames == null || nodeNames.length == 0) {
            throw new ClusterInfoException("1062");
        }
    }

    static final void assertVersion(Version version) throws ClusterInfoException {
        if (version == null) {
            throw new ClusterInfoException("1130");
        }
    }

    static final void initNativeSystem() {
        if (m_nativeSystem == null) {
            m_nativeSystem = new SystemFactory().CreateSystem();
        }
    }

    static final void assertHome(String oracleHome, boolean bCrsHome) throws NoSuchCRSHomeException, ClusterInfoException {
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new ClusterInfoException(bCrsHome ? "1036" : "1076");
        }
        if (!new File(oracleHome).isDirectory()) {
            Object[] args = new String[]{oracleHome};
            if (bCrsHome) {
                throw new NoSuchCRSHomeException(args);
            }
            throw new ClusterInfoException("1032", args);
        }
    }

    private String getSoftwareVersionString(String[] cmd, String nodeName, String errorMsgID) throws ClusterInfoException {
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        if (output.length == 0 || output[0] == null) {
            Object[] args = nodeName == null ? new String[]{this.m_runtimeExec.getErrorString()} : new String[]{nodeName, this.m_runtimeExec.getErrorString()};
            throw new ClusterInfoException(errorMsgID, args);
        }
        Trace.out("output[0]=" + output[0]);
        String versionString = null;
        StringTokenizer tokenizer = new StringTokenizer(output[0], "[", false);
        if (tokenizer.countTokens() == 2) {
            tokenizer.nextToken();
            versionString = tokenizer.nextToken();
        } else if (tokenizer.countTokens() == 3) {
            tokenizer.nextToken();
            tokenizer.nextToken();
            versionString = tokenizer.nextToken();
        }
        if (versionString == null) {
            Object[] args = nodeName == null ? new String[]{this.m_runtimeExec.getErrorString()} : new String[]{nodeName, this.m_runtimeExec.getErrorString()};
            throw new ClusterInfoException(errorMsgID, args);
        }
        int index = versionString.indexOf("]");
        String softwareVersion = versionString;
        if (index != -1) {
            softwareVersion = versionString.substring(0, index);
        }
        Trace.out("Software version = " + versionString);
        return softwareVersion;
    }

    public String getReleaseVersionString(String[] cmd) throws ClusterInfoException {
        this.m_runtimeExec = new RuntimeExec(cmd, null, null);
        this.m_runtimeExec.runCommand();
        String[] error = this.m_runtimeExec.getError();
        if (this.m_runtimeExec.getExitValue() != 0) {
            throw new ClusterInfoException(error);
        }
        String[] output = this.m_runtimeExec.getOutput();
        Trace.out("output[0]=" + output[0]);
        StringTokenizer st = new StringTokenizer(output[0], "[", false);
        st.nextToken();
        String versionString = st.hasMoreTokens() ? st.nextToken() : null;
        String releaseVersion = null;
        if (versionString != null) {
            int index = versionString.indexOf("]");
            releaseVersion = index != -1 ? versionString.substring(0, index) : versionString;
            Trace.out("Release version = " + releaseVersion);
        }
        return releaseVersion;
    }
}

