/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.common.CommonBaseException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class ClusterException
extends CommonBaseException {
    private StringBuffer m_errorBuffer = null;
    private Exception m_exception = null;
    private List<CommandResult> m_commandResultList = new ArrayList<CommandResult>();

    public ClusterException() {
    }

    public ClusterException(String msg) {
        super(msg);
    }

    public ClusterException(String msg, Command[] commands) {
        super(msg);
        if (commands != null) {
            this.setErrorMessage(commands);
        } else {
            Trace.out("Command passed to ClusterException is null");
        }
    }

    public ClusterException(String msg, Exception e) {
        super(msg);
        this.m_exception = e;
    }

    private void setErrorMessage(Command[] commands) {
        CommandResult commandResult = null;
        this.m_errorBuffer = new StringBuffer();
        if (commands == null) {
            return;
        }
        try {
            for (int i = 0; i < commands.length; ++i) {
                Trace.out("ClusterException.setErrorMessage: commands[" + i + "]=" + commands[i]);
                try {
                    commandResult = commands[i] != null ? commands[i].getCommandResult() : null;
                }
                catch (Exception e) {
                    Trace.out(e);
                }
                if (commandResult == null) continue;
                this.m_commandResultList.add(commandResult);
                try {
                    String errStr = commandResult.getErrorString();
                    if (errStr != null && !errStr.equals("")) {
                        if (this.m_errorBuffer.toString().equals("")) {
                            this.m_errorBuffer.append(errStr);
                        } else {
                            this.m_errorBuffer.append(Constants.LINE_SEPARATOR + errStr);
                        }
                        Trace.out("ClusterException.setErrorMessage: errString is '" + errStr + "'");
                    }
                    if ((errStr = commandResult.getOSString()) == null || errStr.equals("")) continue;
                    if (this.m_errorBuffer.toString().equals("")) {
                        this.m_errorBuffer.append(errStr);
                    } else {
                        this.m_errorBuffer.append(Constants.LINE_SEPARATOR + errStr);
                    }
                    Trace.out("ClusterException.setErrorMessage: errString is '" + errStr + "'");
                    continue;
                }
                catch (Exception e) {
                    Trace.out(e);
                }
            }
        }
        catch (Exception e) {
            Trace.out("setErrorMessage:Bad Result");
        }
    }

    public List<CommandResult> getCommandResult() {
        return this.m_commandResultList;
    }

    public String getErrorMessage() {
        return this.getMessage();
    }

    public String getNLSErrorMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String msg = this.m_errorBuffer != null && this.m_errorBuffer.toString().trim().length() != 0 ? this.m_errorBuffer.toString() : super.getMessage();
        if (this.m_exception != null) {
            msg = msg + "\n" + this.m_exception.getMessage();
        }
        return msg;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.m_exception != null) {
            this.m_exception.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_exception != null) {
            this.m_exception.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.m_exception != null) {
            this.m_exception.printStackTrace(s);
        }
    }
}

