/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import oracle.ops.mgmt.cluster.ClientResource;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterService;
import oracle.ops.mgmt.cluster.CommandBuffer;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.RemoteResponseEventMulticaster;
import oracle.ops.mgmt.cluster.RemoteResponseListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.PrepareCommand;
import oracle.ops.mgmt.command.StatusLogger;
import oracle.ops.mgmt.command.Transactional;
import oracle.ops.mgmt.command.daemon.StartOPSMDaemonCommand;
import oracle.ops.mgmt.command.file.ChangeFilePermissionsCommand;
import oracle.ops.mgmt.command.file.CopyCommand;
import oracle.ops.mgmt.command.file.DirCreateCommand;
import oracle.ops.mgmt.command.file.DirRemoveCommand;
import oracle.ops.mgmt.command.file.LinkCommand;
import oracle.ops.mgmt.command.file.MoveCommand;
import oracle.ops.mgmt.command.file.RemoveCommand;
import oracle.ops.mgmt.command.listener.StartListenerCommand;
import oracle.ops.mgmt.command.service.CheckServiceCommand;
import oracle.ops.mgmt.command.service.CreateServiceCommand;
import oracle.ops.mgmt.command.service.DeleteServiceCommand;
import oracle.ops.mgmt.command.service.StartServiceCommand;
import oracle.ops.mgmt.command.service.StopServiceCommand;
import oracle.ops.mgmt.command.util.RunCtlCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.synchronize.Semaphore;
import oracle.ops.mgmt.synchronize.SyncBuffer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

class ClusterConfig
implements Transactional,
ClusterService,
Constants {
    private static ClusterConfig s_instance = null;
    private static int s_refCount = 0;
    private static final int DEFAULT_SIZE = 4;
    private static Object s_blockLock = new Object();
    private static Hashtable s_clientThreadTable;
    private static MessageBundle s_msgBundle;
    private static int m_threadCount;
    private ThreadGroup m_clusterThreadGroup;
    private SyncBuffer m_commandBuffer;
    private String m_localNode;
    private GetActiveNodes m_activeNodes = null;
    private static boolean s_deconfigFlag;
    private static final String INSTALL_PROPERTY = "oracle.installer.setupWizard";

    private ClusterConfig(int workerCount) throws ClusterException {
        s_clientThreadTable = new Hashtable();
        Trace.out("ClusterConfig:Number of workers = " + m_threadCount);
        this.m_commandBuffer = new SyncBuffer(workerCount);
        this.m_clusterThreadGroup = new ThreadGroup("Cluster Thread Group");
        this.createWorkers(workerCount);
        try {
            if (ClusterConfig.isClusterInstalled()) {
                this.createGetActiveNodes();
            }
        }
        catch (ClusterException e) {
            this.m_activeNodes = null;
        }
        if (this.m_activeNodes != null) {
            this.m_localNode = this.m_activeNodes.getNodeName();
        } else {
            try {
                this.m_localNode = InetAddress.getLocalHost().getHostName();
                int index = this.m_localNode.indexOf(".");
                if (index > 0) {
                    this.m_localNode = this.m_localNode.substring(0, index);
                }
            }
            catch (UnknownHostException ue) {
                this.m_localNode = null;
            }
        }
    }

    public static boolean getDeconfigNonClusterMode() {
        return s_deconfigFlag;
    }

    public static void setDeconfigNonClusterMode(boolean dcFlag) {
        s_deconfigFlag = dcFlag;
    }

    private void createWorkers(int workerCount) {
        Thread[] worker = new Thread[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            int workerNum = m_threadCount + i;
            worker[i] = new Thread(this.m_clusterThreadGroup, new ExecuteCommand(workerNum), "Worker " + workerNum);
            worker[i].setDaemon(true);
        }
        for (int k = 0; k < workerCount; ++k) {
            worker[k].start();
        }
        if ((m_threadCount += workerCount) == workerCount) {
            Trace.out("Started worker threads count=" + m_threadCount);
        } else {
            Trace.out("Started additional worker threads count=" + workerCount);
        }
    }

    private int getNumberOfThreads() {
        return this.getNodeNumber();
    }

    protected int getNodeNumber() {
        if (this.m_activeNodes != null) {
            return this.m_activeNodes.getNodeNumber();
        }
        return m_threadCount;
    }

    static final boolean isClusterInstalled() {
        boolean hasJarPresent;
        try {
            Class<?> cl = Class.forName("oracle.ops.mgmt.has.ClusterUtil");
            hasJarPresent = true;
        }
        catch (ClassNotFoundException e) {
            hasJarPresent = false;
        }
        catch (NoClassDefFoundError e) {
            hasJarPresent = false;
        }
        Trace.out("hasJarPresent=" + hasJarPresent);
        if (!hasJarPresent) {
            return false;
        }
        String installProp = System.getProperty(INSTALL_PROPERTY);
        if ("TRUE".equalsIgnoreCase(installProp)) {
            return false;
        }
        if (s_deconfigFlag) {
            Trace.out("Deconfig flag = " + s_deconfigFlag);
            return hasJarPresent;
        }
        return Cluster.isCluster();
    }

    protected static synchronized ClusterConfig init() throws ClusterException {
        int workerCount;
        boolean hasJarPresent = ClusterConfig.isClusterInstalled();
        try {
            int n = workerCount = hasJarPresent ? GetActiveNodes.create().getNodeNumber() : 4;
            if (workerCount < 4) {
                workerCount = 4;
            }
        }
        catch (ClusterException e) {
            workerCount = 4;
        }
        return ClusterConfig.init(workerCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized ClusterConfig init(int workerCount) throws ClusterException {
        if (s_instance == null) {
            s_instance = new ClusterConfig(workerCount);
        }
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            Trace.out("Returning same instance to client" + Thread.currentThread().getName());
            Object object = s_clientThreadTable.get(Thread.currentThread());
            if (object == null) {
                s_clientThreadTable.put(Thread.currentThread(), new ClientResource(s_instance.getNodeNumber()));
            }
            if (m_threadCount < workerCount) {
                s_instance.createWorkers(workerCount - m_threadCount);
            }
            ++s_refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            Thread clientThread = Thread.currentThread();
            Trace.out("destroying resources for client thread " + clientThread);
            ClientResource clientResource = (ClientResource)s_clientThreadTable.get(clientThread);
            clientResource.cleanUp();
            --s_refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean submit(Command[] commandVector, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("Entering submit, cmdCount=" + commandVector.length);
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            if (clientResource.getCommandBufferLength() < commandVector.length) {
                if (clientResource.getBuffer().getFillCount() == 0) {
                    Trace.out("Reinitializing ClientResource for client " + Thread.currentThread().getName());
                    clientResource.cleanUp();
                    s_clientThreadTable.put(Thread.currentThread(), new ClientResource(commandVector.length, false));
                    clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
                } else {
                    throw new ClusterException("Can not accept a commandVector of length " + commandVector.length + " Maximum allowed length is " + ((ClientResource)s_clientThreadTable.get(Thread.currentThread())).getCommandBufferLength());
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            for (int i = 0; i < commandVector.length; ++i) {
                ++commandCount;
                try {
                    this.m_commandBuffer.put(commandVector[i]);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ClusterException(s_msgBundle.getMessage("1001", true));
                }
            }
            Trace.out("submitted commands=" + commandCount);
            if (isBlocking) {
                try {
                    ClusterConfig.block(commandCount);
                }
                catch (InterruptedException e) {
                    throw new ClusterException(s_msgBundle.getMessage("1003", true));
                }
            }
            Trace.out("Out of block");
            CommandBuffer clientCommandBuffer = null;
            try {
                clientCommandBuffer = clientResource.getBuffer();
            }
            catch (Exception e) {
                Trace.out("Exception while getting client Command Buffer");
            }
            boolean status = false;
            if (clientCommandBuffer == null) {
                Trace.out("Client Command Buffer is NULL");
            }
            if (clientCommandBuffer != null) {
                status = clientCommandBuffer.checkCommandStatus();
            }
            Trace.out("status=" + status);
            try {
                if (status) {
                    boolean bl = status;
                    return bl;
                }
                throw new ClusterException(s_msgBundle.getMessage("1002", true), clientCommandBuffer.getAllCommands());
            }
            finally {
                clientResource.clearCommandBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void block(int commandNum) throws InterruptedException {
        Trace.out("block called by thread " + Thread.currentThread().getName() + " commandNum " + commandNum);
        Object object = s_blockLock;
        synchronized (object) {
            Semaphore blockingSemaphore = ((ClientResource)s_clientThreadTable.get(Thread.currentThread())).getSemaphore();
            if (blockingSemaphore == null) {
                Trace.out("Problem acquiring Blocking Semaphore in main thread");
                return;
            }
            for (int i = 0; i < commandNum; ++i) {
                blockingSemaphore.acquire();
                Trace.out("block acquired semnum=" + i);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void waitToCleanUp(int commandCount) throws InterruptedException {
        Semaphore blockingSemaphore;
        Object object = s_blockLock;
        synchronized (object) {
            blockingSemaphore = ((ClientResource)s_clientThreadTable.get(Thread.currentThread())).getSemaphore();
        }
        for (int i = 0; i < commandCount; ++i) {
            blockingSemaphore.acquire();
        }
        this.destroy();
    }

    private synchronized boolean copyFileBetweenNodes(String nodeName1, String fileName1, String nodeName2, String fileName2, int phase, boolean noPreserve) {
        boolean commandCount = false;
        String sourceNode = nodeName1;
        String destNode = nodeName2;
        Trace.out("Checking: Copying files between nodes: " + nodeName1 + ":" + fileName1 + " " + nodeName2 + ":" + fileName2);
        if (nodeName1.equalsIgnoreCase(this.m_localNode)) {
            sourceNode = "localnode";
        }
        if (nodeName2.equalsIgnoreCase(this.m_localNode)) {
            destNode = "localnode";
        }
        Trace.out("Checking 2: Copying files between nodes: " + sourceNode + ":" + fileName1 + " " + destNode + ":" + fileName2);
        Command command = new CommandFactory().CreateCommand(new CopyCommand(sourceNode, fileName1, destNode, fileName2, noPreserve), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected synchronized boolean copyFileBetweenNodes(String nodeName1, String fileName1, String nodeName2, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileBetweenNodes(nodeName1, fileName1, nodeName2, fileName2, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean copyFileBetweenNodes(String nodeName1, String fileName1, String nodeName2, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        int commandCount = 0;
        String sourceNode = nodeName1;
        String destNode = nodeName2;
        if (nodeName1.equalsIgnoreCase(this.m_localNode)) {
            sourceNode = "localnode";
        }
        if (nodeName2.equalsIgnoreCase(this.m_localNode)) {
            destNode = "localnode";
        }
        Trace.out("Copying files between nodes: " + sourceNode + ":" + fileName1 + " " + destNode + ":" + fileName2);
        CopyCommand command = new CopyCommand(sourceNode, fileName1, destNode, fileName2, noPreserve);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer clientCommandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            clientCommandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var13_15] (shouldn't be in output)
            if (clientCommandBuffer != null && clientCommandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1004", true), clientCommandBuffer.getAllCommands());
        }
    }

    protected synchronized boolean copyFileToNodes(String fileName1, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.copyFileToNodes(fileName1, nodeNames, fileName1, isBlocking, false);
    }

    protected synchronized boolean copyFileToNodes(String fileName1, String[] nodeNames, boolean isBlocking, boolean noPreserve) throws ClusterException {
        return this.copyFileToNodes(fileName1, nodeNames, fileName1, isBlocking, noPreserve);
    }

    protected synchronized boolean copyFileToNodes(String fileName1, String[] nodeNames, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileToNodesNonSynchronized(fileName1, nodeNames, fileName2, isBlocking, false);
    }

    protected synchronized boolean copyFileToNodes(String fileName1, String[] nodeNames, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        return this.copyFileToNodesNonSynchronized(fileName1, nodeNames, fileName2, isBlocking, noPreserve);
    }

    protected boolean copyFileToNodesNonSynchronized(String fileName1, String[] nodeNames, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileToNodesNonSynchronized(fileName1, nodeNames, fileName2, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyFileToNodesNonSynchronized(String fileName1, String[] nodeNames, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        int commandCount = 0;
        Trace.out("Number of nodes :" + nodeNames.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            Trace.out(i + "th CopyFileToNodes " + "localnode" + ":" + fileName1 + " to " + nodeNames[i] + ":" + fileName2);
            if (this.m_activeNodes == null) {
                ++commandCount;
                this.copyFileBetweenNodes("localnode", fileName1, nodeNames[i], fileName2, 0, noPreserve);
                continue;
            }
            if (this.m_activeNodes.getNodeName().compareTo(nodeNames[i]) == 0 && fileName1.compareTo(fileName2) == 0) continue;
            ++commandCount;
            this.copyFileBetweenNodes("localnode", fileName1, nodeNames[i], fileName2, 0, noPreserve);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var9_11] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            Trace.out("clusterConfig.copyFileToNodes: throwing ClusterException with mesg `" + s_msgBundle.getMessage("1004", true) + "'");
            throw new ClusterException(s_msgBundle.getMessage("1004", true), commandBuffer.getAllCommands());
        }
    }

    protected synchronized boolean copyFileToNode(String fileName1, String nodeName, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileToNode(fileName1, nodeName, fileName2, isBlocking, false);
    }

    protected synchronized boolean copyFileToNode(String fileName1, String nodeName, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        String[] nodeNames = new String[]{nodeName};
        return this.copyFileToNodes(fileName1, nodeNames, fileName2, isBlocking, noPreserve);
    }

    protected synchronized boolean copyFileToNodesPrepare(String fileName1, String[] nodeNames, String fileName2) {
        return this.copyFileToNodesPrepare(fileName1, nodeNames, fileName2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean copyFileToNodesPrepare(String fileName1, String[] nodeNames, String fileName2, boolean noPreserve) {
        Trace.out("Inside copyFileToNodesPrepare source =" + fileName1 + " dest= " + fileName2);
        int commandCount = 0;
        for (int i = 0; i < nodeNames.length; ++i) {
            if (this.m_activeNodes == null) {
                ++commandCount;
                this.copyFileBetweenNodes("localnode", fileName1, nodeNames[i], fileName2, 0, noPreserve);
                continue;
            }
            if (this.m_activeNodes.getNodeName().compareTo(nodeNames[i]) == 0 && fileName1.compareTo(fileName2) == 0) continue;
            ++commandCount;
            this.copyFileBetweenNodes("localnode", fileName1, nodeNames[i], fileName2, 1, noPreserve);
        }
        try {
            ClusterConfig.block(commandCount);
        }
        catch (InterruptedException e) {
            return false;
        }
        Trace.out("Waking up after blockCopyFileToNodesPrepare " + Thread.currentThread().getName());
        CommandBuffer prepareCommandBuffer = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            prepareCommandBuffer = ((ClientResource)s_clientThreadTable.get(Thread.currentThread())).getBuffer();
            // ** MonitorExit[var7_9] (shouldn't be in output)
            return prepareCommandBuffer != null && prepareCommandBuffer.checkCommandStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean removeFileFromNodesPrepare(String[] nodeNames, String fileName) {
        for (int i = 0; i < nodeNames.length; ++i) {
            this.removeFileFromNode(nodeNames[i], fileName, 1);
        }
        try {
            ClusterConfig.block(nodeNames.length);
        }
        catch (InterruptedException e) {
            return false;
        }
        Trace.out("Waking up after block remove FileFromNodes" + Thread.currentThread().getName());
        CommandBuffer prepareCommandBuffer = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            prepareCommandBuffer = ((ClientResource)s_clientThreadTable.get(Thread.currentThread())).getBuffer();
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return prepareCommandBuffer != null && prepareCommandBuffer.checkCommandStatus();
        }
    }

    protected synchronized boolean copyFileCluster(String fileName, boolean isBlocking) throws ClusterException {
        return this.copyFileCluster(fileName, isBlocking, false);
    }

    protected synchronized boolean copyFileCluster(String fileName, boolean isBlocking, boolean noPreserve) throws ClusterException {
        Trace.out("Inside copyFileCluster");
        this.copyFileCluster(fileName, fileName, isBlocking, noPreserve);
        return true;
    }

    protected synchronized boolean copyFileCluster(String fileName1, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileCluster(fileName1, fileName2, isBlocking, false);
    }

    protected synchronized boolean copyFileCluster(String fileName1, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        for (int j = 0; j < nodeList.length; ++j) {
            Trace.out("Node Name: " + nodeList[j]);
        }
        return this.copyFileToNodes(fileName1, nodeList, fileName2, isBlocking, noPreserve);
    }

    protected synchronized boolean copyFileFromNode(String nodeName, String fileName1, String fileName2, boolean isBlocking) throws ClusterException {
        return this.copyFileFromNode(nodeName, fileName1, fileName2, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean copyFileFromNode(String nodeName, String fileName1, String fileName2, boolean isBlocking, boolean noPreserve) throws ClusterException {
        if (nodeName.compareTo("localnode") != 0 || fileName1.compareTo(fileName2) != 0) {
            this.copyFileBetweenNodes(nodeName, fileName1, "localnode", fileName2, 0, noPreserve);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(1);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_9] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            if (commandBuffer != null) {
                throw new ClusterException(s_msgBundle.getMessage("1004", true), commandBuffer.getAllCommands());
            }
            throw new ClusterException(s_msgBundle.getMessage("1004", true));
        }
    }

    protected synchronized boolean startOPSMDaemonOnNodes(String[] nodeNames, String OracleHomeName, boolean isBlocking) throws ClusterException {
        Command[] startOPSMDaemonCommands = new StartOPSMDaemonCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            startOPSMDaemonCommands[i] = (StartOPSMDaemonCommand)new CommandFactory().CreateCommand(new StartOPSMDaemonCommand(nodeNames[i], OracleHomeName), 0);
        }
        return this.submit(startOPSMDaemonCommands, isBlocking);
    }

    protected synchronized boolean startOPSMDaemonCluster(String OracleHomeName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeNames = this.m_activeNodes.getInternalNodeList();
        return this.startOPSMDaemonOnNodes(nodeNames, OracleHomeName, isBlocking);
    }

    protected synchronized boolean startListener(String[] nodeNames, String[] listenerList, String oracleHome, String OracleHomeName, boolean isBlocking) throws ClusterException {
        Command[] startListenerCommands = new StartListenerCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            startListenerCommands[i] = (StartListenerCommand)new CommandFactory().CreateCommand(new StartListenerCommand(nodeNames[i], listenerList[i], oracleHome, OracleHomeName), 0);
        }
        return this.submit(startListenerCommands, isBlocking);
    }

    protected synchronized boolean startListener(String[] nodeNames, String listenerName, String oracleHome, String OracleHomeName, boolean isBlocking) throws ClusterException {
        String[] listenerList = new String[nodeNames.length];
        for (int i = 0; i < listenerList.length; ++i) {
            listenerList[i] = listenerName;
        }
        return this.startListener(nodeNames, listenerList, oracleHome, OracleHomeName, isBlocking);
    }

    protected synchronized boolean startListener(String nodeName, String listenerName, String oracleHome, String OracleHomeName, boolean isBlocking) throws ClusterException {
        String[] nodeNames = new String[]{nodeName};
        return this.startListener(nodeNames, listenerName, oracleHome, OracleHomeName, isBlocking);
    }

    protected boolean runCmd(String cmd, String[] args, String[] env, String[] nodeList, boolean isBlocking) throws ClusterException {
        Command[] runCommands = new RunCtlCommand[nodeList.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i].equalsIgnoreCase(this.m_localNode) ? "localnode" : nodeList[i];
            runCommands[i] = (RunCtlCommand)factory.CreateCommand(new RunCtlCommand(cmd, args, env, node), 0);
        }
        return this.submit(runCommands, isBlocking);
    }

    protected synchronized boolean removeFileCluster(String fileName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        this.removeFileFromNodes(nodeList, fileName, isBlocking);
        return true;
    }

    protected synchronized boolean removeFileFromNodes(String[] nodeNames, String fileName, boolean isBlocking) throws ClusterException {
        return this.removeFileFromNodesNonSynchronized(nodeNames, fileName, isBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFileFromNodesNonSynchronized(String[] nodeNames, String fileName, boolean isBlocking) throws ClusterException {
        for (int i = 0; i < nodeNames.length; ++i) {
            this.removeFileFromNode(nodeNames[i], fileName, 0);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(nodeNames.length);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var6_8] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1005", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean removeFileFromNode(String nodeName, String fileName, int phase) {
        Trace.out("Removing file  from nodes: " + nodeName + " " + fileName);
        Command command = new CommandFactory().CreateCommand(new RemoveCommand(nodeName, fileName), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean removeFileFromNode(String nodeName, String fileName, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("Removing file  from nodes: " + nodeName + " " + fileName);
        RemoveCommand command = new RemoveCommand(nodeName, fileName);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1005", true), commandBuffer.getAllCommands());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean moveFilesOnNode(String nodeName, String sourceFile, String destFile, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("Moving files on node: " + nodeName + " " + sourceFile + " " + destFile);
        MoveCommand command = new MoveCommand(nodeName, sourceFile, destFile);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var9_11] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1006", true), commandBuffer.getAllCommands());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean linkFilesOnNode(String nodeName, String sourceFile, String destFile, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("Linking files on node: " + nodeName + " " + sourceFile + " " + destFile);
        LinkCommand command = new LinkCommand(nodeName, sourceFile, destFile);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var9_11] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1015", true), commandBuffer.getAllCommands());
        }
    }

    protected synchronized boolean copyDirContentsToNodes(String[] nodeName, String pathName, boolean isBlocking) throws ClusterException {
        return this.copyDirContentsToNodes(nodeName, pathName, isBlocking, false);
    }

    protected synchronized boolean copyDirContentsToNodes(String[] nodeName, String pathName, boolean isBlocking, boolean noPreserve) throws ClusterException {
        String[] dirContents = new File(pathName).list();
        if (dirContents == null) {
            Object[] args = new String[]{pathName};
            throw new ClusterException(s_msgBundle.getMessage("1061", true, args));
        }
        for (int i = 0; i < dirContents.length; ++i) {
            dirContents[i] = pathName + File.separatorChar + dirContents[i];
            File content = new File(dirContents[i]);
            if (content.isDirectory()) {
                this.createDirInNodes(nodeName, dirContents[i], isBlocking);
                this.copyDirContentsToNodes(nodeName, dirContents[i], isBlocking, noPreserve);
                continue;
            }
            this.copyFileToNodes(dirContents[i], nodeName, isBlocking, noPreserve);
        }
        return true;
    }

    protected synchronized boolean createDirCluster(String pathName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        for (int j = 0; j < nodeList.length; ++j) {
            Trace.out("Node Name: " + nodeList[j]);
        }
        this.createDirInNodes(nodeList, pathName, isBlocking);
        return true;
    }

    protected synchronized boolean createDirInNodes(String[] nodeNames, String pathName, boolean isBlocking) throws ClusterException {
        return this.createDirOnNodes(nodeNames, pathName, isBlocking, false, null);
    }

    protected synchronized boolean createDirWithModeOnNodes(String[] nodeNames, String pathName, boolean isBlocking) throws ClusterException {
        return this.createDirOnNodes(nodeNames, pathName, isBlocking, true, null);
    }

    protected synchronized boolean createDirWithPermissionsOnNodes(String[] nodeNames, String dirName, boolean isBlocking, String perm) throws ClusterException {
        return this.createDirOnNodes(nodeNames, dirName, isBlocking, true, perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createDirOnNodes(String[] nodeNames, String pathName, boolean isBlocking, boolean useMode, String perm) throws ClusterException {
        for (int i = 0; i < nodeNames.length; ++i) {
            this.createDirInNode(useMode, nodeNames[i], pathName, perm);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(nodeNames.length);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1007", true), commandBuffer.getAllCommands());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean createDirInNode(String nodeName, String pathName, boolean isBlocking) throws ClusterException {
        Trace.out("Creating dir in nodes: " + nodeName + " " + pathName);
        int commandCount = 0;
        DirCreateCommand command = new DirCreateCommand(nodeName, pathName, false);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1007", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean createDirInNode(boolean useMode, String nodeName, String pathName, String perm) {
        Trace.out("Creating dir in nodes: " + nodeName + ", " + pathName + ", " + useMode + ", " + perm);
        DirCreateCommand command = null;
        command = perm != null ? new DirCreateCommand(nodeName, pathName, false, perm) : new DirCreateCommand(nodeName, pathName, false, useMode);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeModeOnNodes(String[] nodeNames, String paths, boolean isBlocking, String perm) throws ClusterException {
        Object[] args = new String[]{Utils.getString(nodeNames, " ")};
        for (int i = 0; i < nodeNames.length; ++i) {
            this.changeModeInNode(nodeNames[i], paths, perm);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(nodeNames.length);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
            } else {
                throw new ClusterException(s_msgBundle.getMessage("1190", true, args), commandBuffer.getAllCommands());
            }
            return;
        }
    }

    private synchronized boolean changeModeInNode(String nodeName, String paths, String perm) {
        Trace.out("Change mode in node: " + nodeName + ", " + paths + ", " + perm);
        ChangeFilePermissionsCommand command = null;
        command = new ChangeFilePermissionsCommand(nodeName, paths, perm);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected synchronized boolean removeDirCluster(String pathName, boolean isRecurse, boolean isDirPathRemove, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        for (int j = 0; j < nodeList.length; ++j) {
            Trace.out("Node Name: " + nodeList[j]);
        }
        return this.removeDirFromNodes(nodeList, pathName, isRecurse, isDirPathRemove, isBlocking);
    }

    protected synchronized boolean removeDirFromNodes(String[] nodeNames, String pathName, boolean isRecurse, boolean isDirPathRemove, boolean isBlocking) throws ClusterException {
        return this.removeDirFromNodesNonSynchronized(nodeNames, pathName, isRecurse, isDirPathRemove, isBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeDirFromNodesNonSynchronized(String[] nodeNames, String pathName, boolean isRecurse, boolean isDirPathRemove, boolean isBlocking) throws ClusterException {
        for (int i = 0; i < nodeNames.length; ++i) {
            DirRemoveCommand command = new DirRemoveCommand(nodeNames[i], pathName, isRecurse, isDirPathRemove);
            try {
                this.m_commandBuffer.put(command);
                continue;
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(nodeNames.length);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_11] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1008", true), commandBuffer.getAllCommands());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean removeDirFromNode(String nodeName, String pathName, boolean isRecurse, boolean isDirPathRemove, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("Removing dir in nodes: " + nodeName + " " + pathName);
        DirRemoveCommand command = new DirRemoveCommand(nodeName, pathName, isRecurse, isDirPathRemove);
        try {
            this.m_commandBuffer.put(command);
            ++commandCount;
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var10_12] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1008", true), commandBuffer.getAllCommands());
        }
    }

    protected synchronized long getModificationTime(String node, String file) throws ClusterException {
        long retval = 0L;
        Object[] msgArgs = new Object[]{file, node};
        Trace.out("Getting Modification Time for file:" + file + " on node: " + node);
        String tempFileName = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("GGG", ".gmt");
            tempFileName = tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new ClusterException(s_msgBundle.getMessage("1029", true, msgArgs) + System.getProperty("line.separator") + e.getMessage());
        }
        try {
            this.copyFileFromNode(node, file, tempFileName, true, false);
            retval = tempFile.lastModified();
        }
        catch (Exception e) {
            throw new ClusterException(s_msgBundle.getMessage("1029", true, msgArgs) + System.getProperty("line.separator") + e.getMessage());
        }
        finally {
            tempFile.delete();
        }
        return retval;
    }

    private String trimSuccFail(String msg) {
        String newMsg = msg.endsWith(":failed") ? msg.substring(0, msg.lastIndexOf(":failed")) : (msg.endsWith(":successful") ? msg.substring(0, msg.lastIndexOf(":successful")) : msg);
        return newMsg;
    }

    private String compositeMsg(String mainMsg, String[] moreMsgs) {
        StringBuffer errorBuffer = new StringBuffer();
        errorBuffer.append(mainMsg);
        if (moreMsgs != null) {
            for (int i = 0; i < moreMsgs.length; ++i) {
                errorBuffer.append(System.getProperty("line.separator") + this.trimSuccFail(moreMsgs[i]));
            }
        }
        return errorBuffer.toString();
    }

    @Override
    public boolean startServiceCluster(String serviceName) throws ClusterException {
        return this.startServiceCluster(serviceName, true);
    }

    @Override
    public boolean startServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.startServiceOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean checkServiceCluster(String serviceName) throws ClusterException {
        return this.checkServiceCluster(serviceName, true);
    }

    @Override
    public boolean checkServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.checkServiceOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public int getServiceStateCluster(String serviceName) throws ClusterException {
        return this.getServiceStateCluster(serviceName, true);
    }

    @Override
    public int getServiceStateOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.getServiceStateOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean checkServiceRunningCluster(String serviceName) throws ClusterException {
        return this.checkServiceRunningCluster(serviceName, true);
    }

    @Override
    public boolean checkServiceRunningOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.checkServiceRunningOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean checkServiceStoppedCluster(String serviceName) throws ClusterException {
        return this.checkServiceStoppedCluster(serviceName, true);
    }

    @Override
    public boolean checkServiceStoppedOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.checkServiceStoppedOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean checkServiceExistCluster(String serviceName) throws ClusterException {
        return this.checkServiceExistCluster(serviceName, true);
    }

    @Override
    public boolean checkServiceExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.checkServiceExistOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean checkServiceNotExistCluster(String serviceName) throws ClusterException {
        return this.checkServiceNotExistCluster(serviceName, true);
    }

    @Override
    public boolean checkServiceNotExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.checkServiceNotExistOnNodes(serviceName, nodeNames, true);
    }

    @Override
    public boolean createServiceCluster(String serviceName, String exeLocation, int mode) throws ClusterException {
        return this.createServiceCluster(serviceName, exeLocation, mode, true);
    }

    @Override
    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String[] nodeNames) throws ClusterException {
        return this.createServiceOnNodes(serviceName, exeLocation, nodeNames, mode, true);
    }

    @Override
    public boolean createServiceCluster(String serviceName, String exeLocation, int mode, String domainName, String userName, String password) throws ClusterException {
        return this.createServiceCluster(serviceName, exeLocation, mode, domainName, userName, password, true);
    }

    @Override
    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String[] nodeNames) throws ClusterException {
        return this.createServiceOnNodes(serviceName, exeLocation, mode, domainName, userName, password, nodeNames, true);
    }

    @Override
    public void Execute() {
    }

    @Override
    public void execute() {
    }

    public boolean startServiceCluster(String serviceName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.startServiceOnNodes(serviceName, nodeList, isBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("In startService on Nodes: Number of nodes :" + nodeNames.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            ++commandCount;
            this.startServiceOnNode(serviceName, nodeNames[i], 0);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var7_9] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1009", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean startServiceOnNode(String serviceName, String nodeName, int phase) {
        boolean commandCount = false;
        Trace.out("Starting service on node:" + nodeName);
        Command command = new CommandFactory().CreateCommand(new StartServiceCommand(serviceName, nodeName), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private boolean checkServiceStatusOnNodes(String serviceName, String[] nodeNames, int state, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Trace.out("checkServiceStatusOnNodes: Number of nodes :" + nodeNames.length);
        Command[] checkServiceCmds = new CheckServiceCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            checkServiceCmds[i] = (CheckServiceCommand)new CommandFactory().CreateCommand(new CheckServiceCommand(serviceName, nodeNames[i], state), 0);
        }
        try {
            this.submit(checkServiceCmds, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bValidState = true;
        boolean bNewLine = false;
        Object[] args = new String[3];
        for (int i = 0; i < nodeNames.length; ++i) {
            CommandResult resultObj = checkServiceCmds[i].getCommandResult();
            bValidState &= ((CheckServiceCommand)checkServiceCmds[i]).isValidState();
            bStatus &= resultObj.getStatus();
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = serviceName;
            args[1] = nodeNames[i];
            args[2] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1138", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out(serviceName + " requested state of " + state + " = " + bValidState);
        return bValidState;
    }

    private boolean checkServiceStatusCluster(String serviceName, int state, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.checkServiceStatusOnNodes(serviceName, nodeList, state, isBlocking);
    }

    boolean checkServiceCluster(String serviceName, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusCluster(serviceName, 6, isBlocking);
    }

    boolean checkServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusOnNodes(serviceName, nodeNames, 6, isBlocking);
    }

    int getServiceStateCluster(String serviceName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.getServiceStateOnNodes(serviceName, nodeList, isBlocking);
    }

    int getServiceStateOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        boolean bException = false;
        ClusterException ce = null;
        Trace.out("getServiceStateOnNodes: Number of nodes :" + nodeNames.length);
        Command[] checkServiceCmds = new CheckServiceCommand[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            checkServiceCmds[i] = (CheckServiceCommand)new CommandFactory().CreateCommand(new CheckServiceCommand(serviceName, nodeNames[i], 11), 0);
        }
        try {
            this.submit(checkServiceCmds, isBlocking);
        }
        catch (ClusterException e) {
            bException = true;
            ce = e;
            Trace.out(ce.getMessage());
        }
        StringBuffer returnMsg = new StringBuffer();
        boolean bStatus = true;
        boolean bNewLine = false;
        Object[] args = new String[3];
        int currState = 0;
        for (int i = 0; i < nodeNames.length; ++i) {
            CommandResult resultObj = checkServiceCmds[i].getCommandResult();
            bStatus &= resultObj.getStatus();
            if (i == 0) {
                currState = ((CheckServiceCommand)checkServiceCmds[i]).getCurrentState();
            } else if (currState != 10 && currState != ((CheckServiceCommand)checkServiceCmds[i]).getCurrentState()) {
                currState = 10;
            }
            if (resultObj.getStatus()) continue;
            Trace.out("Exception occured while executing native code");
            if (bNewLine) {
                returnMsg.append("\n");
            }
            args[0] = serviceName;
            args[1] = nodeNames[i];
            args[2] = resultObj.getOSString();
            String msg = s_msgBundle.getMessage("1138", true, args);
            returnMsg.append(msg);
            bNewLine = true;
            Trace.out(msg);
        }
        if (ce != null) {
            if (bNewLine) {
                returnMsg.append("\n");
            }
            returnMsg.append(ce.getMessage());
        }
        if (!bStatus) {
            throw new ClusterException(returnMsg.toString());
        }
        if (bException) {
            throw ce;
        }
        Trace.out("The current state for the service, " + serviceName + " = " + currState);
        return currState;
    }

    boolean checkServiceRunningCluster(String serviceName, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusCluster(serviceName, 6, isBlocking);
    }

    boolean checkServiceRunningOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusOnNodes(serviceName, nodeNames, 6, isBlocking);
    }

    boolean checkServiceStoppedCluster(String serviceName, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusCluster(serviceName, 3, isBlocking);
    }

    boolean checkServiceStoppedOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusOnNodes(serviceName, nodeNames, 3, isBlocking);
    }

    boolean checkServiceExistCluster(String serviceName, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusCluster(serviceName, 1, isBlocking);
    }

    boolean checkServiceExistOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusOnNodes(serviceName, nodeNames, 1, isBlocking);
    }

    boolean checkServiceNotExistCluster(String serviceName, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusCluster(serviceName, 2, isBlocking);
    }

    boolean checkServiceNotExistOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.checkServiceStatusOnNodes(serviceName, nodeNames, 2, isBlocking);
    }

    public boolean stopServiceCluster(String serviceName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.stopServiceOnNodes(serviceName, nodeList, isBlocking);
    }

    @Override
    public boolean stopServiceCluster(String serviceName) throws ClusterException {
        return this.stopServiceCluster(serviceName, true);
    }

    @Override
    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.stopServiceOnNodes(serviceName, nodeNames, true);
    }

    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.stopServiceOnNodes(serviceName, nodeNames, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean bypassStopAttemptIfNotRunning) throws ClusterException {
        int commandCount = 0;
        Trace.out("Number of nodes :" + nodeNames.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            ++commandCount;
            this.stopServiceOnNode(serviceName, nodeNames[i], 0, bypassStopAttemptIfNotRunning);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1010", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean stopServiceOnNode(String serviceName, String nodeName, int phase, boolean bypassStopAttemptIfNotRunning) {
        boolean commandCount = false;
        Trace.out("Stopping service on node " + nodeName);
        Command command = new CommandFactory().CreateCommand(new StopServiceCommand(serviceName, nodeName, bypassStopAttemptIfNotRunning), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public boolean createServiceCluster(String serviceName, String exeLocation, int mode, boolean isBlocking) throws ClusterException {
        return this.createServiceCluster(serviceName, exeLocation, mode, null, null, null, isBlocking);
    }

    public boolean createServiceCluster(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.createServiceOnNodes(serviceName, exeLocation, mode, domainName, userName, password, nodeList, isBlocking);
    }

    protected boolean createServiceOnNodes(String serviceName, String exeLocation, String[] nodeNames, int mode, boolean isBlocking) throws ClusterException {
        return this.createServiceOnNodes(serviceName, exeLocation, mode, null, null, null, nodeNames, isBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String[] nodeNames, boolean isBlocking) throws ClusterException {
        int commandCount = 0;
        Trace.out("In createServiceOnNodes: Number of nodes :" + nodeNames.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            ++commandCount;
            this.createServiceOnNode(serviceName, exeLocation, mode, domainName, userName, password, nodeNames[i], 0);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var12_14] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1012", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean createServiceOnNode(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String nodeName, int phase) throws ClusterException {
        boolean commandCount = false;
        Trace.out("Creating service on node");
        Command command = new CommandFactory().CreateCommand(new CreateServiceCommand(serviceName, exeLocation, mode, domainName, userName, password, nodeName), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException e) {
            throw new ClusterException(s_msgBundle.getMessage("1003", true));
        }
        return true;
    }

    public boolean deleteServiceCluster(String serviceName, boolean isBlocking) throws ClusterException {
        this.createGetActiveNodes();
        if (this.m_activeNodes == null) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        String[] nodeList = this.m_activeNodes.getInternalNodeList();
        return this.deleteServiceOnNodes(serviceName, nodeList, isBlocking);
    }

    @Override
    public boolean deleteServiceCluster(String serviceName) throws ClusterException {
        return this.deleteServiceCluster(serviceName, true);
    }

    @Override
    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.deleteServiceOnNodes(serviceName, nodeNames, true);
    }

    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking) throws ClusterException {
        return this.deleteServiceOnNodes(serviceName, nodeNames, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean ignoreNotExist) throws ClusterException {
        int commandCount = 0;
        Trace.out("In deleteServiceOnNode: Number of nodes :" + nodeNames.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            ++commandCount;
            this.deleteServiceOnNode(serviceName, nodeNames[i], 0, ignoreNotExist);
        }
        if (isBlocking) {
            try {
                ClusterConfig.block(commandCount);
            }
            catch (InterruptedException e) {
                throw new ClusterException(s_msgBundle.getMessage("1003", true));
            }
        }
        CommandBuffer commandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            commandBuffer = clientResource.getBuffer();
            // ** MonitorExit[var8_10] (shouldn't be in output)
            if (commandBuffer != null && commandBuffer.checkCommandStatus()) {
                if (clientResource != null) {
                    clientResource.clearCommandBuffer();
                }
                return true;
            }
            throw new ClusterException(s_msgBundle.getMessage("1011", true), commandBuffer.getAllCommands());
        }
    }

    private synchronized boolean deleteServiceOnNode(String serviceName, String nodeName, int phase, boolean ignoreNotExist) {
        boolean commandCount = false;
        Trace.out("Deleting service on node " + nodeName);
        Command command = new CommandFactory().CreateCommand(new DeleteServiceCommand(serviceName, nodeName, ignoreNotExist), phase);
        try {
            this.m_commandBuffer.put(command);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean doSecondPhase() {
        int actualCommandCount = 0;
        Command[] commandArray = null;
        CommandBuffer prepareCommandBuffer = null;
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            // ** MonitorExit[var6_5] (shouldn't be in output)
            prepareCommandBuffer = clientResource.getBuffer();
            int phase = prepareCommandBuffer.checkCommandStatus() ? 2 : 3;
            try {
                commandArray = prepareCommandBuffer.getAllCommands();
            }
            catch (Exception e) {
                Trace.out("Problem in canCommit of doSecondPhase");
            }
            if (commandArray == null) {
                return false;
            }
            Trace.out("Successfully read in doSecondPhase " + commandArray.length);
            clientResource.clearCommandBuffer();
            Trace.out("In doSecondPhase, ThreadName = " + Thread.currentThread().getName() + " commandCount" + commandArray.length);
            for (int i = 0; i < commandArray.length; ++i) {
                try {
                    if (commandArray[i] == null) continue;
                    PrepareCommand prepareCommand = (PrepareCommand)commandArray[i];
                    ++actualCommandCount;
                    Command command = prepareCommand.getCommand();
                    Command secondPhaseCommand = new CommandFactory().CreateCommand(command, phase);
                    this.m_commandBuffer.put(secondPhaseCommand);
                    continue;
                }
                catch (InterruptedException prepareCommand) {
                    // empty catch block
                }
            }
            Trace.out("Blocking in doSecondPhase commandCount= " + actualCommandCount + " threadname = " + Thread.currentThread().getName());
            try {
                ClusterConfig.block(actualCommandCount);
            }
            catch (InterruptedException i) {
            }
            finally {
                clientResource.cleanUp();
            }
            CommandBuffer clientCommandBuffer = clientResource.getBuffer();
            Trace.out("Waking up after block in doSecondPhase, threadname=  " + Thread.currentThread().getName());
            boolean result = clientCommandBuffer.checkCommandStatus();
            StringBuffer summary = new StringBuffer();
            for (int i = 0; i < commandArray.length; ++i) {
                StatusLogger statusLogger = commandArray[i].getStatusLogger();
                summary.append(statusLogger.getLog() + "\n");
            }
            ClusterConfig.createTransactionSummary(summary.toString());
            clientResource.clearCommandBuffer();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void createTransactionSummary(String summary) {
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            clientResource.setTransactionSummary(summary);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized String getTransactionSummary() {
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return clientResource.getTransactionSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addRemoteResponseListener(RemoteResponseListener l) {
        Trace.out("Adding Rmi Event Listner");
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            RemoteResponseListener remoteResponseListener = clientResource.getListener();
            remoteResponseListener = RemoteResponseEventMulticaster.add(remoteResponseListener, l);
            clientResource.setListener(remoteResponseListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeRemoteResponseListener(RemoteResponseListener l) {
        ClientResource clientResource = null;
        Class<ClusterConfig> clazz = ClusterConfig.class;
        synchronized (ClusterConfig.class) {
            clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            RemoteResponseListener remoteResponseListener = clientResource.getListener();
            remoteResponseListener = RemoteResponseEventMulticaster.remove(remoteResponseListener, l);
            return;
        }
    }

    private void createGetActiveNodes() throws ClusterException {
        this.m_activeNodes = GetActiveNodes.create();
    }

    static /* synthetic */ SyncBuffer access$100(ClusterConfig x0) {
        return x0.m_commandBuffer;
    }

    static {
        s_msgBundle = MessageBundle.getMessageBundle("Prkc");
        m_threadCount = 0;
        s_deconfigFlag = false;
    }

    private class ExecuteCommand
    implements Runnable {
        private int id;

        ExecuteCommand(int x) {
            this.id = x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void returnCommandToClient(Command commandObj) {
            try {
                CommandBuffer commandBuffer = null;
                ClientResource clientResource = null;
                Class<ClusterConfig> clazz = ClusterConfig.class;
                synchronized (ClusterConfig.class) {
                    clientResource = (ClientResource)s_clientThreadTable.get(commandObj.getOwnerThread());
                    if (clientResource == null) {
                        Trace.out("FATAL Error..ClientResource NULL");
                        System.exit(1);
                    }
                    commandBuffer = clientResource.getBuffer();
                    Trace.out("returnCommandToClient; fillCount=" + clientResource.getBuffer().getFillCount() + " is full=" + clientResource.isBufferFull());
                    if (!clientResource.isBufferFull()) {
                        commandBuffer.put(commandObj);
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                Trace.out("Could not put in commandBuffer");
            }
            {
                return;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

