/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterService;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.trace.Trace;

public class ClusterBatch
implements ClusterService {
    private int commandCount = 0;
    private ClusterConfig m_clusterConfig = ClusterConfig.init();
    private int noOfNodes = this.m_clusterConfig.getNodeNumber();

    private void checkClusterConfig() throws ClusterException {
        if (this.m_clusterConfig == null) {
            this.m_clusterConfig = ClusterConfig.init();
            this.noOfNodes = this.m_clusterConfig.getNodeNumber();
        }
    }

    public boolean copyFileCluster(String fileName) throws ClusterException {
        ClusterCmd.assertFile(fileName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.copyFileCluster(fileName, false);
    }

    public boolean copyFileBetweenNodes(String sourceNode, String sourceFile, String destNode, String destFile) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        ClusterCmd.assertNode(destNode);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.copyFileBetweenNodes(sourceNode, sourceFile, destNode, destFile, false);
    }

    public boolean copyFileCluster(String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.copyFileCluster(sourceFile, destFile, false);
    }

    public boolean copyFileFromNode(String sourceNode, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertNode(sourceNode);
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.copyFileFromNode(sourceNode, sourceFile, destFile, false);
    }

    public boolean copyFileToNodes(String sourceFile, String[] nodeNames) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.copyFileToNodes(sourceFile, nodeNames, false);
    }

    public boolean copyFileToNodes(String sourceFile, String[] nodeNames, String destFile) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.copyFileToNodes(sourceFile, nodeNames, destFile, false);
    }

    public boolean createDirCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.createDirCluster(dirName, false);
    }

    public boolean createDirInNode(String nodeName, String dirName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.createDirInNode(nodeName, dirName, false);
    }

    public boolean createDirInNodes(String[] nodeNames, String dirName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.createDirInNodes(nodeNames, dirName, false);
    }

    public boolean removeDirectoryFromCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.removeDirCluster(dirName, false, false, false);
    }

    public boolean removeDirCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.removeDirCluster(dirName, false, true, false);
    }

    public boolean removeDirFromNode(String nodeName, String dirName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.removeDirFromNode(nodeName, dirName, false, true, false);
    }

    public boolean removeDirectory(String nodeName, String dirName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.removeDirFromNode(nodeName, dirName, false, false, false);
    }

    public boolean removeDirectory(String[] nodeNames, String dirName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        return this.m_clusterConfig.removeDirFromNodes(nodeNames, dirName, false, false, false);
    }

    public boolean removeDirFromNodes(String[] nodeNames, String dirName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, false);
        this.checkClusterConfig();
        return this.m_clusterConfig.removeDirFromNodes(nodeNames, dirName, false, true, false);
    }

    public boolean removeFileCluster(String fileName) throws ClusterException {
        ClusterCmd.assertFile(fileName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.removeFileCluster(fileName, false);
    }

    public boolean removeFileFromNode(String nodeName, String fileName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertFile(fileName);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.removeFileFromNode(nodeName, fileName, false);
    }

    public boolean removeFileFromNodes(String[] nodeNames, String fileName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertFile(fileName);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.removeFileFromNodes(nodeNames, fileName, false);
    }

    public boolean moveFilesOnNode(String sourceFile, String destFile) throws ClusterException {
        return this.moveFilesOnNode("localnode", sourceFile, destFile);
    }

    public boolean moveFilesOnNode(String node, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        ClusterCmd.assertNode(node);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.moveFilesOnNode(node, sourceFile, destFile, false);
    }

    public boolean linkFilesOnNode(String node, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        this.checkClusterConfig();
        ++this.commandCount;
        return this.m_clusterConfig.linkFilesOnNode(node, sourceFile, destFile, false);
    }

    public boolean linkFilesOnNode(String sourceFile, String destFile) throws ClusterException {
        return this.linkFilesOnNode("localnode", sourceFile, destFile);
    }

    public boolean startListener(String[] nodeNames, String listenerName, String oracleHome, String oracleHomeName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(oracleHome, false);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.startListener(nodeNames, listenerName, oracleHome, oracleHomeName, false);
    }

    public void startOPSMDaemonCluster(String oracleHome) throws ClusterException {
        ClusterCmd.assertDir(oracleHome, false);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        this.m_clusterConfig.startOPSMDaemonCluster(oracleHome, false);
    }

    public void startOPSMDaemonOnNodes(String[] nodeNames, String oracleHome) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(oracleHome, false);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        this.m_clusterConfig.startOPSMDaemonOnNodes(nodeNames, oracleHome, false);
    }

    @Override
    public boolean startServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.startServiceCluster(serviceName, false);
    }

    @Override
    public boolean startServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.startServiceOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean checkServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.checkServiceCluster(serviceName, false);
    }

    @Override
    public boolean checkServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.checkServiceOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public int getServiceStateCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.getServiceStateCluster(serviceName, false);
    }

    @Override
    public int getServiceStateOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.getServiceStateOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean checkServiceRunningCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.checkServiceRunningCluster(serviceName, false);
    }

    @Override
    public boolean checkServiceRunningOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.checkServiceRunningOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean checkServiceStoppedCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.checkServiceStoppedCluster(serviceName, false);
    }

    @Override
    public boolean checkServiceStoppedOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.checkServiceStoppedOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean checkServiceExistCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.checkServiceExistCluster(serviceName, false);
    }

    @Override
    public boolean checkServiceExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.checkServiceExistOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean checkServiceNotExistCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.checkServiceNotExistCluster(serviceName, false);
    }

    @Override
    public boolean checkServiceNotExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.checkServiceNotExistOnNodes(serviceName, nodeNames, false);
    }

    @Override
    public boolean stopServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.stopServiceCluster(serviceName, false);
    }

    @Override
    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.stopServiceOnNodes(serviceName, nodeNames, false, false);
    }

    @Override
    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean bypassStopAttemptIfNotRunning) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.stopServiceOnNodes(serviceName, nodeNames, isBlocking, bypassStopAttemptIfNotRunning);
    }

    @Override
    public boolean createServiceCluster(String serviceName, String exeLocation, int mode) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertFile(exeLocation);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.createServiceCluster(serviceName, exeLocation, mode, false);
    }

    @Override
    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertFile(exeLocation);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.createServiceOnNodes(serviceName, exeLocation, nodeNames, mode, false);
    }

    @Override
    public boolean createServiceCluster(String serviceName, String exeLocation, int mode, String domainName, String userName, String password) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertUserName(userName);
        ClusterCmd.assertFile(exeLocation);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.createServiceCluster(serviceName, exeLocation, mode, domainName, userName, password, false);
    }

    @Override
    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertUserName(userName);
        ClusterCmd.assertFile(exeLocation);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.createServiceOnNodes(serviceName, exeLocation, mode, domainName, userName, password, nodeNames, false);
    }

    @Override
    public boolean deleteServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.checkClusterConfig();
        this.commandCount += this.noOfNodes;
        return this.m_clusterConfig.deleteServiceCluster(serviceName, false);
    }

    @Override
    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.deleteServiceOnNodes(serviceName, nodeNames, false, false);
    }

    @Override
    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean ignoreNotExist) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        this.checkClusterConfig();
        this.commandCount += nodeNames.length;
        return this.m_clusterConfig.deleteServiceOnNodes(serviceName, nodeNames, isBlocking, ignoreNotExist);
    }

    @Override
    public void Execute() {
        this.execute();
    }

    @Override
    public void execute() {
        try {
            Trace.out("In ClusterBatch execute..commandNum= " + this.commandCount);
            this.m_clusterConfig.waitToCleanUp(this.commandCount);
        }
        catch (InterruptedException e) {
            this.m_clusterConfig.destroy();
        }
    }
}

