/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.wallet;

import oracle.cluster.wallet.CLSW;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWAlreadyExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GHAdminWallet {
    private static final String GHADMIN_WALLET_TYPE = "GHADMIN";
    private static final String GH_WALLET_NAME = "";
    public static String GH_DEFAULT_USER = "oc4jadmin";
    private static GHAdminWallet s_instance = null;
    private CLSW m_clsw;

    private GHAdminWallet(Version v) throws CLSWException {
        Trace.out("create a new instance. get the current version first");
        this.m_clsw = CLSW.getInstance(v);
        if (Utils.useTomcat()) {
            GH_DEFAULT_USER = "jwcadmin";
        }
    }

    public static synchronized GHAdminWallet getInstance(Version v) throws CLSWException {
        if (s_instance == null) {
            s_instance = new GHAdminWallet(v);
        }
        return s_instance;
    }

    public static GHAdminWallet getInstance() throws CLSWException {
        return GHAdminWallet.getInstance(new Version());
    }

    public void open() throws CLSWException {
        this.m_clsw.initializeCLSW();
    }

    public void close() throws CLSWException {
        this.m_clsw.terminateCLSW();
    }

    public void createWallet(String passwd) throws CLSWException {
        try {
            this.m_clsw.openWallet(GHADMIN_WALLET_TYPE, GH_WALLET_NAME);
        }
        catch (CLSWAlreadyExistException e) {
            Trace.out("CLSWAlreadyExistException occured. msg:" + e.getMessage());
            Trace.out("GHADMIN already exists. not creation. updating the wallet...");
        }
        this.m_clsw.setSecret(GHADMIN_WALLET_TYPE, GH_WALLET_NAME, GH_DEFAULT_USER, passwd);
    }

    public void updateWallet(String password) throws CLSWException {
        this.m_clsw.setSecret(GHADMIN_WALLET_TYPE, GH_WALLET_NAME, GH_DEFAULT_USER, password);
    }

    public void deleteWallet() throws CLSWException {
        this.m_clsw.deleteWallet(GHADMIN_WALLET_TYPE, GH_WALLET_NAME, GH_WALLET_NAME);
    }

    public boolean isWalletExists() throws CLSWException {
        boolean retVal = false;
        try {
            this.m_clsw.getSecret(GHADMIN_WALLET_TYPE, GH_WALLET_NAME, GH_DEFAULT_USER);
            retVal = true;
        }
        catch (CLSWAliasNotExistException e) {
            Trace.out("wallet exists but alias doesn't");
        }
        catch (CLSWNotExistException e) {
            Trace.out("wallet doesn't exist");
        }
        return retVal;
    }

    public String getPassword() throws CLSWException, CLSWAliasNotExistException {
        String password = this.m_clsw.getSecret(GHADMIN_WALLET_TYPE, GH_WALLET_NAME, GH_DEFAULT_USER);
        return password;
    }
}

