/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.wallet;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.cluster.wallet.CLSWAccessDeniedException;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWAlreadyExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNative;
import oracle.cluster.wallet.CLSWNativeResult;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class CLSW {
    private static CLSW s_instance = null;
    private Version m_version;
    private MessageBundle prfcBundle = MessageBundle.getMessageBundle(PrCfMsgID.facility);
    private MessageBundle prcwBundle = MessageBundle.getMessageBundle("PrCw");

    private CLSW(Version version) throws CLSWException {
        Trace.out("initializing CLSW");
        CLSW.loadLibrary();
        this.m_version = version;
    }

    private static void loadLibrary() throws CLSWException {
        Trace.out("Trying to load the libhasgen library for CLSW.");
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            if (!system.isSRVMHASLibraryLoaded()) {
                Trace.out("Going to load the srvm has native library");
                system.loadSRVMHASNativeLibrary();
                Trace.out("loaded srvm has native library");
            }
        }
        catch (NativeException ne) {
            Trace.out(ne);
            throw new CLSWException(ne.getMessage());
        }
    }

    public static synchronized CLSW getInstance() throws CLSWException {
        Trace.out("create a new instance. get the current version first");
        return CLSW.getInstance(new Version());
    }

    public static synchronized CLSW getInstance(Version version) throws CLSWException {
        if (s_instance == null) {
            Trace.out("CLSW instance is not present, create a new one");
            s_instance = new CLSW(version);
        }
        return s_instance;
    }

    public void initializeCLSW() throws CLSWException {
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
            Trace.out("Initalizing SRVM Context for CLSW");
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new CLSWException(sce);
        }
        CLSWNativeResult result = new CLSWNativeResult();
        Trace.out("trying to initialize CLSW");
        CLSWNative.initializeCLSW(result);
    }

    public void terminateCLSW() throws CLSWException {
        CLSWNativeResult result = new CLSWNativeResult();
        CLSWNative.terminateCLSW(result);
        try {
            Trace.out("Terminating SRVM Context for CLSW");
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.term();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new CLSWException(sce);
        }
    }

    public String getSecret(String walletType, String walletName, String alias) throws CLSWException, CLSWAliasNotExistException, CLSWAccessDeniedException {
        String location = "get passwd";
        this.assertWalletType(walletType, location);
        this.assertAlias(alias, location, false);
        this.assertWalletName(walletName, walletType, location);
        CLSWNativeResult result = new CLSWNativeResult();
        return CLSWNative.getSecret(walletType, walletName, alias, result);
    }

    public void setSecret(String walletType, String walletName, String alias, String secret) throws CLSWException, CLSWNotExistException, CLSWAccessDeniedException {
        String location = "set passwd";
        this.assertWalletType(walletType, location);
        this.assertAlias(alias, location, false);
        this.assertWalletName(walletName, walletType, location);
        this.assertSecret(secret, location);
        CLSWNativeResult result = new CLSWNativeResult();
        CLSWNative.setSecret(walletType, walletName, alias, secret, result);
    }

    public void openWallet(String walletType, String walletName) throws CLSWException, CLSWNotExistException, CLSWAlreadyExistException, CLSWAccessDeniedException {
        String location = "open wallet";
        this.assertWalletType(walletType, location);
        this.assertWalletName(walletName, walletType, location);
        CLSWNativeResult result = new CLSWNativeResult();
        CLSWNative.openWallet(walletType, walletName, result);
    }

    public void deleteWallet(String walletType, String walletName, String alias) throws CLSWException, CLSWNotExistException, CLSWAccessDeniedException {
        String location = "delete wallet";
        this.assertWalletType(walletType, location);
        this.assertAlias(alias, location, true);
        this.assertWalletName(walletName, walletType, location);
        CLSWNativeResult result = new CLSWNativeResult();
        CLSWNative.deleteWallet(walletType, walletName, alias, result);
    }

    public List<String> getWalletUsersList(String walletType, String walletName) throws CLSWException, CLSWAccessDeniedException, CLSWNotExistException {
        String location = "get all users";
        this.assertWalletType(walletType, location);
        this.assertWalletName(walletName, walletType, location);
        CLSWNativeResult result = new CLSWNativeResult();
        String csvUserStr = CLSWNative.getWalletUsersList(walletType, walletName, result);
        ArrayList<String> userList = new ArrayList<String>();
        if (csvUserStr != null && csvUserStr.length() > 0) {
            String[] userArr;
            for (String user : userArr = csvUserStr.split("::")) {
                userList.add(user);
            }
        }
        return userList;
    }

    public boolean isWalletExists(String walletType, String walletName) throws CLSWException, CLSWAccessDeniedException {
        String location = "is exist";
        this.assertWalletType(walletType, location);
        this.assertWalletName(walletName, walletType, location);
        CLSWNativeResult result = new CLSWNativeResult();
        try {
            CLSWNative.checkWalletExists(walletType, walletName, result);
        }
        catch (CLSWNotExistException e) {
            return false;
        }
        return true;
    }

    private void assertWalletType(String walletType, String location) throws CLSWException {
        if (walletType == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, location + " - wlttype"));
        }
    }

    private void assertAlias(String alias, String location, boolean isZeroLengthOK) throws CLSWException {
        if (alias == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, location + " - null alias"));
        }
        if (isZeroLengthOK) {
            return;
        }
        if (alias.trim().length() == 0) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, location + " - empty alias"));
        }
    }

    private void assertSecret(String secret, String location) throws CLSWException {
        if (secret == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, location + " - alias1"));
        }
    }

    private void assertWalletName(String walletName, String walletType, String location) throws CLSWException {
        if (walletName == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, location + " - wltname"));
        }
        if ((walletType.equals("APPQOSDB") || walletType.equals("CVUDB")) && walletName.trim().length() == 0) {
            Trace.out("no wallet name specified for wallet type " + walletType);
            throw new CLSWException(this.prcwBundle.getMessage("1016", true, new Object[]{walletType}));
        }
    }
}

