/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.vm;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.resources.PrCvMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public class VMException
extends SoftwareModuleException {
    private Map<String, List<String>> s_vmMap = null;
    private static final MessageKey ALREADY_REGISTERED_OUTPUT = PrCvMsgID.VM_ALREADY_REGISTERED_OUTPUT;

    public VMException(MessageKey key, Map<String, List<String>> vmMap, Object ... args) {
        super(key, args);
        this.s_vmMap = vmMap;
    }

    public VMException(MessageKey key, Throwable cause, Object ... args) {
        super(key, cause, args);
    }

    public VMException(MessageKey key, Object ... args) {
        super(key, args);
    }

    public VMException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage() {
        String supermsg;
        if (this.s_vmMap == null) {
            return super.getMessage();
        }
        String finalmsg = supermsg = super.getMessage();
        for (String vmRes : this.s_vmMap.keySet()) {
            String[] vmInstances = this.convertStringListToStringArray(this.s_vmMap.get(vmRes));
            finalmsg = finalmsg + "\n" + MessageBundle.getMessage(ALREADY_REGISTERED_OUTPUT, true, vmRes, this.convertStringArrayToString(vmInstances));
        }
        return finalmsg;
    }

    private String convertStringArrayToString(String[] strArray) {
        StringBuilder strBuilder = new StringBuilder("");
        for (int i = 0; i < strArray.length - 1; ++i) {
            strBuilder.append(strArray[i]);
            strBuilder.append(",");
        }
        if (strArray.length >= 1) {
            strBuilder.append(strArray[strArray.length - 1]);
        }
        return strBuilder.toString();
    }

    private String[] convertStringListToStringArray(List<String> strList) {
        String[] strArray = new String[strList.size()];
        strArray = strList.toArray(strArray);
        return strArray;
    }
}

