/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.util;

import oracle.cluster.impl.common.cnative.ClusterNative;
import oracle.cluster.impl.common.cnative.ClusterNativeException;
import oracle.cluster.impl.common.cnative.ClusterNativeResult;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;

public class SRVMContext {
    private static SRVMContext m_srvmcontext;
    private int m_initTermCounter = 0;
    private long m_token = 0L;

    private SRVMContext() {
    }

    public static synchronized SRVMContext getInstance() {
        if (null == m_srvmcontext) {
            m_srvmcontext = new SRVMContext();
        }
        return m_srvmcontext;
    }

    public void terminate() throws SRVMContextException {
        this.destroyOCR();
    }

    public synchronized void init() throws SRVMContextException {
        this.init(ProcType.CLI, "SRVM", false);
    }

    public synchronized void init(ProcType ptype, String component) throws SRVMContextException {
        this.init(ptype, component, false);
    }

    public synchronized void init(boolean ADROn) throws SRVMContextException {
        this.init(ProcType.CLI, "SRVM", ADROn);
    }

    public synchronized void init(ProcType ptype, String component, boolean ADROn) throws SRVMContextException {
        if (null == ptype) {
            throw new SRVMContextException((MessageKey)PrCiMsgID.NULL_PARAM, "ProcType");
        }
        if (null == component) {
            throw new SRVMContextException((MessageKey)PrCiMsgID.NULL_PARAM, "component");
        }
        ++this.m_initTermCounter;
        Trace.out("Performing SRVM Context init. Init Counter=" + this.m_initTermCounter);
        if (this.m_initTermCounter > 1) {
            return;
        }
        NativeSystem ns = new SystemFactory().CreateSystem();
        try {
            ns.loadSRVMHASNativeLibrary();
            if (!Cluster.isCluster()) {
                this.m_initTermCounter = 0;
                Trace.out("No CRS configuration found");
                return;
            }
        }
        catch (NativeException ne) {
            this.m_initTermCounter = 0;
            Trace.out("Received native exception: " + ne.getMessage());
            throw new SRVMContextException(ne);
        }
        try {
            Class<?> cls = this.getClass();
            this.m_token = ClusterNative.CLSBInit(ptype.ordinal(), component, ADROn, new ClusterNativeResult(), cls.getClassLoader());
            Trace.out("SRVM Context init-ed");
        }
        catch (ClusterNativeException cne) {
            Trace.out(cne.getMessage());
            throw new SRVMContextException(cne);
        }
    }

    public synchronized void term() throws SRVMContextException {
        if (this.m_initTermCounter == 0) {
            return;
        }
        --this.m_initTermCounter;
        Trace.out("Performing SRVM Context Term. Term counter is " + this.m_initTermCounter);
        if (this.m_initTermCounter != 0) {
            return;
        }
        if (this.m_token == 0L) {
            return;
        }
        try {
            ClusterNative.CLSBTerm(new ClusterNativeResult(), this.m_token);
            this.m_token = 0L;
            Trace.out("SRVM Context terminated");
        }
        catch (ClusterNativeException cne) {
            throw new SRVMContextException(cne);
        }
    }

    private void destroyOCR() throws SRVMContextException {
        try {
            OCR ocr = OCR.init(7);
            ocr.destroy();
            Trace.out("OCR destroy successfull");
        }
        catch (OCRException e) {
            Trace.out("OCR destroy failed with exception " + e);
            throw new SRVMContextException(e);
        }
    }

    public static enum ProcType {
        CLI,
        DAEMON;

    }
}

