/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.util;

import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.nls.MessageKey;

public enum CryptoAlg {
    AES("AES"),
    SHA256("SHA-256");

    private String m_type;

    public static CryptoAlg getEnumMember(String alg) throws EnumConstNotFoundException {
        for (CryptoAlg ca : CryptoAlg.values()) {
            if (!ca.m_type.equalsIgnoreCase(alg)) continue;
            return ca;
        }
        throw new EnumConstNotFoundException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, alg);
    }

    private CryptoAlg(String type) {
        this.m_type = type;
    }

    public String toString() {
        return this.m_type;
    }
}

