/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;

public class CompositeOperationException
extends ManageableEntityException {
    private int m_SeqID = 0;
    private boolean m_isWarning = false;
    protected Map<Object, NativeResult> m_resultMap;

    public CompositeOperationException() {
        this.m_isNoMsg = true;
        this.m_isWarning = true;
        this.m_resultMap = new HashMap<Object, NativeResult>();
    }

    public CompositeOperationException(MessageKey key, Map<Object, NativeResult> resultMap, Object ... args) {
        super(key, args);
        this.m_resultMap = resultMap;
    }

    public CompositeOperationException(MessageKey key, Throwable cause, Map<Object, NativeResult> resultMap, Object ... args) {
        super(key, cause, args);
        this.m_resultMap = resultMap;
    }

    public CompositeOperationException(Map<Object, Exception> resultMap, MessageKey key, Object ... args) {
        super(key, args);
        this.m_resultMap = new HashMap<Object, NativeResult>(resultMap.size());
        for (Map.Entry<Object, Exception> e : resultMap.entrySet()) {
            NativeResult nativeResult = new NativeResult();
            nativeResult.setStatus(false);
            nativeResult.setException(e.getValue());
            this.m_resultMap.put(e.getKey(), nativeResult);
        }
    }

    public CompositeOperationException(Map<Object, Exception> resultMap) {
        this.m_isNoMsg = true;
        this.m_resultMap = new HashMap<Object, NativeResult>(resultMap.size());
        for (Map.Entry<Object, Exception> e : resultMap.entrySet()) {
            NativeResult nativeResult = new NativeResult();
            nativeResult.setStatus(false);
            nativeResult.setException(e.getValue());
            this.m_resultMap.put(e.getKey(), nativeResult);
        }
    }

    public Map getResultMap() {
        return this.m_resultMap;
    }

    public Status getStatus(Object identifier) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        NativeResult result = this.m_resultMap.get(identifier);
        if (result.getException() != null) {
            return Status.EXCEPTION;
        }
        if (result.getOSString() != null || !result.getStatus()) {
            return Status.FAILURE;
        }
        return Status.SUCCESS;
    }

    public Set<Object> getFailures() {
        HashSet<Object> failed = new HashSet<Object>();
        Set<Object> identifiers = this.getOperationIdentifier();
        for (Object identifier : identifiers) {
            try {
                if (this.getStatus(identifier) == Status.SUCCESS) continue;
                failed.add(identifier);
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {}
        }
        return failed;
    }

    public Set<Object> getOperationIdentifier() {
        return this.m_resultMap.keySet();
    }

    public String getErrorMessage(Object identifier) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        NativeResult result = this.m_resultMap.get(identifier);
        return result.getOSString();
    }

    public String[] getErrorMessages(Object identifier) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        NativeResult result = this.m_resultMap.get(identifier);
        return result.getOSStrings();
    }

    public Exception getException(Object identifier) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        NativeResult result = this.m_resultMap.get(identifier);
        return result.getException();
    }

    public void setException(Object identifier, Exception e) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        this.m_resultMap.get(identifier).setException(e);
    }

    public void addException(Exception excep, boolean isWarning) {
        NativeResult nativeResult = new NativeResult();
        nativeResult.setException(excep);
        this.m_resultMap.put(this.m_SeqID, nativeResult);
        ++this.m_SeqID;
        if (this.m_isWarning && !isWarning) {
            this.m_isWarning = false;
        }
    }

    public boolean isWarning() {
        return this.m_isWarning;
    }

    public String getSequencedMessages() {
        StringBuffer msgbuf = new StringBuffer();
        for (int seq = 0; seq < this.m_SeqID; ++seq) {
            NativeResult result = this.m_resultMap.get(seq);
            Exception ex = result.getException();
            if (ex == null) continue;
            if (msgbuf.length() > 0) {
                msgbuf.append(Constants.LINE_SEPARATOR);
            }
            msgbuf.append(ex.getMessage());
        }
        return msgbuf.toString();
    }

    public String getCompositeMessages() {
        Set<Object> identifiers = this.getOperationIdentifier();
        StringBuffer msgbuf = new StringBuffer();
        for (Object identifier : identifiers) {
            NativeResult result = this.m_resultMap.get(identifier);
            Exception ex = result.getException();
            if (ex == null) continue;
            if (msgbuf.length() > 0) {
                msgbuf.append(Constants.LINE_SEPARATOR);
            }
            msgbuf.append(ex.getMessage());
        }
        return msgbuf.toString();
    }

    @Override
    public String getMessage() {
        if (this.m_isNoMsg) {
            return this.getCompositeMessages();
        }
        return super.getMessage() + Constants.LINE_SEPARATOR + this.getCompositeMessages();
    }

    public String getAccompanyingMessage() {
        if (this.m_isNoMsg) {
            return "";
        }
        return super.getMessage();
    }

    private void assertIdentifier(Object identifer) throws NoSuchIdentifierException {
        if (identifer == null || !this.m_resultMap.containsKey(identifer)) {
            throw new NoSuchIdentifierException((MessageKey)PrCcMsgID.NO_SUCH_IDENTIFIER, identifer);
        }
    }

    public NativeResult getNativeResult(Object identifier) throws NoSuchIdentifierException {
        this.assertIdentifier(identifier);
        return this.m_resultMap.get(identifier);
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        EXCEPTION;

    }
}

