/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.server;

import java.util.List;
import java.util.Map;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerCategoryException;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.server.ServerPoolArgs;
import oracle.cluster.server.Site;
import oracle.cluster.server.SiteException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class ServerFactory {
    public static final int SRVPOOL_DEFAULT_MAX_SIZE = -1;
    private static ServerFactory s_instance;
    private ServerFactoryImpl s_serverFactoryImpl = ServerFactoryImpl.getInstance();

    private ServerFactory() throws ServerException {
    }

    public static synchronized ServerFactory getInstance() throws ServerException {
        if (s_instance == null) {
            s_instance = new ServerFactory();
        }
        return s_instance;
    }

    public Node getNode(String nodename) throws NodeException {
        return this.s_serverFactoryImpl.getNode(nodename);
    }

    public Node getNode(String nodename, boolean chkMbrship) throws NodeException {
        return this.s_serverFactoryImpl.getNode(nodename, chkMbrship);
    }

    public Server createServer(Node node) throws ServerException {
        if (node == null) {
            throw new ServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        return this.s_serverFactoryImpl.createServer(node);
    }

    public List<Server> servers() throws ServerException {
        return this.s_serverFactoryImpl.servers();
    }

    public void modifyServerPool(String serverPoolName, int minSize, int maxSize, int importance, Server[] serverArray) throws ServerGroupException, NotExistsException {
        ServerPoolArgs args = new ServerPoolArgs();
        args.setImportance(importance);
        args.setMaxSize(maxSize);
        args.setMinSize(minSize);
        args.setServers(serverArray);
        this.modifyServerPool(false, serverPoolName, args);
    }

    public void modifyServerPool(boolean forceFlag, String serverPoolName, ServerPoolArgs args) throws ServerGroupException, NotExistsException {
        this.s_serverFactoryImpl.modifyServerPool(forceFlag, serverPoolName, args);
    }

    public Server getServer(Node node) throws ServerException {
        return this.s_serverFactoryImpl.getServer(node);
    }

    public Map<String, String> getProfile(Server server) throws ServerException {
        return this.s_serverFactoryImpl.getProfile(server);
    }

    public void evaluateServerPoolCreation(String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws ServerGroupException {
        this.s_serverFactoryImpl.evaluateServerPoolCreation(serverPoolName, minSize, maxSize, importance, serverList);
    }

    public void evaluateServerGroupCreation(String groupName, Server ... serverList) throws ServerGroupException {
        this.s_serverFactoryImpl.evaluateServerGroupCreation(groupName, serverList);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, String category) throws AlreadyExistsException, ServerGroupException {
        if (serverPoolName == null || serverPoolName.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        if (maxSize < -1) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MAX_SIZE, maxSize);
        }
        if (minSize < 0 || maxSize != -1 && minSize > maxSize) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
        }
        if (importance < 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_IMPORTANCE, importance);
        }
        if (category == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "category", category);
        }
        return this.s_serverFactoryImpl.createServerPool(forceFlag, serverPoolName, minSize, maxSize, importance, category);
    }

    public ServerPool createServerPool(String serverPoolName, int minSize, int maxSize, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerPool(false, serverPoolName, minSize, maxSize, serverList);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, int minSize, int maxSize, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerPoolHelper(forceFlag, serverPoolName, minSize, maxSize, Integer.parseInt(ResourceType.ServerPool.IMPORTANCE.toString()), serverList);
    }

    public ServerPool createServerPool(String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerPool(false, serverPoolName, minSize, maxSize, importance, serverList);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerPoolHelper(forceFlag, serverPoolName, minSize, maxSize, importance, serverList);
    }

    public ServerGroup createServerGroup(String serverPoolName, int minSize, int maxSize, List<ServerGroup> parentList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerGroup(false, serverPoolName, minSize, maxSize, parentList);
    }

    public ServerGroup createServerGroup(boolean forceFlag, String serverPoolName, int minSize, int maxSize, List<ServerGroup> parentList) throws AlreadyExistsException, ServerGroupException {
        if (parentList == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "parentList", parentList);
        }
        for (int i = 0; i < parentList.size(); ++i) {
            if (null != parentList.get(i)) continue;
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "parentList(" + i + ")", parentList.get(i));
        }
        return this.createServerGroupHelper(forceFlag, serverPoolName, minSize, maxSize, 0, null, parentList, new Server[0]);
    }

    public ServerGroup createServerGroup(String serverPoolName, int minSize, int maxSize, int importance, String exclusiveGroups, List<ServerGroup> parentList, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerGroup(false, serverPoolName, minSize, maxSize, importance, exclusiveGroups, parentList, serverList);
    }

    public ServerGroup createServerGroup(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, String exclusiveGroups, List<ServerGroup> parentList, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        return this.createServerGroupHelper(forceFlag, serverPoolName, minSize, maxSize, importance, exclusiveGroups, parentList, serverList);
    }

    private ServerPool createServerPoolHelper(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        if (serverPoolName == null || serverPoolName.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        if (maxSize < -1) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MAX_SIZE, maxSize);
        }
        if (minSize < 0 || maxSize != -1 && minSize > maxSize) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
        }
        if (importance < 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_IMPORTANCE, importance);
        }
        if (serverList == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList", serverList);
        }
        for (int i = 0; i < serverList.length; ++i) {
            if (null != serverList[i]) continue;
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "server[" + i + "]", serverList[i]);
        }
        return this.s_serverFactoryImpl.createServerPool(forceFlag, serverPoolName, minSize, maxSize, importance, serverList);
    }

    private ServerGroup createServerGroupHelper(boolean forceFlag, String serverPoolName, int minSize, int maxSize, int importance, String exclusiveGroups, List<ServerGroup> parentList, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        int i;
        if (serverPoolName == null || serverPoolName.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        if (maxSize < -1) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MAX_SIZE, maxSize);
        }
        if (minSize < 0 || maxSize != -1 && minSize > maxSize) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
        }
        if (importance < 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_IMPORTANCE, importance);
        }
        if (serverList == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList", serverList);
        }
        for (i = 0; i < serverList.length; ++i) {
            if (null != serverList[i]) continue;
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "server[" + i + "]", serverList[i]);
        }
        if (parentList != null) {
            for (i = 0; i < parentList.size(); ++i) {
                if (null != parentList.get(i)) continue;
                throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "parentList(" + i + ")", parentList.get(i));
            }
        }
        return this.s_serverFactoryImpl.createServerGroup(forceFlag, serverPoolName, minSize, maxSize, importance, exclusiveGroups, parentList, serverList);
    }

    public ServerPool getServerPool(String serverPoolName) throws NotExistsException, ServerGroupException {
        if (serverPoolName == null || serverPoolName.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        return this.s_serverFactoryImpl.getServerPool(serverPoolName);
    }

    public ServerGroup getServerGroup(String serverPoolName) throws NotExistsException, ServerGroupException {
        if (serverPoolName == null || serverPoolName.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        return this.s_serverFactoryImpl.getServerGroup(serverPoolName);
    }

    public List<ServerGroup> getServerGroups() throws NotExistsException, ServerGroupException {
        return this.s_serverFactoryImpl.getServerGroups();
    }

    public List<ServerPool> getServerPools(String scType) throws NotExistsException, ServerGroupException {
        return this.s_serverFactoryImpl.getServerPools(scType);
    }

    public List<ServerPool> getServerPools() throws NotExistsException, ServerGroupException {
        return this.s_serverFactoryImpl.getServerPools();
    }

    public Map<ServerPool, ServerPoolArgs> getServerPoolsInfo() throws ServerGroupException {
        return this.s_serverFactoryImpl.getServerPoolsInfo();
    }

    public int getDefaultMinSize() throws ServerGroupException {
        return Integer.parseInt(ResourceType.ServerPool.MIN_SIZE.toString());
    }

    public int getDefaultMaxSize() throws ServerGroupException {
        return Integer.parseInt(ResourceType.ServerPool.MAX_SIZE.toString());
    }

    public int getDefaultImportance() throws ServerGroupException {
        return Integer.parseInt(ResourceType.ServerPool.IMPORTANCE.toString());
    }

    public String getDefaultCategory() throws ServerGroupException {
        return ResourceType.ServerPool.SERVER_CATEGORY.toString();
    }

    public ServerPool createLocalServerPool(String serverPoolName) throws ServerGroupException {
        if (null == serverPoolName) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverPoolName);
        }
        return this.s_serverFactoryImpl.createLocalServerPool(serverPoolName);
    }

    public ServerPool createLocalServerPool(String serverPoolName, ServerPoolArgs spargs) throws ServerGroupException {
        return this.s_serverFactoryImpl.createLocalServerPool(serverPoolName, spargs);
    }

    public Server createLocalServer(String serverName) throws ServerException {
        return this.s_serverFactoryImpl.createLocalServer(serverName);
    }

    public ServerPool createServerPool(boolean forceFlag, String serverPoolName, ServerPoolArgs args) throws ServerGroupException, NotExistsException {
        return this.s_serverFactoryImpl.createServerPool(forceFlag, serverPoolName, args);
    }

    public ServerCategory getServerCategory(String categoryName) throws NotExistsException, ServerCategoryException {
        return this.s_serverFactoryImpl.getServerCategory(categoryName);
    }

    public List<ServerCategory> getServerCategories() throws ServerCategoryException, NotExistsException {
        return this.s_serverFactoryImpl.getServerCategories();
    }

    public ServerCategory createServerCategory(String serverCategoryName, String activeCSSRole, Filter expression) throws AlreadyExistsException, ServerCategoryException {
        return this.s_serverFactoryImpl.createServerCategory(serverCategoryName, activeCSSRole, expression);
    }

    public ServerCategory getServerCategory(ServerGroup serverGroup) throws ServerGroupException {
        if (null == serverGroup) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_NAME, serverGroup);
        }
        return this.s_serverFactoryImpl.getServerCategory(serverGroup);
    }

    public List<ServerGroup> getServerGrpList(String sglistStr, String delim) throws ServerException {
        return this.s_serverFactoryImpl.getServerGrpList(sglistStr, delim);
    }

    public String getServerGrpString(List<ServerGroup> sgList, String separator, boolean userAssigned) {
        return this.s_serverFactoryImpl.getServerGrpString(sgList, separator, userAssigned);
    }

    public String getServerGroupEntityName(String grpName) {
        return this.s_serverFactoryImpl.getServerGroupEntityName(grpName);
    }

    public boolean isExtendedCluster() throws SiteException {
        return this.s_serverFactoryImpl.isExtendedCluster();
    }

    public List<Site> getConfiguredSites() throws SiteException {
        return this.s_serverFactoryImpl.getConfiguredSites();
    }

    public List<Site> getSitesForNodes(List<Node> nodes) throws SiteException {
        return this.s_serverFactoryImpl.getSitesForNodes(nodes);
    }

    public List<Site> getSitesForNodes(String[] nodeNames) throws SiteException {
        return this.s_serverFactoryImpl.getSitesForNodes(nodeNames);
    }

    public Site getSiteForNode(Node node) throws SiteException {
        return this.s_serverFactoryImpl.getSiteForNode(node);
    }

    public Site getSiteForNode(String nodename) throws SiteException {
        Trace.out("Invoking getSiteForNode(String nodename)");
        return this.s_serverFactoryImpl.getSiteForNode(nodename);
    }

    public static enum BuiltinServerGroup {
        LEGACY_SERVER_GROUP("Generic"),
        DEFAULT_SERVER_GROUP("Free");

        private String m_sg;

        public static BuiltinServerGroup getEnumMember(String name) throws ServerGroupException {
            for (BuiltinServerGroup g : BuiltinServerGroup.values()) {
                if (!g.m_sg.equalsIgnoreCase(name)) continue;
                return g;
            }
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_BUILTIN_SP, name);
        }

        private BuiltinServerGroup(String sg) {
            this.m_sg = sg;
        }

        public String toString() {
            return this.m_sg;
        }
    }

    public static enum BuiltinServerCategory {
        HUB(ResourceLiterals.HUB_CATEGORY.toString()),
        RIM(ResourceLiterals.RIM_CATEGORY.toString());

        private String m_sg;

        public static BuiltinServerCategory getEnumMember(String name) throws ServerCategoryException {
            for (BuiltinServerCategory g : BuiltinServerCategory.values()) {
                if (!g.m_sg.equalsIgnoreCase(name)) continue;
                return g;
            }
            throw new ServerCategoryException((MessageKey)PrCsMsgID.INVALID_BUILTIN_CATEGORY, name);
        }

        private BuiltinServerCategory(String sg) {
            this.m_sg = sg;
        }

        public String toString() {
            return this.m_sg;
        }
    }
}

