/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.scan;

import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanListenerImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanListenerException;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class ScanFactory {
    private static ScanFactory s_instance;
    private static ScanFactoryImpl s_factoryImpl;

    private ScanFactory() throws SoftwareModuleException {
        s_factoryImpl = ScanFactoryImpl.getInstance();
    }

    public static synchronized ScanFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ScanFactory();
        }
        return s_instance;
    }

    public List<ScanVIP> createScanVIP(String scanName, Network network, Version version) throws CompositeOperationException, ScanVIPException {
        if (null == scanName) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanName", scanName);
        }
        if (null == network) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "network", network);
        }
        if (null == version) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            return s_factoryImpl.addScanVIPs(scanName, null, network, version);
        }
        catch (AlreadyExistsException e) {
            throw new ScanVIPException(e);
        }
    }

    public List<ScanVIP> addScanVIPs(String scanName, String[] vips, Network network, Version version) throws CompositeOperationException, ScanVIPException, AlreadyExistsException {
        if (null == scanName) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanName", scanName);
        }
        if (null == network) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "network", network);
        }
        if (null == version) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return s_factoryImpl.addScanVIPs(scanName, vips, network, version);
    }

    public Network getNetworkForScan() throws NotExistsException, NetworkException {
        return s_factoryImpl.getNetworkForScan();
    }

    public void removeScanVIPs(boolean force) throws CompositeOperationException, NotExistsException, ScanVIPException {
        s_factoryImpl.removeScanVIPs(force);
    }

    public void removeScanVIPs(int netnum, boolean force) throws CompositeOperationException, NotExistsException, ScanVIPException {
        if (netnum < 1) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        s_factoryImpl.removeScanVIPs(netnum, force);
    }

    public List<ScanVIP> modifyScanVIP(String scanName) throws CompositeOperationException, ScanVIPException {
        if (null == scanName) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanName", scanName);
        }
        return s_factoryImpl.modifyScanVIP(scanName);
    }

    public ScanVIP getScanVIP(int ordinalNumber) throws NotExistsException, ScanVIPException {
        if (ordinalNumber < 0) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ordinalNumber", ordinalNumber);
        }
        return s_factoryImpl.getScanVIP(ScanVIPImpl.getResourceName(1, ordinalNumber));
    }

    public ScanVIP getScanVIP(int netnum, int ordinalNumber) throws NotExistsException, ScanVIPException {
        if (netnum < 1) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        if (ordinalNumber < 0) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ordinalNumber", ordinalNumber);
        }
        return s_factoryImpl.getScanVIP(ScanVIPImpl.getResourceName(netnum, ordinalNumber));
    }

    public List<ScanVIP> getAllScanVIPs() throws NotExistsException, ScanVIPException {
        return s_factoryImpl.getAllScanVIPs();
    }

    public List<ScanVIP> getScanVIPs() throws NotExistsException, ScanVIPException {
        return s_factoryImpl.getScanVIPs(1);
    }

    public List<ScanVIP> getScanVIPs(int netnum) throws NotExistsException, ScanVIPException {
        if (netnum < 1) {
            throw new ScanVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        return s_factoryImpl.getScanVIPs(netnum);
    }

    public List<ScanListener> createScanListener(Version version) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), null, version);
    }

    public List<ScanListener> createScanListenerwithNodes(Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithNodes(ResourceLiterals.LISTENER.toString().toUpperCase(), null, version, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithSubnets(ResourceLiterals.LISTENER.toString().toUpperCase(), null, version, invitedSubnets);
    }

    public List<ScanListener> createScanListener(Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), null, version, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(int scanPort, Version version) throws CompositeOperationException, ScanListenerException {
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), ep, version);
    }

    public List<ScanListener> createScanListenerwithNodes(int scanPort, Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return this.createScanListenerwithNodes(ResourceLiterals.LISTENER.toString().toUpperCase(), ep, version, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(int scanPort, Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return this.createScanListenerwithSubnets(ResourceLiterals.LISTENER.toString().toUpperCase(), ep, version, invitedSubnets);
    }

    public List<ScanListener> createScanListener(int scanPort, Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), ep, version, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(Endpoints endpoints, Version version) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), endpoints, version);
    }

    public List<ScanListener> createScanListenerwithNodes(Endpoints endpoints, Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithNodes(ResourceLiterals.LISTENER.toString().toUpperCase(), endpoints, version, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(Endpoints endpoints, Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithSubnets(ResourceLiterals.LISTENER.toString().toUpperCase(), endpoints, version, invitedSubnets);
    }

    public List<ScanListener> createScanListener(Endpoints endpoints, Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(ResourceLiterals.LISTENER.toString().toUpperCase(), endpoints, version, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanLsnrName, Version version) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(scanLsnrName, null, version);
    }

    public List<ScanListener> createScanListenerwithNodes(String scanLsnrName, Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithNodes(scanLsnrName, null, version, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(String scanLsnrName, Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithSubnets(scanLsnrName, null, version, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanLsnrName, Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(scanLsnrName, null, version, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanListenerName, Endpoints endpoints, Version version) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(scanListenerName, endpoints, version, false);
    }

    public List<ScanListener> createScanListenerwithNodes(String scanListenerName, Endpoints endpoints, Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithNodes(scanListenerName, endpoints, version, false, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(String scanListenerName, Endpoints endpoints, Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListenerwithSubnets(scanListenerName, endpoints, version, false, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanListenerName, Endpoints endpoints, Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        return this.createScanListener(scanListenerName, endpoints, version, false, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanListenerName, Endpoints endpoints, Version version, boolean skipportscheck) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            return s_factoryImpl.addScanListeners(scanListenerName, endpoints, version, skipportscheck);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListenerwithNodes(String scanListenerName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedNodes) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited nodes", invitedNodes);
        }
        try {
            return s_factoryImpl.addScanListeners(scanListenerName, endpoints, version, skipportscheck, invitedNodes, null);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListenerwithSubnets(String scanListenerName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedSubnets) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited subnets", invitedSubnets);
        }
        try {
            return s_factoryImpl.addScanListeners(scanListenerName, endpoints, version, skipportscheck, null, invitedSubnets);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListener(String scanListenerName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedNodes) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited nodes", invitedNodes);
        }
        if (null == invitedSubnets) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited subnets", invitedSubnets);
        }
        try {
            return s_factoryImpl.addScanListeners(scanListenerName, endpoints, version, skipportscheck, invitedNodes, invitedSubnets);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> addScanListeners(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return s_factoryImpl.addScanListeners(sLsnrName, endpoints, version, skipportscheck);
    }

    public List<ScanListener> addScanListenerswithNodes(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedNodes) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited nodes", invitedNodes);
        }
        return s_factoryImpl.addScanListeners(sLsnrName, endpoints, version, skipportscheck, invitedNodes, null);
    }

    public List<ScanListener> addScanListenerswithSubnets(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedSubnets) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited subnets", invitedSubnets);
        }
        return s_factoryImpl.addScanListeners(sLsnrName, endpoints, version, skipportscheck, null, invitedSubnets);
    }

    public List<ScanListener> addScanListeners(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == invitedNodes) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited nodes", invitedNodes);
        }
        if (null == invitedSubnets) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "invited subnets", invitedSubnets);
        }
        return s_factoryImpl.addScanListeners(sLsnrName, endpoints, version, skipportscheck, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanListenerName, int scanPort, Version version) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return s_factoryImpl.createScanListener(scanListenerName, ep, version, false);
    }

    public List<ScanListener> createScanListenerwithNodes(String scanListenerName, int scanPort, Version version, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return s_factoryImpl.createScanListenerwithNodes(scanListenerName, ep, version, false, invitedNodes);
    }

    public List<ScanListener> createScanListenerwithSubnets(String scanListenerName, int scanPort, Version version, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return s_factoryImpl.createScanListenerwithSubnets(scanListenerName, ep, version, false, invitedSubnets);
    }

    public List<ScanListener> createScanListener(String scanListenerName, int scanPort, Version version, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        if (null == version) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Endpoints ep = null;
        try {
            ep = NodeAppsFactory.getInstance().createEndpoints(Integer.toString(scanPort), " ");
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
        return s_factoryImpl.createScanListener(scanListenerName, ep, version, false, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(Endpoints endpoints) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(endpoints);
    }

    public List<ScanListener> modifyScanListener(int netnum, Endpoints endpoints) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, endpoints, null, null);
    }

    public List<ScanListener> modifyScanListenerwithNodes(Endpoints endpoints, String invitedNodes) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(endpoints, invitedNodes, null);
    }

    public List<ScanListener> modifyScanListenerwithNodes(int netnum, Endpoints endpoints, String invitedNodes) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, endpoints, invitedNodes, null);
    }

    public List<ScanListener> modifyScanListenerwithSubnets(Endpoints endpoints, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(endpoints, null, invitedSubnets);
    }

    public List<ScanListener> modifyScanListenerwithSubnets(int netnum, Endpoints endpoints, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, endpoints, null, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(Endpoints endpoints, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(endpoints, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(int netnum, Endpoints endpoints, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, endpoints, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener() throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener();
    }

    public List<ScanListener> modifyScanListener(int netnum) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, null, null);
    }

    public List<ScanListener> modifyScanListenerwithNodes(String invitedNodes) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(invitedNodes, null);
    }

    public List<ScanListener> modifyScanListenerwithNodes(int netnum, String invitedNodes) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, invitedNodes, null);
    }

    public List<ScanListener> modifyScanListenerwithSubnets(String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(null, invitedSubnets);
    }

    public List<ScanListener> modifyScanListenerwithSubnets(int netnum, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(null, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(int netnum, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return s_factoryImpl.modifyScanListener(netnum, invitedNodes, invitedSubnets);
    }

    public ScanListener getScanListener(String scanListenerName, int ordinalNumber) throws NotExistsException, ScanListenerException {
        if (scanListenerName == null || scanListenerName.trim().length() == 0) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanListenerName", scanListenerName);
        }
        if (ordinalNumber < 0) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ordinalNumber", ordinalNumber);
        }
        return s_factoryImpl.getScanListener(ScanListenerImpl.getResourceName(scanListenerName, 1, ordinalNumber));
    }

    public ScanListener getScanListener(String scanListenerName, int netnum, int ordinalNumber) throws NotExistsException, ScanListenerException {
        if (scanListenerName == null || scanListenerName.trim().length() == 0) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanListenerName", scanListenerName);
        }
        if (ordinalNumber < 0) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ordinalNumber", ordinalNumber);
        }
        return s_factoryImpl.getScanListener(ScanListenerImpl.getResourceName(scanListenerName, netnum, ordinalNumber));
    }

    public List<ScanListener> getAllScanListeners() throws NotExistsException, ScanListenerException {
        return s_factoryImpl.getAllScanListeners();
    }

    public List<ScanListener> getScanListeners() throws NotExistsException, ScanListenerException {
        return s_factoryImpl.getScanListeners(1);
    }

    public List<ScanListener> getScanListeners(int netnum) throws NotExistsException, ScanListenerException {
        if (netnum < 1) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        return s_factoryImpl.getScanListeners(netnum);
    }

    public ScanListener getScanListener(int ordinalNumber) throws NotExistsException, ScanListenerException {
        List<ScanListener> scanListenerList = this.getScanListeners();
        if (scanListenerList.size() > 0) {
            return this.getScanListener(scanListenerList.get(0).getListenerName(), ordinalNumber);
        }
        throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_LSNR_NOT_FOUND, ordinalNumber);
    }

    public ScanListener getScanListener(int netnum, int ordinalNumber) throws NotExistsException, ScanListenerException {
        List<ScanListener> scanListenerList = this.getScanListeners(netnum);
        if (scanListenerList.size() > 0) {
            return this.getScanListener(scanListenerList.get(0).getListenerName(), netnum, ordinalNumber);
        }
        throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_LSNR_NOT_FOUND_ON_NETWORK, ordinalNumber, netnum);
    }

    public Scan getScan() throws ScanException {
        return s_factoryImpl.getScan();
    }

    public Scan getScan(int netnum) throws ScanException {
        return s_factoryImpl.getScan(netnum);
    }

    public List<Scan> getScans() throws ScanException {
        return s_factoryImpl.getScans(1);
    }

    public List<Scan> getScans(int netnum) throws ScanException {
        return s_factoryImpl.getScans(netnum);
    }

    public void upgradeScanVIP(int netnum, Version.VersionEnum sourceVersion, Version.VersionEnum destVersion) throws UpgradeException {
        s_factoryImpl.upgradeScanVIP(netnum, sourceVersion, destVersion);
    }

    public void upgradeScanVIP11201To11202FirstPhase() throws UpgradeException {
        s_factoryImpl.upgradeScanVIP(1, Version.VersionEnum.V11201, Version.VersionEnum.V11202);
    }

    public void upgradeSCANVIP12101To122LastPhase() throws UpgradeException {
        s_factoryImpl.upgradeSCANVIP12101To122LastPhase();
    }
}

