/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cluster.common.ProgressListener;
import oracle.ops.mgmt.trace.Trace;

public class StreamCopy
implements Runnable {
    private InputStream m_inputStream;
    private OutputStream m_outputStream;
    private boolean m_isSuccess;
    private Exception m_exception;
    private Object m_hangTimeOutLock;
    private int m_bufferSize;
    private boolean m_isSender;
    private boolean m_isSenderReceiver;
    private Semaphore m_sema = null;
    private boolean m_isTimedOut = false;
    private ProgressListener m_plsnr;
    private static final int BUF_SIZE = 8192;
    private static final long HANG_TIMEOUT = 5000L;
    private static final String EOF_CODE = "ZKee3Z8K6VAV";
    private static final String CHARSET = Charset.defaultCharset().toString();
    private long m_lastPacketWriteTime;

    public StreamCopy(InputStream inputStream, OutputStream outputStream, int bufferSize) {
        this.m_inputStream = inputStream;
        this.m_outputStream = outputStream;
        this.m_hangTimeOutLock = new Object();
        this.m_bufferSize = bufferSize;
        this.m_isSenderReceiver = false;
        this.setException(null);
        this.setSuccess(false);
        this.setLastPacketWriteTime(Long.MAX_VALUE);
    }

    public StreamCopy(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean isSender) {
        this(inputStream, outputStream, bufferSize);
        this.m_isSenderReceiver = true;
        this.m_isSender = isSender;
    }

    public StreamCopy(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean isSender, Semaphore sema) throws InterruptedException {
        this(inputStream, outputStream, bufferSize);
        this.m_isSenderReceiver = true;
        this.m_isSender = isSender;
        this.m_sema = sema;
        try {
            this.m_sema.acquire();
        }
        catch (InterruptedException e) {
            Trace.out("InterruptedException caught in constructor: " + e.getMessage());
            this.setException(e);
            throw new InterruptedException(e.getMessage());
        }
    }

    public StreamCopy(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, 8192);
        this.m_isSenderReceiver = false;
    }

    public StreamCopy(InputStream inputStream, ProgressListener plsnr) {
        this.m_inputStream = inputStream;
        this.m_outputStream = null;
        this.m_hangTimeOutLock = new Object();
        this.m_bufferSize = 8192;
        this.m_isSenderReceiver = false;
        this.setException(null);
        this.setSuccess(false);
        this.setLastPacketWriteTime(Long.MAX_VALUE);
        this.m_plsnr = plsnr;
    }

    public StreamCopy(InputStream inputStream, OutputStream outputStream, boolean isSender) {
        this(inputStream, outputStream, 8192);
        this.m_isSenderReceiver = true;
        this.m_isSender = isSender;
    }

    public StreamCopy(InputStream inputStream, OutputStream outputStream, boolean isSender, Semaphore sema) throws InterruptedException {
        this(inputStream, outputStream, 8192);
        this.m_isSenderReceiver = true;
        this.m_isSender = isSender;
        this.m_sema = sema;
        try {
            this.m_sema.acquire();
        }
        catch (InterruptedException e) {
            Trace.out("InterruptedException caught in constructor: " + e.getMessage());
            this.setException(e);
            throw new InterruptedException(e.getMessage());
        }
    }

    public synchronized boolean isSuccess() {
        return this.m_isSuccess;
    }

    public synchronized Exception getException() {
        return this.m_exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimedOut() {
        if (this.m_isTimedOut) {
            return true;
        }
        Object object = this.m_hangTimeOutLock;
        synchronized (object) {
            return System.currentTimeMillis() - this.m_lastPacketWriteTime > 5000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[this.m_bufferSize];
        int read = 1;
        boolean found = false;
        int codeindex = 0;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Integer> future = null;
        try {
            while (read > -1 && !found) {
                String bufToString;
                if (this.m_sema == null) {
                    read = this.m_inputStream.read(buf, 0, buf.length);
                } else {
                    ReadTask readTask = new ReadTask(buf);
                    future = executor.submit(readTask);
                    read = future.get(5000L, TimeUnit.MILLISECONDS);
                }
                Trace.out("Read length in bytes= " + read);
                if (this.m_isSenderReceiver && read > -1 && !this.m_isSender && (bufToString = new String(buf, 0, read, CHARSET)).contains(EOF_CODE)) {
                    Trace.out("EOF code read");
                    found = true;
                    codeindex = read - EOF_CODE.length();
                    Trace.out("Copy will copy up to index: " + codeindex);
                }
                if (read <= -1) continue;
                if (!found) {
                    Trace.out("No. of bytes written: " + read);
                    this.m_outputStream.write(buf, 0, read);
                } else if (found && codeindex > 0) {
                    Trace.out("No. of bytes written: " + (read - EOF_CODE.length()));
                    this.m_outputStream.write(buf, 0, codeindex);
                }
                this.setLastPacketWriteTime(System.currentTimeMillis());
            }
            if (this.m_isSenderReceiver) {
                if (this.m_isSender) {
                    Trace.out("EOF code written");
                    this.m_outputStream.flush();
                    this.m_outputStream.write(EOF_CODE.getBytes());
                } else if (!this.m_isSender && found) {
                    Trace.out("Closing output stream");
                    this.m_outputStream.flush();
                    this.m_outputStream.close();
                }
            }
            Trace.out("StreamCopy End: no exceptions");
            this.setSuccess(true);
            this.setLastPacketWriteTime(Long.MAX_VALUE);
        }
        catch (IOException e) {
            Trace.out("IOException caught in StreamCopy.run(): " + e.getMessage());
            this.setException(e);
        }
        catch (TimeoutException e) {
            Trace.out("TimeoutException caught in StreamCopy.run(): " + e.getMessage());
            this.setException(e);
            this.m_isTimedOut = true;
            if (future != null && !future.isDone()) {
                future.cancel(true);
            }
        }
        catch (InterruptedException e) {
            Trace.out("InterruptedException caught in StreamCopy.run(): " + e.getMessage());
            this.setException(e);
        }
        catch (ExecutionException e) {
            Trace.out("ExecutionException caught in StreamCopy.run(): " + e.getMessage());
            this.setException(e);
        }
        finally {
            if (this.m_sema != null) {
                this.m_sema.release();
            }
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    private synchronized void setSuccess(boolean isSuccess) {
        this.m_isSuccess = isSuccess;
    }

    private synchronized void setException(Exception e) {
        this.setSuccess(false);
        this.m_exception = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastPacketWriteTime(long time) {
        Object object = this.m_hangTimeOutLock;
        synchronized (object) {
            this.m_lastPacketWriteTime = time;
        }
    }

    private class ReadTask
    implements Callable<Integer> {
        private byte[] m_buf;

        ReadTask(byte[] buf) {
            this.m_buf = buf;
        }

        @Override
        public Integer call() throws IOException {
            return StreamCopy.this.m_inputStream.read(this.m_buf, 0, this.m_buf.length);
        }
    }
}

