/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote;

import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.remote.RemoteFactoryImpl;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.CopyClient;
import oracle.cluster.remote.CopyListener;
import oracle.cluster.remote.CopyListenerException;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.IDInfo;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.remote.SecureFileTransfer;
import oracle.cluster.remote.SecureFileTransferException;
import oracle.cluster.remote.Transfer;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nls.MessageKey;

public class RemoteFactory {
    public static final int DEFAULT_TIMEOUT = 120;
    public static final int DEFAULT_TIMEOUT_MAX = 36000;
    public static final int TIMEOUT_STEPPER_MINS = 3;
    private static RemoteFactory s_instance;
    private static RemoteFactoryImpl s_factoryImpl;

    private RemoteFactory() {
        s_factoryImpl = RemoteFactoryImpl.getInstance();
    }

    public static synchronized RemoteFactory getInstance() {
        if (s_instance == null) {
            s_instance = new RemoteFactory();
        }
        return s_instance;
    }

    public ExecCommand getExecCommand() {
        return s_factoryImpl.getExecCommand();
    }

    public Transfer getTransfer() {
        return s_factoryImpl.getTransfer();
    }

    public CopyListener getCopyListener() throws CopyListenerException {
        return s_factoryImpl.getCopyListener();
    }

    public CopyListener getCopyListener(String baseDir) throws CopyListenerException {
        return s_factoryImpl.getCopyListener(baseDir);
    }

    public CopyClient getCopyClient() {
        return s_factoryImpl.getCopyClient();
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteArgs remoteArgs) {
        return s_factoryImpl.getExecCommandNoUserEq(remoteArgs);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(UserInfo userInfo) throws InvalidArgsException {
        return s_factoryImpl.getExecCommandNoUserEq(userInfo);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser) throws InvalidArgsException {
        return s_factoryImpl.getExecCommandNoUserEq(userInfo, asUser);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, String[] stdin) throws InvalidArgsException {
        return s_factoryImpl.getExecCommandNoUserEq(userInfo, asUser, stdin);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, NodeProgressListener npListener) throws InvalidArgsException {
        return s_factoryImpl.getExecCommandNoUserEq(userInfo, asUser, npListener);
    }

    public ExecCommandNoUserEq getExecCommandNoUserEq(RemoteUserInfo userInfo, String asUser, String[] stdin, NodeProgressListener npListener) throws InvalidArgsException {
        return s_factoryImpl.getExecCommandNoUserEq(userInfo, asUser, stdin, npListener);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, UserInfo userInfo, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, userInfo, timeout);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String user, String password, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, user, password, timeout);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, String rootPassword, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, rootPassword, timeout);
    }

    public Map<String, CommandResult> createDirOnNodes(String[] nodeNames, String dirPathname, String asUser, RemoteUserInfo remoteUserInfo) throws ExecException, InvalidArgsException, CompositeOperationException {
        return s_factoryImpl.createDirOnNodes(nodeNames, dirPathname, asUser, remoteUserInfo, null);
    }

    public Map<String, CommandResult> createDirOnNodes(String[] nodeNames, String dirPathname, String asUser, RemoteUserInfo remoteUserInfo, Integer mode) throws ExecException, InvalidArgsException, CompositeOperationException {
        if (mode == null) {
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        return s_factoryImpl.createDirOnNodes(nodeNames, dirPathname, asUser, remoteUserInfo, mode);
    }

    public Map<String, CommandResult> removeDirOnNodes(String[] nodeNames, String dirPathname, RemoteUserInfo remoteUserInfo, String asUser, boolean isRecursive) throws ExecException, InvalidArgsException, CompositeOperationException {
        return s_factoryImpl.removeDirOnNodes(nodeNames, dirPathname, remoteUserInfo, asUser, isRecursive);
    }

    public boolean isDirExists(String checkDirPath, String node, RemoteArgs remArgs) throws InvalidArgsException, ExecException {
        return s_factoryImpl.isDirExists(checkDirPath, node, remArgs);
    }

    public Map<String, CommandResult> isValidUser(String asUser, String[] nodeList, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.isValidUser(asUser, nodeList, uinfo);
    }

    public boolean isDirEmpty(String targetDir, String node, RemoteArgs remArgs) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.isDirEmpty(targetDir, node, remArgs);
    }

    public boolean isDirExistsAndWritable(String targetDir, String node, RemoteUserInfo userInfo, String asUser) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.isDirExistsAndWritable(targetDir, node, userInfo, asUser);
    }

    public boolean isFileExists(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return s_factoryImpl.isFileExists(targetFile, node, userInfo);
    }

    public boolean isRemoteNodePartOfCluster(String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return s_factoryImpl.isRemoteNodePartOfCluster(node, userInfo);
    }

    public boolean isRemoteNodeSIHA(String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return s_factoryImpl.isRemoteNodeSIHA(node, userInfo);
    }

    public String[] getFileContents(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.getFileContents(targetFile, node, userInfo);
    }

    public String getClusterwareVersion(String crsHome, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.getClusterwareVersion(crsHome, node, userInfo);
    }

    public String getSIHAVersion(String crsHome, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.getSIHAVersion(crsHome, node, userInfo);
    }

    public String getCRSHomeOfRemoteCluster(String node, RemoteUserInfo uinfo, boolean checkForClusterExistence) throws InvalidArgsException, ExecException {
        return s_factoryImpl.getCRSHomeOfRemoteCluster(node, uinfo, checkForClusterExistence);
    }

    public String getRemoteClusterNodes(String crsHome, String node, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.getRemoteClusterNodes(crsHome, node, uinfo);
    }

    public String getRemoteClusterName(String crsHome, String node, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        return s_factoryImpl.getRemoteClusterName(crsHome, node, uinfo);
    }

    public void deleteFileOnRemoteNode(String responseFile, String nodelist, RemoteArgs remArgs) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.deleteFileOnRemoteNode(responseFile, nodelist, remArgs);
    }

    public String getFileOwner(String targetFile, String node, RemoteUserInfo userInfo) throws InvalidArgsException, CompositeOperationException, ExecException {
        return s_factoryImpl.getFileOwner(targetFile, node, userInfo);
    }

    public void copyFileToNodes(String sourceFile, String[] nodeList, String destFile, boolean noPreserve, RemoteUserInfo userInfo, String asUser, int timeout) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.copyFileToNodes(sourceFile, nodeList, destFile, noPreserve, userInfo, asUser, timeout);
    }

    public IDInfo getIDInfo(String userName, String node, RemoteUserInfo userInfo) throws InvalidArgsException, ExecException {
        return s_factoryImpl.getIDInfo(userName, node, userInfo);
    }

    public IDInfo getIDInfo(String userName, String node) throws InvalidArgsException, ExecException {
        return s_factoryImpl.getIDInfo(userName, node);
    }

    public SecureFileTransfer getSecureFileTransfer(String node, UserInfo userInfo) throws SecureFileTransferException, InvalidArgsException {
        return s_factoryImpl.getSecureFileTransfer(node, userInfo);
    }

    public void replaceTextInFile(String node, String crsHome, String file, String oldText, String newText, RemoteUserInfo uinfo) throws InvalidArgsException, ExecException, CompositeOperationException {
        s_factoryImpl.replaceTextInFile(node, crsHome, file, oldText, newText, uinfo);
    }
}

