/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.remote.NameAndID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class IDInfo {
    private static final String UID = "uid";
    private static final String GID = "gid";
    private static final String GROUPS = "groups";
    private NameAndID m_uid = null;
    private NameAndID m_gid = null;
    private List<NameAndID> m_groups = null;
    private String m_idOutput = null;

    public IDInfo(NameAndID uid, NameAndID gid, List<NameAndID> groups) throws InvalidArgsException {
        Utils.assertInputNotNull(uid, UID);
        Utils.assertInputNotNull(gid, GID);
        Utils.assertInputNotNull(groups, GROUPS);
        this.m_uid = uid;
        this.m_gid = gid;
        this.m_groups = groups;
    }

    public IDInfo(String idOutput) throws InvalidArgsException {
        String[] mainContents;
        if (!(idOutput != null && idOutput.contains(UID) && idOutput.contains(GID) && idOutput.contains(GROUPS))) {
            Trace.out("InvalidArgsException for idOutput:" + idOutput);
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "IDInfo-constr01");
        }
        this.m_idOutput = idOutput;
        for (String segment : mainContents = idOutput.trim().split(" ")) {
            String contents = null;
            String name = null;
            int id = -1;
            if (segment.contains(UID)) {
                contents = segment.split("=", 2)[1];
                Trace.out("UID Contents: " + contents);
                id = Integer.parseInt(contents.split("\\(")[0]);
                name = contents.split("\\(")[1].split("\\)")[0];
                this.m_uid = new NameAndID(name, id);
                continue;
            }
            if (segment.contains(GID)) {
                contents = segment.split("=", 2)[1];
                Trace.out("GID Contents: " + contents);
                id = Integer.parseInt(contents.split("\\(")[0]);
                name = contents.split("\\(")[1].split("\\)")[0];
                this.m_gid = new NameAndID(name, id);
                continue;
            }
            if (!segment.contains(GROUPS)) continue;
            String groupContents = segment.split("=", 2)[1];
            Trace.out("Groups Contents: " + groupContents);
            String[] groupList = groupContents.split(",");
            this.m_groups = new ArrayList<NameAndID>();
            for (String groupContent : groupList) {
                id = Integer.parseInt(groupContent.split("\\(")[0]);
                name = groupContent.split("\\(")[1].split("\\)")[0];
                this.m_groups.add(new NameAndID(name, id));
            }
        }
    }

    public NameAndID getUserIDInfo() {
        return this.m_uid;
    }

    public NameAndID getPrimaryGroupIDInfo() {
        return this.m_gid;
    }

    public List<NameAndID> getGroupsInfo() {
        return this.m_groups;
    }

    public String idOuputString() {
        return this.m_idOutput;
    }
}

