/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.remote;

import java.io.InputStream;
import java.io.OutputStream;

public class ExecRunTime {
    private Process m_proc;
    private boolean userTerminated;

    public ExecRunTime(Process proc) {
        this.m_proc = proc;
        this.userTerminated = false;
    }

    public synchronized void terminate() {
        this.m_proc.destroy();
        this.userTerminated = true;
    }

    public synchronized boolean isUserTerminated() {
        this.m_proc.exitValue();
        return this.userTerminated;
    }

    public int exitValue() {
        return this.m_proc.exitValue();
    }

    public int waitFor() throws InterruptedException {
        return this.m_proc.waitFor();
    }

    public OutputStream getOutputStream() {
        return this.m_proc.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.m_proc.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.m_proc.getErrorStream();
    }

    public boolean isAlive() {
        return this.m_proc.isAlive();
    }
}

