/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.priv;

import java.util.List;
import java.util.Map;
import oracle.cluster.impl.priv.ChannelFactoryImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;

public class ChannelFactory
implements Constants {
    private static ChannelFactory s_instance;
    private ChannelFactoryImpl s_channelFactoryImpl;

    private ChannelFactory() throws ChannelException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            throw new ChannelException((MessageKey)PrCzMsgID.INVALID_PLATFORM, new Object[0]);
        }
        this.s_channelFactoryImpl = ChannelFactoryImpl.getInstance();
    }

    public static synchronized ChannelFactory getInstance() throws ChannelException {
        if (null == s_instance) {
            s_instance = new ChannelFactory();
        }
        return s_instance;
    }

    public void checkRootPassword(String[] nodeList, String password, int timeout) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkRootPassword(nodeList, password, timeout);
    }

    public void checkSudoExistence(String[] nodeList, String sudoLocation, String username, String password) throws ChannelException, CompositeOperationException {
        this.checkSudoExistence(nodeList, sudoLocation, username, password, null);
    }

    public void checkSudoExistence(String[] nodeList, String sudoLocation, String username, String password, List<String> noPasswdConfigNodes) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkSudoExistence(nodeList, sudoLocation, username, password, noPasswdConfigNodes);
    }

    public void checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password, int timeout) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkSudoExecution(nodeList, sudoLocation, username, password, timeout, null);
    }

    public void checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password, int timeout, List<String> noPasswdConfigNodes) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkSudoExecution(nodeList, sudoLocation, username, password, timeout, noPasswdConfigNodes);
    }

    public void checkPBRunExistence(String[] nodeList, String pblocation, String username, String password) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkPBRunExistence(nodeList, pblocation, username, password);
    }

    public void checkPBRunExecution(String[] nodeList, String pblocation, String username, String password, String command, int timeout) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.checkPBRunExecution(nodeList, pblocation, username, password, timeout);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, userInfo, timeout);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, userInfo, timeout);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, mode, location, userInfo, timeout);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, mode, location, userInfo, timeout);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, userInfo, timeout, cpListener);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, userInfo, timeout, cpListener);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, mode, location, userInfo, timeout, cpListener);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, mode, location, userInfo, timeout, cpListener);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, mode, location, userInfo, timeout, cpListener, asUser);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, mode, location, userInfo, timeout, cpListener, asUser);
    }

    public void invalidateSudoCredentialsCache(String[] nodeList, String sudoLocation, UserInfo userInfo) throws ChannelException, CompositeOperationException {
        this.s_channelFactoryImpl.invalidateSudoCredentialsCache(nodeList, sudoLocation, userInfo);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, String asUser) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, mode, location, userInfo, timeout, asUser);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, String asUser) throws ChannelException, CompositeOperationException {
        return this.s_channelFactoryImpl.executeCommand(nodeList, command, env, args, mode, location, userInfo, timeout, asUser);
    }
}

