/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nodeapps;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.nodeapps.EONS;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.InvalidFileException;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.ListenerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.ONSException;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.PortException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;

public class NodeAppsFactory {
    private static NodeAppsFactory s_instance;
    private NodeAppsFactoryImpl s_factoryImpl = NodeAppsFactoryImpl.getInstance();

    private NodeAppsFactory() throws SoftwareModuleException {
    }

    public static synchronized NodeAppsFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new NodeAppsFactory();
        }
        return s_instance;
    }

    public Network createNetwork(int netNum, DHCPServerType dhcpServerType, Version version) throws AlreadyExistsException, NetworkException {
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (dhcpServerType == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"dhcpServerType", dhcpServerType});
        }
        if (version == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createNetwork(String.valueOf(netNum), dhcpServerType, null, null, null, null, version, false);
    }

    public Network createNetwork(int netNum, DHCPServerType dhcpServerType, String netmask, String subnet, String[] ifList, Version version) throws AlreadyExistsException, NetworkException {
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (dhcpServerType == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"dhcpServerType", dhcpServerType});
        }
        if (netmask == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netmask", netmask);
        }
        if (subnet == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet", subnet);
        }
        if (ifList == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ifList", ifList);
        }
        if (version == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createNetwork(String.valueOf(netNum), dhcpServerType, netmask, subnet, ifList, null, version, false);
    }

    public GlobalNetworkClassification getGlobalNetworkClassification(String subnet, String netmask, String[] interfaces) {
        return this.s_factoryImpl.getGlobalNetworkClassification(subnet, netmask, interfaces);
    }

    public GlobalNetworkClassification getGlobalNetworkClassification(String subnet) {
        return this.s_factoryImpl.getGlobalNetworkClassification(subnet);
    }

    public Network getNetwork(int netNum) throws NotExistsException, NetworkException {
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        return this.s_factoryImpl.getNetwork(String.valueOf(netNum));
    }

    public Network getNetwork(int netNum, GlobalNetworkClassification gnwcls) throws NotExistsException, NetworkException {
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        return this.s_factoryImpl.getNetwork(netNum, gnwcls);
    }

    public Network getNetwork(GlobalNetworkClassification gnwcls) throws NotExistsException, NetworkException {
        if (gnwcls == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "gnwcls", gnwcls);
        }
        return this.s_factoryImpl.getNetwork(gnwcls);
    }

    public VIP createVIP(VIPAddress vipAddress, String prefNode, int netNum, Version version) throws AlreadyExistsException, VIPException {
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createVIP(vipAddress, null, prefNode, netNum, vipAddress.getSubnet(), DHCPServerType.NONE, version);
    }

    public VIP createVIP(VIPAddress vipAddress, String prefNode, int netNum, Version version, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, VIPException {
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createVIP(vipAddress, null, prefNode, netNum, vipAddress.getSubnet(), DHCPServerType.NONE, version, skipVIPReachabilityCheck);
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version) throws AlreadyExistsException, VIPException {
        String mySubnet = subnet;
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (subnet == null || subnet.trim().length() == 0) {
            if (DHCPServerType.NONE.equals((Object)serverType)) {
                mySubnet = vipAddress.getSubnet();
            } else {
                throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet", subnet);
            }
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Trace.out("mySubnet=" + mySubnet);
        return this.s_factoryImpl.createVIP(vipAddress, vipResIden, prefNode, netNum, mySubnet, serverType, version);
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, VIPException {
        String mySubnet = subnet;
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (subnet == null || subnet.trim().length() == 0) {
            if (DHCPServerType.NONE.equals((Object)serverType)) {
                mySubnet = vipAddress.getSubnet();
            } else {
                throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet", subnet);
            }
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Trace.out("mySubnet=" + mySubnet);
        return this.s_factoryImpl.createVIP(vipAddress, vipResIden, prefNode, netNum, mySubnet, serverType, version, skipVIPReachabilityCheck);
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version, boolean skipVIPReachabilityCheck, VIPAddress natAddr) throws AlreadyExistsException, VIPException {
        String mySubnet = subnet;
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (subnet == null || subnet.trim().length() == 0) {
            if (DHCPServerType.NONE.equals((Object)serverType)) {
                mySubnet = vipAddress.getSubnet();
            } else {
                throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet", subnet);
            }
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        Trace.out("mySubnet=" + mySubnet);
        return this.s_factoryImpl.createVIP(vipAddress, vipResIden, prefNode, netNum, mySubnet, serverType, version, skipVIPReachabilityCheck, natAddr);
    }

    public VIP createVIP(Network network, InetAddress vipAddress, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        return this.s_factoryImpl.createVIP(network, vipAddress, prefNode, version);
    }

    public VIP createVIP(Network network, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        return this.s_factoryImpl.createVIP(network, prefNode, version);
    }

    public VIP getVIP(String nodeOrVipName) throws NotExistsException, VIPException {
        if (nodeOrVipName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeOrVipName", nodeOrVipName);
        }
        return this.s_factoryImpl.getVIP(nodeOrVipName);
    }

    public VIP getVIP(String nodeName, String vipName, int netNum) throws NotExistsException, VIPException, NodeException, NetworkException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        if (vipName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipName", vipName);
        }
        if (netNum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        return this.s_factoryImpl.getVIP(nodeName, vipName, netNum);
    }

    public VIP getVIP(int netNum, String nodeName) throws VIPException, NotExistsException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        if (netNum <= 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        return this.s_factoryImpl.getVIP(netNum, nodeName);
    }

    public List<VIP> getVIPs(int netNumber) throws VIPException {
        if (netNumber < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNumber", netNumber);
        }
        return this.s_factoryImpl.getVIPs(netNumber);
    }

    public List<VIP> getVIPs(String nodeName, String vipName) throws VIPException {
        if (nodeName == null && vipName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeOrVipName", "");
        }
        return this.s_factoryImpl.getVIPs(nodeName, vipName);
    }

    public List<VIP> getVIPs(String vipName, int netNum) throws VIPException {
        return this.s_factoryImpl.getVIPs(vipName, netNum);
    }

    public List<VIP> getVIPs(int netnum, String nodeName) throws VIPException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        if (netnum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        return this.s_factoryImpl.getVIPs(netnum, nodeName);
    }

    public List<VIP> getConfiguredVIPs(String nodeName) throws VIPException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        return this.s_factoryImpl.getConfiguredVIPs(nodeName);
    }

    public Map<String, VIP> getConfiguredVIPs(int networkNumber) throws VIPException {
        return this.s_factoryImpl.getConfiguredVIPs(networkNumber);
    }

    public List<VIP> getVIPs(String nodeName) throws VIPException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        return this.s_factoryImpl.getVIPs(nodeName);
    }

    public List<VIP> getRunningVIPs(String nodeName) throws VIPException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        return this.s_factoryImpl.getRunningVIPs(nodeName);
    }

    public List<VIP> getRunningVIPs(String nodeName, int netnum) throws VIPException {
        if (nodeName == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        if (netnum < 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netnum", netnum);
        }
        return this.s_factoryImpl.getRunningVIPs(nodeName, netnum);
    }

    public ONS createONS(Version version) throws AlreadyExistsException, ONSException {
        if (version == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createONS(null, null, new String[0], null, version, null);
    }

    public ONS createONS(int localPort, int remotePort, Version version) throws AlreadyExistsException, ONSException {
        if (localPort < 0) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "localPort", localPort);
        }
        if (remotePort < 0 || remotePort == localPort) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "remotePort", remotePort);
        }
        if (version == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createONS(String.valueOf(localPort), String.valueOf(remotePort), new String[0], null, version, null);
    }

    public ONS createONS(int localPort, int remotePort, String[] remoteHosts, Version version) throws AlreadyExistsException, ONSException {
        if (localPort < 0) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "localPort", localPort);
        }
        if (remotePort < 0 || remotePort == localPort) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "remotePort", remotePort);
        }
        if (remoteHosts == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "remoteHosts", remoteHosts);
        }
        if (version == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createONS(String.valueOf(localPort), String.valueOf(remotePort), remoteHosts, null, version, null);
    }

    public ONS createONS(int localPort, int remotePort, String[] remoteHosts, int emPort, Version version) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, null);
    }

    public ONS createONS(int localPort, int remotePort, String[] remoteHosts, int emPort, Version version, boolean skipPortCheck) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, null, skipPortCheck);
    }

    public ONS createONS(int localPort, int remotePort, String[] remoteHosts, int emPort, Version version, String clientData) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, clientData, false);
    }

    public ONS createONS(int localPort, int remotePort, String[] remoteHosts, int emPort, Version version, String clientData, boolean skipPortCheck) throws AlreadyExistsException, ONSException {
        if (localPort < 0) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "localPort", localPort);
        }
        if (remotePort < 0 || remotePort == localPort) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "remotePort", remotePort);
        }
        if (emPort < 0 || emPort == localPort) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "emPort", remotePort);
        }
        if (remoteHosts == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "remoteHosts", remoteHosts);
        }
        if (version == null) {
            throw new ONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createONS(String.valueOf(localPort), String.valueOf(remotePort), remoteHosts, String.valueOf(emPort), version, clientData, skipPortCheck);
    }

    public ONS getONS() throws NotExistsException, ONSException {
        return this.s_factoryImpl.getONS();
    }

    public EONS createEONS(Version version) throws AlreadyExistsException, EONSException {
        if (null == version) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            ClusterFactoryImpl fac = ClusterFactoryImpl.getInstance();
            return this.createEONS(fac.getMulticastAddress(), fac.getMulticastPort(), Integer.parseInt(ResourceLiterals.EONS_PORT.toString()), version);
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            throw new EONSException(e);
        }
        catch (UnknownHostException e) {
            Trace.out(e);
            throw new EONSException(e);
        }
        catch (PortException e) {
            Trace.out(e);
            throw new EONSException(e);
        }
    }

    public EONS createEONS(InetAddress mcastAddress, Version version) throws AlreadyExistsException, EONSException {
        return this.createEONS(mcastAddress, Integer.parseInt(ResourceLiterals.EONS_MCAST_PORT.toString()), Integer.parseInt(ResourceLiterals.EONS_PORT.toString()), version);
    }

    public EONS createEONS(InetAddress mcastAddress, int mcastPort, int port, Version version) throws AlreadyExistsException, EONSException {
        return this.createEONS(mcastAddress, mcastPort, port, new HashMap<String, String>(0), version);
    }

    public EONS createEONS(InetAddress mcastAddress, int mcastPort, int port, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        if (null == version) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == mcastAddress) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
        }
        if (mcastPort < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
        }
        if (null == props) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "props", props);
        }
        if (port < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", version);
        }
        return this.s_factoryImpl.createEONS(SCDiscoveryMethod.MULTICAST, String.valueOf(port), mcastAddress, String.valueOf(mcastPort), null, props, version);
    }

    public EONS createEONS(int port, InetAddress mcastAddress, int mcastPort, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        if (port < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == mcastAddress) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
        }
        if (mcastPort < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
        }
        if (null == props) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "props", props);
        }
        if (null == version) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createEONS(SCDiscoveryMethod.MULTICAST, String.valueOf(port), mcastAddress, String.valueOf(mcastPort), null, props, version);
    }

    public EONS createEONS(int port, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        if (port < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == props) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "props", props);
        }
        if (null == version) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createEONS(SCDiscoveryMethod.GOSSIP_SERVERS, String.valueOf(port), null, null, null, props, version);
    }

    public EONS createEONS(int port, Map<String, Integer> mbrMap, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        if (port < 1) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == mbrMap || 0 == mbrMap.size()) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mbrMap", mbrMap);
        }
        if (null == props) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "props", props);
        }
        if (null == version) {
            throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createEONS(SCDiscoveryMethod.LIST, String.valueOf(port), null, null, mbrMap, props, version);
    }

    public EONS getEONS() throws NotExistsException, EONSException {
        return this.s_factoryImpl.getEONS();
    }

    public Listener createListener(Version version) throws AlreadyExistsException, NetworkException, ListenerException {
        return this.createListener(ResourceLiterals.LISTENER.toString().toUpperCase(), version);
    }

    public Listener createListener(String lsnrName, Version version) throws AlreadyExistsException, NetworkException, ListenerException {
        if (lsnrName == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createListener(lsnrName, null, version, null, false);
    }

    public Listener createListener(String lsnrName, String oracleHome, Version version, Endpoints endpoints, boolean portscheck) throws AlreadyExistsException, NetworkException, ListenerException {
        if (lsnrName == null || lsnrName.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (endpoints == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "endpoints", endpoints);
        }
        return this.s_factoryImpl.createListener(lsnrName, oracleHome, version, endpoints, portscheck);
    }

    public Listener createListener(String lsnrName, String oracleHome, Version version, Endpoints endpoints) throws AlreadyExistsException, NetworkException, ListenerException {
        return this.createListener(lsnrName, oracleHome, version, endpoints, false);
    }

    public Listener createListener(String lsnrName, String oracleHome, Version version, int ... portList) throws AlreadyExistsException, NetworkException, ListenerException {
        if (lsnrName == null || lsnrName.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        for (int i = 0; i < portList.length; ++i) {
            if (portList[i] < 0) {
                if (sb.length() > 0) {
                    sb.append(" " + portList[i]);
                    continue;
                }
                sb.append(portList[i]);
                continue;
            }
            if (sb1.length() > 0) {
                sb1.append("," + portList[i]);
                continue;
            }
            sb1.append(portList[i]);
        }
        if (sb.length() > 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "portList", sb.toString());
        }
        return this.s_factoryImpl.createListener(lsnrName, oracleHome, version, this.createEndpoints(sb1.toString(), " "), false);
    }

    public Listener createListener(int netNum, Version version) throws AlreadyExistsException, ListenerException {
        if (netNum < 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createListener(ResourceLiterals.LISTENER.toString().toUpperCase(), null, netNum, version, null, false);
    }

    public Listener createListener(String lsnrName, String oracleHome, int netNum, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        if (lsnrName == null || lsnrName.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        if (netNum < 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createListener(lsnrName, oracleHome, netNum, version, endpoints, skipportscheck);
    }

    public Listener createListener(String lsnrName, String oracleHome, int netNum, Version version, Endpoints endpoints) throws AlreadyExistsException, ListenerException {
        return this.createListener(lsnrName, oracleHome, netNum, version, endpoints, false);
    }

    public Listener createListener(String lsnrName, String oracleHome, int netNum, Version version, int ... portList) throws AlreadyExistsException, ListenerException {
        return this.createListener(lsnrName, oracleHome, netNum, version, false, portList);
    }

    public Listener createListener(String lsnrName, String oracleHome, int netNum, Version version, boolean skipportscheck, int ... portList) throws AlreadyExistsException, ListenerException {
        if (lsnrName == null || lsnrName.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        if (netNum < 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        for (int i = 0; i < portList.length; ++i) {
            if (portList[i] < 0) {
                if (sb.length() > 0) {
                    sb.append(" " + portList[i]);
                    continue;
                }
                sb.append(portList[i]);
                continue;
            }
            if (sb1.length() > 0) {
                sb1.append("," + portList[i]);
                continue;
            }
            sb1.append(portList[i]);
        }
        if (sb.length() > 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "portList", sb.toString());
        }
        return this.s_factoryImpl.createListener(lsnrName, oracleHome, netNum, version, this.createEndpoints(sb1.toString(), " "), skipportscheck);
    }

    public Listener createASMListener(String lsnrName, String subnet, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(ListenerType.ASM_LISTENER, lsnrName, null, 0, this.getGlobalNetworkClassification(subnet), version, endpoints, skipportscheck);
    }

    public Listener createASMListener(String lsnrName, String subnet, Version version) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(ListenerType.ASM_LISTENER, lsnrName, this.getGlobalNetworkClassification(subnet), version);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, String subnet, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, this.getGlobalNetworkClassification(subnet), version, endpoints, skipportscheck);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck);
    }

    public Listener upgradeListener(String lsnrName, String oldHome, String lsnruser) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.upgradeListener(lsnrName, oldHome, lsnruser);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, boolean skipportscheck, String user) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, skipportscheck, user);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, skipportscheck, user, group);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck, String user) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck, user);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck, user, group);
    }

    public Listener createMgmtListener(Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        ListenerType lsnrType = ListenerType.MGMT_LISTENER;
        String lsnrName = ResourceLiterals.MGMTLSNR.toString();
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, null, 0, null, version, endpoints, skipportscheck);
    }

    public Listener createMgmtListener(Version version, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        ListenerType lsnrType = ListenerType.MGMT_LISTENER;
        String lsnrName = ResourceLiterals.MGMTLSNR.toString();
        return this.s_factoryImpl.createListener(lsnrType, lsnrName, null, 0, null, version, skipportscheck, null);
    }

    public List<Listener> createASMListenersForUpgradeToFlex(Node firstNode, Version version) throws AlreadyExistsException, ListenerException {
        return this.s_factoryImpl.createASMListenersForUpgradeToFlex(firstNode, version);
    }

    public Listener getListener(String lsnrName) throws NotExistsException, ListenerException {
        if (lsnrName == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
        return this.s_factoryImpl.getListener(lsnrName);
    }

    public Listener getMgmtListener() throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getMgmtListener();
    }

    public List<Listener> getASMListeners() throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getASMListeners();
    }

    public List<Listener> getRIMListeners() throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getRIMListeners();
    }

    public List<Listener> getListeners() throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getListeners();
    }

    public List<Listener> getListeners(String oHome) throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getListeners(oHome);
    }

    public Network createNetwork(GlobalNetworkClassification gnwcls, int netNum, DHCPServerType serverType, Version version) throws AlreadyExistsException, NetworkException {
        return this.createNetwork(gnwcls, netNum, serverType, version, false);
    }

    public Network createNetwork(GlobalNetworkClassification gnwcls, int netNum, DHCPServerType serverType, String[] pingTargets, Version version) throws AlreadyExistsException, NetworkException {
        if (gnwcls == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "GlobalNetworkClassification", gnwcls);
        }
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (pingTargets == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pingTargets", pingTargets);
        }
        if (version == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createNetwork(gnwcls, netNum, serverType, pingTargets, version, false);
    }

    public Network createNetwork(GlobalNetworkClassification gnwcls, int netNum, DHCPServerType serverType, Version version, boolean isLeaf) throws AlreadyExistsException, NetworkException {
        if (gnwcls == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "GlobalNetworkClassification", gnwcls);
        }
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (version == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createNetwork(gnwcls, netNum, serverType, null, version, isLeaf);
    }

    public Network createNetwork(GlobalNetworkClassification gnwcls, int netNum, DHCPServerType serverType, String[] pingTargets, Version version, boolean isLeaf) throws AlreadyExistsException, NetworkException {
        if (gnwcls == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "GlobalNetworkClassification", gnwcls);
        }
        if (netNum < 0) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "netNum", netNum);
        }
        if (serverType == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"serverType", serverType});
        }
        if (version == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (pingTargets == null) {
            throw new NetworkException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pingTargets", pingTargets);
        }
        return this.s_factoryImpl.createNetwork(gnwcls, netNum, serverType, pingTargets, version, isLeaf);
    }

    public List<Network> getNetworks() throws NotExistsException, NetworkException {
        return this.s_factoryImpl.getNetworks();
    }

    public Endpoints createEndpoints(String endpoints, String separator, boolean isMgmtLsnr) throws ListenerException {
        return this.s_factoryImpl.createEndpoints(endpoints, separator, isMgmtLsnr);
    }

    public Endpoints createEndpoints(String endpoints, String separator) throws ListenerException {
        return this.s_factoryImpl.createEndpoints(endpoints, separator, false);
    }

    public void setUpgradeModeFlags() throws CRSException {
        this.s_factoryImpl.setUpgradeModeFlags();
    }

    public void upgradeONS11201To11202FirstPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeONS11201To11202FirstPhase();
    }

    public void upgradeONS11201To11202LastPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeONS11201To11202LastPhase();
    }

    public void upgradeVIP11204To12101LastPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeVIP11204To12101LastPhase();
    }

    public void upgradeMgmtLsnr12102To12201FirstPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeMgmtLsnr12102To12201FirstPhase();
    }

    public void upgradeVIP12101To122LastPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeVIP12101To122LastPhase();
    }

    public TreeMap<String, String> getListenerHomeNodesMap(Listener lsnr) throws ListenerException {
        return this.s_factoryImpl.getListenerHomeNodesMap(lsnr);
    }

    public String getListenerLocalHome(Listener lsnr) throws ListenerException {
        return this.s_factoryImpl.getListenerLocalHome(lsnr);
    }

    public int getDefaultNetworkNumber() {
        return this.s_factoryImpl.getDefaultNetworkNumber();
    }

    public void assertRoot() throws SoftwareModuleException {
        this.s_factoryImpl.assertRoot();
    }

    public boolean validatePortConflict4Subnet(int port, String subnet) throws ListenerException {
        return this.s_factoryImpl.validatePortConflict4Subnet(port, subnet);
    }

    public void checkPortFree(int port) throws CompositeOperationException, ListenerException {
        this.s_factoryImpl.checkPortFree(port);
    }

    public int getFreePort(ListenerType lsnrType) throws ListenerException {
        return this.s_factoryImpl.getFreePort(lsnrType);
    }

    public List<Listener> getAllListeners() throws NotExistsException, ListenerException {
        return this.s_factoryImpl.getAllListeners();
    }

    public void mergeTnsNames(String srcFile, String tgtFile) throws InvalidFileException, ListenerException {
        this.s_factoryImpl.mergeTnsNames(srcFile, tgtFile);
    }

    public void mergeSqlNet(String srcFile, String tgtFile, String srcOrclHome, String tgtOrclHome) throws InvalidFileException, ListenerException {
        this.s_factoryImpl.mergeSqlNet(srcFile, tgtFile, srcOrclHome, tgtOrclHome);
    }

    public void mergeListenerOra(String srcFile, String tgtFile) throws InvalidFileException, ListenerException {
        this.s_factoryImpl.mergeListenerOra(srcFile, tgtFile);
    }
}

