/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nodeapps;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;

public interface Network
extends SoftwareModule {
    public static final String NETWORK_CHECKLEVEL_PROPERTY = "NETWORK.CHECKLEVEL";

    public int getNumber() throws NetworkException;

    public String[] getPingTargets() throws NetworkException;

    public Subnet subnet() throws NotExistsException, NetworkException;

    public Subnet subnet_ipv6() throws NotExistsException, NetworkException;

    public Map<IPAddressUtil.IPAddrType, Subnet> subnets() throws NotExistsException, NetworkException;

    public IPAddressUtil.IPAddrType addressType() throws NetworkException;

    public void setAddressType(IPAddressUtil.IPAddrType var1) throws NetworkException;

    public List<VIP> getVIPs() throws NetworkException;

    public void removeAddrTypeFromVIPs(IPAddressUtil.IPAddrType var1) throws NetworkException, VIPException;

    public List<NetworkAdapter> networkAdapters() throws NetworkException;

    public DHCPServerType dhcpServerType() throws NetworkException;

    public DHCPServerType dhcpServerTypeIPv6() throws NetworkException;

    public Map<IPAddressUtil.IPAddrType, DHCPServerType> dhcpServerTypes() throws NetworkException;

    public void setDHCPServerType(DHCPServerType var1, IPAddressUtil.IPAddrType var2, boolean var3) throws NetworkException;

    public void setDHCPServerType(DHCPServerType var1) throws NetworkException;

    public void setDHCPServerTypeIPv6(DHCPServerType var1) throws NetworkException;

    public VIP vip(Node var1) throws NotExistsException, NetworkException;

    public void enable(List<Node> var1) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException;

    public void disable(List<Node> var1) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    public CRSResource crsResource() throws NotExistsException, NetworkException;

    public void remove(boolean var1) throws AlreadyRunningException, NetworkException;

    public boolean compareAdapters(List<NetworkAdapter> var1) throws NetworkException;

    public boolean compareSubnet(Subnet var1) throws NetworkException;

    public boolean compareMaskedSubnet(Subnet var1) throws NetworkException;

    public boolean isLeafNW() throws NetworkException;

    public void modifyNetwork(GlobalNetworkClassification var1) throws NetworkException;

    public void modifyNetwork(String[] var1) throws NetworkException;

    public void modifyNetwork(GlobalNetworkClassification var1, String[] var2) throws NetworkException;

    public void setAddrTypeToBoth() throws NetworkException;

    public void ntGrantAclsForTransparentHA() throws NetworkException;

    public void extendToLeaf(boolean var1) throws NetworkException;

    public boolean isExtendedNW() throws NetworkException;
}

