/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.nodeapps;

import java.util.Map;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.resources.PrCnMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public interface Endpoints {
    public String toString();

    public String toCRSValue();

    public boolean equals(Endpoints var1);

    public String getTCPPortStr();

    public String getTCPPortCRSValue();

    public int[] getTCPPortArr();

    public String getTCPSPortStr();

    public Map<LsnrProtocolType, Boolean> getFirewallStatus();

    public boolean isFirewallConfigured();

    public static enum LsnrProtocolType {
        TCP_PROTOCOL("TCP"),
        IPC_PROTOCOL("IPC"),
        TCPS_PROTOCOL("TCPS"),
        NMP_PROTOCOL("NMP"),
        SDP_PROTOCOL("SDP"),
        EXADIRECT_PROTOCOL("EXADIRECT");

        private String m_lpt;

        public static LsnrProtocolType getEnumMember(String lpt) throws ListenerException {
            for (LsnrProtocolType g : LsnrProtocolType.values()) {
                if (!g.m_lpt.equalsIgnoreCase(lpt)) continue;
                return g;
            }
            throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PROTOCOLTYPE, lpt);
        }

        private LsnrProtocolType(String lpt) {
            this.m_lpt = lpt;
        }

        public String toString() {
            return this.m_lpt;
        }
    }
}

