/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.logger;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.LogRecord;
import oracle.cluster.logger.Output;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nls.MessageBundle;

public class StreamOutput
implements Output {
    private PrintStream out = null;
    private OutputStream streamName = null;
    private static MessageBundle msgBndl;
    private static PrintStream ou;

    public StreamOutput() {
    }

    public StreamOutput(OutputStream output) {
        this.streamName = output;
        this.out = new PrintStream(output);
    }

    @Override
    public synchronized void print(LogRecord logRecord) {
        this.print(logRecord.getMessage());
    }

    private void print(String msg) {
        if (this.isValidOutput()) {
            this.out.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    @Override
    public void close() {
        if (this.isValidOutput()) {
            this.out.close();
        }
    }

    @Override
    public boolean isValidOutput() {
        return this.out != null;
    }

    @Override
    public boolean equals(Output out) {
        StreamOutput so = (StreamOutput)out;
        return this.streamName.equals(so.streamName);
    }

    static {
        ou = System.out;
        msgBndl = MessageBundle.getMessageBundle(PrCrMsgID.facility);
        msgBndl.setPackage("oracle.cluster.resources");
    }
}

