/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import oracle.cluster.logger.Output;
import oracle.cluster.logger.SRVErrorManager;
import oracle.cluster.logger.SRVLevel;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;

public class FileOutput
extends PrintStream
implements Output {
    private StreamHandler handler = null;
    private String m_fileName = null;
    private static MessageBundle msgBndl;
    private SRVErrorManager sErrMngr = new SRVErrorManager();
    static int i;
    static final String LSEP;

    public FileOutput(String fileName) {
        this(fileName, false, false);
    }

    public FileOutput(String fileName, boolean append) {
        this(fileName, append, false);
    }

    public FileOutput(String fileName, boolean append, boolean bSavePrevious) {
        this(fileName, append, bSavePrevious, null);
    }

    public FileOutput(String fileName, boolean append, boolean bSavePrevious, String filePerm) {
        super(System.out, false);
        try {
            boolean toSetFilePerm = false;
            if (filePerm != null) {
                toSetFilePerm = !new File(fileName).exists() && filePerm != null;
            }
            this.m_fileName = fileName;
            if (!append) {
                FileOutput.updateOldFiles(fileName, bSavePrevious);
            }
            this.handler = new FileHandler(fileName, append);
            this.handler.setErrorManager(this.sErrMngr);
            this.handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            if (toSetFilePerm) {
                this.modifyFilePerm(fileName, filePerm);
            }
        }
        catch (IOException io) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CREATION_FAILED_IOERROR, true, fileName) + io.getMessage());
        }
        catch (SecurityException so) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CREATION_FAILED_SECURITYERROR, true, fileName));
        }
        catch (IllegalArgumentException iae) {
            System.out.println(msgBndl.getMessage(PrCrMsgID.FILENAME_EMPTY, true));
        }
    }

    public FileOutput(String fileName, int limit, int count) {
        this(fileName, limit, count, false, false);
    }

    public FileOutput(String fileName, int limit, int count, boolean append) {
        this(fileName, limit, count, append, false);
    }

    public FileOutput(String fileName, int limit, int count, boolean append, boolean bSavePrevious) {
        this(fileName, limit, count, append, bSavePrevious, null);
    }

    public FileOutput(String fileName, int limit, int count, boolean append, boolean bSavePrevious, String filePerm) {
        super(System.out, false);
        try {
            boolean toSetFilePerm = false;
            if (filePerm != null) {
                toSetFilePerm = !new File(fileName).exists() && filePerm != null;
            }
            this.m_fileName = fileName;
            if (!append) {
                FileOutput.updateOldFiles(fileName, bSavePrevious);
            }
            this.handler = new FileHandler(fileName, limit, count, append);
            this.handler.setErrorManager(this.sErrMngr);
            this.handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            if (toSetFilePerm) {
                String file = fileName;
                if (count > 1) {
                    file = file + ".0";
                }
                this.modifyFilePerm(file, filePerm);
            }
        }
        catch (IOException io) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CREATION_FAILED_IOERROR, true, fileName) + io.getMessage());
        }
        catch (SecurityException so) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CREATION_FAILED_SECURITYERROR, true, fileName));
        }
        catch (IllegalArgumentException iae) {
            if (fileName.equals("")) {
                System.out.println(msgBndl.getMessage(PrCrMsgID.FILENAME_EMPTY, true));
            }
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CREATION_FAILED_ILLEGALARGUMENT, true, fileName));
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public void close() {
        try {
            if (this.isValidOutput()) {
                this.handler.close();
            }
        }
        catch (SecurityException se) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.FILEOUTPUT_CLOSE_FAILED, true, this.m_fileName));
        }
    }

    @Override
    public synchronized void print(LogRecord logrecord) {
        if (this.isValidOutput()) {
            this.handler.publish(logrecord);
        }
    }

    @Override
    public void println(Object obj) {
        String msg = String.valueOf(obj);
        this.print(msg);
    }

    @Override
    public void println(String msg) {
        this.print(msg);
    }

    @Override
    public void print(String msg) {
        LogRecord lr = new LogRecord(SRVLevel.ALL, msg);
        this.print(lr);
    }

    @Override
    public boolean equals(Output out) {
        FileOutput fo = (FileOutput)out;
        return this.m_fileName.equals(fo.m_fileName);
    }

    @Override
    public boolean isValidOutput() {
        return this.handler != null;
    }

    private static void updateOldFiles(String filePath, boolean bSave) {
        File f = new File(filePath);
        String name = f.getName();
        String path = f.getParent();
        if (path == null) {
            path = ".";
        }
        File dir = new File(path);
        String[] list = dir.list();
        String separator = System.getProperty("file.separator");
        String strTimeStamp = FileOutput.getTimeStamp();
        if (list == null) {
            System.out.println(MessageBundle.getMessage(PrCrMsgID.DIRECTORY_NOT_EXIST, true, dir));
            return;
        }
        for (int idx = 0; idx < list.length; ++idx) {
            String strTmp;
            if (list[idx].equals(name)) {
                File oldFile = new File(path + separator + list[idx]);
                if (bSave) {
                    File newFile = new File(path + separator + list[idx] + "_" + strTimeStamp);
                    if (!oldFile.exists()) continue;
                    oldFile.renameTo(newFile);
                    continue;
                }
                if (!oldFile.isFile()) continue;
                oldFile.delete();
                continue;
            }
            if (!list[idx].startsWith(name) || list[idx].length() <= name.length() || list[idx].charAt(name.length()) != '.' || (strTmp = list[idx].substring(name.length() + 1)) == null || strTmp.length() <= 0 || strTmp.indexOf(95) != -1) continue;
            boolean bValid = true;
            try {
                int n = new Integer(strTmp);
            }
            catch (NumberFormatException nfe) {
                bValid = false;
            }
            catch (Exception e) {
                bValid = false;
            }
            if (!bValid) continue;
            File oldFile = new File(path + separator + list[idx]);
            if (bSave) {
                File newFile = new File(path + separator + list[idx] + "_" + strTimeStamp);
                if (!oldFile.exists()) continue;
                oldFile.renameTo(newFile);
                continue;
            }
            if (!oldFile.isFile()) continue;
            oldFile.delete();
        }
    }

    private static String getTimeStamp() {
        String strTimeStamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        strTimeStamp = sdf.format(new Date());
        return strTimeStamp;
    }

    private void modifyFilePerm(String fileName, String filePerm) {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        if (fileName == null || fileName.length() == 0 || filePerm == null) {
            return;
        }
        String cmdToRun = "/usr/bin/chmod " + filePerm + " " + fileName;
        StringBuilder errMsg = new StringBuilder();
        boolean toReportPermFailure = false;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmdToRun);
            int ret = proc.waitFor();
            if (proc.exitValue() != 0) {
                toReportPermFailure = true;
                String s = null;
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    errMsg.append(s);
                }
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((s = stdErr.readLine()) != null) {
                    errMsg.append(s);
                }
            }
        }
        catch (IOException e) {
            toReportPermFailure = true;
            errMsg.append(e.getMessage());
        }
        catch (InterruptedException e) {
            toReportPermFailure = true;
            errMsg.append(e.getMessage());
        }
        if (toReportPermFailure) {
            this.print("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" + LSEP + "Trace(ERROR): Failure in setting the permissions for this file." + LSEP + errMsg.toString() + LSEP + "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            return;
        }
    }

    static {
        i = 0;
        LSEP = System.getProperty("line.separator");
        msgBndl = MessageBundle.getMessageBundle(PrCrMsgID.facility);
        msgBndl.setPackage("oracle.cluster.resources");
    }
}

