/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.impl.winsecurity.WinSecurityCommand;
import oracle.cluster.impl.winsecurity.WinSecurityNative;
import oracle.cluster.impl.winsecurity.WinSecuritySystem;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.winsecurity.ServiceUserTypes;
import oracle.cluster.winsecurity.WinSecurityUtil;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WinSecurityUtilImpl
implements WinSecurityUtil {
    private Version m_version;
    private SecureUtil m_secureUtil;
    private String m_srcloc;

    public WinSecurityUtilImpl(Version version, String srcLoc) {
        this.m_version = version;
        this.m_secureUtil = new SecureUtil();
        this.m_srcloc = srcLoc;
    }

    @Override
    public boolean isUserTypeSupported(ServiceUserTypes userType) throws WindowsSecurityException {
        Trace.out("checking if type supported for type:" + (Object)((Object)userType));
        NativeResult result = new NativeResult();
        WinSecuritySystem winSecuritySystem = new WinSecuritySystem();
        boolean isUserTypeSupported = false;
        if (userType == ServiceUserTypes.GMSA) {
            Trace.out("checking if win8 or above");
            winSecuritySystem.checkWin8OrAbove(result);
        } else if (userType == ServiceUserTypes.VIRTUALACCOUNT || userType == ServiceUserTypes.MSA) {
            Trace.out("checking if win7 or above");
            winSecuritySystem.checkWin7OrAbove(result);
        } else {
            Trace.out("fall back for all other users types");
            return true;
        }
        if (!result.getStatus()) {
            Exception e = result.getException();
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_USER_TYPE_SUPPORTED_FAILED, (Throwable)e, new Object[0]);
        }
        isUserTypeSupported = result.getBooleanResult();
        Trace.out((Object)((Object)userType) + " type supported status:" + isUserTypeSupported);
        return isUserTypeSupported;
    }

    @Override
    public boolean isDomainController() throws WindowsSecurityException {
        try {
            Map<String, Boolean> isDomainControllerMap = this.doInternalIsDomainController(null, null);
            return isDomainControllerMap.get(null);
        }
        catch (CompositeOperationException e) {
            throw new WindowsSecurityException(e);
        }
    }

    @Override
    public Map<String, Boolean> isDomainController(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        if (!this.m_secureUtil.isRemoteNodeNamesValid(nodeNames)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_REMOTE_NODENAMES, new Object[0]);
        }
        if (!this.m_secureUtil.isLocalNodeNameValid(localNodeName)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_LOCAL_NODENAME, new Object[0]);
        }
        return this.doInternalIsDomainController(localNodeName, nodeNames);
    }

    private Map<String, Boolean> doInternalIsDomainController(String localNodeName, String[] nodeNames) throws WindowsSecurityException, CompositeOperationException {
        HashMap<String, Boolean> nodeDCMap = new HashMap<String, Boolean>();
        boolean isLocalOperation = this.m_secureUtil.isLocalOperation(localNodeName, nodeNames);
        if (isLocalOperation) {
            Trace.out("local node operation");
            NativeResult result = new NativeResult();
            boolean isDomainController = false;
            WinSecurityNative.checkDomainController(result);
            if (!result.getStatus()) {
                Exception e = result.getException();
                Trace.out("native operation failed with " + e.getMessage());
                if (localNodeName == null) {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_DOMAIN_CONTROLLER_FAILED, (Throwable)e, new Object[0]);
                }
                throw new WindowsSecurityException((MessageKey)PrCzMsgID.IS_DOMAIN_CONTROLLER_FAILED_NODE, (Throwable)e, localNodeName);
            }
            isDomainController = result.getBooleanResult();
            Trace.out(" is domain controller = " + isDomainController);
            nodeDCMap.put(localNodeName, isDomainController);
            return nodeDCMap;
        }
        String[] execNodeArr = this.m_secureUtil.createExecutionNodeList(localNodeName, nodeNames);
        Trace.out("remote nodes are involved" + execNodeArr.length);
        Command[] utilCmdArr = new WinSecurityCommand[execNodeArr.length];
        String[] args = null;
        for (int i = 0; i < execNodeArr.length; ++i) {
            utilCmdArr[i] = !execNodeArr[i].equalsIgnoreCase(localNodeName) ? new WinSecurityCommand(WinSecurityCommand.CommandType.isDomainController, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i])) : new WinSecurityCommand(WinSecurityCommand.CommandType.isDomainController, execNodeArr[i], args, this.m_srcloc, this.m_secureUtil.getDestLocation(execNodeArr[i]), true);
        }
        Trace.out("executing the isdomain controller commands");
        try {
            Trace.out("creating parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(utilCmdArr, this.m_version);
            threadExec.submit();
        }
        catch (ConcurrencyException e) {
            throw new WindowsSecurityException(e);
        }
        Trace.out("after execution of commands");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>();
        for (int i = 0; i < execNodeArr.length; ++i) {
            CommandResult nr = utilCmdArr[i].getCommandResult();
            resultMap.put(execNodeArr[i], nr);
            if (nr.getStatus()) {
                boolean nodeStatus = nr.getBooleanResult();
                Trace.out("the node DC status is: " + nodeStatus);
                nodeDCMap.put(execNodeArr[i], nodeStatus);
                continue;
            }
            failedNodes.add(execNodeArr[i]);
        }
        if (failedNodes.size() > 0) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.IS_DOMAIN_CONTROLLER_FAILED_NODE, resultMap, Utils.strListToList(failedNodes));
        }
        return nodeDCMap;
    }
}

