/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import oracle.cluster.impl.winsecurity.WinSecuritySystem;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class WinSecurityCommand
extends Command {
    private String m_srcloc;
    private String m_destloc;
    private CommandType m_command;
    private String[] m_args = null;
    private WinSecuritySystem m_winSecuritySystem;
    private boolean m_isLocalExecution;

    public WinSecurityCommand(CommandType command, String node, String[] args, String srcLoc, String destLoc) throws WindowsSecurityException {
        this(command, node, args, srcLoc, destLoc, false);
    }

    public WinSecurityCommand(CommandType command, String node, String[] args, String srcLoc, String destLoc, boolean isLocalExecution) throws WindowsSecurityException {
        this.m_command = command;
        this.m_node = node;
        this.m_srcloc = srcLoc;
        this.m_destloc = destLoc;
        this.m_args = args;
        this.commandResult = new CommandResult();
        this.m_winSecuritySystem = new WinSecuritySystem();
        this.m_isLocalExecution = isLocalExecution;
    }

    @Override
    public boolean execute() {
        switch (this.m_command) {
            case isAdministrator: {
                this.m_winSecuritySystem.checkAdministrator(this.m_args[0], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after execute cmd srvmIsAdmin status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case isUserExist: {
                this.m_winSecuritySystem.checkUserExist(this.m_args[0], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after execute cmd srvmIisUserExist status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case setServiceUser: {
                this.m_winSecuritySystem.setServiceUserForHome(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native set service user method for node " + this.m_node);
                break;
            }
            case getServiceUserForOhome: {
                this.m_winSecuritySystem.getServiceUserForOhome(this.m_node, this.commandResult);
                Trace.out("after calling native get service user method for node " + this.m_node);
                break;
            }
            case getServiceUserFromPath: {
                this.m_winSecuritySystem.getServiceUserFromOhomePath(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native get service user from path method for node " + this.m_node);
                break;
            }
            case isUserLSA: {
                this.m_winSecuritySystem.checkServiceUserLocalSystem(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to check if service user is LSA for node " + this.m_node);
                break;
            }
            case isSvcUsrPasswordRequired: {
                this.m_winSecuritySystem.checkServiceUserPasswordRequired(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to check if service user requires password for node " + this.m_node);
                break;
            }
            case setHomeType: {
                this.m_winSecuritySystem.setOracleHomeType(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to set home type for node " + this.m_node);
                break;
            }
            case getHomeType: {
                this.m_winSecuritySystem.getOracleHomeType(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to get home type for node " + this.m_node);
                break;
            }
            case checkUserPrivilege: {
                this.m_winSecuritySystem.checkUserPrivilege(this.m_args[0], this.m_args[1], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after executing check user priv cmd status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case grantPrivilegeToUser: {
                this.m_winSecuritySystem.grantPrivilegeToUser(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to grant privilege to user on node " + this.m_node);
                break;
            }
            case revokePrivilegeFromUser: {
                this.m_winSecuritySystem.revokePrivilegeFromUser(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to revoke user privilege on node " + this.m_node);
                break;
            }
            case setAclForUser: {
                this.m_winSecuritySystem.setAclForUser(this.m_args[0], this.m_args[1], this.m_args[2], this.m_args[3], this.m_args[4], this.m_node, this.m_args[5], this.m_args[6], this.m_args[7], this.m_args[8], this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after executing set user access for user cmd status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case revokeAclForUser: {
                this.m_winSecuritySystem.revokeAclForUser(this.m_args[0], this.m_args[1], this.m_args[2], this.m_args[3], this.m_args[4], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after executing revoke user access cmd status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case checkAclForUser: {
                this.m_winSecuritySystem.checkAclForUser(this.m_args[0], this.m_args[1], this.m_args[2], this.m_args[3], this.m_args[4], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after execute check user access cmd status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case addAclForUser: {
                this.m_winSecuritySystem.addAclForUser(this.m_args[0], this.m_args[1], this.m_args[2], this.m_args[3], this.m_args[4], this.m_node, this.m_args[5], this.m_args[6], this.m_args[7], this.m_args[8], this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out(" after executing add user access for user cmd status = " + this.commandResult.getStatus() + "on node " + this.m_node);
                break;
            }
            case updateService: {
                this.m_winSecuritySystem.updateService(this.m_args[0], this.m_args[1], this.m_args[2], this.m_node, this.commandResult);
                Trace.out("after calling native method to update service node " + this.m_node);
                break;
            }
            case createService: {
                String[] dependencies = this.m_args[8].split(this.m_args[9]);
                this.m_winSecuritySystem.createService(this.m_args[0], this.m_args[1], this.m_args[2], this.m_args[3], this.m_args[4], this.m_args[5], this.m_args[6], this.m_args[7], dependencies, this.m_args[10], this.m_args[11], this.m_node, this.commandResult);
                Trace.out("after calling native method to update service node " + this.m_node);
                break;
            }
            case deleteService: {
                this.m_winSecuritySystem.deleteService(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to delete service node " + this.m_node);
                break;
            }
            case isServiceLSA: {
                this.m_winSecuritySystem.checkServiceRunningAsLocalSystem(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to check if service is running as LSA on node " + this.m_node);
                break;
            }
            case getServiceUser: {
                this.m_winSecuritySystem.getServiceUser(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to get service user on node " + this.m_node);
                break;
            }
            case getAllServicesForHome: {
                this.m_winSecuritySystem.getAllServicesForHome(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to get all services for user on node " + this.m_node);
                break;
            }
            case updateAllHomeServicesPasswd: {
                this.m_winSecuritySystem.updateAllHomeServicesPasswd(this.m_args[0], this.m_args[1], this.m_args[2], this.m_node, this.commandResult);
                Trace.out("after calling native method to update all services on node " + this.m_node);
                break;
            }
            case getAllServicesUser: {
                this.m_winSecuritySystem.getAllServicesUser(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to get all services for user on node " + this.m_node);
                break;
            }
            case updateAllUserServicesPasswd: {
                this.m_winSecuritySystem.updateAllUserServicesPasswd(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to update all services on node " + this.m_node);
                break;
            }
            case createOSGroup: {
                this.m_winSecuritySystem.createOSGroup(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to create group on node " + this.m_node);
                break;
            }
            case deleteOSGroup: {
                this.m_winSecuritySystem.deleteOSGroup(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to delete group on node " + this.m_node);
                break;
            }
            case isOSGroupExists: {
                this.m_winSecuritySystem.checkOSGroupExists(this.m_args[0], this.m_node, this.commandResult);
                Trace.out("after calling native method to check if group exists on node " + this.m_node);
                break;
            }
            case addMemberToOSGroup: {
                this.m_winSecuritySystem.addMemberToOSGroup(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to add a member to group on node " + this.m_node);
                break;
            }
            case removeMemberFromOSGroup: {
                this.m_winSecuritySystem.removeMemberFromOSGroup(this.m_args[0], this.m_args[1], this.m_node, this.commandResult);
                Trace.out("after calling native method to remove a member from group on node " + this.m_node);
                break;
            }
            case isMemberOfOSGroup: {
                this.m_winSecuritySystem.checkMemberOfOSGroup(this.m_args[0], this.m_args[1], this.m_args[2], this.m_node, this.commandResult);
                Trace.out("after calling native method to check if user is a member of the group on node " + this.m_node);
                break;
            }
            case isUserGroupMSA: {
                this.m_winSecuritySystem.checkIsUserGroupMSA(this.m_args[0], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out("after execute native method to check if user is GMSA. status = " + this.commandResult.getStatus() + " on node " + this.m_node);
                break;
            }
            case isHomeServiceUserGMSA: {
                this.m_winSecuritySystem.checkHomeServiceUserGMSA(this.m_args[0], this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out("after calling native method to check if service user is  GMSA user on node " + this.m_node);
                break;
            }
            case isDomainController: {
                this.m_winSecuritySystem.checkDomainController(this.m_node, this.m_srcloc, this.m_destloc, this.m_isLocalExecution, this.commandResult);
                Trace.out("after calling native method to check if " + this.m_node + " is a domain controller");
                break;
            }
            default: {
                Trace.out("invalid command" + (Object)((Object)this.m_command));
                return false;
            }
        }
        return this.commandResult.getStatus();
    }

    static enum CommandType {
        isAdministrator("srvmIsAdmin"),
        isUserExist("srvmIsUserExist"),
        setServiceUser("srvmSetServiceUser"),
        getServiceUserForOhome("srvmGetSVCUserForHome"),
        getServiceUserFromPath("srvmGetSVCUserFromPath"),
        isUserLSA("srvmIsUserLSA"),
        isSvcUsrPasswordRequired("srvmIsSvcUsrPasswordRequired"),
        setHomeType("srvmSetHomeType"),
        getHomeType("srvmGetHomeType"),
        checkUserPrivilege("srvmCheckUserPriv"),
        grantPrivilegeToUser("srvmGrantPrivToUser"),
        revokePrivilegeFromUser("srvmRevokePrivFromUser"),
        setAclForUser("srvmSetAclForUser"),
        revokeAclForUser("srvmRevokeAclForUser"),
        checkAclForUser("srvmCheckAclForUser"),
        addAclForUser("srvmAddAclForUser"),
        updateService("srvmUpdateService"),
        createService("srvmCreateService"),
        deleteService("srvmDeleteService"),
        isServiceLSA("srvmIsServiceLSA"),
        getServiceUser("srvmGetServiceUser"),
        getAllServicesForHome("srvmGetAllServicesForHome"),
        updateAllHomeServicesPasswd("srvmUpdateAllHomeServicesPasswd"),
        getAllServicesUser("srvmGetAllServicesUser"),
        updateAllUserServicesPasswd("srvmUpdateAllUserServicesPasswd"),
        createOSGroup("srvmCreateOSGroup"),
        deleteOSGroup("srvmDeleteOSGroup"),
        isOSGroupExists("srvmIsOSGroupExists"),
        addMemberToOSGroup("srvmAddMemberToOSGroup"),
        removeMemberFromOSGroup("srvmRemoveMemberFromOSGroup"),
        isMemberOfOSGroup("srvmIsMemberOfOSGroup"),
        isUserGroupMSA("srvmIsUserGroupMSA"),
        isHomeServiceUserGMSA("srvmIsHomeServiceUserGMSA"),
        isDomainController("srvmIsDomainController");

        private String m_value;

        private CommandType(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

