/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.winsecurity;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import oracle.cluster.impl.winsecurity.WinSecuritySystem;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.WindowsSystem;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class SecureUtil {
    WindowsSystem m_winSys = (WindowsSystem)new SystemFactory().CreateSystem();
    private final int WINDOWS_MAX_PATH = 260;
    private final int WINDOWS_MAX_GROUP_LENGTH = 256;
    private String m_destLoc = null;
    private static final String INVENTORY_REG_KEY = "HKEY_LOCAL_MACHINE" + File.separator + "SOFTWARE" + File.separator + "ORACLE";
    private static final String VALUE_INVENTORY_REG_KEY = "inst_loc";

    boolean isDomainUserFormat(String username) {
        if (username == null || username.length() <= 0) {
            Trace.out("null user name");
            return false;
        }
        int slashPos = username.indexOf("\\");
        if (slashPos != -1 && slashPos != username.length() - 1) {
            Trace.out(username + " is in domain user format");
            return true;
        }
        Trace.out(username + " is not in domain user format");
        return false;
    }

    boolean isLocalNodeNameValid(String nodename) {
        if (nodename != null && nodename.length() > 0) {
            Trace.out(nodename + " is valid node name");
            return true;
        }
        Trace.out(" invalid node name");
        return false;
    }

    boolean isRemoteNodeNamesValid(String[] remotenodenames) throws CompositeOperationException {
        if (remotenodenames == null) {
            Trace.out("invalid remote node name array");
            return false;
        }
        int count = 0;
        HashMap<Object, Exception> errorMap = new HashMap<Object, Exception>();
        boolean except = false;
        for (String node : remotenodenames) {
            if (node != null && node.length() > 0) {
                ++count;
                continue;
            }
            except = true;
            WindowsSecurityException wse = new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_ELEMENT_REMOTE_NODENAMES, count);
            errorMap.put(new Integer(count), wse);
        }
        if (except) {
            throw new CompositeOperationException(errorMap, PrCzMsgID.INVALID_REMOTE_NODENAMES_ARRAY, new Object[0]);
        }
        return true;
    }

    boolean isLocalOperation(String localNodeName, String[] remoteNodeNames) {
        if (localNodeName == null) {
            return true;
        }
        if (remoteNodeNames.length == 0) {
            return true;
        }
        if (remoteNodeNames.length > 1) {
            return false;
        }
        return remoteNodeNames[0].equalsIgnoreCase(localNodeName);
    }

    String[] createExecutionNodeList(String localNode, String[] remoteNodes) {
        String[] execNodeArr = new String[remoteNodes.length + 1];
        int execArrIndex = 0;
        for (String node : remoteNodes) {
            if (node.equalsIgnoreCase(localNode)) {
                return remoteNodes;
            }
            execNodeArr[execArrIndex++] = node;
        }
        execNodeArr[execArrIndex] = localNode;
        return execNodeArr;
    }

    public String getDestLocation(String node) throws WindowsSecurityException {
        if (this.m_destLoc != null) {
            return this.m_destLoc;
        }
        try {
            return this.m_winSys.getDestLoc(node);
        }
        catch (ClusterException e) {
            throw new WindowsSecurityException(e);
        }
    }

    public void setDestLoc(String destLoc) {
        this.m_destLoc = destLoc;
    }

    public boolean isHomePathValid(String homePath) {
        if (homePath == null || homePath.length() <= 0) {
            Trace.out("null path specified");
            return false;
        }
        int len = homePath.length();
        return len <= 260;
    }

    public boolean assertOracleHomeKey(String oracleHomeKey) throws WindowsSecurityException {
        if (oracleHomeKey == null || oracleHomeKey.length() <= 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "oracleHomeKey", oracleHomeKey);
        }
        return true;
    }

    public void assertCredentials(Credentials credentials) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
    }

    public void assertMember(String member) throws WindowsSecurityException {
        if (member == null || member.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "member");
        }
    }

    public void assertGroup(String groupName) throws WindowsSecurityException {
        if (groupName == null || groupName.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "group");
        }
        if (groupName.length() > 256) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_GROUP_NAME, groupName);
        }
    }

    public void assertGroupDesc(String groupName, String groupDesc) throws WindowsSecurityException {
        if (groupDesc == null || groupDesc.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "groupDesc");
        }
        if (groupDesc.length() > 256) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_GROUP_NAME, groupDesc, groupName);
        }
    }

    public void assertPath(String path) throws WindowsSecurityException {
        if (path == null || path.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "path");
        }
    }

    public void assertNode(String nodeName, boolean isLocalNode) throws WindowsSecurityException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new WindowsSecurityException((MessageKey)((Object)(isLocalNode ? PrCzMsgID.INVALID_LOCAL_NODENAME : PrCiMsgID.NULL_NODE_NAME)), new Object[0]);
        }
    }

    public String getUsernameFromSid(String sid) throws WindowsSecurityException {
        WinSecuritySystem wsSystem = new WinSecuritySystem();
        NativeResult nr = new NativeResult();
        wsSystem.getUsernameFromSid(sid, nr);
        if (nr.getStatus()) {
            String username = nr.getStringResult();
            Trace.out("username = " + username);
            return username;
        }
        Exception e = nr.getException();
        if (e != null) {
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.CONVERT_SID_TO_USERNAME_FAILED, (Throwable)e, sid);
        }
        Trace.out("native operation failed");
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.CONVERT_SID_TO_USERNAME_FAILED, sid);
    }

    public String getVirtualAccountGroupName(String oracleHomeName) throws WindowsSecurityException {
        WinSecuritySystem wsSystem = new WinSecuritySystem();
        NativeResult nr = new NativeResult();
        wsSystem.getVirtualAccountGroupName(oracleHomeName, nr);
        if (nr.getStatus()) {
            String groupname = nr.getStringResult();
            Trace.out("group name  = " + groupname);
            return groupname;
        }
        Exception e = nr.getException();
        if (e != null) {
            Trace.out("native operation failed with " + e.getMessage());
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.CONVERT_SID_TO_USERNAME_FAILED, (Throwable)e, oracleHomeName);
        }
        Trace.out("native operation failed");
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.CONVERT_SID_TO_USERNAME_FAILED, oracleHomeName);
    }

    public String getInventory() {
        String pathInv = null;
        try {
            ClusterWindows cw = new ClusterWindows();
            String host = InetAddress.getLocalHost().getHostName();
            pathInv = cw.getRegStringDataOnNode(INVENTORY_REG_KEY, VALUE_INVENTORY_REG_KEY, host);
        }
        catch (ClusterException ee) {
            Trace.out("Error in fetching registry key for inst_loc " + ee.getMessage());
        }
        catch (UnknownHostException ee) {
            Trace.out("Error in fetching host name " + ee.getMessage());
        }
        return pathInv;
    }
}

