/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.whatif;

import java.util.regex.Pattern;
import oracle.cluster.impl.whatif.WhatIfActionImpl;
import oracle.cluster.whatif.WhatIfServerRelocateAction;
import oracle.ops.mgmt.trace.Trace;

public class WhatIfServerRelocateActionImpl
extends WhatIfActionImpl
implements WhatIfServerRelocateAction {
    private String m_srvrName;
    private String m_fromPool;
    private String m_toPool;

    public WhatIfServerRelocateActionImpl(String srvrName, String fromPool, String toPool) {
        Trace.out("Created Server Relocate Action with" + srvrName + "\t" + fromPool + "\t" + toPool);
        this.m_srvrName = srvrName;
        this.m_fromPool = this.getPoolName(fromPool);
        this.m_toPool = this.getPoolName(toPool);
    }

    @Override
    public String serverName() {
        return this.m_srvrName;
    }

    @Override
    public String fromPool() {
        return this.m_fromPool;
    }

    @Override
    public String toPool() {
        return this.m_toPool;
    }

    private String getPoolName(String spName) {
        String[] values = spName.split(Pattern.quote(String.valueOf('.')));
        if (values.length == 2 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.'))) {
            return values[1];
        }
        return spName;
    }
}

