/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.whatif;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.whatif.WhatIfEventImpl;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.whatif.WhatIfException;
import oracle.cluster.whatif.WhatIfResourceEvent;

public class WhatIfResourceEventImpl
extends WhatIfEventImpl
implements WhatIfResourceEvent {
    private SoftwareModule m_res;
    private WhatIfResourceEvent.WhatIfResourceOperation m_op;
    private String m_fromNode;

    public WhatIfResourceEventImpl() {
    }

    public WhatIfResourceEventImpl(SoftwareModule res, WhatIfResourceEvent.WhatIfResourceOperation op) throws NotExistsException, SoftwareModuleException, CRSAttributeNotFoundException, CRSException {
        super(res.getName(), ((CRSEntity)((Object)((SoftwareModuleImpl)res).crsResource())).getAttributes(new String[0]));
        this.m_res = res;
        this.m_op = op;
    }

    public WhatIfResourceEventImpl(SoftwareModule res, WhatIfResourceEvent.WhatIfResourceOperation op, String nodename, boolean force, SoftwareModule local_res) throws WhatIfException, NotExistsException, SoftwareModuleException, CRSAttributeNotFoundException, CRSException {
        super(res.getName(), local_res == null ? ((CRSEntity)((Object)((SoftwareModuleImpl)res).crsResource())).getAttributes(new String[0]) : ((CRSEntity)((Object)((SoftwareModuleImpl)local_res).crsResource())).getAttributes(new String[0]), nodename, force);
        this.m_res = res;
        this.m_op = op;
        if (op == WhatIfResourceEvent.WhatIfResourceOperation.Modify) {
            List<ResourceAttribute> attributes = ((CRSEntity)((Object)((SoftwareModuleImpl)res).crsResource())).getAttributes(new String[0]);
            List<ResourceAttribute> lattributes = ((CRSEntity)((Object)((SoftwareModuleImpl)local_res).crsResource())).getAttributes(new String[0]);
            ArrayList<ResourceAttribute> rattributes = new ArrayList<ResourceAttribute>();
            for (ResourceAttribute attr : lattributes) {
                if (attr.getValue() != null && attr.getValue().trim().length() != 0 && !attributes.contains(attr)) continue;
                rattributes.add(attr);
            }
            for (ResourceAttribute attr : rattributes) {
                lattributes.remove(attr);
            }
            super.setAttributeList(lattributes);
        }
    }

    @Override
    public SoftwareModule getResource() {
        return this.m_res;
    }

    @Override
    public Object getOperation() {
        return this.m_op;
    }

    public void setFromNode(String fromNode) throws WhatIfException {
        this.m_fromNode = fromNode;
        try {
            super.setFirstEntityName(((CRSResourceImpl)((SoftwareModuleImpl)this.m_res).crsResource()).relocateInstanceId(fromNode, super.getSecondEntityName()));
        }
        catch (NotRunningException e) {
            throw new WhatIfException(e);
        }
        catch (CRSException e) {
            throw new WhatIfException(e);
        }
        catch (NotExistsException e) {
            throw new WhatIfException(e);
        }
        catch (SoftwareModuleException e) {
            throw new WhatIfException(e);
        }
    }

    public void setResourceInstanceId(String nodeName) throws WhatIfException {
        try {
            super.setFirstEntityName(((CRSResourceImpl)((SoftwareModuleImpl)this.m_res).crsResource()).resourceInstanceIds(nodeName)[0]);
        }
        catch (NotRunningException e) {
            throw new WhatIfException(e);
        }
        catch (CRSException e) {
            throw new WhatIfException(e);
        }
        catch (NotExistsException e) {
            throw new WhatIfException(e);
        }
        catch (SoftwareModuleException e) {
            throw new WhatIfException(e);
        }
    }
}

