/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.whatif;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.whatif.WhatIfActionImpl;
import oracle.cluster.whatif.WhatIfResourceAction;
import oracle.ops.mgmt.trace.Trace;

public class WhatIfResourceActionImpl
extends WhatIfActionImpl
implements WhatIfResourceAction {
    private String m_resName;
    private String m_resId;
    private List<String> m_srvrList = new ArrayList<String>();
    private List<String> m_initSrvrList = new ArrayList<String>();
    private boolean m_ismandatory;
    private List<WhatIfResourceAction.ResourceFinalState> m_finalState = new ArrayList<WhatIfResourceAction.ResourceFinalState>();
    private List<WhatIfResourceAction.ResourceFinalState> m_initialState = new ArrayList<WhatIfResourceAction.ResourceFinalState>();
    private WhatIfResourceAction.ResourceTargetState m_targetState;
    private WhatIfResourceAction.ResourceTargetState m_initTargetState;
    private List<WhatIfResourceAction.ResourceFinalState> m_stateOnIServer = new ArrayList<WhatIfResourceAction.ResourceFinalState>();
    private WhatIfResourceAction.ResourceType m_resType;
    private String m_UDResName;

    public WhatIfResourceActionImpl(String resName, String resId, String srvr, boolean mand, String fstate, String tstate) {
        this.m_resName = resName;
        this.m_resId = resId;
        if (srvr != null && srvr.trim().length() > 0) {
            this.m_srvrList.add(srvr);
        }
        this.m_ismandatory = mand;
        this.m_targetState = WhatIfResourceAction.ResourceTargetState.getEnumMember(tstate);
        String[] temp = fstate.split(Pattern.quote("|"));
        for (int i = 0; i < temp.length; ++i) {
            this.m_finalState.add(WhatIfResourceAction.ResourceFinalState.getEnumMember(temp[i]));
        }
        this.setTypeAndUDName(resName);
    }

    public WhatIfResourceActionImpl(String resName, String resId, String srvr, String isrvr, boolean mand, String fstate, String tstate, String istate, String itstate, String stateOnInitialServer) {
        this(resName, resId, srvr, mand, fstate, tstate);
        if (isrvr != null && isrvr.trim().length() > 0) {
            this.m_initSrvrList.add(isrvr);
        }
        this.m_initTargetState = WhatIfResourceAction.ResourceTargetState.getEnumMember(itstate);
        String[] temp2 = istate.split(Pattern.quote("|"));
        for (int i = 0; i < temp2.length; ++i) {
            this.m_initialState.add(WhatIfResourceAction.ResourceFinalState.getEnumMember(temp2[i]));
        }
        String[] temp3 = stateOnInitialServer.split(Pattern.quote("|"));
        for (int i = 0; i < temp3.length; ++i) {
            try {
                this.m_stateOnIServer.add(WhatIfResourceAction.ResourceFinalState.getEnumMember(temp3[i]));
                continue;
            }
            catch (Exception UnusedArgument) {
                Trace.out("stateOnInitialServer not used in this case.");
            }
        }
    }

    @Override
    public String resourceName() {
        return this.m_resName;
    }

    @Override
    public String instanceId() {
        return this.m_resId;
    }

    @Override
    public List<String> serverName() {
        return this.m_srvrList;
    }

    @Override
    public List<String> initServerName() {
        return this.m_initSrvrList;
    }

    @Override
    public boolean isMandatory() {
        return this.m_ismandatory;
    }

    @Override
    public List<WhatIfResourceAction.ResourceFinalState> finalState() {
        return this.m_finalState;
    }

    @Override
    public List<WhatIfResourceAction.ResourceFinalState> initialState() {
        return this.m_initialState;
    }

    @Override
    public List<WhatIfResourceAction.ResourceFinalState> stateOnInitialServer() {
        return this.m_stateOnIServer;
    }

    @Override
    public WhatIfResourceAction.ResourceTargetState targetState() {
        return this.m_targetState;
    }

    public WhatIfResourceAction.ResourceType getResourceType() {
        return this.m_resType;
    }

    public String getUDResName() {
        return this.m_UDResName;
    }

    private void setTypeAndUDName(String resName) {
        String[] values = resName.split(Pattern.quote(String.valueOf('.')));
        if (values.length == 3 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ResourceLiterals.DB.toString().equalsIgnoreCase(values[2])) {
            this.m_resType = WhatIfResourceAction.ResourceType.DATABASE;
            this.m_UDResName = values[1];
            Trace.out("ResourceName =i " + resName + "\t+ResourceType = " + (Object)((Object)this.m_resType) + "\t UserDefinedResName" + this.m_UDResName);
            return;
        }
        if (values.length >= 4 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ResourceLiterals.SVC.toString().equalsIgnoreCase(values[values.length - 1])) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < values.length - 1; ++i) {
                if (sb.length() > 0) {
                    sb.append('.' + values[i]);
                    continue;
                }
                sb.append(values[i]);
            }
            this.m_resType = WhatIfResourceAction.ResourceType.SERVICE;
            this.m_UDResName = sb.toString();
            Trace.out("ResourceName =i " + resName + "\t+ResourceType = " + (Object)((Object)this.m_resType) + "\t UserDefinedResName" + this.m_UDResName);
            return;
        }
        if (values.length == 3 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ResourceLiterals.LSNR.toString().equalsIgnoreCase(values[2])) {
            this.m_resType = WhatIfResourceAction.ResourceType.LISTENER;
            this.m_UDResName = values[1];
            Trace.out("ResourceName =i " + resName + "\t+ResourceType = " + (Object)((Object)this.m_resType) + "\t UserDefinedResName" + this.m_UDResName);
            return;
        }
        if (values.length == 3 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ResourceLiterals.NETWORK.toString().equalsIgnoreCase(values[2])) {
            this.m_resType = WhatIfResourceAction.ResourceType.NETWORK;
            this.m_UDResName = values[1].substring(ResourceLiterals.NET.toString().length());
            Trace.out("ResourceName =i " + resName + "\t+ResourceType = " + (Object)((Object)this.m_resType) + "\t UserDefinedResName" + this.m_UDResName);
            return;
        }
        if (values.length == 3 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ".vip".toString().equalsIgnoreCase(String.valueOf('.') + values[2])) {
            this.m_resType = WhatIfResourceAction.ResourceType.VIP;
            this.m_UDResName = values[1];
            Trace.out("ResourceName =i " + resName + "\t+ResourceType = " + (Object)((Object)this.m_resType) + "\t UserDefinedResName" + this.m_UDResName);
            return;
        }
        this.m_resType = WhatIfResourceAction.ResourceType.OTHER;
        this.m_UDResName = resName;
    }

    public void addServer(String srvr) {
        if (!this.m_srvrList.contains(srvr)) {
            this.m_srvrList.add(srvr);
        }
    }

    public boolean isSameResourceAction(WhatIfResourceActionImpl resAction) {
        return this.m_resType == resAction.m_resType && this.m_resName.equals(resAction.m_resName) && this.m_targetState == resAction.m_targetState && this.m_finalState.get(0).equals((Object)resAction.m_finalState.get(0));
    }
}

