/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.whatif;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.Stat3;
import oracle.cluster.impl.crs.cops.WhatIf;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.whatif.WhatIfActivePolicyEventImpl;
import oracle.cluster.impl.whatif.WhatIfResourceEventImpl;
import oracle.cluster.impl.whatif.WhatIfResourceFailedEventImpl;
import oracle.cluster.impl.whatif.WhatIfResultImpl;
import oracle.cluster.impl.whatif.WhatIfServerEventImpl;
import oracle.cluster.impl.whatif.WhatIfServerPoolEventImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.whatif.WhatIfActivePolicyEvent;
import oracle.cluster.whatif.WhatIfEvent;
import oracle.cluster.whatif.WhatIfException;
import oracle.cluster.whatif.WhatIfResourceEvent;
import oracle.cluster.whatif.WhatIfResourceFailedEvent;
import oracle.cluster.whatif.WhatIfResult;
import oracle.cluster.whatif.WhatIfServerEvent;
import oracle.cluster.whatif.WhatIfServerPoolEvent;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WhatIfFactoryImpl {
    private static WhatIfFactoryImpl s_instance;

    public static WhatIfFactoryImpl getInstance() throws WhatIfException {
        if (null == s_instance) {
            s_instance = new WhatIfFactoryImpl();
        }
        return s_instance;
    }

    public WhatIfResult evaluate(WhatIfEvent event) throws WhatIfException, NotExistsException {
        WhatIfResultImpl Result = new WhatIfResultImpl();
        Stat3 stat3 = new Stat3();
        WhatIf.Operation op = WhatIf.Operation.RES_ADD;
        if (event instanceof WhatIfResourceEvent) {
            switch ((WhatIfResourceEvent.WhatIfResourceOperation)((Object)event.getOperation())) {
                case Add: {
                    op = WhatIf.Operation.RES_ADD;
                    break;
                }
                case Modify: {
                    op = WhatIf.Operation.RES_MOD;
                    break;
                }
                case Start: {
                    op = WhatIf.Operation.RES_START;
                    break;
                }
                case Stop: {
                    op = WhatIf.Operation.RES_STOP;
                    break;
                }
                case Relocate: {
                    op = WhatIf.Operation.RES_RELOCATE;
                }
            }
        }
        if (event instanceof WhatIfServerPoolEvent) {
            switch ((WhatIfServerPoolEvent.WhatIfServerPoolOperation)((Object)event.getOperation())) {
                case Add: {
                    op = WhatIf.Operation.SRVPOOL_ADD;
                    break;
                }
                case Modify: {
                    op = WhatIf.Operation.SRVPOOL_MOD;
                    Trace.out("Operation is ServerPool Modify");
                    break;
                }
                case Remove: {
                    op = WhatIf.Operation.SRVPOOL_REMOVE;
                }
            }
        }
        if (event instanceof WhatIfServerEvent) {
            switch ((WhatIfServerEvent.WhatIfServerOperation)((Object)event.getOperation())) {
                case Add: {
                    op = WhatIf.Operation.SRVR_ADD;
                    break;
                }
                case Relocate: {
                    op = WhatIf.Operation.SRVR_RELOCATE;
                    break;
                }
                case Remove: {
                    op = WhatIf.Operation.SRVR_REMOVE;
                }
            }
        }
        if (event instanceof WhatIfResourceFailedEvent) {
            op = WhatIf.Operation.RES_FAIL;
        }
        if (event instanceof WhatIfActivePolicyEvent) {
            op = WhatIf.Operation.ACTPOLICY_SET;
        }
        List<ResourceAttribute> attributes = event.getAttributeList();
        ArrayList<ResourceAttribute> rattributes = new ArrayList<ResourceAttribute>();
        if (op == WhatIf.Operation.SRVPOOL_MOD || op == WhatIf.Operation.RES_MOD) {
            boolean isName = false;
            for (ResourceAttribute attr : attributes) {
                if (!attr.getName().equals("NAME") && !attr.getName().equals("STOP_DEPENDENCIES") && !attr.getName().equals("START_DEPENDENCIES")) continue;
                rattributes.add(attr);
            }
            for (ResourceAttribute attr : rattributes) {
                attributes.remove(attr);
            }
        }
        WhatIf whatif = new WhatIf(event.getFirstEntityName(), op, event.getSecondEntityName(), true, attributes, Result, event.getOverAttributeList());
        try {
            CRSNative.performWhatIf(whatif, stat3);
        }
        catch (CRSException e) {
            StringBuilder args = new StringBuilder();
            args.append(event.getFirstEntityName());
            if (event.getSecondEntityName() != null) {
                args.append(", " + event.getSecondEntityName());
            }
            throw new WhatIfException((MessageKey)PrCrMsgID.WHATIF_FAILED, (Throwable)e, args.toString());
        }
        Result.validate();
        return Result;
    }

    public WhatIfResourceEvent resourceEvent(SoftwareModule resource, WhatIfResourceEvent.WhatIfResourceOperation op) throws WhatIfException {
        return this.resourceEvent(resource, op, null, false, null);
    }

    public WhatIfResourceEvent resourceEvent(SoftwareModule resource, WhatIfResourceEvent.WhatIfResourceOperation op, String nodename, boolean force, SoftwareModule local_res) throws WhatIfException {
        WhatIfResourceEventImpl resevent;
        try {
            resevent = new WhatIfResourceEventImpl(resource, op, nodename, force, local_res);
        }
        catch (NotExistsException e) {
            throw new WhatIfException(e);
        }
        catch (CRSAttributeNotFoundException e) {
            throw new WhatIfException(e);
        }
        catch (CRSException e) {
            throw new WhatIfException(e);
        }
        catch (SoftwareModuleException e) {
            throw new WhatIfException(e);
        }
        return resevent;
    }

    public WhatIfServerEvent serverEvent(Server server, WhatIfServerEvent.WhatIfServerOperation op) throws WhatIfException {
        WhatIfServerEventImpl serverEvent = new WhatIfServerEventImpl(server, op);
        return serverEvent;
    }

    public WhatIfServerEvent serverEvent(Server server, WhatIfServerEvent.WhatIfServerOperation op, String poolname) throws WhatIfException {
        WhatIfServerEventImpl serverEvent = new WhatIfServerEventImpl(server, op, poolname);
        return serverEvent;
    }

    public WhatIfServerPoolEvent serverPoolEvent(ServerPool pool, WhatIfServerPoolEvent.WhatIfServerPoolOperation op) throws WhatIfException {
        return this.serverPoolEvent(pool, op, false, null);
    }

    public WhatIfServerPoolEvent serverPoolEvent(ServerPool pool, WhatIfServerPoolEvent.WhatIfServerPoolOperation op, boolean isForced, ServerPool local_sp) throws WhatIfException {
        WhatIfServerPoolEventImpl spevent;
        try {
            spevent = new WhatIfServerPoolEventImpl(pool, op, isForced, local_sp);
        }
        catch (NotExistsException e) {
            throw new WhatIfException(e);
        }
        catch (CRSAttributeNotFoundException e) {
            throw new WhatIfException(e);
        }
        catch (CRSException e) {
            throw new WhatIfException(e);
        }
        catch (SoftwareModuleException e) {
            throw new WhatIfException(e);
        }
        catch (ServerGroupException e) {
            throw new WhatIfException(e);
        }
        return spevent;
    }

    public WhatIfActivePolicyEvent activePolicyEvent(String policyName, WhatIfActivePolicyEvent.WhatIfServerOperation op) throws WhatIfException {
        return this.activePolicyEvent(policyName, op, false);
    }

    public WhatIfActivePolicyEvent activePolicyEvent(String policyName, WhatIfActivePolicyEvent.WhatIfServerOperation op, boolean forceFlag) throws WhatIfException {
        return new WhatIfActivePolicyEventImpl(policyName, op, forceFlag);
    }

    public WhatIfResourceFailedEvent resourceFailedEvent(SoftwareModule resource, WhatIfResourceFailedEvent.WhatIfResourceFailedReason op) throws WhatIfException {
        return this.resourceFailedEvent(resource, op, null);
    }

    public WhatIfResourceFailedEvent resourceFailedEvent(SoftwareModule resource, WhatIfResourceFailedEvent.WhatIfResourceFailedReason op, String serverName) throws WhatIfException {
        if (serverName != null) {
            serverName = Utils.convertToCSSNodeName(serverName);
        }
        WhatIfResourceFailedEventImpl res_fail_event = new WhatIfResourceFailedEventImpl(resource, op, serverName, Arrays.asList(new ResourceAttribute(ResourceType.ClusterResource.RESTART_ATTEMPTS.name(), "0")));
        return res_fail_event;
    }
}

