/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.whatif;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.Service;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.whatif.WhatIfActionImpl;
import oracle.cluster.impl.whatif.WhatIfResourceActionImpl;
import oracle.cluster.impl.whatif.WhatIfServerRelocateActionImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.whatif.WhatIfAction;
import oracle.cluster.whatif.WhatIfActionPlan;
import oracle.cluster.whatif.WhatIfException;
import oracle.cluster.whatif.WhatIfResourceAction;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WhatIfActionPlanImpl
implements WhatIfActionPlan {
    private ArrayList<WhatIfAction> m_actionlist = new ArrayList();
    private static final String fServer = "FINAL_SERVER";
    private static final String fState = "FINAL_STATE";
    private static final String fTarget = "FINAL_TARGET";
    private static final String grpNumber = "GROUP_NUMBER";
    private static final String iServer = "INITIAL_SERVER";
    private static final String iState = "INITIAL_STATE";
    private static final String iTarget = "INITIAL_TARGET";
    private static final String stateOnIServer = "STATE_ON_INITIAL_SERVER";
    private static final String instID = "INSTANCE_ID";
    private static final String resName = "RESOURCE_NAME";
    private static final String isMand = "IS_MANDATORY";
    private static final String srvrName = "SERVER_NAME";
    private static final String fromPool = "FROM_POOLS";
    private static final String toPool = "TO_POOLS";
    private Map<String, HashMap<String, String>> resLastServers = new HashMap<String, HashMap<String, String>>();

    public WhatIfActionPlanImpl() {
    }

    public WhatIfActionPlanImpl(ArrayList<WhatIfAction> alist) {
        this.m_actionlist = alist;
    }

    public ArrayList<WhatIfAction> actions() {
        return this.m_actionlist;
    }

    public void addAction() {
        WhatIfActionImpl action = new WhatIfActionImpl();
        this.m_actionlist.add(action);
    }

    public void addParametertoAction(int i, String name, String value) {
        ((WhatIfActionImpl)this.m_actionlist.get(i)).addParam(name, value);
    }

    public void setActionTypetoAction(int i, int actiontype) {
        ((WhatIfActionImpl)this.m_actionlist.get(i)).setActionType(actiontype);
    }

    @Override
    public Map<Database, List<Node>> databases2BeStopped(boolean completely) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Map<Service, List<Node>> services2BeStopped(boolean noRunningInstances) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Map<String, List<Node>> userDefinedResources2BeStopped() {
        throw new RuntimeException("not implemented yet");
    }

    public void validate() throws WhatIfException {
        ArrayList<WhatIfResourceActionImpl> resActionList = new ArrayList<WhatIfResourceActionImpl>();
        ArrayList<WhatIfServerRelocateActionImpl> srvActionList = new ArrayList<WhatIfServerRelocateActionImpl>();
        for (WhatIfAction actn : this.m_actionlist) {
            WhatIfActionImpl action = (WhatIfActionImpl)actn;
            switch (action.getActionType()) {
                case ERR_CASE: {
                    Trace.out("message = " + action.getErrorMessage());
                    throw new WhatIfException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, action.getErrorMessage());
                }
                case RES_STATE: {
                    WhatIfResourceActionImpl resAction = new WhatIfResourceActionImpl(action.getParamValue(resName), action.getParamValue(instID), action.getParamValue(fServer), action.getParamValue(iServer), action.getParamValue(isMand).equals("TRUE"), action.getParamValue(fState), action.getParamValue(fTarget), action.getParamValue(iState), action.getParamValue(iTarget), action.getParamValue(stateOnIServer));
                    boolean flag = false;
                    String finalserver = action.getParamValue(fServer);
                    try {
                        String resName = resAction.resourceName();
                        String string = resAction.instanceId();
                        String UDresName = resAction.getUDResName();
                        WhatIfResourceAction.ResourceType type = resAction.getResourceType();
                        List<String> srvrName = resAction.serverName();
                        List<WhatIfResourceAction.ResourceFinalState> fstateList = resAction.finalState();
                        if ((srvrName == null || srvrName.size() == 0) && fstateList.contains((Object)WhatIfResourceAction.ResourceFinalState.OFFLINE)) {
                            DatabaseFactory df = DatabaseFactory.getInstance();
                            switch (type) {
                                case DATABASE: {
                                    Database db = df.getDatabase(UDresName);
                                    if (!this.resLastServers.containsKey(resName)) {
                                        HashMap<String, String> tmap = ((CRSResourceImpl)db.crsResource()).fetchLastServers();
                                        this.resLastServers.put(resName, tmap);
                                        Trace.out("Adding LastServer  map for resource " + resName + " map length" + tmap.size());
                                    }
                                    HashMap<String, String> lastServers = this.resLastServers.get(resName);
                                    Trace.out("Got the lastServersMap for resource " + resName + " looking for instance " + string);
                                    finalserver = lastServers.get(string);
                                    if (finalserver == null) break;
                                    Trace.out("lastServer for instance " + string + " is " + finalserver);
                                    resAction.addServer(finalserver);
                                    break;
                                }
                                case SERVICE: {
                                    String[] values = resName.split(Pattern.quote(String.valueOf('.')));
                                    Trace.out("Database Name for service " + UDresName + " is " + values[1]);
                                    Service svc = df.getService(values[1], UDresName);
                                    if (!this.resLastServers.containsKey(resName)) {
                                        HashMap<String, String> tmap = ((CRSResourceImpl)svc.crsResource()).fetchLastServers();
                                        this.resLastServers.put(resName, tmap);
                                        Trace.out("Adding LastServer map for resource " + resName + " map length" + tmap.size());
                                    }
                                    HashMap<String, String> lastServers1 = this.resLastServers.get(resName);
                                    Trace.out("Got the lastServers for resource " + resName + " looking for instance " + string);
                                    finalserver = lastServers1.get(string);
                                    if (finalserver == null) break;
                                    Trace.out("lastServer for instance " + string + " is " + finalserver);
                                    resAction.addServer(finalserver);
                                }
                            }
                        }
                    }
                    catch (SoftwareModuleException e) {
                        throw new WhatIfException(e);
                    }
                    catch (NotExistsException e) {
                        throw new WhatIfException(e);
                    }
                    catch (CRSException e) {
                        throw new WhatIfException(e);
                    }
                    for (WhatIfResourceAction whatIfResourceAction : resActionList) {
                        if (!((WhatIfResourceActionImpl)whatIfResourceAction).isSameResourceAction(resAction)) continue;
                        flag = true;
                        if (finalserver == null || finalserver.trim().length() <= 0) break;
                        ((WhatIfResourceActionImpl)whatIfResourceAction).addServer(finalserver);
                        break;
                    }
                    if (flag) break;
                    resActionList.add(resAction);
                    break;
                }
                case SRV_MOVE: {
                    WhatIfServerRelocateActionImpl srvrAction = new WhatIfServerRelocateActionImpl(action.getParamValue(srvrName), action.getParamValue(fromPool), action.getParamValue(toPool));
                    srvActionList.add(srvrAction);
                    break;
                }
            }
        }
        this.m_actionlist.clear();
        this.m_actionlist.addAll(resActionList);
        this.m_actionlist.addAll(srvActionList);
    }

    public void addActionPlan(WhatIfActionPlan plan) throws WhatIfException {
        ArrayList<WhatIfAction> tempList = new ArrayList<WhatIfAction>();
        tempList.addAll(this.m_actionlist);
        for (WhatIfAction waction : plan.actions()) {
            if (waction instanceof WhatIfResourceAction) {
                boolean actionfound = false;
                for (WhatIfAction action : tempList) {
                    if (!(action instanceof WhatIfResourceAction) || !((WhatIfResourceActionImpl)waction).isSameResourceAction((WhatIfResourceActionImpl)action)) continue;
                    actionfound = true;
                    ((WhatIfResourceActionImpl)action).serverName().addAll(((WhatIfResourceActionImpl)action).serverName());
                    HashSet<String> hs = new HashSet<String>();
                    hs.addAll(((WhatIfResourceActionImpl)action).serverName());
                    ((WhatIfResourceActionImpl)action).serverName().clear();
                    ((WhatIfResourceActionImpl)action).serverName().addAll(hs);
                }
                if (actionfound) continue;
                this.m_actionlist.add(waction);
                continue;
            }
            this.m_actionlist.add(waction);
        }
    }
}

