/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.vm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.vm.VMDetailImpl;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCvMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerCategoryException;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyNotPresentException;
import oracle.cluster.util.AlreadyPresentException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotConfiguredException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.vm.VM;
import oracle.cluster.vm.VMArgs;
import oracle.cluster.vm.VMDetail;
import oracle.cluster.vm.VMException;
import oracle.cluster.vm.VMFactory;
import oracle.cluster.vm.VMWarningException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class VMImpl
extends SoftwareModuleImpl
implements VM {
    private ResourceAttribute m_nameAttr;
    private static final int VM_RESOURCE_SPLIT_LENGTH = 3;
    List<VMWarningException> m_vmWarningList;

    VMImpl(ResourceAttribute nameAttr) throws VMException, NotExistsException {
        this(nameAttr, false);
    }

    VMImpl(ResourceAttribute nameAttr, boolean bCreate) throws VMException, NotExistsException {
        try {
            this.m_vmWarningList = new ArrayList<VMWarningException>();
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.NAME.name())) {
                Trace.out(nameAttr.getName() + " resource Name for " + nameAttr.getValue() + "  was invalid");
                throw new VMException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.VirtualMachine.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.VM.toString().equalsIgnoreCase(values[2])) {
                Trace.out("Resource Name was invalid");
                throw new VMException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.VirtualMachine.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            Trace.out("VM resource " + this.m_displayName + " has been created");
            this.m_crsResource = (CRSResourceImpl)((Object)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr));
            try {
                int vmCount = this.getVM().length;
                ServerPool serverPool = null;
                try {
                    serverPool = this.getServerPool();
                    String sPool = "";
                    if (serverPool != null) {
                        sPool = serverPool.getName();
                    }
                    if (!sPool.isEmpty() && !sPool.equals("*") && sPool != null) {
                        this.validateServerPoolSize(sPool, vmCount);
                    }
                }
                catch (VMException e) {
                    Trace.out("String sPool was not found. Return here. It is infeasible.");
                    throw new VMException(e);
                }
                catch (NotExistsException e) {
                    Trace.out("The serverPool configured does not exist. Error");
                    throw new VMException(e);
                }
                catch (NotConfiguredException e) {
                    Trace.out("ServerPool was not configured so serverpool-related warning was not generated.");
                }
            }
            catch (VMException e) {
                Trace.out("VM Exception caught in warning check. Error.");
                throw new VMException(e);
            }
            catch (VMWarningException e) {
                Trace.out("VMWarning caught which means that warning list has been updated");
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught and will be displayed");
            throw new VMException(e);
        }
        catch (NotExistsException e) {
            if (bCreate) {
                Trace.out("Resource " + nameAttr.getValue() + " may not have been created yet");
            }
            Trace.out("Resource " + nameAttr.getValue() + " not created yet");
            throw new NotExistsException((MessageKey)PrCvMsgID.VM_RES_NOT_FOUND, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, VMException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            Trace.out("Resource lookup failed");
            throw new VMException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public List<VMWarningException> getWarnings() {
        return this.m_vmWarningList;
    }

    @Override
    public boolean isWarningExists() {
        return this.m_vmWarningList.size() > 0;
    }

    public void create(VMArgs args) throws VMException, AlreadyExistsException, VMWarningException {
        if (null == args) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        String m_VMName = args.getName();
        List<String> m_VMList = args.getVM();
        int m_stopTimeout = args.getStopTimeout();
        int m_checkInterval = args.getCheckInterval();
        String m_serverPool = args.getServerPool();
        String m_serverCategory = args.getServerCategory();
        List<String> m_nodes = args.getNodes();
        if (m_VMList == null) {
            throw new VMException((MessageKey)PrCvMsgID.VM_LIST_REQUIRED, m_VMName);
        }
        if (m_VMList.contains("")) {
            Trace.out("Error: VM list provided contains an empty invalid value");
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        if (m_stopTimeout <= 0 && m_stopTimeout != -1) {
            Trace.out("Stop timeout " + m_stopTimeout + " supplied was invalid");
            throw new VMException((MessageKey)PrCvMsgID.INVALID_STOPTIMEOUT_FAILED, m_stopTimeout);
        }
        if (m_checkInterval != -1 && m_checkInterval <= 0) {
            Trace.out("Check Interval " + m_checkInterval + " supplied was invalid");
            throw new VMException((MessageKey)PrCvMsgID.INVALID_INTERVAL_FAILED, m_checkInterval);
        }
        Map<String, List<String>> vmMap = VMFactory.validateVMs(this.convertStringListToStringArray(args.getVM()));
        if (!vmMap.isEmpty()) {
            Trace.out("Some virtual machines mentioned found in other VM resources");
            throw new VMException((MessageKey)PrCvMsgID.ADD_VM_FAILED_ALREADY_REGISTERED, vmMap, new Object[0]);
        }
        if (m_nodes != null && m_VMList != null && m_nodes.size() < m_VMList.size()) {
            Trace.out("Number of hosting members specified is lesser than the number of VM instances");
            throw new VMException((MessageKey)PrCvMsgID.INSUFFICIENT_NODES_FAILED, String.valueOf(m_nodes.size()), String.valueOf(m_VMList.size()));
        }
        List<String> duplicates = this.checkDuplicate(m_VMList);
        if (duplicates != null) {
            String[] dups = new String[duplicates.size()];
            dups = duplicates.toArray(dups);
            Trace.out("Duplicates found in the VM list: " + this.convertStringArrayToString(dups));
            throw new VMException((MessageKey)PrCvMsgID.DUPLICATE_VM_FAILED, this.convertStringArrayToListString(dups));
        }
        String vmResName = VMFactory.getResourceType();
        Trace.out("Beginning of VMImpl create");
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute vmTypeAttr = crsFactory.create(ResourceType.VirtualMachine.NAME.name(), ResourceType.VirtualMachine.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(vmTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.VM_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.STOP_TIMEOUT.name()) && m_stopTimeout > 0) {
                    attr.setValue(String.valueOf(m_stopTimeout));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.CHECK_INTERVAL.name()) && m_checkInterval > 0) {
                    attr.setValue(String.valueOf(m_checkInterval));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.SERVER_CATEGORY.name()) && m_serverCategory != null && m_serverCategory.trim().length() > 0) {
                    String validatedServerCategory = this.validateServerCategory(m_serverCategory, m_VMList.size());
                    attr.setValue(validatedServerCategory);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.SERVER_POOLS.name())) {
                    if (m_serverPool == null || m_serverPool.trim().length() <= 0) continue;
                    String validatedServerPool = this.validateServerPool(m_serverPool, m_VMList.size());
                    attr.setValue(validatedServerPool);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.HOSTING_MEMBERS.name()) && m_nodes != null) {
                    String[] nodeArr = new String[m_nodes.size()];
                    nodeArr = m_nodes.toArray(nodeArr);
                    try {
                        this.validateNodes(nodeArr);
                    }
                    catch (NotExistsException e) {
                        Trace.out("NotExistsException caught for the nodes supplied");
                        throw new VMException(e);
                    }
                    String hostingMembers = this.convertStringArrayToString(nodeArr);
                    attr.setValue(hostingMembers);
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.VirtualMachine.CARDINALITY.name())) continue;
                attr.setValue(String.valueOf(m_VMList.size()));
            }
            for (int i = 0; i < m_VMList.size(); ++i) {
                attrList.add(crsFactory.create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(i + 1)), m_VMList.get(i)));
            }
            ResourceAttribute aclPerm = this.createVMACLAttr();
            attrList.add(aclPerm);
            if (m_nodes != null || m_serverPool != null) {
                attrList.add(crsFactory.create(ResourceType.VirtualMachine.SERVER_CATEGORY.name(), ""));
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("Checking for server pool size to see if warning needs to be flagged");
            if (m_serverPool != null && m_serverPool.trim().length() > 0) {
                this.validateServerPoolSize(m_serverPool, m_VMList.size());
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught");
            throw new VMException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (AlreadyExistsException e) {
            Trace.out("AlreadyExistsException caught in VM resource creation.");
            throw new AlreadyExistsException((MessageKey)PrCvMsgID.VM_ALREADY_EXISTS, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String getName() {
        return VMImpl.getVMUniqueName(this.m_nameAttr.getValue());
    }

    @Override
    public String[] getVM() throws VMException {
        ArrayList<String> vmList = new ArrayList<String>();
        try {
            int size = this.getCardinality();
            for (int i = 0; i < size; ++i) {
                String vmName = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(i + 1))).getValue();
                vmList.add(vmName);
            }
            Trace.out("VM attribute contains: " + this.convertStringArrayToListString(this.convertStringListToStringArray(vmList)));
            return this.convertStringListToStringArray(vmList);
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_VMLIST_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public int getStopTimeout() throws VMException {
        try {
            return Integer.parseInt(this.m_crsResource.getAttribute(ResourceType.VirtualMachine.STOP_TIMEOUT.name()).getValue());
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_STOPTIMEOUT_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public int getCheckInterval() throws VMException {
        try {
            return Integer.parseInt(this.m_crsResource.getAttribute(ResourceType.VirtualMachine.CHECK_INTERVAL.name()).getValue());
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_INTERVAL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void setStopTimeout(int stopTimeout) throws VMException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.STOP_TIMEOUT.name(), String.valueOf(stopTimeout)));
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_STOPTIMEOUT_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void setCheckInterval(int checkInterval) throws VMException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.CHECK_INTERVAL.name(), String.valueOf(checkInterval)));
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_INTERVAL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void enable() throws VMException, AlreadyEnabledException {
        try {
            super.enable();
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void disable() throws VMException, AlreadyDisabledException {
        try {
            super.disable();
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void enable(Node node) throws VMException, AlreadyEnabledException {
        try {
            if (null == node) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
            }
            ArrayList<Node> nodeList = new ArrayList<Node>(1);
            nodeList.add(node);
            super.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void enable(String vm) throws VMException, AlreadyEnabledException {
        try {
            if (null == vm) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            int cardinalityID = this.getCardinalityID(vm);
            if (cardinalityID == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.enable(cardinalityID);
        }
        catch (AlreadyEnabledException e) {
            Trace.out("AlreadyEnabledException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new AlreadyEnabledException((MessageKey)PrCvMsgID.RES_ALREADY_ENABLED_VM, vm, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void enable(List<Node> nodes) throws VMException, AlreadyEnabledException {
        try {
            if (null == nodes) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodes");
            }
            super.enable(nodes);
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void enableVMs(List<String> vmList) throws VMException, AlreadyEnabledException {
        try {
            if (null == vmList) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vmList");
            }
            ArrayList<Integer> cardinalityIDList = new ArrayList<Integer>();
            for (String vm : vmList) {
                int cardinalityID = this.getCardinalityID(vm);
                cardinalityIDList.add(cardinalityID);
                if (cardinalityID != 0) continue;
                Trace.out("Virtual machine " + vm + " was not found in the VM resource " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.enableCardinality(cardinalityIDList);
        }
        catch (AlreadyEnabledException e) {
            Trace.out("AlreadyEnabledException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            if (vmList.size() == 1) {
                throw new AlreadyEnabledException((MessageKey)PrCvMsgID.RES_ALREADY_ENABLED_VM, vmList.get(0), VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            throw new AlreadyEnabledException((MessageKey)PrCvMsgID.RES_ALREADY_ENABLED_VMS, this.convertStringArrayToListString(this.convertStringListToStringArray(vmList)), VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (CompositeOperationException e) {
            boolean isAlreadyEnabled = true;
            try {
                Set<Object> cardErrList = e.getOperationIdentifier();
                for (Object cardErrID : cardErrList) {
                    if (e.getException(cardErrID).getClass().isAssignableFrom(AlreadyEnabledException.class)) {
                        e.setException(cardErrID, new AlreadyEnabledException((MessageKey)PrCvMsgID.RES_ALREADY_ENABLED_VM, this.getVM((Integer)cardErrID), VMImpl.getVMUniqueName(this.m_nameAttr.getValue())));
                        continue;
                    }
                    isAlreadyEnabled = false;
                }
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
                // empty catch block
            }
            if (isAlreadyEnabled) {
                Trace.out("Error: Some of the virtual machines were already enabled.");
                throw new AlreadyEnabledException(e);
            }
            Trace.out("Unexpected error enabling some of the virtual machines.");
            throw new VMException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void disable(Node node) throws VMException, AlreadyDisabledException {
        try {
            if (null == node) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
            }
            ArrayList<Node> nodeList = new ArrayList<Node>(1);
            nodeList.add(node);
            super.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void disable(String vm) throws VMException, AlreadyDisabledException {
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            int cardinalityID = this.getCardinalityID(vm);
            if (cardinalityID == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.disable(cardinalityID);
        }
        catch (AlreadyDisabledException e) {
            Trace.out("AlreadyDisabledException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new AlreadyDisabledException((MessageKey)PrCvMsgID.RES_ALREADY_DISABLED_VM, vm, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void disable(List<Node> nodes) throws VMException, AlreadyDisabledException {
        try {
            if (null == nodes) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodes");
            }
            super.disable(nodes);
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void disableVMs(List<String> vmList) throws VMException, AlreadyDisabledException {
        try {
            if (null == vmList) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vmList");
            }
            Trace.out("Beginning of disable for Cardinality IDs");
            ArrayList<Integer> cardinalityIDList = new ArrayList<Integer>();
            for (String vm : vmList) {
                int cardinalityID = this.getCardinalityID(vm);
                cardinalityIDList.add(cardinalityID);
                if (cardinalityID != 0) continue;
                Trace.out("At least one of the virtual machines was not found in VM resource for VM: " + vm);
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.disableCardinality(cardinalityIDList);
            Trace.out("End of disable");
        }
        catch (AlreadyDisabledException e) {
            Trace.out("AlreadyDisabledException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            if (vmList.size() == 1) {
                throw new AlreadyDisabledException((MessageKey)PrCvMsgID.RES_ALREADY_DISABLED_VM, vmList.get(0), VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            throw new AlreadyDisabledException((MessageKey)PrCvMsgID.RES_ALREADY_DISABLED_VMS, this.convertStringArrayToListString(this.convertStringListToStringArray(vmList)), VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (CompositeOperationException e) {
            boolean isAlreadyDisabled = true;
            try {
                Set<Object> cardErrList = e.getOperationIdentifier();
                for (Object cardErrID : cardErrList) {
                    if (e.getException(cardErrID).getClass().isAssignableFrom(AlreadyDisabledException.class)) {
                        e.setException(cardErrID, new AlreadyDisabledException((MessageKey)PrCvMsgID.RES_ALREADY_DISABLED_VM, this.getVM((Integer)cardErrID), VMImpl.getVMUniqueName(this.m_nameAttr.getValue())));
                        continue;
                    }
                    isAlreadyDisabled = false;
                }
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
                // empty catch block
            }
            if (isAlreadyDisabled) {
                Trace.out("Some of the virtual machines were already disabled");
                throw new AlreadyDisabledException(e);
            }
            Trace.out("Some of the disable operations on virtual machines failed unexpectedly");
            throw new VMException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void remove(boolean force) throws VMException, AlreadyRunningException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public void modify(VMArgs args) throws VMException, VMWarningException, AlreadyPresentException, AlreadyNotPresentException {
        Trace.out("In the beginning of VMImpl.modify");
        if (null == args) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        ArrayList<String> vmToBeAdded = new ArrayList<String>();
        ArrayList<String> vmToBeRemoved = new ArrayList<String>();
        List<Object> alreadyPresentVMs = new ArrayList();
        ArrayList<String> alreadyAbsentVMs = new ArrayList<String>();
        int vmCount = this.getVM().length;
        if (args.getVM() != null || args.getRemoveVM() != null) {
            List<String> duplicates = this.checkDuplicate(args.getVM(), args.getRemoveVM());
            if (duplicates != null) {
                Trace.out("Duplicates found in the VM list");
                String[] dups = new String[duplicates.size()];
                dups = duplicates.toArray(dups);
                throw new VMException((MessageKey)PrCvMsgID.DUPLICATE_VM_FAILED, this.convertStringArrayToListString(dups));
            }
            if (args.getVM() != null) {
                if (args.getVM().contains("")) {
                    Trace.out("Error: VM list provided contains an empty invalid value");
                    throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
                }
                vmToBeAdded.addAll(args.getVM());
                Map<String, List<String>> vmMap = VMFactory.validateVMs(this.convertStringListToStringArray(args.getVM()));
                if (!vmMap.isEmpty()) {
                    alreadyPresentVMs = vmMap.remove(VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                    if (alreadyPresentVMs != null) {
                        vmToBeAdded.removeAll(alreadyPresentVMs);
                    }
                    if (!vmMap.isEmpty()) {
                        Trace.out("Some of the VMs were already registered in resources");
                        throw new VMException((MessageKey)PrCvMsgID.ADD_VM_FAILED_ALREADY_REGISTERED, vmMap, new Object[0]);
                    }
                }
                vmCount += vmToBeAdded.size();
            }
            if (args.getRemoveVM() != null) {
                if (args.getRemoveVM().contains("")) {
                    Trace.out("Error: VM list provided contains an empty invalid value");
                    throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "removeVM");
                }
                try {
                    if (this.m_crsResource.isRunning()) {
                        Trace.out("Error: removing vms failed since the VM resource was running.");
                        throw new VMException((MessageKey)PrCvMsgID.REMOVEVM_RUNNING_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                    }
                }
                catch (CRSException e) {
                    Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + " in finding if crsResource.isRunning: " + e.getMessage());
                    throw new VMException(e);
                }
                List<String> vmList = this.convertStringArrayToStringList(this.getVM());
                List<String> vmNameList = this.convertStringArrayToStringList(this.getVMNames());
                List<String> vmIdList = this.convertStringArrayToStringList(this.getVMIDs());
                for (String vmRem : args.getRemoveVM()) {
                    if (!(vmList.contains(vmRem) || vmNameList.contains(vmRem) || vmIdList.contains(vmRem))) {
                        alreadyAbsentVMs.add(vmRem);
                        continue;
                    }
                    vmToBeRemoved.add(vmRem);
                }
                vmCount -= vmToBeRemoved.size();
            }
        }
        if (args.getNodes() != null && args.getNodes().size() != 0) {
            int nodeCount = args.getNodes().size();
            if (nodeCount < vmCount) {
                Trace.out("Insufficient number of nodes to place all virtual machines.");
                throw new VMException((MessageKey)PrCvMsgID.INSUFFICIENT_NODES_FAILED, nodeCount, vmCount);
            }
        } else if (args.getNodes() != null && args.getNodes().size() == 0) {
            boolean nodeCount = false;
        } else {
            try {
                int nodeCount;
                if (this.getNodes() != null && !this.getNodes()[0].isEmpty() && args.getServerPool() == null && args.getServerCategory() == null && (nodeCount = this.getNodes().length) < vmCount) {
                    Trace.out("Insufficient number of nodes to place all virtual machines.");
                    throw new VMException((MessageKey)PrCvMsgID.INSUFFICIENT_NODES_FAILED, nodeCount, vmCount);
                }
            }
            catch (NotConfiguredException vmList) {
            }
            catch (NotExistsException e) {
                Trace.out("One of the nodes currently configured does not exist. Error.");
                throw new VMException(e);
            }
            if (args.getNodes() != null && args.getNodes().size() != 0) {
                int n = args.getNodes().size();
            }
        }
        if (vmCount <= 0) {
            Trace.out("Error: removing virtual machines failed in VM resource as the number of virtual machines cannot be <= 0");
            throw new VMException((MessageKey)PrCvMsgID.VM_REMOVE_EMPTY_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        if (args.getServerPool() != null && !args.getServerPool().isEmpty()) {
            this.validateServerPool(args.getServerPool(), vmCount);
        }
        if (args.getServerCategory() != null && !args.getServerCategory().isEmpty()) {
            this.validateServerCategory(args.getServerCategory(), vmCount);
        }
        if (args.getStopTimeout() <= 0 && args.getStopTimeout() != -1) {
            Trace.out("Invalid stop timeout value: " + args.getStopTimeout());
            throw new VMException((MessageKey)PrCvMsgID.INVALID_STOPTIMEOUT_FAILED, args.getStopTimeout());
        }
        if (args.getCheckInterval() <= 0 && args.getCheckInterval() != -1) {
            Trace.out("Invalid check interval value: " + args.getCheckInterval());
            throw new VMException((MessageKey)PrCvMsgID.INVALID_INTERVAL_FAILED, args.getCheckInterval());
        }
        Trace.out("All validation succeeded. Modify will begin now.");
        if (args.getServerPool() != null) {
            this.setServerPool(args.getServerPool());
        } else if (args.getServerCategory() != null) {
            this.setServerCategory(args.getServerCategory());
        } else if (args.getNodes() != null) {
            this.setNodes(args.getNodes());
        }
        if (args.getStopTimeout() >= 0) {
            this.setStopTimeout(args.getStopTimeout());
        }
        if (args.getCheckInterval() >= 0) {
            this.setCheckInterval(args.getCheckInterval());
        }
        if (!vmToBeAdded.isEmpty()) {
            this.addVMHelper(vmToBeAdded);
        }
        if (!vmToBeRemoved.isEmpty()) {
            this.removeVMHelper(vmToBeRemoved);
        }
        ServerPool serverPool = null;
        try {
            serverPool = this.getServerPool();
            String sPool = "";
            if (serverPool != null) {
                sPool = serverPool.getName();
            }
            if (!sPool.isEmpty() && !sPool.equals("*") && sPool != null) {
                this.validateServerPoolSize(sPool, vmCount);
            }
        }
        catch (VMException e) {
            Trace.out("VMException caught. Error");
            throw new VMException(e);
        }
        catch (NotExistsException e) {
            Trace.out("Server Pool returned did not exist. Error");
            throw new VMException(e);
        }
        catch (NotConfiguredException e) {
            Trace.out("ServerPool is not configured. Skipped");
        }
        if (alreadyPresentVMs != null && alreadyPresentVMs.size() > 0) {
            Trace.out("The following VMs were already present: " + this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyPresentVMs)));
            throw new AlreadyPresentException((MessageKey)PrCvMsgID.ALREADY_PRESENT_VM, this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyPresentVMs)));
        }
        if (alreadyAbsentVMs.size() > 0) {
            Trace.out("The following VMs were already absent: " + this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyAbsentVMs)));
            throw new AlreadyNotPresentException((MessageKey)PrCvMsgID.ALREADY_ABSENT_VM, this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyAbsentVMs)));
        }
    }

    @Override
    public void addVM(List<String> vm) throws VMException, AlreadyPresentException {
        if (vm == null) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        if (vm.contains("")) {
            Trace.out("Error: VM list provided contains an empty invalid value");
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        ArrayList<String> vmToBeAdded = new ArrayList<String>();
        List<Object> alreadyPresentVMs = new ArrayList();
        int vmCount = this.getVM().length;
        vmToBeAdded.addAll(vm);
        Map<String, List<String>> vmMap = VMFactory.validateVMs(this.convertStringListToStringArray(vm));
        if (!vmMap.isEmpty()) {
            alreadyPresentVMs = vmMap.remove(VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            vmToBeAdded.removeAll(alreadyPresentVMs);
            if (!vmMap.isEmpty()) {
                Trace.out("Some virtual machines mentioned found in other VM resources");
                throw new VMException((MessageKey)PrCvMsgID.ADD_VM_FAILED_ALREADY_REGISTERED, vmMap, new Object[0]);
            }
        }
        vmCount += vmToBeAdded.size();
        int nodeCount = Integer.MAX_VALUE;
        try {
            if (this.getNodes() != null && this.getNodes().length != 0) {
                nodeCount = this.getNodes().length;
            }
        }
        catch (NotConfiguredException notConfiguredException) {
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught in getNodes(). Error.");
            throw new VMException(e);
        }
        List<String> duplicates = this.checkDuplicate(vm);
        if (duplicates != null) {
            Trace.out("Duplicates found in the VM list");
            String[] dups = new String[duplicates.size()];
            dups = duplicates.toArray(dups);
            throw new VMException((MessageKey)PrCvMsgID.DUPLICATE_VM_FAILED, this.convertStringArrayToListString(dups));
        }
        if (nodeCount < vmCount) {
            Trace.out("Number of hosting members specified is lesser than the number of VM instances");
            throw new VMException((MessageKey)PrCvMsgID.INSUFFICIENT_NODES_FAILED, nodeCount, vmCount);
        }
        if (!vmToBeAdded.isEmpty()) {
            this.addVMHelper(vm);
        }
        if (alreadyPresentVMs != null && alreadyPresentVMs.size() > 0) {
            Trace.out("The following VMs were already present: " + this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyPresentVMs)));
            throw new AlreadyPresentException((MessageKey)PrCvMsgID.ALREADY_PRESENT_VM, this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyPresentVMs)));
        }
    }

    @Override
    public void removeVM(List<String> vm) throws VMException, AlreadyNotPresentException {
        if (null == vm) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        if (vm.contains("")) {
            Trace.out("Error: VM list provided contains an empty invalid value");
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        ArrayList<String> vmToBeRemoved = new ArrayList<String>();
        ArrayList<String> alreadyAbsentVMs = new ArrayList<String>();
        int vmCount = this.getVM().length;
        try {
            if (this.m_crsResource.isRunning()) {
                Trace.out("Error: removing vms failed since the VM resource was running.");
                throw new VMException((MessageKey)PrCvMsgID.REMOVEVM_RUNNING_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for VM resource " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + " in crsResource.getRunning");
            throw new VMException(e);
        }
        List<String> duplicates = this.checkDuplicate(vm);
        if (duplicates != null) {
            Trace.out("Duplicates found in the VM list");
            String[] dups = new String[duplicates.size()];
            dups = duplicates.toArray(dups);
            throw new VMException((MessageKey)PrCvMsgID.DUPLICATE_VM_FAILED, this.convertStringArrayToListString(dups));
        }
        List<String> vmList = this.convertStringArrayToStringList(this.getVM());
        List<String> vmNameList = this.convertStringArrayToStringList(this.getVMNames());
        List<String> vmIdList = this.convertStringArrayToStringList(this.getVMIDs());
        for (String vmRem : vm) {
            if (!(vmList.contains(vmRem) || vmNameList.contains(vmRem) || vmIdList.contains(vmRem))) {
                alreadyAbsentVMs.add(vmRem);
                continue;
            }
            vmToBeRemoved.add(vmRem);
        }
        if ((vmCount -= vmToBeRemoved.size()) <= 0) {
            Trace.out("Error: removing virtual machines failed in VM resource as the number of virtual machines cannot be <= 0");
            throw new VMException((MessageKey)PrCvMsgID.VM_REMOVE_EMPTY_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        if (!vmToBeRemoved.isEmpty()) {
            this.removeVMHelper(vmToBeRemoved);
        }
        if (alreadyAbsentVMs.size() > 0) {
            Trace.out("The following VMs were already absent: " + this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyAbsentVMs)));
            throw new AlreadyNotPresentException((MessageKey)PrCvMsgID.ALREADY_ABSENT_VM, this.convertStringArrayToListString(this.convertStringListToStringArray(alreadyAbsentVMs)));
        }
    }

    @Override
    public ServerPool getServerPool() throws VMException, NotExistsException, NotConfiguredException {
        try {
            String serverPoolName = this.m_crsResource.getAttribute(ResourceType.VirtualMachine.SERVER_POOLS.name()).getValue();
            if (serverPoolName.equals("") || serverPoolName.equals("*")) {
                Trace.out("ServerPool option was not configured.");
                throw new NotConfiguredException((MessageKey)PrCvMsgID.SERVERPOOL_NOT_CONFIGURED, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            try {
                ServerFactoryImpl serverFactoryImpl = ServerFactoryImpl.getInstance();
                return serverFactoryImpl.getServerPool(serverPoolName);
            }
            catch (ServerException e) {
                Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new VMException((MessageKey)PrCvMsgID.GET_SERVERPOOL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            catch (NotExistsException e) {
                Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new NotExistsException((MessageKey)PrCvMsgID.GET_SERVERPOOL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_SERVERPOOL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public ServerCategory getServerCategory() throws VMException, NotExistsException, NotConfiguredException {
        try {
            String serverCategoryName = this.m_crsResource.getAttribute(ResourceType.VirtualMachine.SERVER_CATEGORY.name()).getValue();
            if (serverCategoryName.equals("")) {
                Trace.out("ServerCategory was not configured.");
                throw new NotConfiguredException((MessageKey)PrCvMsgID.CATEGORY_NOT_CONFIGURED, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            try {
                ServerFactoryImpl serverFactoryImpl = ServerFactoryImpl.getInstance();
                return serverFactoryImpl.getServerCategory(serverCategoryName);
            }
            catch (ServerException e) {
                Trace.out("ServerException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new VMException((MessageKey)PrCvMsgID.GET_CATEGORY_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            catch (NotExistsException e) {
                Trace.out("NotExistsException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new NotExistsException((MessageKey)PrCvMsgID.GET_CATEGORY_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_CATEGORY_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public String[] getNodes() throws VMException, NotExistsException, NotConfiguredException {
        try {
            String hostingMembers = this.m_crsResource.getAttribute(ResourceType.VirtualMachine.HOSTING_MEMBERS.name()).getValue();
            List<String> nodeList = this.convertStringToStringList(hostingMembers);
            if (nodeList.get(0).isEmpty()) {
                Trace.out("Hosting members are not configured.");
                throw new NotConfiguredException((MessageKey)PrCvMsgID.NODES_NOT_CONFIGURED, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            Trace.out("getNodes returns: " + this.convertStringArrayToListString(this.convertStringListToStringArray(nodeList)));
            this.validateNodes(this.convertStringListToStringArray(nodeList));
            return this.convertStringListToStringArray(nodeList);
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.GET_NODES_FAILED, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public boolean isEnabledVM(String vm) throws VMException {
        if (null == vm || vm.isEmpty()) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        boolean isEnable = this.isEnabledCardinality(this.getCardinalityID(vm));
        Trace.out("Virtual machine " + vm + " is enabled? " + String.valueOf(isEnable));
        return isEnable;
    }

    @Override
    public void setServerPool(ServerPool serverPool) throws VMException {
        try {
            if (null == serverPool) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverPool");
            }
            this.setPlacement("", serverPool.getName(), "");
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_SERVERPOOL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void setServerCategory(ServerCategory serverCategory) throws VMException {
        try {
            if (null == serverCategory) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverCategory");
            }
            this.setPlacement("", "*", serverCategory.getName());
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_CATEGORY_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void setServerPool(String serverPool) throws VMException {
        block5: {
            try {
                if (serverPool != null) {
                    if (serverPool.isEmpty()) {
                        this.setPlacement("", "*", "");
                    } else {
                        serverPool = "ora." + serverPool;
                        this.setPlacement("", serverPool, "");
                    }
                    break block5;
                }
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverPool");
            }
            catch (CRSException e) {
                Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new VMException((MessageKey)PrCvMsgID.SET_SERVERPOOL_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
    }

    @Override
    public void setServerCategory(String serverCategory) throws VMException {
        block5: {
            try {
                if (serverCategory != null) {
                    if (serverCategory.isEmpty()) {
                        this.setPlacement("", "*", "");
                    } else {
                        serverCategory = "ora." + serverCategory + '.' + "category";
                        this.setPlacement("", "*", serverCategory);
                    }
                    break block5;
                }
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverCategory");
            }
            catch (CRSException e) {
                Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
                throw new VMException((MessageKey)PrCvMsgID.SET_CATEGORY_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
    }

    @Override
    public void setNodes(List<String> nodes) throws VMException {
        try {
            if (nodes == null) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodes");
            }
            if (nodes.isEmpty()) {
                this.setPlacement("", "*", "");
            } else {
                String[] nodeArr = new String[nodes.size()];
                nodeArr = nodes.toArray(nodeArr);
                this.validateNodes(nodeArr);
                String hostingMembers = this.convertStringArrayToString(nodeArr);
                this.setPlacement(hostingMembers, "*", "");
            }
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_NODES_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.SET_NODES_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void relocate(String vm, Node dest) throws VMException, RelocateException, NotRunningException {
        Node src = null;
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            if (null == dest) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dest");
            }
            List<Node> nodeList = this.m_crsResource.fetchRunningNodes();
            if (this.getCardinalityID(vm) == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            String instId = this.m_nameAttr.getValue() + " " + this.getCardinalityID(vm) + " 1";
            for (Node node : nodeList) {
                if (!this.m_crsResource.resourceInstanceIds(node.getName())[0].trim().equals(instId.trim())) continue;
                src = node;
            }
            if (src == null) {
                Trace.out("Relocate command failed because NotRunningException caught:");
                throw new NotRunningException((MessageKey)PrCvMsgID.VM_INST_RELOCATE_RUNNING_FAIL, vm, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
        catch (NodeException e) {
            Trace.out("NodeException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        this.relocate(src, dest);
    }

    @Override
    public void relocate(Node src, Node dest) throws RelocateException, NotRunningException, VMException {
        try {
            if (null == src) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "src");
            }
            if (null == dest) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dest");
            }
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(src, dest);
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new RelocateException(e);
        }
        catch (NotRunningException e) {
            Trace.out("NotRunningException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            try {
                throw new NotRunningException((MessageKey)PrCvMsgID.VM_RELOCATE_RUNNING_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()), src.getName());
            }
            catch (NodeException ne) {
                throw new RelocateException(ne);
            }
        }
    }

    @Override
    public void relocate(String vm) throws VMException, RelocateException, NotRunningException {
        Node src = null;
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            List<Node> nodeList = this.m_crsResource.fetchRunningNodes();
            if (this.getCardinalityID(vm) == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            String instId = this.m_nameAttr.getValue() + " " + this.getCardinalityID(vm) + " 1";
            for (Node node : nodeList) {
                if (!this.m_crsResource.resourceInstanceIds(node.getName())[0].trim().equals(instId.trim())) continue;
                src = node;
                Trace.out("Virtual machine " + vm + " running on node " + node.getName());
            }
            if (src == null) {
                Trace.out("NotRunningException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new NotRunningException((MessageKey)PrCvMsgID.VM_INST_RELOCATE_RUNNING_FAIL, vm, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
        }
        catch (NodeException e) {
            Trace.out("NodeException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
        this.relocate(src);
    }

    @Override
    public void relocate(Node src) throws RelocateException, NotRunningException, VMException {
        try {
            if (null == src) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "src");
            }
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(src);
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new RelocateException(e);
        }
        catch (NotRunningException e) {
            Trace.out("NotRunningException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            try {
                throw new NotRunningException((MessageKey)PrCvMsgID.VM_RELOCATE_RUNNING_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()), src.getName());
            }
            catch (NodeException ne) {
                throw new RelocateException(ne);
            }
        }
    }

    @Override
    public void start() throws VMException, AlreadyRunningException {
        try {
            super.start();
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_START_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void stop() throws VMException, AlreadyStoppedException {
        try {
            super.stop(true);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_STOP_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void start(String vm, Node node) throws VMException, AlreadyRunningException {
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            if (null == node) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
            }
            int cardinalityID = this.getCardinalityID(vm);
            if (cardinalityID == 0) {
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.startInstance(cardinalityID, node);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_START_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (NodeException e) {
            Trace.out("NodeException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_START_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void start(String vm) throws VMException, AlreadyRunningException {
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            int cardinalityID = this.getCardinalityID(vm);
            if (cardinalityID == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.startInstance(cardinalityID);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_START_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void start(Node node) throws VMException, AlreadyRunningException {
        try {
            if (null == node) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
            }
            super.start(node);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_START_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void stop(String vm) throws VMException, AlreadyStoppedException {
        try {
            if (null == vm || vm.isEmpty()) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            int cardinalityID = this.getCardinalityID(vm);
            if (cardinalityID == 0) {
                Trace.out("Virtual machine " + vm + " was not found in " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
                throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            this.m_crsResource.stopInstance(cardinalityID);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_STOP_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public void stop(Node node) throws VMException, AlreadyStoppedException {
        try {
            if (null == node) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
            }
            super.stop(node, true);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_STOP_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    @Override
    public HashMap<VMDetail, String> getStatus() throws VMException {
        try {
            Trace.out("Assembling a map of VM instances and running node");
            HashMap<String, String> instanceMap = this.m_crsResource.fetchRunningInstances();
            HashMap<VMDetail, String> vmMap = new HashMap<VMDetail, String>();
            for (Map.Entry<String, String> entry : instanceMap.entrySet()) {
                String instanceID = entry.getKey();
                int cardinalityID = Integer.parseInt(instanceID.split(" ")[1]);
                vmMap.put(this.getVMDetail(cardinalityID), entry.getValue());
            }
            return vmMap;
        }
        catch (CRSException e) {
            Trace.out("CRS Exception caught for " + VMImpl.getVMUniqueName(this.m_nameAttr.getValue()) + ": " + e.getMessage());
            throw new VMException(e);
        }
    }

    @Override
    public String[] getDisabledVMs() throws VMException {
        List<String> vmList = this.convertStringArrayToStringList(this.getVM());
        ArrayList<String> disabledVMs = new ArrayList<String>();
        for (String vmInst : vmList) {
            if (this.isEnabledVM(vmInst)) continue;
            disabledVMs.add(vmInst);
        }
        return this.convertStringListToStringArray(disabledVMs);
    }

    @Override
    public String[] getInvalidVMs() throws VMException {
        ArrayList<String> invalidVMs = new ArrayList<String>();
        int size = this.getCardinality();
        for (int i = 1; i <= size; ++i) {
            if (this.getVMName(i) == null || this.getVMID(i) == null || !this.getVMName(i).isEmpty() || !this.getVMID(i).isEmpty()) continue;
            invalidVMs.add(this.getVM(i));
        }
        if (invalidVMs.size() > 0) {
            VMWarningException e = new VMWarningException((MessageKey)PrCvMsgID.CONFIG_VM_INVALID, this.convertStringArrayToListString(this.convertStringListToStringArray(invalidVMs)));
            if (!this.m_vmWarningList.contains(e)) {
                this.m_vmWarningList.add(e);
            }
        } else {
            Iterator<VMWarningException> it = this.m_vmWarningList.iterator();
            while (it.hasNext()) {
                VMWarningException e = it.next();
                if (e.getMessageKey() == null || !e.getMessageKey().getID().equals(PrCvMsgID.CONFIG_VM_INVALID)) continue;
                it.remove();
            }
        }
        return this.convertStringListToStringArray(invalidVMs);
    }

    @Override
    public List<VMDetail> getVMDetail() throws VMException {
        int count = this.getCardinality();
        ArrayList<VMDetail> vmDetailList = new ArrayList<VMDetail>();
        String vmResourceName = VMImpl.getVMUniqueName(this.m_nameAttr.getValue());
        ArrayList<String> invalidVMs = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            VMDetail.VMState vmNameState;
            String vm = this.getVM(i);
            String vmName = this.getVMName(i);
            String vmID = this.getVMID(i);
            if (!(vmName == null || vmID == null || vmName.equals(vm) || vmID.equals(vm) || vmName.isEmpty() || vmID.isEmpty())) {
                Trace.out("Mismatched VM warning: VM = " + vm + "; VM Name = " + vmName + "; VM ID = " + vmID);
                VMWarningException e = new VMWarningException((MessageKey)PrCvMsgID.MISMATCH_VM_WARNING, vm, vmName, vmID);
                this.m_vmWarningList.add(e);
            }
            if (vmName == null) {
                vmNameState = VMDetail.VMState.NOTPROCESSED;
            } else if (vmName.isEmpty()) {
                vmNameState = VMDetail.VMState.INVALID;
                invalidVMs.add(vm);
            } else {
                vmNameState = VMDetail.VMState.AVAILABLE;
            }
            VMDetail.VMState vmIDState = vmID == null ? VMDetail.VMState.NOTPROCESSED : (vmID.isEmpty() ? VMDetail.VMState.INVALID : VMDetail.VMState.AVAILABLE);
            boolean isEnabled = this.isEnabledVM(vm);
            Trace.out("Check for duplicates");
            if (vmDetailList.contains(this.createVMDetail(vmResourceName, vm, vmName, vmID, vmNameState, vmIDState, isEnabled, i))) {
                Trace.out("Duplicate VM : " + vm);
                String duplicateVMs = vmName + "," + vmID;
                VMWarningException e = new VMWarningException((MessageKey)PrCvMsgID.DUPLICATE_VM_WARNING, duplicateVMs, vmID);
                this.m_vmWarningList.add(e);
            }
            vmDetailList.add(this.createVMDetail(vmResourceName, vm, vmName, vmID, vmNameState, vmIDState, isEnabled, i));
        }
        if (invalidVMs.size() > 0) {
            VMWarningException e = new VMWarningException((MessageKey)PrCvMsgID.CONFIG_VM_INVALID, this.convertStringArrayToListString(this.convertStringListToStringArray(invalidVMs)));
            this.m_vmWarningList.add(e);
        } else {
            Iterator<VMWarningException> it = this.m_vmWarningList.iterator();
            while (it.hasNext()) {
                VMWarningException e = it.next();
                if (e.getMessageKey() == null || !e.getMessageKey().getID().equals(PrCvMsgID.CONFIG_VM_INVALID)) continue;
                it.remove();
            }
        }
        return vmDetailList;
    }

    @Override
    public VMDetail getVMDetail(String vm) throws VMException {
        return this.getVMDetail(this.getCardinalityID(vm));
    }

    private VMDetail createVMDetail(String vmResourceName, String vm, String vmName, String vmID, VMDetail.VMState vmNameState, VMDetail.VMState vmIDState, boolean isEnabled, int cardinalityID) {
        return new VMDetailImpl(vmResourceName, vm, vmName, vmID, vmNameState, vmIDState, isEnabled, cardinalityID);
    }

    private void validateServerPoolSize(String serverPool, int count) throws VMException, VMWarningException {
        ServerFactoryImpl serverFactoryImpl;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new VMException((MessageKey)PrCvMsgID.GET_SERVERPOOL_FAILED, (Throwable)se, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        try {
            ServerPool currServerPool = serverFactoryImpl.getServerPool(serverPool);
            if (currServerPool.getCurrentSize() < count) {
                Trace.out("Warning thrown because server count < vm count");
                VMWarningException e = new VMWarningException((MessageKey)PrCvMsgID.INSUFFICIENT_SERVERS_WARNING, currServerPool.getCurrentSize(), count);
                if (!this.m_vmWarningList.contains(e)) {
                    this.m_vmWarningList.add(e);
                }
                throw e;
            }
            Iterator<VMWarningException> it = this.m_vmWarningList.iterator();
            while (it.hasNext()) {
                VMWarningException e = it.next();
                if (e.getMessageKey() == null || !e.getMessageKey().getID().equals(PrCvMsgID.INSUFFICIENT_SERVERS_WARNING)) continue;
                it.remove();
            }
        }
        catch (NotExistsException nee) {
            throw new VMException((MessageKey)PrCaMsgID.SERVERPOOL_NOT_EXISTS, serverPool);
        }
        catch (ServerGroupException sge) {
            throw new VMException((MessageKey)PrCaMsgID.UNABLE_TO_OBTAIN_SERVERPPOOL_INFO, serverPool, sge);
        }
    }

    private ResourceAttribute createVMACLAttr() throws CRSException {
        NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();
        ResourcePermissionsImpl per = null;
        try {
            if (m_nativeSystem.isUnixSystem()) {
                per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
            } else {
                Trace.out("Create windows resource using NT AUTHORITY\\SYSTEM as owner");
                per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.DB_USER);
            }
            String acl = ResourceLiterals.ACL_ATTR.toString();
            Util utl = new Util();
            String owner = per.getOwner();
            String pGroup = utl.getPrimaryGroup(owner);
            per.setPerm(ResourceType.ACL.PGROUP, pGroup, new ResourceType.ACL_PERM[0]);
            per.setPerm(ResourceType.ACL.OTHER, "", new ResourceType.ACL_PERM[0]);
            Trace.out("VM ACL permissions:" + per.getAclString());
            ResourceAttribute aclAttr = new ResourceAttribute(acl, per.getAclString());
            return aclAttr;
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new CRSException(e);
        }
    }

    private void validateNodes(String[] nodeNames) throws VMException, NotExistsException {
        ServerFactoryImpl serverFactoryImpl;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new VMException((MessageKey)PrCcMsgID.FAILED_TO_VERIFY_MEMBERSHIP, (Throwable)se, new Object[0]);
        }
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                serverFactoryImpl.getNode(nodeNames[i]);
                continue;
            }
            catch (NodeException ne) {
                throw new NotExistsException((MessageKey)PrCcMsgID.NODE_VALIDATION_ERROR, nodeNames[i]);
            }
        }
    }

    private String convertStringArrayToString(String[] strArray) {
        StringBuilder strBuilder = new StringBuilder("");
        for (int i = 0; i < strArray.length - 1; ++i) {
            strBuilder.append(strArray[i]);
            strBuilder.append(" ");
        }
        if (strArray.length >= 1) {
            strBuilder.append(strArray[strArray.length - 1]);
        }
        return strBuilder.toString();
    }

    private String convertStringArrayToListString(String[] strArray) {
        StringBuilder strBuilder = new StringBuilder("");
        for (int i = 0; i < strArray.length - 1; ++i) {
            strBuilder.append(strArray[i]);
            strBuilder.append(",");
        }
        if (strArray.length >= 1) {
            strBuilder.append(strArray[strArray.length - 1]);
        }
        return strBuilder.toString();
    }

    private List<String> convertStringToStringList(String str) {
        return Arrays.asList(str.split("\\s"));
    }

    private String[] convertStringListToStringArray(List<String> strList) {
        String[] strArray = new String[strList.size()];
        strArray = strList.toArray(strArray);
        return strArray;
    }

    private List<String> convertStringArrayToStringList(String[] strArray) {
        return new ArrayList<String>(Arrays.asList(strArray));
    }

    private String validateServerPool(String serverPool, int count) throws VMException {
        ServerFactoryImpl serverFactoryImpl;
        String sPool = null;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new VMException((MessageKey)PrCvMsgID.GET_SERVERPOOL_FAILED, (Throwable)se, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        try {
            ServerPool currServerPool = serverFactoryImpl.getServerPool(serverPool);
            if (currServerPool.getCurrentSize() < count) {
                Trace.out("Warning: The ServerPool does not have enough members to start all VM instances");
            }
            sPool = currServerPool.getName();
        }
        catch (NotExistsException nee) {
            throw new VMException((MessageKey)PrCaMsgID.SERVERPOOL_NOT_EXISTS, serverPool);
        }
        catch (ServerGroupException sge) {
            throw new VMException((MessageKey)PrCaMsgID.UNABLE_TO_OBTAIN_SERVERPPOOL_INFO, serverPool, sge);
        }
        return sPool;
    }

    public static String getResourceName(String vmName) {
        return "ora." + vmName + '.' + ResourceLiterals.VM.toString();
    }

    private static String getVMUniqueName(String vmResName) {
        return vmResName.split("\\.")[1];
    }

    private String validateServerCategory(String serverCategory, int count) throws VMException {
        ServerFactoryImpl serverFactoryImpl;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException se) {
            throw new VMException((MessageKey)PrCvMsgID.GET_CATEGORY_FAILED, (Throwable)se, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        serverCategory = "ora." + serverCategory + '.' + "category";
        try {
            ServerCategory currServerCategory = serverFactoryImpl.getServerCategory(serverCategory);
        }
        catch (NotExistsException nee) {
            throw new VMException((MessageKey)PrCsMsgID.SC_NOT_EXISTS, serverCategory);
        }
        catch (ServerCategoryException sge) {
            throw new VMException((MessageKey)PrCaMsgID.UNABLE_TO_OBTAIN_SERVERCATEGORY_INFO, (Throwable)sge, serverCategory);
        }
        return serverCategory;
    }

    private int getCardinality() throws VMException {
        int cardinality = 0;
        try {
            cardinality = Integer.parseInt(this.m_crsResource.getAttribute(ResourceType.VirtualMachine.CARDINALITY.name()).getValue());
            Trace.out("Cardinality of resource: " + String.valueOf(cardinality));
            return cardinality;
        }
        catch (CRSException e) {
            throw new VMException(e);
        }
    }

    private List<String> checkDuplicate(List<String> vmList) {
        Trace.out("Checking for duplicate entries of virtual machines");
        ArrayList<String> duplicates = new ArrayList<String>();
        boolean found = false;
        HashSet<String> vmSet = new HashSet<String>();
        for (String vm : vmList) {
            if (vmSet.add(vm)) continue;
            found = true;
            duplicates.add(vm);
        }
        if (!found) {
            return null;
        }
        return duplicates;
    }

    private List<String> checkDuplicate(List<String> vmList, List<String> removeVMList) {
        Trace.out("Checking for duplicate entries of virtual machines");
        ArrayList<String> duplicates = new ArrayList<String>();
        boolean found = false;
        HashSet<String> vmSet = new HashSet<String>();
        if (vmList != null) {
            for (String vm : vmList) {
                if (vmSet.add(vm)) continue;
                found = true;
                duplicates.add(vm);
            }
        }
        if (removeVMList != null) {
            for (String vm : removeVMList) {
                if (vmSet.add(vm)) continue;
                found = true;
                duplicates.add(vm);
            }
        }
        if (!found) {
            return null;
        }
        return duplicates;
    }

    private void setPlacement(String hostingMembers, String serverPool, String serverCategory) throws CRSException {
        Trace.out("Setting placement attributes: hostingMembers=" + hostingMembers + " serverPool=" + serverPool + " serverCategory=" + serverCategory);
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.HOSTING_MEMBERS.name(), hostingMembers));
        attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.SERVER_CATEGORY.name(), serverCategory));
        attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.SERVER_POOLS.name(), serverPool));
        this.m_crsResource.update(true, attrList.toArray(new ResourceAttribute[attrList.size()]));
    }

    private boolean isEnabledCardinality(int cardinalityID) throws VMException {
        try {
            String enabledDisabled = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.ENABLED.name(), String.valueOf(cardinalityID))).getValue();
            return !enabledDisabled.equals("0");
        }
        catch (CRSException e) {
            Trace.out("Absense of ENABLED per-X implies cardinality:" + String.valueOf(cardinalityID) + " is enabled");
            return true;
        }
    }

    private void removeVMHelper(List<String> vm) throws VMException {
        try {
            int i;
            Trace.out("Beggining of remove VM");
            int currCardinality = this.getCardinality();
            int newCardinality = currCardinality - vm.size();
            if (newCardinality <= 0) {
                throw new VMException((MessageKey)PrCvMsgID.VM_REMOVE_EMPTY_FAIL, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
            }
            Trace.out("Number of virtual machine instance validation complete");
            List<String> vmList = this.convertStringArrayToStringList(this.getVM());
            List<String> vmNameList = this.convertStringArrayToStringList(this.getVMNames());
            List<String> vmIdList = this.convertStringArrayToStringList(this.getVMIDs());
            ArrayList<Integer> remC = new ArrayList<Integer>();
            ArrayList<Integer> enableCard = new ArrayList<Integer>();
            for (i = 0; i < currCardinality; ++i) {
                enableCard.add(this.isEnabledCardinality(i + 1) ? 1 : 0);
            }
            for (i = 0; i < vm.size(); ++i) {
                int remCardinality = this.getCardinalityID(vm.get(i));
                if (remCardinality == 0) continue;
                remC.add(remCardinality);
            }
            Collections.sort(remC);
            for (i = remC.size() - 1; i >= 0; --i) {
                Trace.out("Will remove values for cardinality: " + ((Integer)remC.get(i) - 1));
                vmList.remove((Integer)remC.get(i) - 1);
                vmNameList.remove((Integer)remC.get(i) - 1);
                vmIdList.remove((Integer)remC.get(i) - 1);
                enableCard.remove((Integer)remC.get(i) - 1);
            }
            for (i = 0; i < newCardinality; ++i) {
                if ((Integer)enableCard.get(i) == 1) {
                    try {
                        this.m_crsResource.purgePerXCardinality(String.valueOf(i + 1), ResourceType.VirtualMachine.ENABLED.name());
                    }
                    catch (NotExistsException e) {
                        Trace.out("Enabled did not exist for this and can be safely ignored");
                    }
                } else {
                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.ENABLED.name(), String.valueOf(i + 1)), String.valueOf(enableCard.get(i))));
                }
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(i + 1)), vmList.get(i)));
                if (vmIdList.get(i) != null) {
                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_ID.name(), String.valueOf(i + 1)), vmIdList.get(i)));
                } else {
                    try {
                        this.m_crsResource.purgePerXCardinality(String.valueOf(i + 1), ResourceType.VirtualMachine.OVMM_VM_NAME.name());
                    }
                    catch (CRSException e) {
                        Trace.out("OVMM_VM_NAME or OVMM_VM_ID attribute may not have been created for cardinality ID: " + String.valueOf(i) + ". No need to throw exception");
                    }
                    catch (NotExistsException e) {
                        Trace.out("NotExistsException caused because of the PerXCardinality for cardinality ID: " + String.valueOf(i) + " doesn't exist: Ignored");
                    }
                }
                if (vmNameList.get(i) != null) {
                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_NAME.name(), String.valueOf(i + 1)), vmNameList.get(i)));
                    continue;
                }
                try {
                    this.m_crsResource.purgePerXCardinality(String.valueOf(i + 1), ResourceType.VirtualMachine.OVMM_VM_ID.name());
                    continue;
                }
                catch (CRSException e) {
                    Trace.out("OVMM_VM_NAME or OVMM_VM_ID attribute may not have been created for cardinality ID: " + String.valueOf(i) + ". No need to throw exception");
                    continue;
                }
                catch (NotExistsException e) {
                    Trace.out("NotExistsException caused because of the PerXCardinality for cardinality ID: " + String.valueOf(i) + " doesn't exist: Ignored");
                }
            }
            Trace.out("Purge excess cardinality-based attributes:");
            for (i = newCardinality + 1; i <= currCardinality; ++i) {
                this.m_crsResource.purgePerXCardinality(String.valueOf(i), ResourceType.VirtualMachine.VM.name());
                try {
                    this.m_crsResource.purgePerXCardinality(String.valueOf(i), ResourceType.VirtualMachine.ENABLED.name());
                }
                catch (CRSException e) {
                    Trace.out("OVMM_VM_NAME or OVMM_VM_ID attribute may not have been created for cardinality ID: " + String.valueOf(i) + ". No need to throw exception");
                }
                catch (NotExistsException e) {
                    Trace.out("NotExistsException caused because of the PerXCardinality for cardinality ID: " + String.valueOf(i) + " doesn't exist: Ignored");
                }
                try {
                    this.m_crsResource.purgePerXCardinality(String.valueOf(i), ResourceType.VirtualMachine.OVMM_VM_NAME.name());
                }
                catch (CRSException e) {
                    Trace.out("OVMM_VM_NAME or OVMM_VM_ID attribute may not have been created for cardinality ID: " + String.valueOf(i) + ". No need to throw exception");
                }
                catch (NotExistsException e) {
                    Trace.out("NotExistsException caused because of the PerXCardinality for cardinality ID: " + String.valueOf(i) + " doesn't exist: Ignored");
                }
                try {
                    this.m_crsResource.purgePerXCardinality(String.valueOf(i), ResourceType.VirtualMachine.OVMM_VM_ID.name());
                    continue;
                }
                catch (CRSException e) {
                    Trace.out("OVMM_VM_NAME or OVMM_VM_ID attribute may not have been created for cardinality ID: " + String.valueOf(i) + ". No need to throw exception");
                    continue;
                }
                catch (NotExistsException e) {
                    Trace.out("NotExistsException caused because of the PerXCardinality for cardinality ID: " + String.valueOf(i) + " doesn't exist: Ignored");
                }
            }
            Trace.out("Update new resource cardinality.");
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.CARDINALITY.name(), String.valueOf(newCardinality)));
            Trace.out("End of remove vm");
        }
        catch (CRSException e) {
            Trace.out("CRSException caught: " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.REMOVE_VM_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caused because of the PerXCardinality to be purged don't exist: Ignored");
        }
    }

    private void addVMHelper(List<String> vm) throws VMException {
        try {
            if (vm == null) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
            }
            Trace.out("Beginning of addVM");
            int currCardinality = this.getCardinality();
            int newCardinality = currCardinality + vm.size();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.CARDINALITY.name(), String.valueOf(newCardinality)));
            for (int i = 0; i < vm.size(); ++i) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(i + 1 + currCardinality)), vm.get(i)));
            }
            Trace.out("End of Add VM");
        }
        catch (CRSException e) {
            throw new VMException((MessageKey)PrCvMsgID.ADD_VM_FAILED, (Throwable)e, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    private void addWarning(VMWarningException e) {
        this.m_vmWarningList.add(e);
    }

    private String[] getVMNames() throws VMException {
        ArrayList<String> nameList = new ArrayList<String>();
        int cardinality = this.getCardinality();
        for (int i = 0; i < cardinality; ++i) {
            try {
                String vmName = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_NAME.name(), String.valueOf(i + 1))).getValue();
                nameList.add(vmName);
                continue;
            }
            catch (CRSException e) {
                Trace.out("The perX Attribute does not exist. Skipping and continuing.");
                nameList.add(null);
            }
        }
        Trace.out("VM Name attribute contains: " + this.convertStringArrayToListString(this.convertStringListToStringArray(nameList)));
        return this.convertStringListToStringArray(nameList);
    }

    private String[] getVMIDs() throws VMException {
        ArrayList<String> idList = new ArrayList<String>();
        int cardinality = this.getCardinality();
        for (int i = 0; i < cardinality; ++i) {
            try {
                String vmName = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_ID.name(), String.valueOf(i + 1))).getValue();
                idList.add(vmName);
                continue;
            }
            catch (CRSException e) {
                Trace.out("The perX Attribute does not exist. Skipping and continuing");
                idList.add(null);
            }
        }
        Trace.out("VM ID attribute contains: " + this.convertStringArrayToListString(this.convertStringListToStringArray(idList)));
        return this.convertStringListToStringArray(idList);
    }

    private String getInstanceID(String vm) throws VMException {
        if (null == vm || vm.isEmpty()) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        Trace.out("Trying to find Instance ID for " + vm);
        int vmCard = this.getCardinalityID(vm);
        if (vmCard == 0) {
            throw new VMException((MessageKey)PrCvMsgID.VM_NOT_FOUND, VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
        Trace.out("Instance ID: " + this.m_nameAttr.getValue() + " " + vmCard + " 1");
        return this.m_nameAttr.getValue() + " " + String.valueOf(vmCard) + " 1";
    }

    private int getCardinalityID(String vm) throws VMException {
        String vmCompare;
        int i;
        if (null == vm || vm.isEmpty()) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vm");
        }
        Trace.out("Trying to find carridnality ID for " + vm);
        int cardinality = this.getCardinality();
        int cardinalityID = 0;
        for (i = 0; i < cardinality && cardinalityID == 0; ++i) {
            try {
                vmCompare = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_ID.name(), String.valueOf(i + 1))).getValue();
                if (!vmCompare.trim().equals(vm.trim())) continue;
                Trace.out(vm + " was found at cardinality ID " + String.valueOf(cardinalityID));
                cardinalityID = i + 1;
                continue;
            }
            catch (CRSException e) {
                Trace.out("The perX Attribute does not exist. Skipping and continuing search");
            }
        }
        for (i = 0; i < cardinality && cardinalityID == 0; ++i) {
            try {
                vmCompare = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_NAME.name(), String.valueOf(i + 1))).getValue();
                if (!vmCompare.trim().equals(vm.trim())) continue;
                Trace.out(vm + " was found at cardinality ID " + String.valueOf(cardinalityID));
                cardinalityID = i + 1;
                continue;
            }
            catch (CRSException e) {
                Trace.out("The perX Attribute does not exist. Skipping and continuing search");
            }
        }
        for (i = 0; i < cardinality && cardinalityID == 0; ++i) {
            try {
                vmCompare = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(i + 1))).getValue();
                if (!vmCompare.trim().equals(vm.trim())) continue;
                Trace.out(vm + " was found at cardinality ID " + String.valueOf(cardinalityID));
                cardinalityID = i + 1;
                continue;
            }
            catch (CRSException e) {
                Trace.out("The perX Attribute does not exist. Skipping and continuing search");
            }
        }
        if (cardinalityID == 0) {
            Trace.out("No such vm " + vm + " was found");
            return 0;
        }
        return cardinalityID;
    }

    private String getVMID(int cardinalityID) throws VMException {
        try {
            String vmID = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_ID.name(), String.valueOf(cardinalityID))).getValue();
            Trace.out("VM ID for cardinality ID " + String.valueOf(cardinalityID) + " is " + vmID);
            return vmID;
        }
        catch (CRSException e) {
            Trace.out("VM ID not found at cardinalityID " + cardinalityID);
            return null;
        }
    }

    private String getVM(int cardinalityID) throws VMException {
        try {
            String vmName = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.VM.name(), String.valueOf(cardinalityID))).getValue();
            Trace.out("VM for cardinality ID " + String.valueOf(cardinalityID) + " is " + vmName);
            return vmName;
        }
        catch (CRSException e) {
            throw new VMException((MessageKey)PrCvMsgID.PERX_CARDINALITY_FAILED, String.valueOf(cardinalityID), VMImpl.getVMUniqueName(this.m_nameAttr.getValue()));
        }
    }

    private String getVMName(int cardinalityID) throws VMException {
        try {
            String vmName = this.m_crsResource.getAttribute(ResourceType.getPerXCardinalityName(ResourceType.VirtualMachine.OVMM_VM_NAME.name(), String.valueOf(cardinalityID))).getValue();
            Trace.out("VM name for cardinality ID " + String.valueOf(cardinalityID) + " is " + vmName);
            return vmName;
        }
        catch (CRSException e) {
            Trace.out("VM name not found at cardinalityID " + cardinalityID);
            return null;
        }
    }

    private VMDetail getVMDetail(int cardinalityID) throws VMException {
        String vmResourceName = VMImpl.getVMUniqueName(this.m_nameAttr.getValue());
        String vm = this.getVM(cardinalityID);
        String vmName = this.getVMName(cardinalityID);
        String vmID = this.getVMID(cardinalityID);
        VMDetail.VMState vmNameState = vmName == null ? VMDetail.VMState.NOTPROCESSED : (vmName.isEmpty() ? VMDetail.VMState.INVALID : VMDetail.VMState.AVAILABLE);
        VMDetail.VMState vmIDState = vmID == null ? VMDetail.VMState.NOTPROCESSED : (vmID.isEmpty() ? VMDetail.VMState.INVALID : VMDetail.VMState.AVAILABLE);
        boolean isEnabled = this.isEnabledVM(vm);
        Trace.out("VMDetail object created for " + vmResourceName + " at cardinalityID " + cardinalityID);
        Trace.out("vm = " + vm + " vmName = " + vmName + " vmID = " + vmID);
        return this.createVMDetail(vmResourceName, vm, vmName, vmID, vmNameState, vmIDState, isEnabled, cardinalityID);
    }
}

