/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.vm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.vm.OVMMImpl;
import oracle.cluster.impl.vm.VMImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCvMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.cluster.vm.OVMM;
import oracle.cluster.vm.OVMMArgs;
import oracle.cluster.vm.OVMMException;
import oracle.cluster.vm.VM;
import oracle.cluster.vm.VMArgs;
import oracle.cluster.vm.VMDetail;
import oracle.cluster.vm.VMException;
import oracle.cluster.vm.VMWarningException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class VMFactoryImpl {
    private static VMFactoryImpl s_vmFactoryImpl;

    private VMFactoryImpl() throws SoftwareModuleException {
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
        }
        catch (SRVMContextException sce) {
            throw new SoftwareModuleException(sce);
        }
    }

    public static synchronized VMFactoryImpl getInstance() throws SoftwareModuleException {
        if (s_vmFactoryImpl == null) {
            s_vmFactoryImpl = new VMFactoryImpl();
        }
        return s_vmFactoryImpl;
    }

    public VM createVM(VMArgs args) throws VMException, AlreadyExistsException, VMWarningException {
        try {
            OVMM ovmmLocal = this.getOVMM();
            Trace.out("getOVMM() succeeded - OVMM exists");
        }
        catch (NotExistsException nee) {
            Trace.out("Throwing exception since OVMM was not configured");
            throw new VMException((MessageKey)PrCvMsgID.VM_CREATE_FAIL_OVMM, args.getName());
        }
        catch (OVMMException oe) {
            Trace.out("OVMMException caught in checking OVMM status before creating VM resource");
            throw new VMException((MessageKey)PrCvMsgID.VM_CREATE_FAIL_OVMM, (Throwable)oe, args.getName());
        }
        if (null == args) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        try {
            if (args.getName() != null) {
                if (args.getName().isEmpty()) {
                    throw new VMException((MessageKey)PrCvMsgID.VM_CREATE_EMPTY_NAME, new Object[0]);
                }
                VMImpl vmImpl = new VMImpl(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.NAME.name(), VMImpl.getResourceName(args.getName())), true);
                vmImpl.create(args);
                return vmImpl;
            }
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "VM Name");
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for createVM: " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_CREATE_FAILED, (Throwable)e, args.getName());
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught for createVM: " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.VM_CREATE_FAILED, (Throwable)e, args.getName());
        }
    }

    public VM getVM(String vmName) throws VMException, NotExistsException {
        try {
            if (null == vmName) {
                throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vmName");
            }
            VMImpl vmImpl = new VMImpl(CRSFactoryImpl.getInstance().create(ResourceType.VirtualMachine.NAME.name(), VMImpl.getResourceName(vmName)));
            return vmImpl;
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for createVM: " + e.getMessage());
            throw new VMException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for createVM: " + e.getMessage());
            throw new VMException(e);
        }
    }

    public static List<VM> getVMRes() throws VMException {
        try {
            VMFactoryImpl.getInstance();
            List<String> vmNameList = VMFactoryImpl.convertStringArrayToStringList(VMFactoryImpl.getVMResNames());
            ArrayList<VM> vmList = new ArrayList<VM>(vmNameList.size());
            for (String vmName : vmNameList) {
                vmList.add(s_vmFactoryImpl.getVM(vmName));
            }
            return vmList;
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException caught for createVM: " + e.getMessage());
            throw new VMException(e);
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException caught for createVM: " + e.getMessage());
            throw new VMException(e);
        }
    }

    public static String[] getVMResNames() throws VMException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter vmTypeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.VirtualMachine.NAME.toString());
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, vmTypeFilter, ResourceType.VirtualMachine.NAME.name());
            ArrayList<String> vmList = new ArrayList<String>();
            Trace.out("Retrieving list of VM resources");
            for (String riID : resultData.keySet()) {
                Map<String, String> valueMap = resultData.get(riID);
                for (String attrName : valueMap.keySet()) {
                    String attrValue = valueMap.get(attrName);
                    if (!attrName.equalsIgnoreCase(ResourceType.VirtualMachine.NAME.name())) continue;
                    vmList.add(attrValue.split("\\.")[1]);
                }
            }
            return VMFactoryImpl.convertStringListToStringArray(vmList);
        }
        catch (CRSException e) {
            Trace.out("CRSException caught for createVM: " + e.getMessage());
            throw new VMException((MessageKey)PrCvMsgID.ERROR_VM_SEARCH, (Throwable)e, new Object[]{null});
        }
    }

    public static Map<String, List<String>> validateVMs(String[] vmInstArr) throws VMException {
        if (null == vmInstArr) {
            throw new VMException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vmInstArr");
        }
        HashMap<String, List<String>> vmMap = new HashMap<String, List<String>>();
        List<String> vmInstList = VMFactoryImpl.convertStringArrayToStringList(vmInstArr);
        List<VM> vmList = VMFactoryImpl.getVMRes();
        for (VM vm : vmList) {
            List<VMDetail> vmDetailList = vm.getVMDetail();
            ArrayList<String> vmContents = new ArrayList<String>();
            ArrayList<String> vmNameContents = new ArrayList<String>();
            ArrayList<String> vmIdContents = new ArrayList<String>();
            for (int i = 0; i < vmDetailList.size(); ++i) {
                vmContents.add(vmDetailList.get(i).getUserProvidedName());
                vmNameContents.add(vmDetailList.get(i).getVMName());
                vmIdContents.add(vmDetailList.get(i).getVMID());
            }
            vmContents.retainAll(vmInstList);
            vmNameContents.retainAll(vmInstList);
            vmIdContents.retainAll(vmInstList);
            if (vmContents.isEmpty() && vmNameContents.isEmpty() && vmIdContents.isEmpty()) continue;
            HashSet<String> combinedSet = new HashSet<String>(vmContents);
            combinedSet.addAll(vmNameContents);
            combinedSet.addAll(vmIdContents);
            ArrayList combined = new ArrayList(combinedSet);
            String traceOutput = "Following VMs are present in Resource " + vm.getName() + ": ";
            for (String common : combined) {
                traceOutput = traceOutput + common + " ";
            }
            Trace.out(traceOutput);
            vmMap.put(vm.getName(), combined);
        }
        return vmMap;
    }

    public OVMM createOVMM(OVMMArgs ovmmArgs) throws AlreadyExistsException, OVMMException {
        OVMMImpl ovmmImpl = new OVMMImpl();
        ovmmImpl.create(ovmmArgs);
        return ovmmImpl;
    }

    public OVMM getOVMM() throws NotExistsException, OVMMException {
        OVMMImpl ovmmImpl = new OVMMImpl();
        ovmmImpl.loadAttributes();
        return ovmmImpl;
    }

    private static String[] convertStringListToStringArray(List<String> strList) {
        String[] strArray = new String[strList.size()];
        strArray = strList.toArray(strArray);
        return strArray;
    }

    private static List<String> convertStringArrayToStringList(String[] strArray) {
        return new ArrayList<String>(Arrays.asList(strArray));
    }
}

