/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot.events;

import java.util.LinkedList;
import java.util.Map;
import oracle.clsce.EventHandler;
import oracle.cluster.impl.snapshot.events.Event;
import oracle.cluster.impl.snapshot.events.EventProcessor;
import oracle.cluster.impl.snapshot.events.ResourceEvent;
import oracle.cluster.impl.snapshot.events.ResourceInstanceEvent;
import oracle.cluster.impl.snapshot.events.ServerEvent;
import oracle.cluster.impl.snapshot.events.ServerPoolEvent;
import oracle.ops.mgmt.trace.Trace;

public class SnapshotEventHandler
implements EventHandler {
    private EventProcessor m_evtProcessorCb;
    private LinkedList<Event> m_evts;

    SnapshotEventHandler(EventProcessor evtProcessorCb) {
        this.m_evtProcessorCb = evtProcessorCb;
        this.m_evts = new LinkedList();
    }

    public void handleEvent(oracle.clsce.Event event, int flag) {
        if (flag != 0) {
            Trace.out("Error from event subscription: " + flag);
            return;
        }
        String evtType = event.getType();
        Map evtData = event.getDataMap();
        Map evtProp = event.getPropertyMap();
        Trace.out("event type = " + evtType);
        for (Map.Entry entry : evtData.entrySet()) {
            Trace.out("<%s,%s>", entry.getKey(), entry.getValue());
        }
        if (evtType.equals("CRS_RESOURCE_STATE_CHANGE") || evtType.equals("CRS_RESOURCE_PROFILE_CHANGE")) {
            this.handleResourceEvt(evtType, evtProp, evtData);
        } else if (evtType.equals("CRS_SERVER_STATE_CHANGE")) {
            this.handleServerEvt(evtProp, evtData);
        } else if (evtType.equals("CRS_SERVER_POOL_PROFILE_CHANGE") || evtType.equals("CRS_SERVER_POOL_STATE_CHANGE")) {
            Trace.out("Type is " + evtType + "; size is " + this.m_evts.size());
            this.handleSrvPoolEvt(evtProp, evtData);
            Trace.out("\t\tsize is " + this.m_evts.size());
        } else if (evtType.equals("EONS_TEST_QUIT")) {
            Event evt = new Event(Event.EvtType.TESTEXIT, evtData);
            this.m_evts.add(evt);
        } else {
            Trace.out("event dropped, unknown event type " + evtType.toString());
        }
        Trace.out("number of events = " + this.m_evts.size());
        if (this.isLogicalEvent()) {
            Trace.out("collected %d events", this.m_evts.size());
            for (Event e : this.m_evts) {
                Trace.out("********* " + e);
            }
            this.m_evtProcessorCb.processEvents(this.m_evts);
            this.m_evts.clear();
        }
    }

    private void handleResourceEvt(String evtType, Map<String, String> evtProp, Map<String, String> evtData) {
        if (evtType.equals("CRS_RESOURCE_PROFILE_CHANGE")) {
            this.m_evts.add(new ResourceEvent(evtProp, evtData));
        } else if (evtType.equals("CRS_RESOURCE_STATE_CHANGE")) {
            this.m_evts.add(new ResourceInstanceEvent(evtProp, evtData));
        } else {
            Trace.out("Unknown event type " + evtType);
        }
    }

    private void handleServerEvt(Map<String, String> evtProp, Map<String, String> evtData) {
        ServerEvent srvEvt = new ServerEvent(evtData);
        this.m_evts.add(srvEvt);
    }

    private void handleSrvPoolEvt(Map<String, String> evtProp, Map<String, String> evtData) {
        ServerPoolEvent srvPoolEvt = new ServerPoolEvent(evtProp, evtData);
        this.m_evts.add(srvPoolEvt);
    }

    private boolean isLogicalEvent() {
        boolean logicalEvent = false;
        for (Event evt : this.m_evts) {
            if (evt.getType() == Event.EvtType.TESTEXIT) {
                logicalEvent = true;
                break;
            }
            Map<String, String> evtData = evt.getDataMap();
            String txnPart = evtData.get("TRANSACTION_PART");
            String txnSize = evtData.get("TRANSACTION_SIZE");
            Trace.out("txnPart: " + txnPart + " txnSize: " + txnSize);
            if (txnPart == null || txnSize == null) {
                logicalEvent = true;
                continue;
            }
            if (!txnPart.trim().equals(txnSize.trim())) continue;
            logicalEvent = true;
        }
        return logicalEvent;
    }
}

