/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot.events;

import oracle.clsce.ClusterEvents;
import oracle.clsce.ClusterEventsException;
import oracle.clsce.EventHandler;
import oracle.clsce.impl.ClusterEventsNative;
import oracle.cluster.impl.snapshot.events.EventProcessor;
import oracle.cluster.impl.snapshot.events.SnapshotEventHandler;
import oracle.ops.mgmt.trace.Trace;

public class EventSubscriber {
    private EventProcessor m_evtProcessorCb;
    private ClusterEvents m_clusterEvtSubscriber;
    private String m_filter;
    private int m_flags;

    public EventSubscriber(EventProcessor evtProcessorCb) {
        this.m_evtProcessorCb = evtProcessorCb;
    }

    private void setFilter(String filter) {
        this.m_filter = filter;
    }

    private void setFlags(boolean sync) {
        this.m_flags = 0;
        if (!sync) {
            this.m_flags = 1;
        }
    }

    public String getFilter() {
        return this.m_filter;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public EventProcessor getEvtProcessorCb() {
        return this.m_evtProcessorCb;
    }

    public void unsubscribe() throws ClusterEventsException {
        try {
            this.m_clusterEvtSubscriber.unsubscribe();
        }
        catch (ClusterEventsException cee) {
            Trace.out("ClusterEventsException caught: " + cee.getMessage());
            throw cee;
        }
    }

    public void subscribe() throws ClusterEventsException {
        SnapshotEventHandler evtHandler = new SnapshotEventHandler(this.m_evtProcessorCb);
        this.setFilter("*");
        this.setFlags(false);
        try {
            this.m_clusterEvtSubscriber = new ClusterEventsNative(0);
            Trace.out("filter = " + this.m_filter + " flags = " + this.m_flags);
            Trace.out("Subscribing to Cluster events.. ");
            this.m_clusterEvtSubscriber.subscribe(this.m_filter, (EventHandler)evtHandler, this.m_flags);
            Trace.out("Subscribed to Cluster events");
        }
        catch (ClusterEventsException cee) {
            Trace.out("ClusterEventsException caught: " + cee.getMessage());
            throw cee;
        }
    }
}

