/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.Cache;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.snapshot.Snapshot;
import oracle.cluster.snapshot.SnapshotException;
import oracle.cluster.snapshot.SnapshotFatalException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class SnapshotImpl
implements Snapshot {
    private static String s_dbType = ResourceType.Database.NAME.toString();
    private static String s_serviceType = ResourceType.Service.NAME.toString();
    private long m_seqNumber = -1L;
    private Map<String, Map<String, String>> m_resources = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_ris = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_pools = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> m_servers = new LinkedHashMap<String, Map<String, String>>();
    private List<Database> m_dbList = new LinkedList<Database>();
    private List<Service> m_serviceList = new LinkedList<Service>();
    private List<Server> m_serverList = new LinkedList<Server>();
    private List<ServerPool> m_poolList = new LinkedList<ServerPool>();

    @Override
    public long seqNumber() {
        return this.m_seqNumber;
    }

    @Override
    public List<Database> databases() {
        return Collections.unmodifiableList(this.m_dbList);
    }

    @Override
    public Database database(String uniqueName) throws NotExistsException {
        String resName = DatabaseFactory.getDatabaseResourceName(uniqueName);
        for (Database db : this.m_dbList) {
            if (!db.getName().equals(resName)) continue;
            return db;
        }
        throw new NotExistsException((MessageKey)PrCrMsgID.SNAP_DB_NOT_EXISTS, uniqueName);
    }

    @Override
    public List<Service> services() {
        return Collections.unmodifiableList(this.m_serviceList);
    }

    @Override
    public List<Server> servers() {
        return Collections.unmodifiableList(this.m_serverList);
    }

    @Override
    public Server server(String nodeName) throws NotExistsException {
        for (Server serv : this.m_serverList) {
            if (!nodeName.equalsIgnoreCase(serv.getName())) continue;
            return serv;
        }
        throw new NotExistsException((MessageKey)PrCrMsgID.SNAP_SERVER_NOT_EXISTS, nodeName);
    }

    @Override
    public List<ServerPool> serverPools() {
        return Collections.unmodifiableList(this.m_poolList);
    }

    SnapshotImpl(long seqNumber, Map<String, Map<String, String>> resources, Map<String, Map<String, String>> ris, Map<String, Map<String, String>> pools, Map<String, Map<String, String>> servers) throws SnapshotException {
        ServerFactoryImpl sFactory;
        DatabaseFactoryImpl dbf;
        LinkedHashMap<String, String> wrkMap = null;
        this.m_seqNumber = seqNumber;
        for (String resourceName : resources.keySet()) {
            wrkMap = new LinkedHashMap<String, String>();
            wrkMap.putAll(resources.get(resourceName));
            this.m_resources.put(resourceName, wrkMap);
        }
        for (String riName : ris.keySet()) {
            wrkMap = new LinkedHashMap();
            wrkMap.putAll(ris.get(riName));
            this.m_ris.put(riName, wrkMap);
        }
        for (String spName : pools.keySet()) {
            wrkMap = new LinkedHashMap();
            wrkMap.putAll(pools.get(spName));
            this.m_pools.put(spName, wrkMap);
        }
        for (String serverName : servers.keySet()) {
            wrkMap = new LinkedHashMap();
            wrkMap.putAll(servers.get(serverName));
            this.m_servers.put(serverName, wrkMap);
        }
        try {
            dbf = DatabaseFactoryImpl.getInstance();
            sFactory = ServerFactoryImpl.getInstance();
        }
        catch (SoftwareModuleException e) {
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ServerException se) {
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)se, new Object[0]);
        }
        for (Map.Entry<String, Map<String, String>> entry : resources.entrySet()) {
            String eName = entry.getKey();
            Map<String, String> eMap = entry.getValue();
            String eType = this.getEntityType(eMap);
            if (eType == null) continue;
            if (eType.equals(s_dbType)) {
                try {
                    Database database = dbf.createSnapshotDatabase(eName, this);
                    Trace.out("databse : %s, Attrs: %s", eName, eMap);
                    this.m_dbList.add(database);
                    continue;
                }
                catch (DatabaseException e) {
                    throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
                }
            }
            if (!eType.equals(s_serviceType)) continue;
            try {
                Service service = dbf.createSnapshotService(eName, this);
                this.m_serviceList.add(service);
            }
            catch (ServiceException e) {
                throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
            }
        }
        for (Map.Entry<String, Map<String, String>> spEntry : pools.entrySet()) {
            String spName = spEntry.getKey();
            Map<String, String> spMap = spEntry.getValue();
            String parents = spMap.get(ResourceType.ServerPool.PARENT_POOLS.name());
            if (parents != null && !parents.trim().isEmpty()) {
                Trace.out("Ignoring sp : %s, parents: %s", spName, parents);
                continue;
            }
            try {
                ServerPool sp = sFactory.createSnapshotServerPool(spName, this);
                this.m_poolList.add(sp);
                Trace.out((Object)"server poool %s added into the list", spName);
            }
            catch (ServerGroupException e) {
                throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
            }
        }
        for (String serverName : this.m_servers.keySet()) {
            try {
                Server server = sFactory.createSnapshotServer(serverName, this);
                this.m_serverList.add(server);
            }
            catch (ServerException e) {
                throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAPSHOT_BUILD_FAILED, (Throwable)e, new Object[0]);
            }
        }
    }

    public Map<String, Map<String, String>> resourcesMap() {
        return this.m_resources;
    }

    public Map<String, Map<String, String>> risMap() {
        return this.m_ris;
    }

    public Map<String, Map<String, String>> poolsMap() {
        return this.m_pools;
    }

    public Map<String, Map<String, String>> serversMap() {
        return this.m_servers;
    }

    public String getAttrValue(Cache.EntityType type, String entityName, String attrName) {
        Map<String, String> entity = this.getEntity(type, entityName);
        if (entity == null) {
            return null;
        }
        return entity.get(attrName);
    }

    public Map<String, String> getAttributes(Cache.EntityType type, String entityName, String ... attrNames) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Map<String, String> entity = this.getEntity(type, entityName);
        if (entity == null) {
            Trace.out(String.format("Snap: entity %s not found", entityName));
            return null;
        }
        if (attrNames != null && attrNames.length > 0) {
            for (String attrName : attrNames) {
                String attrXName = String.format("%s@SERVERNAME(", attrName);
                for (Map.Entry<String, String> eAttr : entity.entrySet()) {
                    String entAttrName = eAttr.getKey();
                    if (entAttrName.equals(attrName)) {
                        result.put(attrName, eAttr.getValue());
                    }
                    if (!entAttrName.startsWith(attrXName)) continue;
                    result.put(entAttrName, eAttr.getValue());
                }
            }
        } else {
            for (Map.Entry<String, String> en : entity.entrySet()) {
                result.put(en.getKey(), en.getValue());
            }
        }
        return result;
    }

    Map<String, String> getEntity(Cache.EntityType type, String entityName) {
        switch (type) {
            case Resource: {
                return this.m_resources.get(entityName);
            }
            case RInstance: {
                return this.m_ris.get(entityName);
            }
            case Server: {
                return this.m_servers.get(entityName);
            }
            case ServerPool: {
                return this.m_pools.get(entityName);
            }
        }
        return null;
    }

    public Version getResourceVersion(String resourceName) {
        Version version = null;
        String versionString = this.getAttrValue(Cache.EntityType.Resource, resourceName, ResourceType.LocalResource.VERSION.name());
        if (versionString == null) {
            version = new Version();
        } else {
            try {
                version = Version.getVersion(versionString);
            }
            catch (ConfigurationException e) {
                version = new Version();
            }
        }
        return version;
    }

    public String getDBUniqueName(String resourceName) {
        return this.getAttrValue(Cache.EntityType.Resource, resourceName, ResourceType.Database.DB_UNIQUE_NAME.name());
    }

    public String getServiceName(String resourceName) {
        return this.getAttrValue(Cache.EntityType.Resource, resourceName, ResourceType.Service.SERVICE_NAME.name());
    }

    String getEntityType(Map<String, String> entity) {
        return entity.get(ResourceLiterals.TYPE.name());
    }
}

