/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.snapshot;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.clsce.ClusterEventsException;
import oracle.cluster.impl.snapshot.Cache;
import oracle.cluster.impl.snapshot.SnapshotFactoryImpl;
import oracle.cluster.impl.snapshot.events.Event;
import oracle.cluster.impl.snapshot.events.EventProcessor;
import oracle.cluster.impl.snapshot.events.EventSubscriber;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.snapshot.Snapshot;
import oracle.cluster.snapshot.SnapshotActiveVersionException;
import oracle.cluster.snapshot.SnapshotException;
import oracle.cluster.snapshot.SnapshotFactory;
import oracle.cluster.snapshot.SnapshotFatalException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class CacheController
extends Thread
implements EventProcessor {
    private Cache m_cache = null;
    private boolean m_runningFlag = false;
    private EventSubscriber m_eventSubscriber = null;
    private ClusterEventsException m_clsceException = null;
    private boolean m_subscribed = false;
    private SnapshotException m_snapException = null;
    private List<Event> eventQueue = new LinkedList<Event>();
    private List<SnapshotFactory.SnapshotListener> m_snapListeners = new CopyOnWriteArrayList<SnapshotFactory.SnapshotListener>();
    private static CacheController s_cacheController = null;

    static CacheController getInstance() {
        if (s_cacheController == null) {
            s_cacheController = new CacheController();
        }
        return s_cacheController;
    }

    boolean isRunning() {
        return this.m_runningFlag;
    }

    boolean isReady() {
        return this.m_cache.isReady();
    }

    long lastSeqN() {
        return this.m_cache.getSeqN();
    }

    Snapshot getSnapshot() throws SnapshotException {
        if (this.isRunning()) {
            return this.m_cache.createSnapshot();
        }
        if (this.m_snapException != null) {
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_NOT_RUNNING, (Throwable)this.m_snapException, new Object[0]);
        }
        throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_NOT_RUNNING, new Object[0]);
    }

    void addSnapshotListener(SnapshotFactory.SnapshotListener listener) throws SnapshotException {
        if (listener == null) {
            throw new SnapshotException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "listener");
        }
        if (!this.m_snapListeners.contains(listener)) {
            this.m_snapListeners.add(listener);
        }
    }

    public void removeSnapshotListener(SnapshotFactory.SnapshotListener listener) throws SnapshotException {
        if (listener == null) {
            throw new SnapshotException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "listener");
        }
        this.m_snapListeners.remove(listener);
    }

    private CacheController() {
        this.m_cache = Cache.getInstance();
        this.m_eventSubscriber = new EventSubscriber(this);
    }

    private void cleanUp() {
        this.m_runningFlag = false;
        this.m_cache.clear();
        if (this.m_eventSubscriber == null) {
            try {
                this.m_eventSubscriber.unsubscribe();
            }
            catch (ClusterEventsException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (SnapshotException e) {
            this.m_snapException = e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_runningFlag = false;
    }

    private void execute() throws SnapshotException {
        this.m_runningFlag = true;
        block11: while (true) {
            this.checkInterrupt();
            if (this.m_subscribed) {
                try {
                    this.m_eventSubscriber.unsubscribe();
                }
                catch (ClusterEventsException e) {
                    e.printStackTrace();
                }
                this.m_subscribed = false;
            }
            try {
                this.m_eventSubscriber.subscribe();
                this.m_clsceException = null;
            }
            catch (ClusterEventsException e) {
                this.m_clsceException = e;
                throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_INIT_FAILED, (Throwable)e, new Object[0]);
            }
            this.m_subscribed = true;
            try {
                SnapshotFactoryImpl.initCache(this.m_cache);
                Trace.out("init cache done");
                this.m_snapException = null;
            }
            catch (SnapshotActiveVersionException e) {
                this.cleanUp();
                throw e;
            }
            catch (SnapshotException e) {
                this.cleanUp();
                throw e;
            }
            this.skipEvents();
            this.checkInterrupt();
            List<Event> lastEvents = null;
            this.m_cache.setReadyFlag(true);
            while (true) {
                try {
                    lastEvents = this.getNewEvents();
                }
                catch (InterruptedException e) {
                    this.cleanUp();
                    throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_INTERRUPTED, new Object[0]);
                }
                try {
                    Trace.out("about to handle %d events ", lastEvents.size());
                    this.handleEvents(lastEvents);
                }
                catch (SnapshotException e) {
                    Trace.out((Object)"Failed to handel events: %s", e.getMessage());
                    continue block11;
                }
            }
            break;
        }
    }

    private void checkInterrupt() throws SnapshotException {
        if (CacheController.interrupted()) {
            this.cleanUp();
            throw new SnapshotFatalException((MessageKey)PrCrMsgID.SNAP_INTERRUPTED, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipEvents() throws SnapshotException {
        long seqn = this.m_cache.getSeqN();
        List<Event> list = this.eventQueue;
        synchronized (list) {
            Trace.out("eventQueue.isEmpty():  " + this.eventQueue.isEmpty());
            if (this.eventQueue.isEmpty()) {
                return;
            }
            Iterator<Event> iter = this.eventQueue.iterator();
            while (iter.hasNext()) {
                Event ev = iter.next();
                long sn = Long.parseLong(ev.getSeqNum());
                if (sn > seqn) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getNewEvents() throws InterruptedException {
        LinkedList<Event> result = new LinkedList<Event>();
        List<Event> list = this.eventQueue;
        synchronized (list) {
            if (this.eventQueue.isEmpty()) {
                this.eventQueue.wait();
            }
            result.addAll(this.eventQueue);
            this.eventQueue.clear();
        }
        return result;
    }

    private void handleEvents(List<Event> lastEvents) throws SnapshotException {
        long seqN = 0L;
        HashMap<String, Map<String, String>> item = new HashMap<String, Map<String, String>>();
        int eventsCnt = 0;
        block7: for (Event ev : lastEvents) {
            ++eventsCnt;
            seqN = Long.parseLong(ev.getSeqNum());
            item.clear();
            item.put(ev.getEntityName(), ev.attributesMap());
            Trace.out("event : " + ev.toString());
            Trace.out("event MAP: " + ev.attributesMap());
            switch (ev.getType()) {
                case SERVERPOOL: {
                    this.m_cache.update(seqN, Cache.EntityType.ServerPool, item);
                    continue block7;
                }
                case SERVER: {
                    this.m_cache.update(seqN, Cache.EntityType.Server, item);
                    continue block7;
                }
                case DATABASE: 
                case SERVICE: {
                    this.m_cache.update(seqN, Cache.EntityType.Resource, item);
                    continue block7;
                }
                case RESOURCE_INSTANCE: {
                    this.m_cache.update(seqN, Cache.EntityType.RInstance, item);
                    continue block7;
                }
                case UNSUPPORTED: {
                    Trace.out("ignoring unsupported type");
                    continue block7;
                }
            }
            Trace.out((Object)"Unknown event type: %s", ev.getType().toString());
            --eventsCnt;
        }
        if (eventsCnt > 0 && !this.m_snapListeners.isEmpty()) {
            for (SnapshotFactory.SnapshotListener listener : this.m_snapListeners) {
                listener.entityUpdated(seqN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents(LinkedList<Event> evts) {
        List<Event> list = this.eventQueue;
        synchronized (list) {
            Trace.out("got events " + evts.size());
            this.eventQueue.addAll(evts);
            this.eventQueue.notifyAll();
        }
    }
}

