/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.server.SiteNativeException;
import oracle.cluster.impl.server.SiteNativeResult;
import oracle.cluster.server.Node;
import oracle.cluster.server.Site;
import oracle.cluster.server.SiteException;
import oracle.ops.mgmt.has.CRSContext;
import oracle.ops.mgmt.has.CRSContextException;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class SiteNative {
    private CRSContext m_ctx = null;

    SiteNative() throws SiteException {
        try {
            Trace.out("Calling CRSContext()");
            this.m_ctx = new CRSContext();
        }
        catch (CRSContextException e) {
            throw new SiteException(e);
        }
    }

    public boolean queryIsExtendedCluster() throws SiteNativeException {
        SiteNativeResult result = new SiteNativeResult();
        SiteNative.doCheckIsExtendedCluster(result);
        return result.IsExtendedCluster();
    }

    public List<Site> querySites() throws SiteNativeException, SiteException {
        return this.querySites(null);
    }

    public List<Site> querySites(List<Node> nodes) throws SiteNativeException, SiteException {
        SiteNativeResult result = new SiteNativeResult();
        SiteNative.doGetSites(result);
        List<Site> sites = result.getSites();
        if (nodes == null || nodes.size() == 0) {
            return sites;
        }
        try {
            if (nodes != null) {
                for (Node node : nodes) {
                    String nodeName = node.getName();
                    result.clearSiteGUID(nodeName);
                    SiteNative.doGetSiteForNode(result, nodeName);
                    String siteGUID = result.getSiteGUID(nodeName);
                    Trace.out("siteGUID is " + siteGUID);
                    if (siteGUID == null) {
                        Trace.out("Failed to get GUID for node " + nodeName);
                        continue;
                    }
                    for (Site site : sites) {
                        if (!siteGUID.equals(site.getSiteGUID())) continue;
                        Trace.out("Add node " + node.getName() + " to site " + site.getSiteName());
                        site.addNode(node);
                    }
                }
            }
        }
        catch (NodeException e) {
            throw new SiteException(e);
        }
        ArrayList<Site> usedSites = new ArrayList<Site>();
        for (Site site : sites) {
            if (site.getNodeList().size() <= 0) continue;
            usedSites.add(site);
        }
        return usedSites;
    }

    public static native long doCheckIsExtendedCluster(SiteNativeResult var0) throws SiteNativeException;

    public static native long doGetSites(SiteNativeResult var0) throws SiteNativeException;

    public static native long doGetSiteForNode(SiteNativeResult var0, String var1) throws SiteNativeException;
}

