/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSLocalEntityException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSServerCategoryEntity;
import oracle.cluster.impl.crs.CRSServerGroupEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerGroupLocalException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.server.ServerPoolArgs;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ServerPoolImpl
extends ManageableEntityImpl
implements ServerPool {
    protected ResourceAttribute m_nameAttr;
    protected CRSServerGroupEntity m_crsServerPool;

    protected ServerPoolImpl(ResourceAttribute nameAttr) throws ServerGroupException {
        this(nameAttr, null);
    }

    protected ServerPoolImpl(ResourceAttribute nameAttr, CRSEntity sibling) throws ServerGroupException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ServerPool.NAME.name())) {
                throw new ServerGroupException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ServerPool.NAME.name());
            }
            String value = nameAttr.getValue();
            if (value == null || value.trim().length() == 0) {
                throw new ServerGroupException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ServerPool.NAME.name(), "'" + value + "'");
            }
            this.m_nameAttr = nameAttr;
            this.m_name = nameAttr.getValue();
            this.m_displayName = this.m_name.startsWith("ora.") ? this.m_name.substring("ora.".length()) : this.m_name;
            Trace.out("m_name = " + this.m_name + ", m_displayName = " + this.m_displayName);
            this.m_crsServerPool = sibling == null ? CRSFactoryImpl.getInstance().getServerGroup(this.m_name) : CRSFactoryImpl.getInstance().getServerGroup(this.m_name, sibling);
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    ServerPoolImpl(String spName, SnapshotImpl snapshot) throws ServerGroupException {
        this.m_nameAttr = new ResourceAttribute(ResourceType.ServerPool.NAME.name(), spName);
        this.m_name = spName;
        this.m_displayName = this.m_name.startsWith("ora.") ? this.m_name.substring("ora.".length()) : this.m_name;
        try {
            this.m_crsServerPool = CRSFactoryImpl.getInstance().getSnapshotServerPool(spName, snapshot);
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    ServerPoolImpl(String spName, EntityOperations.EntityOpsMode mode) throws ServerGroupException {
        this.m_nameAttr = new ResourceAttribute(ResourceType.ServerPool.NAME.name(), spName);
        this.m_name = spName;
        this.m_displayName = this.m_name.startsWith("ora.") ? this.m_name.substring("ora.".length()) : this.m_name;
        try {
            this.m_crsServerPool = CRSFactoryImpl.getInstance().getServerPool(spName, mode);
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    static void evaluateServerPoolCreation(String poolName, int minSize, int maxSize, int importance, Server ... serverList) throws ServerGroupException {
        ServerPoolImpl.evaluateCreation(poolName, true, minSize, maxSize, importance, serverList);
    }

    static void evaluateCreation(String name, boolean serverPool, int minSize, int maxSize, int importance, Server[] serverList) throws ServerGroupException {
        try {
            String parent = null;
            if (!serverPool) {
                parent = ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString();
            }
            List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.ServerPool.class);
            ServerPoolImpl.makeAttrList(attrList, minSize, maxSize, importance, name, null, serverList, parent);
            CRSFactoryImpl.getInstance().getServerGroup(name).evaluateRegisterEntity(attrList);
        }
        catch (CRSException e) {
            StringBuilder sb = new StringBuilder();
            if (serverList != null && serverList.length != 0) {
                for (Server srv : serverList) {
                    if (sb.length() == 0) {
                        sb.append(srv.getUserAssignedName());
                        continue;
                    }
                    sb.append(',').append(srv.getUserAssignedName());
                }
            }
            if (serverPool) {
                throw new ServerGroupException((MessageKey)PrCsMsgID.EVAL_SRVPOOL_CREATION_FAILED, (Throwable)e, name, Integer.toString(minSize), Integer.toString(maxSize), Integer.toString(importance), sb.toString());
            }
            throw new ServerGroupException((MessageKey)PrCsMsgID.EVAL_SRVGRP_CREATION_FAILED, (Throwable)e, name, sb.toString());
        }
    }

    void create(boolean forceFlag, int minSize, int maxSize, int importance, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        String category = "";
        try {
            ServerFactory servFactory = ServerFactory.getInstance();
            category = servFactory.getDefaultCategory();
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        this.create(forceFlag, minSize, maxSize, importance, category, serverList);
    }

    void create(boolean forceFlag, int minSize, int maxSize, int importance, String category, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        String assignedName = this.getUserAssignedName();
        if (ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString().equals(assignedName) || ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString().equals(assignedName)) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SPNAME_CREATE_FAILED, assignedName);
        }
        try {
            String user = new Util().getCurrentUser();
            CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
            if (!crsFactoryImpl.hasCrsAdminRole(user)) {
                throw new ServerGroupException((MessageKey)PrCsMsgID.NO_CRS_ADMIN_ROLE, user);
            }
            if (!crsFactoryImpl.isRegistered(ResourceLiterals.HUB_CATEGORY.toString(), CRSEntity.Type.ServerCategory)) {
                Trace.out("Calling createHubRimCategory when creating srvpool");
                crsFactoryImpl.createHubRimCategory();
            }
            List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.ServerPool.class);
            ServerPoolImpl.makeAttrList(attrList, minSize, maxSize, importance, this.m_nameAttr.getName(), category, serverList, null);
            this.m_crsServerPool.register(attrList, forceFlag);
        }
        catch (UtilException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_CREATE_FAILED, (Throwable)e, assignedName);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCsMsgID.SP_ALREADY_EXISTS, (Throwable)e, assignedName);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_CREATE_FAILED, (Throwable)e, assignedName);
        }
        catch (ServerGroupException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_CREATE_FAILED, (Throwable)e, assignedName);
        }
    }

    public void modify(int minSize, int maxSize, int importance, String category) throws ServerGroupException, NotExistsException {
        ServerPoolArgs args = new ServerPoolArgs();
        args.setMinSize(minSize);
        args.setMaxSize(maxSize);
        args.setImportance(importance);
        args.setCategory(category);
        this.modify(false, args);
    }

    public void modify(int minSize, int maxSize, int importance, Server[] serverArray) throws ServerGroupException, NotExistsException {
        ServerPoolArgs args = new ServerPoolArgs();
        args.setMinSize(minSize);
        args.setMaxSize(maxSize);
        args.setImportance(importance);
        args.setServers(serverArray);
        this.modify(false, args);
    }

    @Override
    public void modify(boolean forceFlag, ServerPoolArgs args) throws ServerGroupException {
        ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
        this.modifyHelper(forceFlag, args, raList);
    }

    @Override
    public void modifyLocal(boolean forceFlag, ServerPoolArgs args) throws ServerGroupException {
        ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
        this.modifyHelper(forceFlag, args, raList, true);
    }

    void modifyHelper(boolean forceFlag, ServerPoolArgs args, List<ResourceAttribute> raList) throws ServerGroupException {
        this.modifyHelper(forceFlag, args, raList, false);
    }

    void modifyHelper(boolean forceFlag, ServerPoolArgs args, List<ResourceAttribute> raList, boolean isLocalSP) throws ServerGroupException {
        Server[] serverArray = args.getServers();
        Integer importance = args.getImportance();
        Integer minSize = args.getMinSize();
        Integer maxSize = args.getMaxSize();
        String category = args.getCategory();
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            if (category != null && serverArray != null) {
                throw new ServerGroupException((MessageKey)PrCsMsgID.SERVERS_CATEGORY_CONFLICT, this.getUserAssignedName());
            }
            if (category != null) {
                if (category.trim().equals("")) {
                    raList.add(cf.create(ResourceType.ServerPool.SERVER_CATEGORY.name(), ""));
                } else {
                    String serverNames = null;
                    if (cf.isRegistered(this.m_nameAttr.getValue(), CRSEntity.Type.ServerPool)) {
                        try {
                            serverNames = this.getValue(ResourceType.ServerPool.SERVER_NAMES.name());
                        }
                        catch (ServerGroupLocalException e) {
                            serverNames = null;
                        }
                    }
                    if (serverNames == null || serverNames.trim().equals("")) {
                        ServerFactory servFactory = ServerFactory.getInstance();
                        try {
                            ServerCategory serverCategory = servFactory.getServerCategory(category);
                            raList.add(cf.create(ResourceType.ServerPool.SERVER_CATEGORY.name(), serverCategory.getName()));
                        }
                        catch (NotExistsException ne) {
                            if (isLocalSP) {
                                raList.add(cf.create(ResourceType.ServerPool.SERVER_CATEGORY.name(), category));
                            }
                            throw ne;
                        }
                    } else {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.SERVER_NAMES_ALREADY_EXISTS, new Object[]{this.getUserAssignedName(), ResourceLiterals.SERVER_NAMES});
                    }
                }
            }
            if (serverArray != null) {
                if (serverArray.length == 0) {
                    raList.add(cf.create(ResourceType.ServerPool.SERVER_NAMES.name(), ""));
                } else {
                    String categoryAttr = null;
                    if (cf.isRegistered(this.m_nameAttr.getValue(), CRSEntity.Type.ServerPool)) {
                        categoryAttr = this.getValue(ResourceType.ServerPool.SERVER_CATEGORY.name());
                    }
                    if (categoryAttr == null || categoryAttr.trim().equals("")) {
                        String[] serverNames = new String[serverArray.length];
                        for (int i = 0; i < serverArray.length; ++i) {
                            try {
                                serverNames[i] = serverArray[i].node().getName();
                                continue;
                            }
                            catch (ServerException e) {
                                throw new ServerGroupException(e);
                            }
                            catch (NodeException e) {
                                throw new ServerGroupException(e);
                            }
                        }
                        raList.add(cf.create(ResourceType.ServerPool.SERVER_NAMES.name(), Utils.getString(serverNames, String.valueOf(" "))));
                    } else {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.SERVER_CATEGORY_ALREADY_EXISTS, new Object[]{this.getUserAssignedName(), ResourceLiterals.SERVER_CATEGORY_ATTR_NAME});
                    }
                }
            }
            if (importance != null) {
                if (importance >= 0) {
                    raList.add(cf.create(ResourceType.ServerPool.IMPORTANCE.name(), String.valueOf(importance)));
                } else {
                    throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_IMPORTANCE, importance);
                }
            }
            if (minSize != null && maxSize != null && maxSize > -1 && minSize > maxSize) {
                throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
            }
            if (minSize != null) {
                if (minSize >= 0) {
                    raList.add(cf.create(ResourceType.ServerPool.MIN_SIZE.name(), String.valueOf(minSize)));
                } else {
                    throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
                }
            }
            if (maxSize != null) {
                if (maxSize >= -1) {
                    raList.add(cf.create(ResourceType.ServerPool.MAX_SIZE.name(), String.valueOf(maxSize)));
                } else {
                    throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MAX_SIZE, maxSize);
                }
            }
            ResourceAttribute[] attrArr = new ResourceAttribute[raList.size()];
            this.m_crsServerPool.update(forceFlag, raList.toArray(attrArr));
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    public CRSEntity crsEntity() throws NotExistsException, ServerGroupException {
        try {
            if (this.m_crsServerPool == null || !this.m_crsServerPool.isRegistered()) {
                throw new NotExistsException((MessageKey)PrCrMsgID.SERVER_POOL_NOT_EXISTS, this.m_crsServerPool != null ? this.m_crsServerPool.entityName() : this.getName());
            }
            return this.m_crsServerPool;
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public int getCurrentSize() throws ServerGroupException {
        return this.servers().size();
    }

    @Override
    public int getMinSize() throws ServerGroupException {
        return Integer.parseInt(this.getValue(ResourceType.ServerPool.MIN_SIZE.name()));
    }

    @Override
    public int getMaxSize() throws ServerGroupException {
        return Integer.parseInt(this.getValue(ResourceType.ServerPool.MAX_SIZE.name()));
    }

    @Override
    public int getImportance() throws ServerGroupException {
        return Integer.parseInt(this.getValue(ResourceType.ServerPool.IMPORTANCE.name()));
    }

    @Override
    public boolean hasExecutePermissions() throws ServerGroupException {
        throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_FAILED, "NOT IMPLEMENTED YET");
    }

    @Override
    public boolean hasUpdatePermissions() throws ServerGroupException {
        throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_FAILED, "NOT IMPLEMENTED YET");
    }

    @Override
    public void setImportance(int importance) throws ServerGroupException {
        if (importance < -1) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_IMPORTANCE, importance);
        }
        this.setValue(ResourceType.ServerPool.IMPORTANCE, String.valueOf(importance));
    }

    @Override
    public void setMinSize(int minSize) throws ServerGroupException {
        int maxSize = 99999;
        try {
            maxSize = Integer.parseInt(this.getValue(ResourceType.ServerPool.MAX_SIZE.name()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (minSize < 0 || minSize > maxSize && maxSize != -1) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MIN_SIZE, minSize);
        }
        this.setValue(ResourceType.ServerPool.MIN_SIZE, String.valueOf(minSize));
    }

    @Override
    public void setMaxSize(int maxSize) throws ServerGroupException {
        int minSize = 0;
        try {
            minSize = Integer.parseInt(this.getValue(ResourceType.ServerPool.MIN_SIZE.name()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxSize != -1 && (maxSize < minSize || maxSize < -1)) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.INVALID_MAX_SIZE, maxSize);
        }
        Trace.out("Set max size: " + maxSize);
        this.setValue(ResourceType.ServerPool.MAX_SIZE, String.valueOf(maxSize));
    }

    public void setServers(Server[] serverArray) throws ServerGroupException {
        this.setServers(false, serverArray);
    }

    public void setServers(boolean forceFlag, Server[] serverArray) throws ServerGroupException {
        if (serverArray == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverArray", serverArray);
        }
        String[] serverNames = new String[serverArray.length];
        for (int i = 0; i < serverArray.length; ++i) {
            try {
                serverNames[i] = serverArray[i].node().getName();
                continue;
            }
            catch (ServerException e) {
                throw new ServerGroupException(e);
            }
            catch (NodeException e) {
                throw new ServerGroupException(e);
            }
        }
        this.setValue(forceFlag, ResourceType.ServerPool.SERVER_NAMES, Utils.getString(serverNames, String.valueOf(" ")));
    }

    @Override
    public List<Server> candidateServers() throws ServerGroupException {
        return this.serversHelper(false);
    }

    @Override
    public List<Server> servers() throws ServerGroupException {
        return this.serversHelper(true);
    }

    private List<Server> serversHelper(boolean bActiveServers) throws ServerGroupException {
        try {
            List<String> serverList = this.serversHelper2(bActiveServers);
            ArrayList<Server> list = new ArrayList<Server>(serverList.size());
            for (String serverName : serverList) {
                list.add(this.m_crsServerPool.getServer(serverName));
            }
            return list;
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
    }

    private List<String> serversHelper2(boolean bActiveServers) throws ServerGroupException {
        try {
            String attrName = bActiveServers ? ResourceLiterals.ACTIVE_SERVERS.toString() : ResourceType.ServerPool.SERVER_NAMES.name();
            String attrValue = this.getValue(attrName);
            Trace.out("attrValue=" + attrValue);
            if (attrValue.length() == 0) {
                return new ArrayList<String>(0);
            }
            String[] serverNames = attrValue.split(String.valueOf(" "));
            ArrayList<String> serverList = new ArrayList<String>(serverNames.length);
            for (String server : serverNames) {
                serverList.add(server);
            }
            return serverList;
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public void addServers(List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        this.addServers(false, serverList);
    }

    @Override
    public void addServers(boolean forceFlag, List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        if (serverList.size() == 0) {
            return;
        }
        String[] pinnedServers = this.getValue(ResourceType.ServerPool.SERVER_NAMES.name()).split(String.valueOf(" "));
        ArrayList<String> list = new ArrayList<String>(pinnedServers.length + serverList.size());
        for (int i = 0; i < pinnedServers.length; ++i) {
            list.add(pinnedServers[i]);
        }
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(serverList.size());
        String serverName = null;
        for (int i = 0; i < serverList.size(); ++i) {
            NativeResult result;
            try {
                serverName = serverList.get(i).node().getName();
                if (!list.contains(serverName)) {
                    list.add(serverName);
                    continue;
                }
                result = new NativeResult();
                result.setException(new AlreadyExistsException((MessageKey)PrCsMsgID.SERVER_EXISTS_IN_SP, serverName, this.getUserAssignedName()));
                resultMap.put(serverName, result);
                continue;
            }
            catch (ServerException e) {
                result = new NativeResult();
                result.setException(e);
                resultMap.put(serverName, result);
                continue;
            }
            catch (NodeException e) {
                result = new NativeResult();
                result.setException(e);
                resultMap.put(serverName, result);
            }
        }
        if (list.size() > pinnedServers.length) {
            pinnedServers = new String[list.size()];
            list.toArray(pinnedServers);
            this.setValue(forceFlag, ResourceType.ServerPool.SERVER_NAMES, Utils.getString(pinnedServers, String.valueOf(" ")));
        }
        if (!resultMap.isEmpty()) {
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SP_MODIFY_FAILED, resultMap, this.getUserAssignedName());
        }
    }

    @Override
    public String[] relocateServers(List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        return this.relocateServers(false, serverList);
    }

    @Override
    public String[] relocateServers(boolean forceFlag, List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        if (serverList == null || serverList.size() == 0) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList", serverList);
        }
        String[] serverNames = new String[serverList.size()];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < serverList.size(); ++i) {
            try {
                serverNames[i] = serverList.get(i).node().getName();
                if (sb.length() > 0) {
                    sb.append("," + serverNames[i]);
                    continue;
                }
                sb.append(serverNames[i]);
                continue;
            }
            catch (ServerException e) {
                throw new ServerGroupException(e);
            }
            catch (NodeException e) {
                throw new ServerGroupException(e);
            }
        }
        try {
            return this.m_crsServerPool.relocateServers(serverNames, forceFlag);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_RELOCATE_SERVERS_FAILED, (Throwable)e, sb.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public void removeServers(List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        this.removeServers(false, serverList);
    }

    @Override
    public void removeServers(boolean forceFlag, List<Server> serverList) throws CompositeOperationException, ServerGroupException {
        if (serverList.size() == 0) {
            return;
        }
        String[] pinnedServers = this.getValue(ResourceType.ServerPool.SERVER_NAMES.name()).split(String.valueOf(" "));
        ArrayList<String> pinnedList = new ArrayList<String>(pinnedServers.length);
        for (int i = 0; i < pinnedServers.length; ++i) {
            pinnedList.add(pinnedServers[i]);
        }
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(serverList.size());
        String serverName = null;
        for (int i = 0; i < serverList.size(); ++i) {
            NativeResult result;
            try {
                serverName = serverList.get(i).node().getName();
                if (pinnedList.contains(serverName)) {
                    pinnedList.remove(serverName);
                    continue;
                }
                result = new NativeResult();
                result.setException(new NotExistsException((MessageKey)PrCsMsgID.SERVER_NOT_EXISTS_IN_SP, serverName, this.getUserAssignedName()));
                resultMap.put(serverName, result);
                continue;
            }
            catch (ServerException e) {
                result = new NativeResult();
                result.setException(e);
                resultMap.put(serverName, result);
                continue;
            }
            catch (NodeException e) {
                result = new NativeResult();
                result.setException(e);
                resultMap.put(serverName, result);
            }
        }
        pinnedServers = new String[pinnedList.size()];
        pinnedList.toArray(pinnedServers);
        this.setValue(forceFlag, ResourceType.ServerPool.SERVER_NAMES, Utils.getString(pinnedServers, String.valueOf(" ")));
        if (!resultMap.isEmpty()) {
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SP_MODIFY_FAILED, resultMap, this.getUserAssignedName());
        }
    }

    @Override
    public List<Database> databases() throws ServerGroupException {
        List<Database> dbList;
        try {
            dbList = DatabaseFactoryImpl.getInstance().getDatabases(this);
        }
        catch (SoftwareModuleException sme) {
            throw new ServerGroupException(sme);
        }
        return dbList;
    }

    @Override
    public List<String> databaseNames() throws ServerGroupException {
        List<String> dbList;
        try {
            dbList = DatabaseFactoryImpl.getInstance().listDatabaseNames(this);
        }
        catch (SoftwareModuleException sme) {
            throw new ServerGroupException(sme);
        }
        return dbList;
    }

    @Override
    public List<Service> services(String dbUniqueName) throws ServerGroupException {
        try {
            List<Service> srvList = DatabaseFactoryImpl.getInstance().getServices(this, dbUniqueName);
            return srvList;
        }
        catch (SoftwareModuleException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public Map<String, List<String>> getRunningDatabaseInstances() throws ServerGroupException {
        try {
            ArrayList<String> serverList = new ArrayList<String>();
            Map<String, Map<String, String>> resultData = this.dBInstanceHelper(serverList, null, true, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name(), ResourceLiterals.CRS_LAST_SERVER.toString());
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            for (String riID : resultData.keySet()) {
                String instanceName = null;
                ArrayList<String> instList = new ArrayList<String>();
                Map<String, String> valueMap = resultData.get(riID);
                String dbUniqueName = valueMap.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String dbVersion = valueMap.get(ResourceType.ClusterResource.VERSION.name());
                String serverName = valueMap.get(ResourceLiterals.CRS_LAST_SERVER.toString());
                Trace.out("SP- dbUniq=" + dbUniqueName);
                Trace.out("SP- dbVersion=" + dbVersion);
                Trace.out("SP- serverName=" + serverName);
                for (String attrName : valueMap.keySet()) {
                    String attrValue = valueMap.get(attrName);
                    Trace.out("SP:ri %s, name %s, val %s", riID, attrName, attrValue);
                    if (!attrName.startsWith(ResourceType.Database.GEN_USR_ORA_INST_NAME.name()) || !attrName.contains("(" + serverName + ")")) continue;
                    instanceName = attrValue;
                    Trace.out("SP- instanceName=" + instanceName);
                }
                if (null == instanceName) {
                    instanceName = valueMap.get(ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                    Trace.out("SP: Instance name=" + instanceName);
                }
                if (!serverList.contains(serverName)) continue;
                instList.add(instanceName);
                if (result.containsKey(dbUniqueName)) {
                    instList.addAll(0, (Collection)result.get(dbUniqueName));
                }
                result.put(dbUniqueName, instList);
            }
            Trace.out("result=" + result);
            return result;
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_RUNNING_DB_INSTS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public Map<Database, List<DatabaseInstance>> getOnlineDatabaseInstances() throws ServerGroupException {
        return this.getDatabaseInstances(null, true);
    }

    @Override
    public Map<Database, List<DatabaseInstance>> getAllDatabaseInstances() throws ServerGroupException {
        return this.getDatabaseInstances(null, false);
    }

    @Override
    public Map<Database, List<DatabaseInstance>> getAllDatabaseInstances(String dbUniqueName) throws ServerGroupException {
        return this.getDatabaseInstances(DatabaseImpl.getResourceName(dbUniqueName), false);
    }

    private Map<Database, List<DatabaseInstance>> getDatabaseInstances(String dbResName, boolean running) throws ServerGroupException {
        Exception mExc = null;
        ArrayList<String> dbNames = new ArrayList<String>();
        if (dbResName != null) {
            dbNames.add(dbResName);
        }
        try {
            Trace.out("Start of getOnlineDatabaseInstances for server pool " + this.getName());
            DatabaseFactoryImpl dbFactory = DatabaseFactoryImpl.getInstance();
            ServerFactoryImpl servFactory = ServerFactoryImpl.getInstance();
            ArrayList<String> serverList = new ArrayList<String>();
            Map<String, Map<String, String>> resultData = this.dBInstanceHelper(serverList, dbNames, running, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name(), ResourceLiterals.CRS_LAST_SERVER.toString());
            HashMap<Database, List<DatabaseInstance>> result = new HashMap<Database, List<DatabaseInstance>>();
            HashMap<String, Database> dbMap = new HashMap<String, Database>();
            for (String riID : resultData.keySet()) {
                String instanceName = null;
                ArrayList<DatabaseInstance> instList = new ArrayList<DatabaseInstance>();
                Map<String, String> valueMap = resultData.get(riID);
                String dbUniqueName = valueMap.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String dbVersion = valueMap.get(ResourceType.ClusterResource.VERSION.name());
                String serverName = valueMap.get(ResourceLiterals.CRS_LAST_SERVER.toString());
                Trace.out("SP dbUniq=" + dbUniqueName);
                Trace.out("SP dbVersion=" + dbVersion);
                Trace.out("SP serverName=" + serverName);
                for (String attrName : valueMap.keySet()) {
                    String attrValue = valueMap.get(attrName);
                    Trace.out("ri %s, name %s, val %s", riID, attrName, attrValue);
                    if (!attrName.startsWith(ResourceType.Database.GEN_USR_ORA_INST_NAME.name()) || !attrName.contains("(" + serverName + ")")) continue;
                    instanceName = attrValue;
                    Trace.out("SP instanceName=" + instanceName);
                }
                if (null == instanceName) {
                    instanceName = valueMap.get(ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                    Trace.out("SP: Instance name=" + instanceName);
                }
                if (!serverList.contains(serverName)) continue;
                Database database = (Database)dbMap.get(dbUniqueName);
                if (database == null) {
                    database = this.m_crsServerPool.getDatabase(dbUniqueName);
                    dbMap.put(dbUniqueName, database);
                }
                Node node = servFactory.getNode(serverName, false);
                DatabaseInstance dbInstance = dbFactory.createDatabaseInstance(database, instanceName, node);
                instList.add(dbInstance);
                if (result.containsKey(database)) {
                    instList.addAll(0, (Collection)result.get(database));
                }
                result.put(database, instList);
            }
            Trace.out("result=" + result);
            return result;
        }
        catch (CRSException e) {
            mExc = e;
        }
        catch (InstanceException ie) {
            mExc = ie;
        }
        catch (DatabaseException de) {
            mExc = de;
        }
        catch (NotExistsException ne) {
            mExc = ne;
        }
        catch (NodeException nde) {
            mExc = nde;
        }
        catch (SoftwareModuleException se) {
            mExc = se;
        }
        catch (ServerException srve) {
            mExc = srve;
        }
        throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_RUNNING_DB_INSTS_FAILED, (Throwable)mExc, this.getUserAssignedName());
    }

    private Map<String, Map<String, String>> dBInstanceHelper(List<String> serverList, List<String> dbResNames, boolean running, String ... qryAttrList) throws ServerGroupException, CRSException {
        Filter filter;
        Map<String, Map<String, String>> resultData = new HashMap<String, Map<String, String>>();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        Filter dbTypeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
        Filter containsPoolFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.Database.SERVER_POOLS.name(), this.getName());
        Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, dbTypeFilter, containsPoolFilter);
        if (dbResNames != null && dbResNames.size() > 0) {
            Filter dbNameFilter = crsFactory.getORFilter(ResourceType.Database.NAME.name(), Filter.Comparator.EQ, dbResNames.toArray(new String[dbResNames.size()]));
            dbFilter = crsFactory.getFilter(Filter.Operator.AND, dbFilter, dbNameFilter);
        }
        serverList.clear();
        Map<String, Map<String, String>> allDbs = crsFactory.searchEntities(this.m_crsServerPool, CRSEntity.Type.Resource, false, dbFilter, qryAttrList);
        if (allDbs.isEmpty()) {
            return resultData;
        }
        String[] dbNames = new String[allDbs.size()];
        int i = 0;
        for (String dbname : allDbs.keySet()) {
            Trace.out("dbName = " + dbname);
            dbNames[i] = dbname;
            ++i;
        }
        for (String server : this.serversHelper2(true)) {
            serverList.add(server);
        }
        Filter allDbFilter = crsFactory.getORFilter(ResourceType.Database.NAME.name(), Filter.Comparator.EQ, dbNames);
        if (running) {
            Filter stateOnlineFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "ONLINE");
            Filter stateIntermediateFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "INTERMEDIATE");
            Filter tgtOnlineFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TARGET_ATTR_NAME.toString(), "ONLINE");
            Filter stateAndTgtFilter = crsFactory.getFilter(Filter.Operator.OR, stateOnlineFilter, stateIntermediateFilter);
            stateAndTgtFilter = crsFactory.getFilter(Filter.Operator.AND, tgtOnlineFilter, stateAndTgtFilter);
            filter = crsFactory.getFilter(Filter.Operator.AND, allDbFilter, stateAndTgtFilter);
        } else {
            if (serverList == null || serverList.size() == 0) {
                return resultData;
            }
            Filter spFilter = crsFactory.getORFilter(ResourceLiterals.CRS_LAST_SERVER.toString(), Filter.Comparator.EQ, serverList.toArray(new String[serverList.size()]));
            filter = crsFactory.getFilter(Filter.Operator.AND, allDbFilter, spFilter);
        }
        Trace.out("filter: " + filter.toString() + ", qryAttrList: " + Arrays.toString(qryAttrList));
        resultData = crsFactory.searchEntities(this.m_crsServerPool, CRSEntity.Type.ResourceInstance, true, filter, qryAttrList);
        for (String resID : resultData.keySet()) {
            Trace.out("resID from resultdata:" + resID);
            String resName = resID.split(" ")[0];
            Trace.out("resName from resID:" + resName);
            Map<String, String> resIDAttrs = resultData.get(resID);
            Map<String, String> resAttrs = allDbs.get(resName);
            for (String attr1 : resAttrs.keySet()) {
                Trace.out("Resname attr:" + attr1 + " ;val=" + resIDAttrs.get(attr1));
                if (resIDAttrs.get(attr1) != null) continue;
                Trace.out("Including attr " + attr1 + "=" + resAttrs.get(attr1));
                resIDAttrs.put(attr1, resAttrs.get(attr1));
            }
        }
        return resultData;
    }

    @Override
    public List<Service> services() throws ServerGroupException {
        try {
            List<Service> srvList = DatabaseFactoryImpl.getInstance().getServices(this);
            return srvList;
        }
        catch (SoftwareModuleException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public void remove() throws CompositeOperationException, ServerGroupException {
        try {
            List<Database> dbList = this.databases();
            Trace.out("The dblist size is " + dbList.size());
            if (dbList.size() > 0) {
                NativeResult result;
                List<Service> svcList = this.services();
                LinkedHashMap<Object, NativeResult> resultMap = new LinkedHashMap<Object, NativeResult>(dbList.size() + svcList.size());
                String name = null;
                for (Database db : dbList) {
                    name = db.getUserAssignedName();
                    result = new NativeResult();
                    result.setException(new AlreadyExistsException((MessageKey)PrCdMsgID.DB_DEP_ON_SP, name, this.getUserAssignedName()));
                    resultMap.put(name, result);
                }
                for (Service svc : svcList) {
                    name = svc.getUserAssignedName();
                    result = new NativeResult();
                    result.setException(new AlreadyExistsException((MessageKey)PrCdMsgID.SVC_DEP_ON_SP, name, this.getUserAssignedName()));
                    resultMap.put(name, result);
                }
                throw new CompositeOperationException((MessageKey)PrCsMsgID.SP_REMOVE_FAILED, resultMap, this.getUserAssignedName());
            }
            this.m_crsServerPool.unregister(false);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_REMOVE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    protected String getValue(String attrName) throws ServerGroupException {
        try {
            ResourceAttribute attr = this.m_crsServerPool.getAttribute(attrName);
            return attr.getValue();
        }
        catch (CRSLocalEntityException e) {
            throw new ServerGroupLocalException((MessageKey)PrCsMsgID.SP_GET_FAILED, (Throwable)e, attrName, this.getName());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_FAILED, (Throwable)e, attrName, this.getName());
        }
    }

    protected void setValue(ResourceType.ServerPool attrName, String value) throws ServerGroupException {
        this.setValue(false, attrName, value);
    }

    protected void setValue(boolean forceFlag, ResourceType.ServerPool attrName, String value) throws ServerGroupException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            if (attrName.name().equals(ResourceType.ServerPool.SERVER_NAMES.name())) {
                ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>(2);
                raList.add(cf.create(ResourceType.ServerPool.SERVER_NAMES.name(), value));
                if (value.trim().equals("")) {
                    if (this.getValue(ResourceType.ServerPool.SERVER_CATEGORY.name()).trim().equals("")) {
                        raList.add(cf.create(ResourceType.ServerPool.SERVER_CATEGORY.name(), ResourceLiterals.HUB_CATEGORY.toString()));
                    }
                } else {
                    raList.add(cf.create(ResourceType.ServerPool.SERVER_CATEGORY.name(), ""));
                }
                ResourceAttribute[] attrArr = new ResourceAttribute[raList.size()];
                this.m_crsServerPool.update(forceFlag, raList.toArray(attrArr));
            } else {
                this.m_crsServerPool.update(cf.create(attrName.name(), value), forceFlag);
            }
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    private static void makeAttrList(List<ResourceAttribute> attrList, int minSize, int maxSize, int importance, String poolName, String category, Server[] serverList, String parent) throws ServerGroupException {
        for (ResourceAttribute attr : attrList) {
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.NAME.name())) {
                attr.setValue(poolName);
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.MIN_SIZE.name())) {
                attr.setValue(String.valueOf(minSize));
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.MAX_SIZE.name())) {
                attr.setValue(String.valueOf(maxSize));
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.IMPORTANCE.name())) {
                attr.setValue(String.valueOf(importance));
            }
            if (serverList.length > 0 && attr.getName().equalsIgnoreCase(ResourceType.ServerPool.SERVER_NAMES.name())) {
                String[] serverNames = new String[serverList.length];
                for (int i = 0; i < serverList.length; ++i) {
                    try {
                        serverNames[i] = serverList[i].node().getName();
                        continue;
                    }
                    catch (ServerException e) {
                        throw new ServerGroupException(e);
                    }
                    catch (NodeException e) {
                        throw new ServerGroupException(e);
                    }
                }
                attr.setValue(Utils.getString(serverNames, String.valueOf(" ")));
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.SERVER_CATEGORY.name())) {
                Trace.out("srvpool category is " + category);
                if (serverList != null && serverList.length > 0) {
                    attr.setValue("");
                    Trace.out("Set category to empty string because servers are specified");
                } else {
                    ServerFactory servFactory;
                    if (category == null) {
                        Trace.out("change the category to default when category parameter is null");
                        try {
                            servFactory = ServerFactory.getInstance();
                            attr.setValue(servFactory.getDefaultCategory());
                        }
                        catch (ServerException e) {
                            throw new ServerGroupException(e);
                        }
                    }
                    if (category.trim().equals("")) {
                        attr.setValue("");
                        Trace.out("Set category to empty string");
                    } else {
                        try {
                            servFactory = ServerFactory.getInstance();
                            ServerCategory serverCategory = servFactory.getServerCategory(category);
                            attr.setValue(serverCategory.getName());
                        }
                        catch (ServerException e) {
                            throw new ServerGroupException(e);
                        }
                        catch (NotExistsException e) {
                            throw new ServerGroupException(e);
                        }
                    }
                }
            }
            if (parent == null || !attr.getName().equalsIgnoreCase(ResourceType.ServerPool.PARENT_POOLS.name())) continue;
            attr.setValue(parent);
        }
    }

    @Override
    public int getPolicyMinSize() throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getPolicyMaxSize() throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getPolicyImportance() throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void setPolicyImportance(int importance) throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void setPolicyMinSize(int minSize) throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void setPolicyMaxSize(int maxSize) throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public String serverCategoryStr() throws ServerGroupException {
        ServerCategory sc = this.serverCategory();
        if (sc == null) {
            return "";
        }
        return sc.getUserAssignedName();
    }

    @Override
    public ServerCategory serverCategory() throws ServerGroupException {
        try {
            String category;
            String attrName = ResourceType.ServerPool.SERVER_CATEGORY.name();
            ResourceAttribute attr = this.m_crsServerPool.getAttribute(attrName);
            if (attr != null && !(category = attr.getValue().trim()).equals("")) {
                return ServerFactoryImpl.getInstance().getServerCategory(attr.getValue());
            }
            return null;
        }
        catch (CRSAttributeNotFoundException e) {
            throw new ServerGroupException(e);
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ServerPoolImpl)) {
            return false;
        }
        ServerPoolImpl other = (ServerPoolImpl)obj;
        return this.m_name != null && this.m_name.equalsIgnoreCase(other.m_name);
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : super.hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<Server> candidateServersByCategory() throws ServerGroupException {
        List<Server> slist = new ArrayList<Server>();
        try {
            String category = this.getValue(ResourceType.ServerPool.SERVER_CATEGORY.name());
            if (!category.trim().equals("")) {
                slist = CRSServerCategoryEntity.serversByCategory(category);
            }
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
        return slist;
    }

    @Override
    public List<Server> getEligibleServers() throws ServerGroupException {
        List<Object> slist = new ArrayList(0);
        try {
            Trace.out("Calling candidateServers");
            slist = this.candidateServers();
            if (slist.size() == 0) {
                String category = this.getValue(ResourceType.ServerPool.SERVER_CATEGORY.name());
                Trace.out("Calling candidateServersByCategory for category " + category);
                slist = CRSServerCategoryEntity.serversByCategory(category);
            }
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        return slist;
    }

    @Override
    public List<Server> getEligibleServers(Server.ServerState serverState) throws ServerGroupException {
        ArrayList<Server> nslist = new ArrayList<Server>(0);
        try {
            List<Server> slist = this.getEligibleServers();
            for (Server server : slist) {
                List<Server.ServerState> states = server.states();
                for (Server.ServerState state : states) {
                    Trace.out("Server's state is " + state.toString());
                    if (state != serverState) continue;
                    nslist.add(server);
                }
            }
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        return nslist;
    }

    @Override
    public boolean isBuiltinPool() {
        String name = this.getName().trim();
        return name.equals(ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString()) || name.equals(ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString());
    }
}

